/*
 * Decompiled with CFR 0.152.
 */
package com.trend.iwss.jscan.runtime;

import com.trend.iwss.jscan.runtime.AlertDialog;
import com.trend.iwss.jscan.runtime.AllowDialog;
import com.trend.iwss.jscan.runtime.AppletTrapStopError;
import com.trend.iwss.jscan.runtime.CallContext;
import com.trend.iwss.jscan.runtime.OkDialog;
import com.trend.iwss.jscan.runtime.PolicyProps;
import com.trend.iwss.jscan.runtime.Session;
import com.trend.iwss.jscan.runtime.StubAppletDisplay;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.TextArea;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.Enumeration;

public abstract class PolicyRuntime {
    public static final String METH_PREFILTER = "preFilter";
    public static final String METH_POSTFILTER = "postFilter";
    public static final String PARAMDEF_PREFILTER = CallContext.ARG_POLICYFILTER;
    public static final String PARAMDEF_POSTFILTER = CallContext.ARG_POLICYFILTER;
    public static final String RUNTIME_PACKAGE_BASE = "com/trend/iwss/jscan/runtime";
    public static final String RUNTIME_URL_NASE = "/com/trend/iwss/jscan/runtime";
    public static final String CFG_MISC_PROMPT_USER_BOOL = "misc.prompt_user";
    public static final String CFG_MISC_NOTIFY_USER_BOOL = "misc.notify_user";
    public static final String CFG_MISC_NO_USER_INTERACTION_BOOL = "misc.no_user_interaction";
    public static final String CFG_MISC_MAX_OFFENCE_COUNT_INT = "misc.max_offense_cnt";
    public static final String CFG_MISC_STRICT_ENFORCEMENT = "misc.strict_enforcement";
    public static final String CFG_JSCAN_SESSION_ORIGIN_URI = "jscan.session.origin_uri";
    public static final String CFG_JSCAN_SESSION_POLICYNAME = "jscan.session.policyname";
    public static final String REPORT_START_TAG = "Report?";
    public static final String REPORT_REASON_TAG = "Reason=";
    public static final String REPORT_URI_TAG = "URI=";
    public static final String REPORT_CLASS_TAG = "class=";
    public static final String REPORT_POLICYNAME_TAG = "Policyname=";
    public static final String REPORT_AMP = "&";
    public static final String CLASS_STRING = "java.lang.String";
    private PolicyProps m_props;
    protected Session m_ses;
    protected String m_name;
    private String m_prefix;
    private String m_policyName;
    private String m_originURI;
    private int m_maxOffenses;
    private boolean m_noUserInteraction;
    private boolean m_doAllowDialog;
    private boolean m_doNotifyDialog;
    private boolean m_strictEnforcement;

    public static String classNameSlashNotation(Class clazz) {
        String string = clazz.getName();
        return string.replace('.', '/');
    }

    protected PolicyRuntime(String string, String string2, Session session) {
        this.m_ses = session;
        this.m_props = this.m_ses.getProperties();
        this.m_name = string;
        this.m_prefix = string2;
        this.m_policyName = this.getB64StrProp(CFG_JSCAN_SESSION_POLICYNAME, null);
        this.m_originURI = this.getStrProp(CFG_JSCAN_SESSION_ORIGIN_URI, null);
        this.m_noUserInteraction = this.getBoolProp(CFG_MISC_NO_USER_INTERACTION_BOOL, false);
        this.m_doAllowDialog = this.m_noUserInteraction ? false : this.getBoolProp(CFG_MISC_PROMPT_USER_BOOL, true);
        this.m_doNotifyDialog = this.m_noUserInteraction ? false : this.getBoolProp(CFG_MISC_NOTIFY_USER_BOOL, true);
        this.m_maxOffenses = this.getIntProp(CFG_MISC_MAX_OFFENCE_COUNT_INT, -1);
        this.m_strictEnforcement = this.getBoolProp(CFG_MISC_STRICT_ENFORCEMENT, false);
    }

    String getPolicyName() {
        return this.m_name;
    }

    boolean isEnforcementStrict() {
        return this.m_strictEnforcement;
    }

    abstract void _preFilter(CallContext var1);

    abstract void _postFilter(CallContext var1);

    static void preFilter(CallContext callContext, Factory factory) {
        Session session = Session.get();
        PolicyRuntime policyRuntime = PolicyRuntime.accessInstance(factory, session);
        if (session.getStatus() == 1) {
            PolicyRuntime.syserr("-->> Invocation of " + callContext.toString() + " with STOP set");
            session.stopCurrentThread();
            return;
        }
        try {
            policyRuntime._preFilter(callContext);
        }
        catch (Exception exception) {
            if (exception instanceof SecurityException) {
                throw (SecurityException)exception;
            }
            exception.printStackTrace();
        }
    }

    static void postFilter(CallContext callContext, Factory factory) {
        Session session = Session.get();
        PolicyRuntime policyRuntime = PolicyRuntime.accessInstance(factory, session);
        try {
            policyRuntime._postFilter(callContext);
        }
        catch (Exception exception) {
            if (exception instanceof SecurityException) {
                throw (SecurityException)exception;
            }
            exception.printStackTrace();
        }
    }

    boolean stopAction(String string) {
        return this.stopAction(string, (String[])null);
    }

    boolean stopAction(String string, String string2) {
        return this.stopAction(string, new String[]{string2});
    }

    boolean stopAction(String string, String[] stringArray) {
        String string2 = this.m_ses.getMsg(string);
        String string3 = MessageFormat.format(string2, stringArray);
        return this.stopActionInner(string3);
    }

    String getStrProp(String string, String string2) {
        return this.m_props.getStrProp(string, string2);
    }

    String getB64StrProp(String string, String string2) {
        return this.m_props.getB64StrProp(string, string2);
    }

    int getIntProp(String string, int n) {
        return this.m_props.getIntProp(string, n);
    }

    boolean getBoolProp(String string, boolean bl) {
        return this.m_props.getBoolProp(string, bl);
    }

    String getStrPolicyProp(String string, String string2) {
        String string3 = this.composeKey(string);
        return this.getStrProp(string3, string2);
    }

    int getIntPolicyProp(String string, int n) {
        String string2 = this.composeKey(string);
        return this.getIntProp(string2, n);
    }

    boolean getBoolPolicyProp(String string, boolean bl) {
        String string2 = this.composeKey(string);
        return this.getBoolProp(string2, bl);
    }

    private static PolicyRuntime accessInstance(Factory factory, Session session) {
        PolicyRuntime policyRuntime = (PolicyRuntime)session.getKey(factory.getCtxKey());
        if (null == policyRuntime) {
            policyRuntime = factory.make(session);
            session.setKey(factory.getCtxKey(), policyRuntime);
        }
        return policyRuntime;
    }

    private boolean stopActionInner(String string) {
        boolean bl = false;
        boolean bl2 = false;
        if (this.m_ses.getStatus() == 1) {
            PolicyRuntime.syserr("-->> Reinvocation with STOP set");
            this.m_ses.stopCurrentThread();
            return false;
        }
        if (this.m_doAllowDialog) {
            int n = this.showAllowDialog(string);
            if (n == 0) {
                return false;
            }
            if (n == 2) {
                bl = true;
            }
        }
        if (!bl2) {
            this.report(string);
        }
        if (bl) {
            this.stopApplet();
            return true;
        }
        if (this.m_doNotifyDialog && !this.m_doAllowDialog) {
            bl = this.showOKDialog(string);
        }
        if (!bl) {
            this.m_ses.incrOffenceCount();
            if (this.m_maxOffenses > 0 && this.m_ses.getOffenceCount() >= this.m_maxOffenses) {
                bl = true;
            }
        }
        if (!bl) {
            throw this.makeSecurityException(string);
        }
        this.stopApplet();
        return true;
    }

    private void stopApplet() {
        this.m_ses.setStatus(1);
        this.m_ses.closeAllActiveWindows();
        this.m_ses.closeAllOpenDialogs();
        this.stopApplets();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            this.m_ses.stopAllActiveThreads();
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new AppletTrapStopError(this.m_ses.getMsg("instr.action.policy_stop_error"));
    }

    private void stopApplets() {
        Enumeration enumeration = this.m_ses.getApplets();
        String string = this.m_ses.getMsg("instr.msg.dialog.applet_stopped");
        while (enumeration.hasMoreElements()) {
            Applet applet = (Applet)enumeration.nextElement();
            if (this.m_ses.isStoppedApplet(applet)) continue;
            ClearAppletThread clearAppletThread = new ClearAppletThread(this.m_ses, applet, string, this.m_noUserInteraction);
            clearAppletThread.start();
            this.m_ses.setAppletStopped(applet);
        }
    }

    private int showAllowDialog(String string) {
        Object[] objectArray = new Object[]{string};
        String string2 = MessageFormat.format(this.m_ses.getMsg("instr.msg.dialog.action_warning_start"), objectArray);
        AllowDialog allowDialog = AllowDialog.make(string2, this.m_ses, 1);
        return allowDialog.display();
    }

    private boolean showOKDialog(String string) {
        Object[] objectArray = new Object[]{string};
        String string2 = MessageFormat.format(this.m_ses.getMsg("instr.msg.dialog.action_warning_start"), objectArray);
        OkDialog okDialog = OkDialog.make(string2, this.m_ses, "instr.msg.dialog.ask_stop_applet", true);
        return okDialog.display();
    }

    private SecurityException makeSecurityException(String string) {
        Object[] objectArray = new Object[]{string};
        String string2 = MessageFormat.format(this.m_ses.getMsg("instr.action.policy_security_exception"), objectArray);
        return new SecurityException(string2);
    }

    private String composeKey(String string) {
        return this.m_prefix == null ? string : this.m_prefix + "." + string;
    }

    private void report(String string) {
        Object object;
        StringBuffer stringBuffer;
        if (null == this.m_originURI) {
            return;
        }
        String string2 = null != this.m_policyName ? this.m_policyName : "unknown";
        try {
            stringBuffer = new StringBuffer();
            stringBuffer.append(REPORT_START_TAG);
            PolicyRuntime.rptAppend(stringBuffer, REPORT_REASON_TAG, string, false);
            PolicyRuntime.rptAppend(stringBuffer, REPORT_URI_TAG, this.m_originURI, false);
            object = this.m_ses.getApplets();
            while (object.hasMoreElements()) {
                Applet applet = (Applet)object.nextElement();
                if (this.m_ses.isStoppedApplet(applet)) continue;
                PolicyRuntime.rptAppend(stringBuffer, REPORT_CLASS_TAG, applet.getClass().getName(), false);
            }
            PolicyRuntime.rptAppend(stringBuffer, REPORT_POLICYNAME_TAG, string2, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        object = new ReportThread(this.m_originURI, stringBuffer.toString());
        ((Thread)object).start();
    }

    private static void rptAppend(StringBuffer stringBuffer, String string, String string2, boolean bl) {
        stringBuffer.append(string);
        String string3 = URLEncoder.encode(string2);
        stringBuffer.append(string3);
        if (!bl) {
            stringBuffer.append(REPORT_AMP);
        }
    }

    private static void syserr(String string) {
        System.err.println(string);
        System.err.flush();
    }

    public static String invokeStringGetter(Object object, String string, String string2) {
        Object object2 = PolicyRuntime.invokeZeroArgMethod(object, string, string2, CLASS_STRING);
        if (null == object2) {
            return null;
        }
        return (String)object2;
    }

    public static Object invokeZeroArgMethod(Object object, String string, String string2, String string3) {
        Object object2;
        if (null == object) {
            return null;
        }
        Class<?> clazz = object.getClass();
        if (!PolicyRuntime.checkClass(clazz, string)) {
            return null;
        }
        Method method = PolicyRuntime.getMethod(clazz, string2);
        if (null == method) {
            return null;
        }
        try {
            object2 = method.invoke(object, (Object[])null);
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
        if (!PolicyRuntime.checkClass(object2, string3)) {
            return null;
        }
        return object2;
    }

    public static Method getMethod(Class clazz, String string) {
        if (null == clazz) {
            return null;
        }
        try {
            return clazz.getMethod(string, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static boolean checkClass(Object object, String string) {
        if (null == object) {
            return false;
        }
        return PolicyRuntime.checkClass(object.getClass(), string);
    }

    public static boolean checkClass(Class clazz, String string) {
        if (null == clazz) {
            return false;
        }
        if (clazz.getName().equals(string)) {
            return true;
        }
        return PolicyRuntime.checkClass(clazz.getSuperclass(), string);
    }

    static abstract class Factory {
        private final String m_ctxKey;

        Factory(String string) {
            this.m_ctxKey = string;
        }

        public String getCtxKey() {
            return this.m_ctxKey;
        }

        abstract PolicyRuntime make(Session var1);
    }

    private static class ReportThread
    extends Thread {
        private final String m_infoStr;
        private final String m_originURI;

        private ReportThread(String string, String string2) {
            this.m_originURI = string;
            this.m_infoStr = string2;
        }

        public void run() {
            if (null == this.m_originURI) {
                System.err.println("Origin URI not available - cannot send report");
                return;
            }
            try {
                URL uRL = new URL(this.m_originURI + PolicyRuntime.RUNTIME_URL_NASE + "/" + this.m_infoStr);
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.setDoInput(true);
                uRLConnection.connect();
                InputStream inputStream = uRLConnection.getInputStream();
                byte[] byArray = new byte[1024];
                while (inputStream.read(byArray) > 0) {
                }
            }
            catch (Exception exception) {
                System.err.println("Error while reporting ...");
                exception.printStackTrace();
            }
        }
    }

    private static class ClearAppletThread
    extends Thread {
        private final Session m_ses;
        private final Applet m_applet;
        private final String m_msg;
        private final boolean m_noUserInteraction;

        private ClearAppletThread(Session session, Applet applet, String string, boolean bl) {
            this.m_ses = session;
            this.m_applet = applet;
            this.m_msg = string;
            this.m_noUserInteraction = bl;
        }

        public void run() {
            this.m_applet.removeAll();
            this.m_applet.invalidate();
            this.m_applet.setLayout(new BorderLayout());
            if (StubAppletDisplay.useAppletArea(this.m_applet)) {
                this.showInAppletArea();
            } else {
                this.showInDialog();
            }
        }

        private void showInDialog() {
            if (this.m_noUserInteraction) {
                return;
            }
            AlertDialog alertDialog = AlertDialog.make(this.m_ses, this.m_msg, "instr.msg.dialog.applet_terminated");
            alertDialog.display();
        }

        private void showInAppletArea() {
            TextArea textArea = StubAppletDisplay.getTextArea(this.m_msg);
            this.m_applet.add("Center", textArea);
            textArea.invalidate();
            this.m_applet.validate();
        }
    }
}

