/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.jspreadsheet;

import java.util.TreeSet;
import net.java.dev.jspreadsheet.CellPoint;
import net.java.dev.jspreadsheet.Formula;
import net.java.dev.jspreadsheet.ParserException;

public class Cell {
    public static final int TEXT = 0;
    public static final int NUMBER = 1;
    public static final int FORMULA = 2;
    private Formula expression;
    private Object value;
    private TreeSet refs;

    Cell() {
        this.value = null;
        this.expression = null;
        this.refs = null;
    }

    Cell(Object datum) {
        this.value = datum;
        this.expression = null;
        this.refs = null;
    }

    Cell(Object datum, TreeSet reference) {
        this.value = datum;
        this.expression = null;
        this.refs = reference;
    }

    Cell(Formula thing, Object eVal, TreeSet reference) {
        this.expression = thing;
        this.value = eVal;
        this.refs = reference;
    }

    public boolean isEmpty() {
        return this.value.equals("") && this.expression == null;
    }

    public boolean isErrorCell() {
        return this.isFormula() && this.value instanceof ParserException;
    }

    public boolean isFormula() {
        return this.expression != null;
    }

    public String getFormulaString() {
        return this.expression == null ? null : this.expression.toString();
    }

    public int getType() {
        if (this.expression != null) {
            return 2;
        }
        if (this.value instanceof Number) {
            return 1;
        }
        return 0;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        if (this.expression != null) {
            return "=" + this.expression.toString();
        }
        return this.value.toString();
    }

    void setData(Object datum) {
        this.value = datum;
        this.expression = null;
    }

    void setFormula(Formula form) {
        this.expression = form;
    }

    Formula getFormula() {
        return this.expression;
    }

    TreeSet getRefs() {
        return this.refs;
    }

    void setValue(Object datum) {
        this.value = datum;
    }

    void addRef(CellPoint reference) {
        if (this.refs == null) {
            this.refs = new TreeSet();
        }
        this.refs.add(reference);
    }

    int compare(Cell x, boolean ascending) {
        if (this.value.equals("")) {
            if (!x.value.equals("")) {
                if (ascending) {
                    return 1;
                }
                return -1;
            }
            return 0;
        }
        if (x.value.equals("")) {
            if (ascending) {
                return -1;
            }
            return 1;
        }
        if (this.isErrorCell()) {
            if (x.isErrorCell()) {
                return 0;
            }
            return -1;
        }
        if (x.isErrorCell()) {
            return 1;
        }
        if (this.getType() == 0) {
            if (x.getType() == 0) {
                String temp = (String)this.value;
                return temp.compareToIgnoreCase((String)x.value);
            }
            return -1;
        }
        if (x.getType() == 0) {
            return 1;
        }
        Float first = (Float)this.value;
        Float second = (Float)x.value;
        return first.compareTo(second);
    }

    boolean hasRefs() {
        return this.refs != null && !this.refs.isEmpty();
    }

    void removeRef(CellPoint reference) {
        if (this.refs != null) {
            this.refs.remove(reference);
            if (this.refs.isEmpty()) {
                this.refs = null;
            }
        }
    }
}

