/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.jspreadsheet;

import net.java.dev.jspreadsheet.Node;

public class CellPoint
implements Comparable {
    private int col;
    private int row;

    public CellPoint(int aRow, int aCol) {
        this.row = aRow;
        this.col = aCol;
    }

    public int getCol() {
        return this.col;
    }

    public int getRow() {
        return this.row;
    }

    public int compareTo(Object x) {
        if (x instanceof CellPoint) {
            CellPoint y = (CellPoint)x;
            if (this.row > y.row) {
                return 1;
            }
            if (this.row == y.row) {
                if (this.col > y.col) {
                    return 1;
                }
                if (this.col == y.col) {
                    return 0;
                }
                return -1;
            }
            return -1;
        }
        return 2;
    }

    public boolean equals(Object x) {
        if (x instanceof CellPoint) {
            CellPoint y = (CellPoint)x;
            return this.row == y.row && this.col == y.col;
        }
        return false;
    }

    public String toString() {
        return Node.translateColumn(this.col) + Node.translateRow(this.row);
    }

    void setCol(int col) {
        this.col = col;
    }

    void setRow(int row) {
        this.row = row;
    }

    void incrCol(int x) {
        this.col += x;
    }

    void incrRow(int x) {
        this.row += x;
    }
}

