/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.jspreadsheet;

import java.util.LinkedList;
import net.java.dev.jspreadsheet.CellPoint;
import net.java.dev.jspreadsheet.Function;
import net.java.dev.jspreadsheet.Node;
import net.java.dev.jspreadsheet.ParserException;
import net.java.dev.jspreadsheet.SpreadsheetTableModel;

class FunctionCount
extends Function {
    FunctionCount() {
    }

    @Override
    public String getDescription() {
        return "Counts the number of cells that contain numbers and numbers within the list of arguments.";
    }

    @Override
    public String getUsage() {
        return "COUNT(value1,value2,...)";
    }

    @Override
    public Number evaluate(SpreadsheetTableModel table, Node node, int row, int col) throws ParserException {
        this.checkParamsExist(node);
        int count = 0;
        LinkedList params = node.getParams();
        if (params != null) {
            for (Node exp : params) {
                if (this.isRange(exp)) {
                    CellPoint[] addr = this.getFirst(exp).getAddressRange(row, col);
                    count += (addr[1].getRow() - addr[0].getRow() + 1) * (addr[1].getCol() - addr[0].getCol() + 1);
                    continue;
                }
                ++count;
            }
        }
        return new Integer(count);
    }
}

