/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.jspreadsheet;

import java.util.LinkedList;
import net.java.dev.jspreadsheet.CellPoint;
import net.java.dev.jspreadsheet.Formula;
import net.java.dev.jspreadsheet.Function;
import net.java.dev.jspreadsheet.FunctionAverage;
import net.java.dev.jspreadsheet.FunctionCount;
import net.java.dev.jspreadsheet.Node;
import net.java.dev.jspreadsheet.ParserException;
import net.java.dev.jspreadsheet.SpreadsheetTableModel;

class FunctionMeandev
extends Function {
    FunctionMeandev() {
    }

    @Override
    public String getDescription() {
        return "Returns the average absolute deviation in a set of values.";
    }

    @Override
    public String getUsage() {
        return "MEANDEV(value1,value2,...)";
    }

    @Override
    public Number evaluate(SpreadsheetTableModel table, Node node, int row, int col) throws ParserException {
        float dev = 0.0f;
        float nCells = new FunctionCount().evaluate(table, node, row, col).floatValue();
        float mean = new FunctionAverage().evaluate(table, node, row, col).floatValue();
        LinkedList params = node.getParams();
        if (params != null) {
            for (Node exp : params) {
                if (this.isRange(exp)) {
                    CellPoint[] addr = this.getFirst(exp).getAddressRange(row, col);
                    for (int i = addr[0].getRow(); i <= addr[1].getRow(); ++i) {
                        for (int j = addr[0].getCol(); j <= addr[1].getCol(); ++j) {
                            dev += Math.abs(table.getNumericValueAt(i, j).floatValue() - mean);
                        }
                    }
                    continue;
                }
                dev += Math.abs(Formula.evaluate(table, exp.getExp(), row, col).floatValue());
            }
        }
        return new Float(dev / nCells);
    }
}

