/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.jspreadsheet;

import java.util.LinkedList;
import net.java.dev.jspreadsheet.CellPoint;
import net.java.dev.jspreadsheet.Formula;
import net.java.dev.jspreadsheet.Function;
import net.java.dev.jspreadsheet.Node;
import net.java.dev.jspreadsheet.ParserException;
import net.java.dev.jspreadsheet.SpreadsheetTableModel;

class FunctionMin
extends Function {
    FunctionMin() {
    }

    @Override
    public String getDescription() {
        return "Returns the smallest number in a set of values.";
    }

    @Override
    public String getUsage() {
        return "MIN(value1,value2,...)";
    }

    @Override
    public Number evaluate(SpreadsheetTableModel table, Node node, int row, int col) throws ParserException {
        this.checkParamsExist(node);
        float min = Float.MAX_VALUE;
        LinkedList params = node.getParams();
        if (params != null) {
            for (Node exp : params) {
                if (this.isRange(exp)) {
                    CellPoint[] addr = this.getFirst(exp).getAddressRange(row, col);
                    for (int i = addr[0].getRow(); i <= addr[1].getRow(); ++i) {
                        for (int j = addr[0].getCol(); j <= addr[1].getCol(); ++j) {
                            float value = table.getNumericValueAt(i, j).floatValue();
                            if (!(value < min)) continue;
                            min = value;
                        }
                    }
                    continue;
                }
                float value = Formula.evaluate(table, exp.getExp(), row, col).floatValue();
                if (!(value < min)) continue;
                min = value;
            }
        }
        return new Float(min);
    }
}

