/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.jspreadsheet;

import net.java.dev.jspreadsheet.Formula;
import net.java.dev.jspreadsheet.Function;
import net.java.dev.jspreadsheet.Node;
import net.java.dev.jspreadsheet.ParserException;
import net.java.dev.jspreadsheet.SpreadsheetTableModel;

class FunctionRange
extends Function {
    FunctionRange() {
    }

    @Override
    public String getDescription() {
        return "Returns the difference between MAX and MIN in a set of values.";
    }

    @Override
    public String getUsage() {
        return "RANGE(value1,value2,...)";
    }

    @Override
    public Number evaluate(SpreadsheetTableModel table, Node node, int row, int col) throws ParserException {
        float max = Formula.getFuncHandler("MAX").evaluate(table, node, row, col).floatValue();
        float min = Formula.getFuncHandler("MIN").evaluate(table, node, row, col).floatValue();
        return new Float(max - min);
    }
}

