/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.jspreadsheet;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEditSupport;
import net.java.dev.jspreadsheet.CellRange;
import net.java.dev.jspreadsheet.Debug;
import net.java.dev.jspreadsheet.SpreadsheetClipboard;
import net.java.dev.jspreadsheet.SpreadsheetTableModel;

class History
extends UndoableEditSupport {
    public static final int UNCHANGED = 0;
    public static final int INSERTROW = 1;
    public static final int INSERTCOLUMN = 2;
    public static final int REMOVEROW = 3;
    public static final int REMOVECOLUMN = 4;
    private SpreadsheetTableModel model;

    History() {
    }

    public void add(CellRange range) {
        SpreadsheetClipboard clip = new SpreadsheetClipboard(this.model, range, false);
        this.add(clip);
    }

    public void add(SpreadsheetClipboard clip) {
        UndoableUpdate node = new UndoableUpdate(clip);
        if (Debug.isDebug()) {
            Debug.println("Add history for range " + clip.getSource());
        }
        this.postEdit(node);
        this.model.setModified(true);
    }

    public void add(CellRange range, int type) {
        UndoableUpdate node;
        if (type == 0) {
            this.add(range);
            return;
        }
        if (type == 3 || type == 4) {
            SpreadsheetClipboard clip = new SpreadsheetClipboard(this.model, range, false);
            node = new UndoableUpdate(clip);
        } else {
            node = new UndoableUpdate(range);
        }
        node.setType(type);
        this.postEdit(node);
        this.model.setModified(true);
    }

    void setTableModel(SpreadsheetTableModel model) {
        this.model = model;
    }

    private void redo(UndoableUpdate current) {
        int type = current.getType();
        if (type == 0) {
            SpreadsheetClipboard oldClip = (SpreadsheetClipboard)current.getObject();
            CellRange range = oldClip.getSource();
            SpreadsheetClipboard newClip = new SpreadsheetClipboard(this.model, range, false);
            current.setObject(newClip);
            oldClip.paste(this.model, range.getminCorner());
            this.model.setSelection(range);
        } else if (type == 3 || type == 4) {
            SpreadsheetClipboard clip = (SpreadsheetClipboard)current.getObject();
            CellRange range = clip.getSource();
            if (type == 3) {
                this.model.removeRow(range);
            } else {
                this.model.removeColumn(range);
            }
        } else {
            CellRange range = (CellRange)current.getObject();
            if (type == 1) {
                this.model.insertRow(range);
            } else {
                this.model.insertColumn(range);
            }
        }
        this.model.setModified(true);
    }

    private void undo(UndoableUpdate current) {
        CellRange range;
        int type = current.getType();
        if (type == 0) {
            SpreadsheetClipboard oldClip = (SpreadsheetClipboard)current.getObject();
            range = oldClip.getSource();
            SpreadsheetClipboard newClip = new SpreadsheetClipboard(this.model, range, false);
            current.setObject(newClip);
            oldClip.paste(this.model, range.getminCorner());
        } else if (type == 3 || type == 4) {
            SpreadsheetClipboard clip = (SpreadsheetClipboard)current.getObject();
            range = clip.getSource();
            if (type == 3) {
                this.model.insertRow(range);
            } else {
                this.model.insertColumn(range);
            }
            clip.paste(this.model, range.getminCorner());
        } else {
            range = (CellRange)current.getObject();
            if (type == 1) {
                this.model.removeRow(range);
            } else {
                this.model.removeColumn(range);
            }
        }
        this.model.setSelection(range);
        this.model.setModified(true);
    }

    class UndoableUpdate
    extends AbstractUndoableEdit {
        private Object obj;
        private int type;

        public UndoableUpdate(Object obj) {
            this.setObject(obj);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            History.this.redo(this);
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            History.this.undo(this);
        }

        void setObject(Object obj) {
            this.obj = obj;
        }

        Object getObject() {
            return this.obj;
        }

        void setType(int type) {
            this.type = type;
        }

        int getType() {
            return this.type;
        }
    }
}

