/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.jspreadsheet;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import net.java.dev.jspreadsheet.Cell;
import net.java.dev.jspreadsheet.CellPoint;
import net.java.dev.jspreadsheet.CellRange;
import net.java.dev.jspreadsheet.Debug;
import net.java.dev.jspreadsheet.Formula;
import net.java.dev.jspreadsheet.History;
import net.java.dev.jspreadsheet.Node;
import net.java.dev.jspreadsheet.SpreadsheetCellEditor;
import net.java.dev.jspreadsheet.SpreadsheetCellRenderer;
import net.java.dev.jspreadsheet.SpreadsheetSelectionEvent;
import net.java.dev.jspreadsheet.SpreadsheetSelectionListener;
import net.java.dev.jspreadsheet.SpreadsheetTableModel;

public class JSpreadsheet
extends JComponent {
    private CellPoint copyPoint = new CellPoint(0, 0);
    private Clipboard system = Toolkit.getDefaultToolkit().getSystemClipboard();
    private History history = new History();
    private JTable table = this.createTable();
    private SpreadsheetTableModel tableModel;
    private int columnWidth;

    public JSpreadsheet(int rows, int columns) {
        this.setLayout(new BorderLayout());
        this.newTableModel(rows, columns);
        this.table.setAutoResizeMode(0);
        this.table.setDefaultRenderer(Cell.class, new SpreadsheetCellRenderer());
        this.table.setDefaultEditor(Cell.class, new SpreadsheetCellEditor(new JTextField()));
        this.table.setSelectionMode(1);
        this.table.setCellSelectionEnabled(true);
        HeaderMouseAdapter ml = new HeaderMouseAdapter();
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getTableHeader().addMouseListener(ml);
        ListSelectionModel rowSelectionModel = this.table.getSelectionModel();
        ListSelectionModel columnSelectionModel = this.table.getColumnModel().getSelectionModel();
        JScrollPane scrollPane = new JScrollPane(this.table, 22, 32);
        this.add((Component)scrollPane, "Center");
        JTable rowHeader = new JTable(new RowModel(this.table.getModel()));
        RowHeaderRenderer renderer = new RowHeaderRenderer();
        Component comp = renderer.getTableCellRendererComponent(rowHeader, null, false, false, rowHeader.getRowCount() - 1, 0);
        rowHeader.setIntercellSpacing(new Dimension(0, 0));
        Dimension d = rowHeader.getPreferredScrollableViewportSize();
        d.width = comp.getPreferredSize().width;
        rowHeader.setPreferredScrollableViewportSize(d);
        rowHeader.setRowHeight(this.table.getRowHeight());
        rowHeader.setDefaultRenderer(Object.class, renderer);
        rowHeader.addMouseListener(ml);
        scrollPane.setRowHeaderView(rowHeader);
        JPanel blank = new JPanel();
        blank.addMouseListener(ml);
        scrollPane.setCorner("UPPER_LEFT_CORNER", blank);
        this.table.setRequestFocusEnabled(true);
        this.table.requestFocus();
        Formula.registerFunctions();
        SelectionAdapter lsl = new SelectionAdapter();
        this.table.getSelectionModel().addListSelectionListener(lsl);
        this.table.getColumnModel().getSelectionModel().addListSelectionListener(lsl);
    }

    public Cell getCellAt(int row, int col) {
        return this.tableModel.getCellAt(row, col);
    }

    public int getColumnCount() {
        return this.tableModel.getColumnCount();
    }

    public void setContents(String text) {
        this.setContents(text, ',');
    }

    public void setContents(String text, char delim) {
        TableCellEditor editor = this.table.getCellEditor();
        if (editor != null) {
            editor.cancelCellEditing();
        }
        CellPoint size = SpreadsheetTableModel.getSize(text, delim);
        this.newTableModel(size.getRow(), size.getCol());
        this.tableModel.fromString(text, delim, 0, 0, new CellRange(0, size.getRow(), 0, size.getCol()));
    }

    public String getContents() {
        return this.getContents(',');
    }

    public String getContents(char delim) {
        return this.tableModel.toString(delim);
    }

    public boolean isDeletionSafe(boolean byRow, int start, int end) {
        TableCellEditor editor = this.table.getCellEditor();
        if (editor != null) {
            editor.cancelCellEditing();
        }
        CellRange range = this.insertRemoveRange(byRow, start, end);
        return this.tableModel.isDeletionSafe(range, byRow);
    }

    public void setModified(boolean modified) {
        this.tableModel.setModified(modified);
    }

    public boolean isModified() {
        return this.tableModel.isModified();
    }

    public int getRowCount() {
        return this.tableModel.getRowCount();
    }

    public void setSelectedRange(CellRange range) {
        this.table.setColumnSelectionInterval(range.getStartCol(), range.getEndCol());
        this.table.setRowSelectionInterval(range.getStartRow(), range.getEndRow());
        this.table.scrollRectToVisible(new Rectangle(this.table.getCellRect(range.getStartRow(), range.getStartCol(), true)));
    }

    public CellRange getSelectedRange() {
        if (this.table.getSelectedRowCount() != 0 && this.table.getSelectedColumnCount() != 0) {
            int[] rows = this.table.getSelectedRows();
            int[] cols = this.table.getSelectedColumns();
            int minColIndex = 0;
            if (cols[0] < 0) {
                if (cols.length == 1) {
                    return null;
                }
                ++minColIndex;
            }
            int minRow = rows[0];
            int maxRow = rows[rows.length - 1];
            int minCol = cols[minColIndex];
            int maxCol = cols[cols.length - 1];
            return new CellRange(minRow, maxRow, minCol, maxCol);
        }
        return null;
    }

    public void setValueAt(Object value, int row, int col) {
        this.tableModel.doSetValueAt(value, row, col);
    }

    public void addSelectionListener(SpreadsheetSelectionListener l) {
        this.listenerList.add(SpreadsheetSelectionListener.class, l);
    }

    public void addUndoableEditListener(UndoableEditListener l) {
        this.history.addUndoableEditListener(l);
    }

    public void clear(CellRange range) {
        TableCellEditor editor = this.table.getCellEditor();
        if (editor != null) {
            editor.cancelCellEditing();
        }
        this.history.add(range);
        Debug.println("Clear");
        this.tableModel.clearRange(range);
    }

    public void copy() {
        this.doCopy(false);
    }

    public void cut() {
        this.doCopy(true);
    }

    public void fill(CellRange range, String value) {
        TableCellEditor editor = this.table.getCellEditor();
        if (editor != null) {
            editor.cancelCellEditing();
        }
        this.history.add(range);
        this.tableModel.fillRange(range, value);
    }

    public CellPoint find(CellPoint start, String findValue, boolean matchCase, boolean matchCell) {
        TableCellEditor editor = this.table.getCellEditor();
        if (editor != null) {
            editor.cancelCellEditing();
        }
        return this.tableModel.look(start, SpreadsheetTableModel.fieldParser(findValue), matchCase, matchCell);
    }

    public void insert(boolean byRow, int start, int end) {
        TableCellEditor editor = this.table.getCellEditor();
        if (editor != null) {
            editor.cancelCellEditing();
        }
        CellRange range = this.insertRemoveRange(byRow, start, end);
        if (byRow) {
            this.history.add(range, 1);
            this.tableModel.insertRow(range);
        } else {
            this.history.add(range, 2);
            this.tableModel.insertColumn(range);
        }
    }

    public void paste() {
        TableCellEditor editor = this.table.getCellEditor();
        if (editor != null) {
            editor.cancelCellEditing();
        }
        if (this.table.getSelectedRowCount() != 0) {
            int startRow = this.table.getSelectedRow();
            int startCol = this.table.getSelectedColumn();
            int rowOff = startRow - this.copyPoint.getRow();
            int colOff = startCol - this.copyPoint.getCol();
            try {
                String trstring = (String)this.system.getContents(this).getTransferData(DataFlavor.stringFlavor);
                CellPoint size = SpreadsheetTableModel.getSize(trstring, '\t');
                int endRow = Math.min(this.table.getRowCount() - 1, startRow + size.getRow() - 1);
                int endCol = Math.min(this.table.getColumnCount() - 1, startCol + size.getCol() - 1);
                CellRange affectedRange = new CellRange(startRow, endRow, startCol, endCol);
                this.history.add(affectedRange);
                this.tableModel.fromString(trstring, '\t', rowOff, colOff, affectedRange);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void remove(boolean byRow, int start, int end) {
        TableCellEditor editor = this.table.getCellEditor();
        if (editor != null) {
            editor.cancelCellEditing();
        }
        CellRange range = this.insertRemoveRange(byRow, start, end);
        if (byRow) {
            this.history.add(range, 3);
            Debug.println(range);
            this.tableModel.removeRow(range);
            Debug.println("Delete row range " + range);
        } else {
            Debug.println("Delete column range " + range);
            this.history.add(range, 4);
            Debug.println(range);
            this.tableModel.removeColumn(range);
        }
    }

    public void removeSelectionListener(SpreadsheetSelectionListener l) {
        this.listenerList.remove(SpreadsheetSelectionListener.class, l);
    }

    public void removeUndoableEditListener(UndoableEditListener l) {
        this.history.removeUndoableEditListener(l);
    }

    public void sort(CellRange range, int first, int second, boolean byRow, boolean firstAscending, boolean secondAscending) {
        TableCellEditor editor = this.table.getCellEditor();
        if (editor != null) {
            editor.cancelCellEditing();
        }
        this.history.add(range);
        if (second < 0) {
            second = first;
        }
        this.tableModel.sort(range, first, second, byRow, firstAscending, secondAscending);
    }

    public static String translateColumn(int column) {
        return Node.translateColumn(column);
    }

    public static int translateColumn(String column) {
        return Node.translateColumn(column);
    }

    public static String translateRow(int row) {
        return Node.translateRow(row);
    }

    public static int translateRow(String row) {
        return Node.translateRow(row);
    }

    public void setColumnWidth(int columnWidth) {
        this.columnWidth = columnWidth;
        this.applyColumnWidth(columnWidth);
    }

    public int getColumnWidth() {
        return this.columnWidth;
    }

    protected JTable createTable() {
        return new JTable();
    }

    protected void fireSelectionChanged() {
        SpreadsheetSelectionListener[] listeners = (SpreadsheetSelectionListener[])this.listenerList.getListeners(SpreadsheetSelectionListener.class);
        SpreadsheetSelectionEvent event = new SpreadsheetSelectionEvent(this, this.getSelectedRange());
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].selectionChanged(event);
        }
    }

    private void applyColumnWidth(int colWidth) {
        if (colWidth > 0) {
            for (int i = 0; i < this.table.getModel().getColumnCount(); ++i) {
                TableColumn column = this.table.getColumnModel().getColumn(i);
                column.setMinWidth(colWidth);
                column.setPreferredWidth(colWidth);
            }
        }
    }

    private void doCopy(boolean isCut) {
        TableCellEditor editor = this.table.getCellEditor();
        if (editor != null) {
            editor.cancelCellEditing();
        }
        if (this.table.getSelectedRowCount() != 0) {
            CellRange range = new CellRange(this.table.getSelectedRows(), this.table.getSelectedColumns());
            if (isCut) {
                this.history.add(range);
            }
            StringBuffer sbf = new StringBuffer();
            int startRow = this.table.getSelectedRow();
            int startCol = this.table.getSelectedColumn();
            int numrows = this.table.getSelectedRowCount();
            int numcols = this.table.getSelectedColumnCount();
            this.copyPoint = new CellPoint(this.table.getSelectedRow(), this.table.getSelectedColumn());
            String str = this.tableModel.toString(range, false, '\t');
            StringSelection stsel = new StringSelection(str);
            this.system.setContents(stsel, stsel);
            if (isCut) {
                this.tableModel.clearRange(range);
            }
        }
    }

    private CellRange insertRemoveRange(boolean byRow, int start, int end) {
        if (byRow) {
            return new CellRange(start, end, 0, this.tableModel.getColumnCount() - 1);
        }
        return new CellRange(0, this.tableModel.getRowCount() - 1, start, end);
    }

    private void newTableModel(int rows, int cols) {
        this.tableModel = new SpreadsheetTableModel(this.table, rows, cols);
        this.table.setModel(this.tableModel);
        this.applyColumnWidth(this.columnWidth);
        this.history.setTableModel(this.tableModel);
        this.tableModel.setHistory(this.history);
        this.tableModel.setPasswordModified(false);
        this.tableModel.setModified(false);
    }

    public Action[] getActions() {
        return new Action[0];
    }

    private class SelectionAdapter
    implements ListSelectionListener {
        private SelectionAdapter() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int c = JSpreadsheet.this.listenerList.getListenerCount(SpreadsheetSelectionListener.class);
            if (c > 0) {
                JSpreadsheet.this.fireSelectionChanged();
            }
        }
    }

    private static class RowModel
    implements TableModel {
        private TableModel source;

        RowModel(TableModel source) {
            this.source = source;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int columnIndex) {
            return Object.class;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return null;
        }

        @Override
        public int getRowCount() {
            return this.source.getRowCount();
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return null;
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
        }
    }

    private static class RowHeaderRenderer
    extends DefaultTableCellRenderer {
        public RowHeaderRenderer() {
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setHorizontalAlignment(4);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            JTableHeader header;
            if (table != null && (header = table.getTableHeader()) != null) {
                this.setForeground(header.getForeground());
                this.setBackground(header.getBackground());
            }
            this.setValue(String.valueOf(row + 1));
            return this;
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        }
    }

    private class HeaderMouseAdapter
    extends MouseAdapter {
        private HeaderMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int col = -1;
            int row = -1;
            if (e.getSource() instanceof JTableHeader) {
                col = JSpreadsheet.this.table.columnAtPoint(e.getPoint());
            }
            if (e.getSource() instanceof JTable) {
                row = JSpreadsheet.this.table.rowAtPoint(e.getPoint());
            }
            int rowCount = JSpreadsheet.this.table.getRowCount();
            int colCount = JSpreadsheet.this.table.getColumnCount();
            JSpreadsheet.this.table.setRowSelectionInterval(0, rowCount - 1);
            if (col >= 0) {
                JSpreadsheet.this.table.setColumnSelectionInterval(col, col);
                JSpreadsheet.this.table.setRowSelectionInterval(0, rowCount - 1);
            } else if (row >= 0) {
                JSpreadsheet.this.table.setColumnSelectionInterval(0, colCount - 1);
                JSpreadsheet.this.table.setRowSelectionInterval(row, row);
            } else {
                JSpreadsheet.this.table.setColumnSelectionInterval(0, colCount - 1);
                JSpreadsheet.this.table.setRowSelectionInterval(0, rowCount - 1);
            }
        }
    }
}

