/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.jspreadsheet;

import java.util.LinkedList;
import net.java.dev.jspreadsheet.CellPoint;

class Node {
    public static final int DEFAULT = 0;
    public static final int REL_ADDR = 1;
    public static final int ABS_ADDR = 2;
    public static final int FUNCTION = 3;
    public static final int LPAREN = 4;
    public static final int RPAREN = 5;
    public static final int NUMBER = 6;
    public static final int OPERATOR = 7;
    public static final int COMMA = 8;
    public static final int COLON = 9;
    public static final int EXP = 10;
    private static final String[] desc = new String[]{"Default", "Rel_Addr", "Abs_Addr", "Function", "LBracket", "RBracket", "Number", "Operator", "Comma", "Colon", "Param"};
    private LinkedList exp;
    private Node nextRange;
    private String data;
    private boolean pending;
    private float number;
    private int col;
    private int row;
    private int type;

    Node() {
    }

    Node(Node node) {
        this.type = node.type;
        if (this.data != null) {
            this.data = new String(node.data);
        }
        this.number = node.number;
        this.row = node.row;
        this.col = node.col;
    }

    public void setCol(int col) {
        this.col = col;
    }

    public int getCol() {
        return this.col;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getData() {
        return this.data;
    }

    public void setExp(LinkedList exp) {
        this.exp = exp;
    }

    public LinkedList getExp() {
        return this.exp;
    }

    public void setNextRange(Node node) {
        this.nextRange = node;
    }

    public Node getNextRange() {
        return this.nextRange;
    }

    public void setNumber(float number) {
        this.number = number;
    }

    public float getNumber() {
        return this.number;
    }

    public void setParams(LinkedList list) {
        this.exp = list;
    }

    public LinkedList getParams() {
        return this.exp;
    }

    public void setPending(boolean pending) {
        this.pending = pending;
    }

    public boolean isPending() {
        return this.pending;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public int getRow() {
        return this.row;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public boolean isType(int type) {
        return this.type == type;
    }

    public void addParam(Node node) {
        if (node.getExp().size() > 0) {
            this.exp.add(node);
        }
    }

    public void appendData(char data) {
        this.data = this.data + data;
    }

    public void appendData(String data) {
        this.data = this.data + data;
    }

    public boolean hasValue() {
        return this.type == 6 || this.type == 1 || this.type == 2 || this.type == 3 || this.type == 5;
    }

    public String toString() {
        switch (this.type) {
            case 6: {
                return Float.toString(this.number);
            }
            case 1: {
                StringBuffer buf1 = new StringBuffer();
                buf1.append('(');
                buf1.append(String.valueOf(this.col));
                buf1.append(',');
                buf1.append(this.row);
                buf1.append(')');
                return buf1.toString();
            }
            case 2: {
                StringBuffer buf2 = new StringBuffer();
                buf2.append('$');
                buf2.append(Node.translateColumn(this.col));
                buf2.append('$');
                buf2.append(Node.translateRow(this.row));
                return buf2.toString();
            }
            case 3: {
                return this.data + this.exp.toString();
            }
            case 10: {
                return this.exp.toString();
            }
            case 4: {
                return "(";
            }
            case 5: {
                return ")";
            }
            case 8: {
                return ",";
            }
            case 9: {
                return this.nextRange.toString() + ":" + this.nextRange.nextRange.toString();
            }
        }
        return this.data;
    }

    public static int translateColumn(String column) {
        int col = 0;
        for (int i = 0; i < column.length(); ++i) {
            col = col * 26 + (column.charAt(i) - 65 + 1);
        }
        return col - 1;
    }

    public static String translateColumn(int column) {
        if (++column < 1) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        int div = 1;
        while (div > 0) {
            div = (column - 1) / 26;
            buf.insert(0, (char)(65 + (column - 1 - div * 26)));
            column = div;
        }
        return buf.toString();
    }

    public static int translateRow(String row) {
        int r = Integer.parseInt(row);
        return r - 1;
    }

    public static String translateRow(int row) {
        if (row < 0) {
            return null;
        }
        return String.valueOf(row + 1);
    }

    public CellPoint[] getAddressRange(int row, int col) {
        CellPoint[] addr = new CellPoint[2];
        if (this.isType(9)) {
            CellPoint addr1 = this.getNextRange().toCellPoint(row, col);
            CellPoint addr2 = this.getNextRange().getNextRange().toCellPoint(row, col);
            addr[0] = new CellPoint(Node.min(addr1.getRow(), addr2.getRow()), Node.min(addr1.getCol(), addr2.getCol()));
            addr[1] = new CellPoint(Node.max(addr1.getRow(), addr2.getRow()), Node.max(addr1.getCol(), addr2.getCol()));
        } else {
            CellPoint cell;
            addr[0] = cell = this.toCellPoint(row, col);
            addr[1] = cell;
        }
        return addr;
    }

    public CellPoint toCellPoint(int row, int col) {
        if (this.isType(1)) {
            return new CellPoint(this.getRow() + row, this.getCol() + col);
        }
        return new CellPoint(this.getRow(), this.getCol());
    }

    private static int max(int m, int n) {
        return m > n ? m : n;
    }

    private static int min(int m, int n) {
        return m < n ? m : n;
    }
}

