/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.jspreadsheet;

import net.java.dev.jspreadsheet.CellPoint;
import net.java.dev.jspreadsheet.CellRange;
import net.java.dev.jspreadsheet.SpreadsheetTableModel;

class SpreadsheetClipboard {
    private CellRange source;
    private String text;

    public SpreadsheetClipboard(SpreadsheetTableModel model, CellRange range, boolean isCut) {
        this.text = model.toString(range, false, '\t');
        this.source = range;
        if (isCut) {
            model.clearRange(range);
        }
    }

    public CellRange getRange(SpreadsheetTableModel model, CellPoint corner) {
        int rowLimit = model.getRowCount() - 1;
        int colLimit = model.getColumnCount() - 1;
        int rowMax = corner.getRow() + this.source.getHeight() - 1;
        int colMax = corner.getCol() + this.source.getWidth() - 1;
        if (corner.getRow() < 0 || corner.getCol() < 0) {
            return null;
        }
        return new CellRange(corner, new CellPoint(Math.min(rowMax, rowLimit), Math.min(colMax, colLimit)));
    }

    public void setSource(CellRange x) {
        this.source = x;
    }

    public CellRange getSource() {
        return this.source;
    }

    public void paste(SpreadsheetTableModel table, CellPoint corner) {
        CellRange range = this.getRange(table, corner);
        this.paste(table, range);
    }

    public void paste(SpreadsheetTableModel table, CellRange range) {
        if (range != null) {
            int rowOff = range.getStartRow() - this.source.getStartRow();
            int colOff = range.getStartCol() - this.source.getStartCol();
            table.fromString(this.text, '\t', rowOff, colOff, range);
        }
    }

    public String toString() {
        return this.text;
    }
}

