/*
 * Decompiled with CFR 0.152.
 */
package com.trend.iwss.jscan.runtime;

import com.trend.iwss.jscan.runtime.Msgs;
import com.trend.iwss.jscan.runtime.Session;
import com.trend.iwss.jscan.runtime.StubAppletDisplay;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.InvocationTargetException;

public class BaseDialog
extends Dialog
implements WindowListener {
    public static final int PANEL_WIDTH = 400;
    public static final int PANEL_HEIGHT = 150;
    private final Object disposeLock = new Object();
    private Session m_ses;
    private boolean m_disposed = false;
    private Frame m_owner;

    public BaseDialog(Frame frame, Session session) {
        super(frame, BaseDialog.getMsg(session, "instr.dialog.title.applet_alert"), true);
        this.m_owner = frame;
        this.m_ses = session;
        this.addWindowListener(this);
        ((Component)this).setSize(400, 150);
        this.setLayout(new BorderLayout(10, 10));
    }

    protected boolean canDisplay() {
        BaseDialog.syserr("BaseDialog: owner frame is a " + this.m_owner.getClass().getName());
        return true;
    }

    protected String getMsg(String string) {
        return BaseDialog.getMsg(this.m_ses, string);
    }

    protected static String getMsg(Session session, String string) {
        if (null != session) {
            return session.getMsg(string);
        }
        return Msgs.getDefaultMsg(string);
    }

    protected static Frame getActiveFrame(Session session) {
        Frame frame = session.getActiveFrame();
        if (null != frame) {
            return frame;
        }
        return new Frame();
    }

    private void doDisplay() {
        if (null != this.m_ses) {
            this.m_ses.addOpenDialog(this);
        }
        this.pack();
        StubAppletDisplay.setDialogPosition(this, this, 150, 400);
        this.show();
        if (null != this.m_ses) {
            this.m_ses.removeOpenDialog(this);
        }
    }

    protected void displayDialog() {
        if (this.m_disposed) {
            BaseDialog.syserr("BaseDialog: display() called for disposed dialog");
            return;
        }
        if (!this.canDisplay()) {
            BaseDialog.syserr("BaseDialog: not displaying: m_owner.isDisplayable() == " + this.m_owner.isDisplayable());
            return;
        }
        if (EventQueue.isDispatchThread()) {
            this.doDisplay();
        } else {
            this.dispatch();
        }
    }

    private void dispatch() {
        Runnable runnable = new Runnable(){

            public void run() {
                BaseDialog.this.doDisplay();
            }
        };
        try {
            EventQueue.invokeAndWait(runnable);
        }
        catch (InterruptedException interruptedException) {
            BaseDialog.syserr("BaseDialog: dispatch(): InterruptedException: " + interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            BaseDialog.syserr("BaseDialog: InvocationTargetException in displayDialog");
            invocationTargetException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.disposeLock;
        synchronized (object) {
            if (this.m_disposed) {
                return;
            }
            this.m_disposed = true;
            super.dispose();
        }
    }

    protected static void syserr(String string) {
        System.err.println(string);
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.dispose();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

