/*
 * Decompiled with CFR 0.152.
 */
package com.trend.iwss.jscan.runtime;

import com.trend.iwss.jscan.runtime.CallContext;
import com.trend.iwss.jscan.runtime.MethodRefMatcher;
import com.trend.iwss.jscan.runtime.PolicyRuntime;
import com.trend.iwss.jscan.runtime.RuntimeValue;
import com.trend.iwss.jscan.runtime.Session;
import java.util.Vector;

public final class MiscPolicyRuntime
extends PolicyRuntime {
    public static final String FULLCLASSPATH = PolicyRuntime.classNameSlashNotation(class$com$trend$iwss$jscan$runtime$MiscPolicyRuntime == null ? (class$com$trend$iwss$jscan$runtime$MiscPolicyRuntime = MiscPolicyRuntime.class$("com.trend.iwss.jscan.runtime.MiscPolicyRuntime")) : class$com$trend$iwss$jscan$runtime$MiscPolicyRuntime);
    public static final String NAME = "Misc";
    public static final String PROP_PREFIX = "misc";
    public static final Factory FACT = new Factory("Misc");
    public static final String CFG_MISC_BLOCK_COM_MS_PKGS_BOOL = "block_com_ms_pkgs";
    public static final String CFG_MISC_BLOCK_NETSCAPE_PKGS_BOOL = "block_netscape_pkgs";
    private static final String[] SYSTEM_PROPS_GENERAL = new String[]{"java.version", "java.vendor", "java.vendor.url", "java.vm.specification.version", "java.vm.specification.vendor", "java.vm.specification.name", "java.vm.version", "java.vm.vendor", "java.vm.name", "java.specification.version", "java.specification.vendor", "java.specification.name", "java.class.version", "java.compiler", "file.separator", "path.separator", "line.separator", "os.name", "os.arch", "os.version"};
    private static final String[] SYSTEM_PROPS_SENSITIVE = new String[]{"java.home", "java.class.path", "java.library.path", "java.io.tmpdir", "java.ext.dirs", "user.name", "user.home", "user.dir"};
    private static final Vector SYSTEM_PROPERTIES_GENERAL = MiscPolicyRuntime.arrayToVector(SYSTEM_PROPS_GENERAL);
    private static final Vector SYSTEM_PROPERTIES_SENSITIVE = MiscPolicyRuntime.arrayToVector(SYSTEM_PROPS_SENSITIVE);
    private static final String STRING_ARG = "(Ljava/lang/String;*";
    private static final String RUNTIME_CLASS = "java/lang/Runtime";
    private static final String SYSTEM_CLASS = "java/lang/System";
    private static final String[] RUNTIME_METHODS_OTHER = new String[]{"exit", "gc", "halt", "addShutdownHook", "removeShutdownHook", "runFinalization", "runFinalizersOnExit", "traceInstructions", "traceMethodCalls"};
    private static final String[] RUNTIME_METHODS_LOAD = new String[]{"load", "loadLibrary"};
    private static final String[] SYSTEM_METHODS_OTHER = new String[]{"exit", "gc", "inheritedChannel", "runFinalization", "setProperties", "getProperties"};
    private static final String[] SYSTEM_METHODS_PROPERTY_SET = new String[]{"clearProperty", "setProperty"};
    private static final String[] SYSTEM_METHODS_LOAD = new String[]{"load", "loadLibrary"};
    public static final MethodRefMatcher.Set MATCHERS = new MethodRefMatcher.Set();
    public static final MethodRefMatcher MATCH_JAVA_RUNTIME_EXEC = MATCHERS.make("java/lang/Runtime", "exec");
    public static final MethodRefMatcher MATCH_JAVA_RUNTIME_OTHER = MATCHERS.make("java/lang/Runtime", RUNTIME_METHODS_OTHER);
    public static final MethodRefMatcher MATCH_JAVA_RUNTIME_LOAD = MATCHERS.make("java/lang/Runtime", RUNTIME_METHODS_LOAD, "(Ljava/lang/String;*");
    public static final MethodRefMatcher MATCH_JAVA_SYSTEM_OTHER = MATCHERS.make("java/lang/System", SYSTEM_METHODS_OTHER);
    public static final MethodRefMatcher MATCH_JAVA_SYSTEM_LOAD = MATCHERS.make("java/lang/System", SYSTEM_METHODS_LOAD, "(Ljava/lang/String;*");
    public static final MethodRefMatcher MATCH_SYS_SETPROPERTY = MATCHERS.make("java/lang/System", SYSTEM_METHODS_PROPERTY_SET, "(Ljava/lang/String;*");
    public static final MethodRefMatcher MATCH_SYS_GETENV = MATCHERS.make("java/lang/System", "getenv", "(Ljava/lang/String;*");
    public static final MethodRefMatcher MATCH_SYS_GETPROPERTY = MATCHERS.make("java/lang/System", "getProperty", "(Ljava/lang/String;*");
    public static final MethodRefMatcher MATCH_MS_CLASSES = MATCHERS.make("com/ms/*");
    public static final MethodRefMatcher MATCH_NETSCAPE_CLASSES = MATCHERS.make(new String[]{"-netscape/security/*", "netscape/*"});
    private boolean m_blockComMsPkgUse = this.getBoolPolicyProp("block_com_ms_pkgs", true);
    private boolean m_blockNetscapePkgUse = this.getBoolPolicyProp("block_netscape_pkgs", true);
    static /* synthetic */ Class class$com$trend$iwss$jscan$runtime$MiscPolicyRuntime;

    MiscPolicyRuntime(Session session) {
        super(NAME, PROP_PREFIX, session);
    }

    public static void preFilter(CallContext callContext) {
        PolicyRuntime.preFilter(callContext, FACT);
    }

    public static void postFilter(CallContext callContext) {
        PolicyRuntime.postFilter(callContext, FACT);
    }

    void _preFilter(CallContext callContext) {
        String string = callContext.getClassName();
        String string2 = callContext.getRefName();
        MethodRefMatcher methodRefMatcher = MATCHERS.getMatch(callContext);
        if (MATCH_MS_CLASSES == methodRefMatcher) {
            if (!this.m_blockComMsPkgUse) {
                return;
            }
            String string3 = callContext.getClassName() + "#" + string2 + "()";
            this.stopAction("instr.action.invoke", string3);
        } else if (MATCH_NETSCAPE_CLASSES == methodRefMatcher) {
            if (!this.m_blockNetscapePkgUse) {
                return;
            }
            String string4 = callContext.getClassName() + "#" + string2 + "()";
            this.stopAction("instr.action.invoke", string4);
        } else if (MATCH_JAVA_RUNTIME_EXEC == methodRefMatcher) {
            String string5 = MiscPolicyRuntime.getExecTarget(callContext);
            this.stopAction("instr.action.runtime.exec", string5);
        } else if (MATCH_SYS_GETPROPERTY == methodRefMatcher) {
            String string6 = MiscPolicyRuntime.getStrArg(callContext);
            if (!this.enforceForProperty(string6)) {
                return;
            }
            String[] stringArray = new String[]{string, string2, string6};
            this.stopAction("instr.action.invoke_sys_arg", stringArray);
        } else if (methodRefMatcher.hasArg()) {
            String string7 = MiscPolicyRuntime.getStrArg(callContext);
            String[] stringArray = new String[]{string, string2, string7};
            this.stopAction("instr.action.invoke_sys_arg", stringArray);
        } else {
            String[] stringArray = new String[]{string, string2};
            this.stopAction("instr.action.invoke_sys_noarg", stringArray);
        }
    }

    void _postFilter(CallContext callContext) {
    }

    private boolean enforceForProperty(String string) {
        String string2 = string.toLowerCase();
        if (SYSTEM_PROPERTIES_SENSITIVE.contains(string2)) {
            return true;
        }
        if (this.isEnforcementStrict()) {
            return true;
        }
        return this.isSensitiveTopLevel(string) && !SYSTEM_PROPERTIES_GENERAL.contains(string2);
    }

    private boolean isSensitiveTopLevel(String string) {
        return string.startsWith("java.") || string.startsWith("os.") || string.startsWith("user.");
    }

    private static String getStrArg(CallContext callContext) {
        RuntimeValue runtimeValue = callContext.getArg(0);
        if (null == runtimeValue) {
            return "";
        }
        Object object = runtimeValue.getObjectValue();
        if (!(object instanceof String)) {
            return "";
        }
        return (String)object;
    }

    private static String getExecTarget(CallContext callContext) {
        RuntimeValue runtimeValue = callContext.getArg(0);
        if (null == runtimeValue) {
            return "";
        }
        Object object = runtimeValue.getObjectValue();
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof String[]) {
            String[] stringArray = (String[])object;
            if (0 == stringArray.length) {
                return "";
            }
            return stringArray[0];
        }
        return "";
    }

    private static Vector arrayToVector(String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.addElement(stringArray[i]);
        }
        return vector;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class Factory
    extends PolicyRuntime.Factory {
        Factory(String string) {
            super(string);
        }

        PolicyRuntime make(Session session) {
            return new MiscPolicyRuntime(session);
        }
    }
}

