/*
 * Decompiled with CFR 0.152.
 */
package com.trend.iwss.jscan.runtime;

import com.trend.iwss.jscan.runtime.CallContext;
import com.trend.iwss.jscan.runtime.FileIOPolicyRuntime;
import com.trend.iwss.jscan.runtime.MethodRefMatcher;
import com.trend.iwss.jscan.runtime.MiscPolicyRuntime;
import com.trend.iwss.jscan.runtime.NetworkPolicyRuntime;
import com.trend.iwss.jscan.runtime.PolicyRuntime;
import com.trend.iwss.jscan.runtime.RuntimeValue;
import com.trend.iwss.jscan.runtime.ThreadPolicyRuntime;
import com.trend.iwss.jscan.runtime.WindowPolicyRuntime;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;

public final class ReflectionPolicyRuntime
extends PolicyRuntime {
    public static final String FULLCLASSPATH = PolicyRuntime.classNameSlashNotation(class$com$trend$iwss$jscan$runtime$ReflectionPolicyRuntime == null ? (class$com$trend$iwss$jscan$runtime$ReflectionPolicyRuntime = ReflectionPolicyRuntime.class$("com.trend.iwss.jscan.runtime.ReflectionPolicyRuntime")) : class$com$trend$iwss$jscan$runtime$ReflectionPolicyRuntime);
    public static final String NAME = "Reflection";
    public static final String PROP_PREFIX = "reflection";
    public static final MethodRefMatcher.Set MATCHERS = new MethodRefMatcher.Set("java/lang/reflect/");
    public static final MethodRefMatcher MATCH_METHOD = MATCHERS.make("java/lang/reflect/Method", "invoke", "(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;");
    public static final MethodRefMatcher MATCH_CONSTRUCTOR = MATCHERS.make("java/lang/reflect/Constructor", "newInstance", "([Ljava/lang/Object;)Ljava/lang/Object;");
    private static final Hashtable hash = new Hashtable();
    static /* synthetic */ Class class$com$trend$iwss$jscan$runtime$ReflectionPolicyRuntime;

    private ReflectionPolicyRuntime() {
        super(NAME, PROP_PREFIX, null);
    }

    public static void preFilter(CallContext callContext) {
        try {
            String string = ReflectionPolicyRuntime.getClassName(callContext);
            if (null == string) {
                return;
            }
            CallContext callContext2 = ReflectionPolicyRuntime.getReflectContext(callContext);
            if (null == callContext2) {
                return;
            }
            hash.put(callContext, callContext2);
            if (FileIOPolicyRuntime.MATCHERS.matchClass(string)) {
                FileIOPolicyRuntime.preFilter(callContext2);
            } else if (NetworkPolicyRuntime.MATCHERS.matchClass(string)) {
                NetworkPolicyRuntime.preFilter(callContext2);
            } else if (ThreadPolicyRuntime.MATCHERS.matchClass(string)) {
                ThreadPolicyRuntime.preFilter(callContext2);
            } else if (WindowPolicyRuntime.MATCHERS.matchClass(string)) {
                WindowPolicyRuntime.preFilter(callContext2);
            } else if (MiscPolicyRuntime.MATCHERS.matchClass(string)) {
                MiscPolicyRuntime.preFilter(callContext2);
            } else if (MATCHERS.match(callContext2)) {
                ReflectionPolicyRuntime.preFilter(callContext2);
            }
        }
        catch (Exception exception) {
            if (exception instanceof SecurityException) {
                throw (SecurityException)exception;
            }
            exception.printStackTrace();
        }
    }

    public static void postFilter(CallContext callContext) {
        try {
            String string = ReflectionPolicyRuntime.getClassName(callContext);
            if (null == string) {
                return;
            }
            CallContext callContext2 = (CallContext)hash.get(callContext);
            if (callContext2 == null) {
                return;
            }
            hash.remove(callContext);
            if (callContext.getTarget() instanceof Method) {
                callContext2.setResult(ReflectionPolicyRuntime.toRuntimeValue(callContext.getResult().getObjectValue(), ((Method)callContext.getTarget()).getReturnType()));
            } else if (callContext.getTarget() instanceof Constructor) {
                callContext2.setTarget(callContext.getResult().getObjectValue());
            } else {
                return;
            }
            if (FileIOPolicyRuntime.MATCHERS.matchClass(string)) {
                FileIOPolicyRuntime.preFilter(callContext2);
            } else if (NetworkPolicyRuntime.MATCHERS.matchClass(string)) {
                NetworkPolicyRuntime.preFilter(callContext2);
            } else if (ThreadPolicyRuntime.MATCHERS.matchClass(string)) {
                ThreadPolicyRuntime.preFilter(callContext2);
            } else if (WindowPolicyRuntime.MATCHERS.matchClass(string)) {
                WindowPolicyRuntime.preFilter(callContext2);
            } else if (MiscPolicyRuntime.MATCHERS.matchClass(string)) {
                MiscPolicyRuntime.preFilter(callContext2);
            } else if (MATCHERS.match(callContext2)) {
                ReflectionPolicyRuntime.postFilter(callContext2);
            }
        }
        catch (Exception exception) {
            if (exception instanceof SecurityException) {
                throw (SecurityException)exception;
            }
            exception.printStackTrace();
        }
    }

    void _preFilter(CallContext callContext) {
    }

    void _postFilter(CallContext callContext) {
    }

    private static CallContext getReflectContext(CallContext callContext) {
        if (callContext.getTarget() instanceof Method) {
            return ReflectionPolicyRuntime.transformMethodContext(callContext);
        }
        if (callContext.getTarget() instanceof Constructor) {
            return ReflectionPolicyRuntime.transformConstructorContext(callContext);
        }
        return null;
    }

    private static String getClassName(CallContext callContext) {
        Object object = callContext.getTarget();
        if (object instanceof Method) {
            return ((Method)object).getDeclaringClass().getName();
        }
        if (object instanceof Constructor) {
            return ((Constructor)object).getDeclaringClass().getName();
        }
        return null;
    }

    private static CallContext transformMethodContext(CallContext callContext) {
        Method method = (Method)callContext.getTarget();
        int n = Modifier.isStatic(method.getModifiers()) ? 184 : 182;
        Class[] classArray = method.getParameterTypes();
        String string = ReflectionPolicyRuntime.makeParamString(classArray, ReflectionPolicyRuntime.classToDesc(method.getReturnType()));
        CallContext callContext2 = new CallContext(n, method.getDeclaringClass().getName().replace('.', '/'), method.getName(), string, callContext.getThisObject());
        callContext2.setTarget(callContext.getArg(0).getObjectValue());
        Object[] objectArray = (Object[])callContext.getArg(1).getObjectValue();
        ReflectionPolicyRuntime.addArgsToCtx(callContext, objectArray, classArray);
        return callContext2;
    }

    private static CallContext transformConstructorContext(CallContext callContext) {
        Constructor constructor = (Constructor)callContext.getTarget();
        int n = 183;
        Class[] classArray = constructor.getParameterTypes();
        String string = ReflectionPolicyRuntime.makeParamString(classArray, "V");
        CallContext callContext2 = new CallContext(n, constructor.getDeclaringClass().getName().replace('.', '/'), "<init>", string, callContext.getThisObject());
        callContext2.setTarget(null);
        Object[] objectArray = (Object[])callContext.getArg(0).getObjectValue();
        ReflectionPolicyRuntime.addArgsToCtx(callContext, objectArray, classArray);
        return callContext2;
    }

    private static void addArgsToCtx(CallContext callContext, Object[] objectArray, Class[] classArray) {
        if (objectArray == null) {
            return;
        }
        if (classArray == null) {
            return;
        }
        for (int i = objectArray.length - 1; i >= 0; --i) {
            if (i >= classArray.length) continue;
            callContext.addArg(ReflectionPolicyRuntime.toRuntimeValue(objectArray[i], classArray[i]));
        }
    }

    private static String makeParamString(Class[] classArray, String string) {
        String string2 = "(";
        if (null != classArray) {
            for (int i = 0; i < classArray.length; ++i) {
                string2 = string2 + ReflectionPolicyRuntime.classToDesc(classArray[i]);
            }
        }
        return string2 + ")" + string;
    }

    private static RuntimeValue toRuntimeValue(Object object, Class clazz) {
        RuntimeValue runtimeValue;
        try {
            runtimeValue = clazz == Boolean.TYPE ? new RuntimeValue((Boolean)object) : (clazz == Character.TYPE ? new RuntimeValue(((Character)object).charValue()) : (clazz == Byte.TYPE ? new RuntimeValue((Byte)object) : (clazz == Short.TYPE ? new RuntimeValue((Short)object) : (clazz == Integer.TYPE ? new RuntimeValue((Integer)object) : (clazz == Long.TYPE ? new RuntimeValue((Long)object) : (clazz == Float.TYPE ? new RuntimeValue(((Float)object).floatValue()) : (clazz == Double.TYPE ? new RuntimeValue((Double)object) : new RuntimeValue(object))))))));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            runtimeValue = new RuntimeValue(object);
        }
        return runtimeValue;
    }

    private static String classToDesc(Class clazz) {
        if (clazz == Boolean.TYPE) {
            return "Z";
        }
        if (clazz == Character.TYPE) {
            return "C";
        }
        if (clazz == Byte.TYPE) {
            return "B";
        }
        if (clazz == Short.TYPE) {
            return "S";
        }
        if (clazz == Integer.TYPE) {
            return "I";
        }
        if (clazz == Long.TYPE) {
            return "J";
        }
        if (clazz == Float.TYPE) {
            return "F";
        }
        if (clazz == Double.TYPE) {
            return "D";
        }
        if (clazz == Void.TYPE) {
            return "V";
        }
        if (clazz.isArray()) {
            return clazz.getName();
        }
        return "L" + clazz.getName() + ";";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

