/*
 * Decompiled with CFR 0.152.
 */
package com.trend.iwss.jscan.runtime;

import com.trend.iwss.jscan.runtime.CallContext;
import com.trend.iwss.jscan.runtime.MethodRefMatcher;
import com.trend.iwss.jscan.runtime.PolicyRuntime;
import com.trend.iwss.jscan.runtime.Session;
import java.awt.Window;

public final class WindowPolicyRuntime
extends PolicyRuntime {
    public static final String FULLCLASSPATH = PolicyRuntime.classNameSlashNotation(class$com$trend$iwss$jscan$runtime$WindowPolicyRuntime == null ? (class$com$trend$iwss$jscan$runtime$WindowPolicyRuntime = WindowPolicyRuntime.class$("com.trend.iwss.jscan.runtime.WindowPolicyRuntime")) : class$com$trend$iwss$jscan$runtime$WindowPolicyRuntime);
    public static final String NAME = "Window";
    public static final String PROP_PREFIX = "window";
    public static final Factory FACT = new Factory("Window");
    public static final String CFG_WINDOW_NUM_LIMITED_BOOL = "num_limited";
    public static final String CFG_WINDOW_NUM_MAX_INT = "num_max";
    private static final String[] CLASSES = new String[]{"java/awt/Frame", "java/awt/Dialog", "java/awt/Window", "javax/swing/JFrame", "javax/swing/JDialog", "javax/swing/JWindow"};
    public static final MethodRefMatcher.Set MATCHERS = new MethodRefMatcher.Set();
    private static final MethodRefMatcher.Set MATCHERS_SHOW = MATCHERS.makeSet();
    private static final MethodRefMatcher MATCH_SHOW = MATCHERS_SHOW.make(CLASSES, "show");
    private static final MethodRefMatcher MATCH_SETVISIBLE = MATCHERS_SHOW.make(CLASSES, "setVisible");
    private static final MethodRefMatcher.Set MATCHERS_DISPOSE = MATCHERS.makeSet();
    private static final MethodRefMatcher MATCH_DISPOSE = MATCHERS_DISPOSE.make(CLASSES, "dispose");
    private boolean m_isLimited = this.getBoolPolicyProp("num_limited", false);
    private int m_maxWindows = this.getIntPolicyProp("num_max", 0);
    static /* synthetic */ Class class$com$trend$iwss$jscan$runtime$WindowPolicyRuntime;

    WindowPolicyRuntime(Session session) {
        super(NAME, PROP_PREFIX, session);
    }

    public static void preFilter(CallContext callContext) {
        PolicyRuntime.preFilter(callContext, FACT);
    }

    public static void postFilter(CallContext callContext) {
        PolicyRuntime.postFilter(callContext, FACT);
    }

    void _preFilter(CallContext callContext) {
        if (!this.matchShow(callContext)) {
            return;
        }
        int n = this.m_ses.getActiveWindowsCount();
        if (this.m_isLimited && this.m_maxWindows <= n) {
            this.stopAction("instr.msg.window.limit", "" + this.m_maxWindows);
        }
    }

    void _postFilter(CallContext callContext) {
        if (this.matchDispose(callContext)) {
            this.m_ses.removeActiveWindow((Window)callContext.getTarget());
        } else if (this.matchShow(callContext)) {
            this.m_ses.addActiveWindow((Window)callContext.getTarget());
        }
    }

    private boolean matchShow(CallContext callContext) {
        if (MATCH_SHOW.match(callContext)) {
            return true;
        }
        if (!MATCH_SETVISIBLE.match(callContext)) {
            return false;
        }
        return callContext.getArg(0).getBooleanValue();
    }

    private boolean matchDispose(CallContext callContext) {
        if (MATCHERS_DISPOSE.match(callContext)) {
            return true;
        }
        if (!MATCH_SETVISIBLE.match(callContext)) {
            return false;
        }
        return !callContext.getArg(0).getBooleanValue();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class Factory
    extends PolicyRuntime.Factory {
        Factory(String string) {
            super(string);
        }

        PolicyRuntime make(Session session) {
            return new WindowPolicyRuntime(session);
        }
    }
}

