/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.djep.diffRules;

import org.lsmp.djep.djep.DJep;
import org.lsmp.djep.djep.DiffRulesI;
import org.lsmp.djep.xjep.NodeFactory;
import org.lsmp.djep.xjep.XOperatorSet;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.FunctionTable;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommandI;

public abstract class ChainRuleDiffRules
implements DiffRulesI {
    protected String name;
    protected PostfixMathCommandI pfmc;
    protected Node[] rules = null;

    public String getName() {
        return this.name;
    }

    public PostfixMathCommandI getPfmc() {
        return this.pfmc;
    }

    public int getNumRules() {
        return this.rules.length;
    }

    public Node getRule(int i) {
        return this.rules[i];
    }

    public Node differentiate(ASTFunNode node, String var, Node[] children, Node[] dchildren, DJep djep) throws ParseException {
        XOperatorSet opSet = (XOperatorSet)djep.getOperatorSet();
        NodeFactory nf = djep.getNodeFactory();
        FunctionTable funTab = djep.getFunctionTable();
        int nRules = this.rules.length;
        if (nRules != children.length) {
            throw new ParseException("Error differentiating " + this.name + " number of rules " + nRules + " != number of arguments " + children.length);
        }
        if (nRules == 1) {
            Node fprime = djep.deepCopy(this.rules[0]);
            Node g = children[0];
            Node fprimesub = djep.substitute(fprime, "x", g);
            Node gprime = dchildren[0];
            return nf.buildOperatorNode(opSet.getMultiply(), fprimesub, gprime);
        }
        if (nRules == 2) {
            Node df_dg = djep.deepCopy(this.rules[0]);
            Node df_dh = djep.deepCopy(this.rules[1]);
            Node gprime = dchildren[0];
            Node hprime = dchildren[1];
            df_dg = djep.substitute(df_dg, new String[]{"x", "y"}, children);
            df_dh = djep.substitute(df_dh, new String[]{"x", "y"}, children);
            return nf.buildOperatorNode(opSet.getAdd(), nf.buildOperatorNode(opSet.getMultiply(), df_dg, gprime), nf.buildOperatorNode(opSet.getMultiply(), df_dh, hprime));
        }
        if (nRules < 1) {
            throw new ParseException("Error differentiating " + this.name + " zero differention rules!");
        }
        String[] names = new String[nRules];
        Node[] df_dg = new Node[nRules];
        Node[] products = new Node[nRules];
        int i = 0;
        while (i < nRules) {
            df_dg[i] = djep.deepCopy(this.rules[i]);
            names[i] = "x" + i;
            ++i;
        }
        i = 0;
        while (i < nRules) {
            df_dg[i] = djep.substitute(df_dg[i], names, children);
            products[i] = nf.buildOperatorNode(opSet.getMultiply(), df_dg[i], dchildren[i]);
            ++i;
        }
        return nf.buildFunctionNode("sum", funTab.get("sum"), products);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.name) + "  \t");
        if (this.rules == null) {
            sb.append("no diff rules possible parse error?");
        } else {
            int i = 0;
            while (i < this.getNumRules()) {
                sb.append("\t");
                ++i;
            }
        }
        return sb.toString();
    }
}

