/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.groupJep.groups;

import java.util.Enumeration;
import org.lsmp.djep.groupJep.groups.Group;
import org.lsmp.djep.groupJep.interfaces.RingI;
import org.lsmp.djep.groupJep.values.FreeGroupElement;
import org.nfunk.jep.JEP;
import org.nfunk.jep.SymbolTable;
import org.nfunk.jep.Variable;
import org.nfunk.jep.type.Complex;

public class FreeGroup
extends Group
implements RingI {
    protected RingI baseRing;
    protected FreeGroupElement zeroPoly;
    protected FreeGroupElement unitPoly;
    protected FreeGroupElement tPoly;
    protected String symbol;
    protected Complex rootVal = new Complex(Double.NaN);

    public FreeGroup(RingI K, String symbol) {
        this.symbol = symbol;
        this.baseRing = K;
        this.zeroPoly = new FreeGroupElement(this, new Number[]{this.baseRing.getZERO()});
        this.unitPoly = new FreeGroupElement(this, new Number[]{this.baseRing.getONE()});
        this.tPoly = new FreeGroupElement(this, new Number[]{this.baseRing.getZERO(), this.baseRing.getONE()});
    }

    public Number add(Number a, Number b) {
        return ((FreeGroupElement)a).add((FreeGroupElement)b);
    }

    public Number sub(Number a, Number b) {
        return ((FreeGroupElement)a).sub((FreeGroupElement)b);
    }

    public Number mul(Number a, Number b) {
        return ((FreeGroupElement)a).mul((FreeGroupElement)b);
    }

    public boolean equals(Number a, Number b) {
        return ((FreeGroupElement)a).equals((FreeGroupElement)b);
    }

    public Number valueOf(String s) {
        Number[] coeffs = new Number[]{this.baseRing.valueOf(s)};
        return this.valueOf(coeffs);
    }

    public Number valueOf(Number[] coeffs) {
        return new FreeGroupElement(this, coeffs);
    }

    public Number getZERO() {
        return this.zeroPoly;
    }

    public Number getONE() {
        return this.unitPoly;
    }

    public Number getTPoly() {
        return this.tPoly;
    }

    public Number getInverse(Number a) {
        return this.sub(this.zeroPoly, a);
    }

    public void addStandardConstants(JEP j) {
        this.baseRing.addStandardConstants(j);
        SymbolTable st = j.getSymbolTable();
        Enumeration en = st.elements();
        while (en.hasMoreElements()) {
            Variable val = (Variable)en.nextElement();
            st.remove(val.getName());
            Number num = (Number)val.getValue();
            Number p = this.valueOf(new Number[]{num});
            j.addConstant(val.getName(), p);
        }
        j.addConstant(this.symbol, this.tPoly);
    }

    public String toString() {
        return String.valueOf(this.baseRing.toString()) + "[" + this.symbol + "]";
    }

    public RingI getBaseRing() {
        return this.baseRing;
    }

    public void setRootVal(Complex complex) {
        this.rootVal = complex;
    }

    public boolean setRootVal(String sym, Complex val) {
        if (this.symbol.equals(sym)) {
            this.rootVal = val;
            return true;
        }
        if (this.baseRing instanceof FreeGroup) {
            return ((FreeGroup)this.baseRing).setRootVal(sym, val);
        }
        return false;
    }

    public Complex getRootVal() {
        return this.rootVal;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public boolean isConstantPoly(Number poly) {
        return ((FreeGroupElement)poly).isConstantPoly();
    }
}

