/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.jama;

import Jama.Matrix;
import org.lsmp.djep.jama.Inverse;
import org.lsmp.djep.jama.Rank;
import org.lsmp.djep.jama.Solve;
import org.lsmp.djep.vectorJep.values.MVector;
import org.nfunk.jep.JEP;
import org.nfunk.jep.ParseException;

public final class JamaUtil {
    public static Matrix toJama(org.lsmp.djep.vectorJep.values.Matrix m) throws ParseException {
        int rows = m.getNumRows();
        int cols = m.getNumCols();
        Object[][] data = m.getEles();
        double[][] A = new double[rows][cols];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                Object ele = data[i][j];
                if (!(ele instanceof Number)) {
                    throw new ParseException("Only real matricies are supported");
                }
                A[i][j] = ((Number)ele).doubleValue();
                ++j;
            }
            ++i;
        }
        return new Matrix(A);
    }

    public static Matrix toJamaCol(MVector m) throws ParseException {
        int rows = 1;
        int cols = m.getNumEles();
        double[][] A = new double[rows][cols];
        int j = 0;
        while (j < cols) {
            Object ele = m.getEle(j);
            if (!(ele instanceof Number)) {
                throw new ParseException("Only real matricies are supported");
            }
            A[0][j] = ((Number)ele).doubleValue();
            ++j;
        }
        return new Matrix(A);
    }

    public static Matrix toJamaRow(MVector m) throws ParseException {
        int rows = m.getNumEles();
        int cols = 1;
        double[][] A = new double[rows][cols];
        int i = 0;
        while (i < rows) {
            Object ele = m.getEle(i);
            if (!(ele instanceof Number)) {
                throw new ParseException("Only real matricies are supported");
            }
            A[i][0] = ((Number)ele).doubleValue();
            ++i;
        }
        return new Matrix(A);
    }

    public static org.lsmp.djep.vectorJep.values.Matrix fromJama(Matrix A, org.lsmp.djep.vectorJep.values.Matrix m) {
        int rows = A.getRowDimension();
        int cols = A.getRowDimension();
        double[][] in = A.getArray();
        Object[][] out = m.getEles();
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                out[i][j] = new Double(in[i][j]);
                ++j;
            }
            ++i;
        }
        return m;
    }

    public static org.lsmp.djep.vectorJep.values.Matrix fromJama(Matrix A) {
        int rows = A.getRowDimension();
        int cols = A.getRowDimension();
        org.lsmp.djep.vectorJep.values.Matrix m = (org.lsmp.djep.vectorJep.values.Matrix)org.lsmp.djep.vectorJep.values.Matrix.getInstance(rows, cols);
        double[][] in = A.getArray();
        Object[][] out = m.getEles();
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                out[i][j] = new Double(in[i][j]);
                ++j;
            }
            ++i;
        }
        return m;
    }

    public static void addStandardFunctions(JEP j) {
        j.addFunction("inverse", new Inverse());
        j.addFunction("rank", new Rank());
        j.addFunction("solve", new Solve());
    }
}

