/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.matrixJep;

import org.lsmp.djep.matrixJep.nodeTypes.ASTMConstant;
import org.lsmp.djep.matrixJep.nodeTypes.ASTMFunNode;
import org.lsmp.djep.matrixJep.nodeTypes.ASTMVarNode;
import org.lsmp.djep.matrixJep.nodeTypes.MatrixNodeI;
import org.lsmp.djep.vectorJep.Dimensions;
import org.lsmp.djep.vectorJep.function.BinaryOperatorI;
import org.lsmp.djep.vectorJep.function.NaryOperatorI;
import org.lsmp.djep.vectorJep.function.UnaryOperatorI;
import org.lsmp.djep.vectorJep.values.Scaler;
import org.lsmp.djep.xjep.NodeFactory;
import org.lsmp.djep.xjep.XJep;
import org.nfunk.jep.ASTConstant;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.Node;
import org.nfunk.jep.Operator;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.Variable;
import org.nfunk.jep.function.PostfixMathCommandI;

public class MatrixNodeFactory
extends NodeFactory {
    public MatrixNodeFactory(XJep xj) {
        super(xj);
    }

    public ASTConstant buildConstantNode(Object value) throws ParseException {
        ASTMConstant node = new ASTMConstant(4);
        if (value instanceof Scaler) {
            node.setValue(((Scaler)value).getEle(0));
        } else {
            node.setValue(value);
        }
        return node;
    }

    public ASTVarNode buildVariableNode(Variable var) throws ParseException {
        ASTMVarNode node = new ASTMVarNode(3);
        node.setVar(var);
        return node;
    }

    public ASTFunNode buildFunctionNode(String name, PostfixMathCommandI pfmc, Node[] arguments) throws ParseException {
        ASTMFunNode res = new ASTMFunNode(2);
        res.setFunction(name, pfmc);
        this.copyChildren(res, arguments);
        res.setDim(this.calcDim(name, pfmc, arguments));
        return res;
    }

    public Dimensions calcDim(String name, PostfixMathCommandI pfmc, Node[] arguments) throws ParseException {
        MatrixNodeI[] children = new MatrixNodeI[arguments.length];
        int i = 0;
        while (i < arguments.length) {
            children[i] = (MatrixNodeI)arguments[i];
            ++i;
        }
        if (pfmc instanceof BinaryOperatorI) {
            if (children.length != 2) {
                throw new ParseException("Operator " + name + " must have two elements, it has " + children.length);
            }
            BinaryOperatorI bin = (BinaryOperatorI)pfmc;
            Dimensions dim = bin.calcDim(children[0].getDim(), children[1].getDim());
            return dim;
        }
        if (pfmc instanceof UnaryOperatorI) {
            if (children.length != 1) {
                throw new ParseException("Operator " + name + " must have one elements, it has " + children.length);
            }
            UnaryOperatorI uni = (UnaryOperatorI)pfmc;
            Dimensions dim = uni.calcDim(children[0].getDim());
            return dim;
        }
        if (pfmc instanceof NaryOperatorI) {
            Dimensions[] dims = new Dimensions[children.length];
            int i2 = 0;
            while (i2 < children.length) {
                dims[i2] = children[i2].getDim();
                ++i2;
            }
            NaryOperatorI uni = (NaryOperatorI)pfmc;
            Dimensions dim = uni.calcDim(dims);
            return dim;
        }
        return Dimensions.ONE;
    }

    public Dimensions calcDim(Operator op, Node[] arguments) throws ParseException {
        return this.calcDim(op.getName(), op.getPFMC(), arguments);
    }

    public ASTFunNode buildFunctionNode(ASTFunNode node, Node[] children) throws ParseException {
        if (node instanceof ASTMFunNode) {
            if (node.isOperator()) {
                return this.buildOperatorNode(node.getOperator(), children, ((ASTMFunNode)node).getDim());
            }
            ASTMFunNode res = new ASTMFunNode(2);
            res.setFunction(node.getName(), node.getPFMC());
            this.copyChildren(res, children);
            res.setDim(((ASTMFunNode)node).getDim());
            return res;
        }
        if (node.isOperator()) {
            return this.buildOperatorNode(node.getOperator(), children);
        }
        ASTMFunNode res = new ASTMFunNode(2);
        res.setFunction(node.getName(), node.getPFMC());
        this.copyChildren(res, children);
        res.setDim(this.calcDim(node.getName(), node.getPFMC(), children));
        return res;
    }

    public ASTFunNode buildFunctionNode(ASTFunNode node, Node[] arguments, Dimensions dim) {
        ASTMFunNode res = new ASTMFunNode(2);
        res.setFunction(node.getName(), node.getPFMC());
        res.setDim(dim);
        this.copyChildren(res, arguments);
        return res;
    }

    public ASTFunNode buildOperatorNode(Operator op, Node[] arguments) throws ParseException {
        ASTMFunNode res = new ASTMFunNode(2);
        res.setOperator(op);
        this.copyChildren(res, arguments);
        res.setDim(this.calcDim(op, arguments));
        return res;
    }

    public ASTFunNode buildOperatorNode(Operator op, Node[] arguments, Dimensions dim) {
        ASTMFunNode res = new ASTMFunNode(2);
        res.setOperator(op);
        res.setDim(dim);
        this.copyChildren(res, arguments);
        return res;
    }

    public ASTFunNode buildUnfinishedOperatorNode(Operator op) {
        ASTMFunNode res = new ASTMFunNode(2);
        res.setOperator(op);
        return res;
    }
}

