/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.mrpe;

import org.lsmp.djep.mrpe.MRpEval;
import org.lsmp.djep.vectorJep.Dimensions;

public final class MRpCommandList {
    private static final int STACK_INC = 10;
    MRpCommand[] commands = new MRpCommand[10];
    private short commandPos;
    private int finalType;
    private Dimensions resultDim;

    MRpCommandList() {
    }

    final void addCommand(short command, short aux) {
        if (this.commandPos == this.commands.length) {
            MRpCommand[] newCommands = new MRpCommand[this.commands.length + 10];
            System.arraycopy(this.commands, 0, newCommands, 0, this.commands.length);
            this.commands = newCommands;
        }
        this.commands[this.commandPos] = new MRpCommand(command, aux);
        this.commandPos = (short)(this.commandPos + 1);
    }

    final void addCommand(short command, short aux1, short aux2) {
        if (this.commandPos == this.commands.length) {
            MRpCommand[] newCommands = new MRpCommand[this.commands.length + 10];
            System.arraycopy(this.commands, 0, newCommands, 0, this.commands.length);
            this.commands = newCommands;
        }
        this.commands[this.commandPos] = new MRpCommand(command, aux1, aux2);
        this.commandPos = (short)(this.commandPos + 1);
    }

    public int getNumCommands() {
        return this.commandPos;
    }

    int getFinalType() {
        return this.finalType;
    }

    void setResultDim(Dimensions dim) {
        this.resultDim = dim;
        this.finalType = MRpEval.getDimType(dim);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.commandPos) {
            sb.append(this.commands[i].toString());
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }

    public Dimensions getDimsOfResult() {
        return this.resultDim;
    }

    static final class MRpCommand {
        short command;
        short aux1;
        short aux2;

        MRpCommand(short command, short aux) {
            this.command = command;
            this.aux1 = aux;
            this.aux2 = (short)-1;
        }

        MRpCommand(short command, short aux1, short aux2) {
            this.command = command;
            this.aux1 = aux1;
            this.aux2 = aux2;
        }

        public String toString() {
            switch (this.command) {
                case 0: {
                    return "Constant\tnum " + this.aux1;
                }
                case 1: {
                    return "Variable\ttype " + MRpEval.dimTypeToDimension(this.aux1) + "\tnum " + this.aux2;
                }
                case 2: {
                    return "ADD\ttype " + MRpEval.dimTypeToDimension(this.aux1);
                }
                case 3: {
                    return "SUB\ttype " + MRpEval.dimTypeToDimension(this.aux1);
                }
                case 4: {
                    return "MUL\ttype " + MRpEval.dimTypeToDimension(this.aux1) + " by " + MRpEval.dimTypeToDimension(this.aux2);
                }
                case 5: {
                    return "DIV\ttype " + MRpEval.dimTypeToDimension(this.aux1);
                }
                case 6: {
                    return "MOD\ttype " + MRpEval.dimTypeToDimension(this.aux1);
                }
                case 7: {
                    return "POW\ttype " + MRpEval.dimTypeToDimension(this.aux1);
                }
                case 8: {
                    return "AND\ttype " + MRpEval.dimTypeToDimension(this.aux1);
                }
                case 9: {
                    return "OR\ttype " + MRpEval.dimTypeToDimension(this.aux1);
                }
                case 10: {
                    return "NOT\ttype " + MRpEval.dimTypeToDimension(this.aux1);
                }
                case 11: {
                    return "LT\ttype " + MRpEval.dimTypeToDimension(this.aux1);
                }
                case 13: {
                    return "GT\ttype " + MRpEval.dimTypeToDimension(this.aux1);
                }
                case 12: {
                    return "LE\ttype " + MRpEval.dimTypeToDimension(this.aux1);
                }
                case 14: {
                    return "GE\ttype " + MRpEval.dimTypeToDimension(this.aux1);
                }
                case 15: {
                    return "NE\ttype " + MRpEval.dimTypeToDimension(this.aux1);
                }
                case 16: {
                    return "EQ\ttype " + MRpEval.dimTypeToDimension(this.aux1);
                }
                case 20: {
                    return "Assign type " + MRpEval.dimTypeToDimension(this.aux1) + " no " + this.aux2;
                }
                case 17: {
                    return "List type " + MRpEval.dimTypeToDimension(this.aux1);
                }
                case 18: {
                    return "Dot type " + MRpEval.dimTypeToDimension(this.aux1);
                }
                case 19: {
                    return "Cross type " + MRpEval.dimTypeToDimension(this.aux1);
                }
                case 23: {
                    return "Function\tnum " + this.aux1;
                }
                case 24: {
                    return "UMinus\ttype " + MRpEval.dimTypeToDimension(this.aux1);
                }
            }
            return "Warning unknown command: " + this.command + " " + this.aux1 + " " + this.aux2;
        }
    }
}

