/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.sjep;

import org.lsmp.djep.sjep.Monomial;
import org.lsmp.djep.sjep.PConstant;
import org.lsmp.djep.sjep.PNodeI;
import org.lsmp.djep.sjep.Polynomial;
import org.lsmp.djep.sjep.PolynomialCreator;
import org.nfunk.jep.ParseException;

public class MutiablePolynomial {
    PolynomialCreator pc;
    PNodeI[] terms;

    public MutiablePolynomial(PolynomialCreator pc, PNodeI[] nodes) {
        this.pc = pc;
        this.terms = nodes;
    }

    public void add(PNodeI term) throws ParseException {
        int i;
        if (term instanceof PConstant) {
            i = 0;
            while (i < this.terms.length) {
                if (this.terms[i] instanceof PConstant) {
                    this.terms[i] = this.terms[i].add(term);
                    return;
                }
                ++i;
            }
        }
        if (term instanceof Polynomial) {
            Polynomial p = (Polynomial)term;
            int i2 = 0;
            while (i2 < p.terms.length) {
                this.add(p.terms[i2]);
                ++i2;
            }
            return;
        }
        i = 0;
        while (i < this.terms.length) {
            if (this.terms[i] instanceof Monomial) {
                if (((Monomial)this.terms[i]).equalsIgnoreConstant(term)) {
                    this.terms[i] = this.terms[i].add(term);
                    return;
                }
            } else if (this.terms[i].equals(term)) {
                this.terms[i] = this.terms[i].add(term);
                return;
            }
            ++i;
        }
        PNodeI[] newTerms = new PNodeI[this.terms.length + 1];
        int pos = 0;
        boolean done = false;
        int i3 = 0;
        while (i3 < this.terms.length) {
            if (!done && this.terms[i3].compareTo(term) > 0) {
                newTerms[pos] = term;
                ++pos;
                done = true;
            }
            newTerms[pos] = this.terms[i3];
            ++pos;
            ++i3;
        }
        if (!done) {
            newTerms[pos] = term;
            ++pos;
        }
        this.terms = newTerms;
    }

    void expandMul(Polynomial p) throws ParseException {
        PNodeI[][] newTerms = new PNodeI[this.terms.length][p.terms.length];
        int i = 0;
        while (i < this.terms.length) {
            int j = 0;
            while (j < p.terms.length) {
                newTerms[i][j] = this.terms[i].mul(p.terms[j]);
                ++j;
            }
            ++i;
        }
        int oldLen = this.terms.length;
        this.terms = new PNodeI[0];
        int i2 = 0;
        while (i2 < oldLen) {
            int j = 0;
            while (j < p.terms.length) {
                this.add(newTerms[i2][j]);
                ++j;
            }
            ++i2;
        }
    }

    void expandMul(PNodeI node) throws ParseException {
        if (node instanceof Polynomial) {
            this.expandMul((Polynomial)node);
            return;
        }
        PNodeI[] newTerms = new PNodeI[this.terms.length];
        int i = 0;
        while (i < this.terms.length) {
            newTerms[i] = this.terms[i].mul(node);
            ++i;
        }
        this.terms = new PNodeI[0];
        i = 0;
        while (i < newTerms.length) {
            this.add(newTerms[i]);
            ++i;
        }
    }

    private void reduce() throws ParseException {
        int numZeros = 0;
        int numConst = 0;
        PConstant c = this.pc.zeroConstant;
        int i = 0;
        while (i < this.terms.length) {
            if (this.terms[i].isZero()) {
                ++numZeros;
            } else if (this.terms[i] instanceof PConstant) {
                ++numConst;
                c = (PConstant)c.add(this.terms[i]);
            }
            ++i;
        }
        if (numZeros == 0 && numConst == 0) {
            return;
        }
        int newLen = this.terms.length - numZeros - numConst;
        if (!c.isZero()) {
            ++newLen;
        }
        PNodeI[] newTerms = new PNodeI[newLen];
        int pos = 0;
        if (!c.isZero()) {
            newTerms[pos++] = c;
        }
        int i2 = 0;
        while (i2 < this.terms.length) {
            if (!this.terms[i2].isZero() && !(this.terms[i2] instanceof PConstant)) {
                newTerms[pos] = this.terms[i2];
                ++pos;
            }
            ++i2;
        }
        this.terms = newTerms;
    }

    PNodeI toPNode() throws ParseException {
        this.reduce();
        if (this.terms.length == 0) {
            return this.pc.zeroConstant;
        }
        if (this.terms.length == 1) {
            return this.terms[0];
        }
        return new Polynomial(this.pc, this.terms);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.terms.length) {
            if (i > 0) {
                sb.append('+');
            }
            sb.append(this.terms[i].toString());
            ++i;
        }
        return sb.toString();
    }
}

