/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.vectorJep;

import org.lsmp.djep.vectorJep.Dimensions;
import org.lsmp.djep.vectorJep.function.BinaryOperatorI;
import org.lsmp.djep.vectorJep.function.NaryOperatorI;
import org.lsmp.djep.vectorJep.function.UnaryOperatorI;
import org.lsmp.djep.vectorJep.values.MatrixValueI;
import org.lsmp.djep.vectorJep.values.Tensor;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.EvaluatorVisitor;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.SymbolTable;
import org.nfunk.jep.function.CallbackEvaluationI;
import org.nfunk.jep.function.Comparative;
import org.nfunk.jep.function.PostfixMathCommandI;
import org.nfunk.jep.function.SpecialEvaluationI;

public class VectorEvaluator
extends EvaluatorVisitor {
    public VectorEvaluator(SymbolTable st) {
        super(st);
    }

    public Object visit(ASTFunNode node, Object data) throws ParseException {
        if (node == null) {
            return null;
        }
        PostfixMathCommandI pfmc = node.getPFMC();
        if (pfmc == null) {
            throw new ParseException("No function class associated with " + node.getName());
        }
        int numChild = node.jjtGetNumChildren();
        if (pfmc instanceof SpecialEvaluationI) {
            return ((SpecialEvaluationI)((Object)node.getPFMC())).evaluate(node, data, this, this.stack, this.symTab);
        }
        if (pfmc instanceof CallbackEvaluationI) {
            Object value = ((CallbackEvaluationI)((Object)pfmc)).evaluate(node, this);
            this.stack.push(value);
            return value;
        }
        data = node.childrenAccept(this, data);
        if (pfmc.getNumberOfParameters() == -1) {
            pfmc.setCurNumberOfParameters(numChild);
        }
        if (pfmc instanceof UnaryOperatorI || pfmc instanceof BinaryOperatorI || pfmc instanceof NaryOperatorI || pfmc instanceof Comparative) {
            pfmc.run(this.stack);
        } else if (numChild == 0) {
            pfmc.run(this.stack);
        } else if (this.stack.peek() instanceof MatrixValueI) {
            MatrixValueI[] args = new MatrixValueI[node.jjtGetNumChildren()];
            args[numChild - 1] = (MatrixValueI)this.stack.pop();
            Dimensions lastDim = args[numChild - 1].getDim();
            int i = numChild - 2;
            while (i >= 0) {
                Object val = this.stack.pop();
                if (!(val instanceof MatrixValueI)) {
                    throw new ParseException("All arguments of function must be same dimension");
                }
                args[i] = (MatrixValueI)val;
                if (!lastDim.equals(args[i].getDim())) {
                    throw new ParseException("All arguments of function must be same dimension");
                }
                --i;
            }
            MatrixValueI res = Tensor.getInstance(lastDim);
            int i2 = 0;
            while (i2 < lastDim.numEles()) {
                int j = 0;
                while (j < numChild) {
                    this.stack.push(args[j].getEle(i2));
                    ++j;
                }
                pfmc.run(this.stack);
                res.setEle(i2, this.stack.pop());
                ++i2;
            }
            this.stack.push(res);
        } else {
            pfmc.run(this.stack);
        }
        return data;
    }
}

