/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.xjep;

import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import org.lsmp.djep.xjep.CommandVisitorI;
import org.lsmp.djep.xjep.XJep;
import org.lsmp.djep.xjep.XSymbolTable;
import org.nfunk.jep.ASTConstant;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class Eval
extends PostfixMathCommand
implements CommandVisitorI {
    public Eval() {
        this.numberOfParameters = -1;
    }

    public Node process(Node node, Node[] children, XJep xjep) throws ParseException {
        Vector errorList = new Vector();
        int nchild = children.length;
        if (nchild % 2 == 0) {
            throw new ParseException("Number of parameters must be odd");
        }
        XSymbolTable localSymTab = (XSymbolTable)((XSymbolTable)xjep.getSymbolTable()).newInstance();
        XJep localJep = xjep.newInstance(localSymTab);
        Enumeration en = xjep.getSymbolTable().keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            Object val = xjep.getSymbolTable().getValue(key);
            localSymTab.addVariable(key, val);
        }
        int i = 1;
        while (i < nchild) {
            Object value;
            ASTVarNode var;
            try {
                var = (ASTVarNode)children[i];
                Node rhs = children[i + 1];
                if (rhs instanceof ASTConstant) {
                    value = ((ASTConstant)rhs).getValue();
                } else {
                    value = localJep.evaluate(rhs);
                    if (!errorList.isEmpty()) {
                        throw new ParseException(errorList.toString());
                    }
                }
            }
            catch (ClassCastException e) {
                throw new ParseException("Format should be eval(f,x,1,y,2) where x,y are variables and 1,2 are constants");
            }
            catch (Exception e) {
                throw new ParseException(e.getMessage());
            }
            localSymTab.setVarValue(var.getName(), value);
            i += 2;
        }
        try {
            Object res = localJep.evaluate(node.jjtGetChild(0));
            if (!errorList.isEmpty()) {
                throw new ParseException(errorList.toString());
            }
            return xjep.getNodeFactory().buildConstantNode(res);
        }
        catch (Exception e2) {
            throw new ParseException(e2.getMessage());
        }
    }

    public void run(Stack s) throws ParseException {
        throw new ParseException("Eval should not be called by Evaluator");
    }
}

