/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.xjep;

import java.util.Stack;
import org.lsmp.djep.xjep.XJep;
import org.lsmp.djep.xjep.XSymbolTable;
import org.nfunk.jep.EvaluatorI;
import org.nfunk.jep.EvaluatorVisitor;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.Variable;
import org.nfunk.jep.function.PostfixMathCommand;

public class MacroFunction
extends PostfixMathCommand {
    private String name;
    private Node topNode;
    private EvaluatorI ev;
    private XSymbolTable mySymTab;
    private Variable[] vars;

    public String getName() {
        return this.name;
    }

    public Node getTopNode() {
        return this.topNode;
    }

    public MacroFunction(String inName, int nargs, String expression, XJep jep) throws IllegalArgumentException, ParseException {
        this.name = inName;
        XSymbolTable jepSymTab = (XSymbolTable)jep.getSymbolTable();
        this.mySymTab = (XSymbolTable)jepSymTab.newInstance();
        this.mySymTab.copyConstants(jepSymTab);
        XJep localJep = jep.newInstance(this.mySymTab);
        this.numberOfParameters = nargs;
        if (this.numberOfParameters != 0) {
            if (this.numberOfParameters == 1) {
                this.vars = new Variable[]{this.mySymTab.addVariable("x", null)};
            } else if (this.numberOfParameters == 2) {
                this.vars = new Variable[]{this.mySymTab.addVariable("x", null), this.mySymTab.addVariable("y", null)};
            } else {
                this.vars = new Variable[this.numberOfParameters];
                int i = this.numberOfParameters;
                while (i > 0) {
                    this.vars[i - 1] = this.mySymTab.addVariable("x" + String.valueOf(i), null);
                    --i;
                }
            }
        }
        this.topNode = localJep.parse(expression);
        this.ev = new EvaluatorVisitor(this.mySymTab);
    }

    public void run(Stack stack) throws ParseException {
        if (this.numberOfParameters != 0) {
            if (this.numberOfParameters == 1) {
                this.vars[0].setValue(stack.pop());
            } else if (this.numberOfParameters == 2) {
                this.vars[1].setValue(stack.pop());
                this.vars[0].setValue(stack.pop());
            } else {
                int i = this.numberOfParameters;
                while (i > 0) {
                    this.vars[i - 1].setValue(stack.pop());
                    --i;
                }
            }
        }
        try {
            Object res = this.ev.eval(this.topNode);
            stack.push(res);
        }
        catch (Exception e1) {
            throw new ParseException("MacroFunction eval: " + e1.getMessage());
        }
    }
}

