/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djepExamples;

import com.trend.iwss.jscan.runtime.Session;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.TextArea;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.nfunk.jep.FunctionTable;
import org.nfunk.jep.JEP;
import org.nfunk.jep.Node;
import org.nfunk.jep.Operator;
import org.nfunk.jep.OperatorSet;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.SymbolTable;

public class Console
extends Applet
implements KeyListener {
    private static final long serialVersionUID = 9035584745289937584L;
    protected JEP j;
    private BufferedReader br;
    protected TextArea ta;

    public Console() {
        Session.setAppletInstance(this, "mmc.sess_pe_act.action=validate\nthread.thread_num_max=8\nfile.destructive.state=disabled\njscan.session.user_name=172.26.113.23\njscan.sess_applet_act.unsigned=instrument\njscan.sess_applet_act.stub_out_blocked_applet=true\njscan.sess_applet_act.block_all=false\nmmc.sess_pe_act.block_invalid=true\nmmc.sess_cab_act.block_unsigned=false\nthread.thread_num_limited=true\nwindow.num_max=5\njscan.session.policyname=TU1DIERlZmF1bHQgUG9saWN5\njscan.sess_applet_act.sig_trusted=pass\njscan.sess_applet_act.sig_invalid=block\nmmc.sess_pe_act.block_blacklisted=false\nmmc.sess_cab_act.block_blacklisted=true\njscan.sess_applet_act.sig_blacklisted=block\njscan.session.origin_uri=http://www.singsurf.org/djep/jars/djep-full-latest.jar\nnet.connect_other=false\njscan.session.user_ipaddr=172.26.113.23\njscan.session.daemon_protocol=http\nthread.threadgroup_create=false\nfile.read.state=disabled\nfile.nondestructive.state=disabled\nnet.bind_enable=false\nnet.connect_src=true\nmmc.sess_cab_act.action=validate\nmmc.sess_pe_act.block_unsigned=false\nfile.write.state=disabled\nmmc.sess_cab_act.block_invalid=true\nwindow.num_limited=true", "instr.action.send_data=send data to {0}\ninstr.action.invoke_sys_noarg=invoke the {0}.{1}() operation\ninstr.msg.dialog.applet_terminated=APPLET TERMINATED\ninstr.button.no=No\ninstr.button.allow=Allow\ninstr.action.bind_local=bind local port {0}\ninstr.action.policy_stop_error=Applet disabled by IWSS Javascan site policy.\ninstr.action.connect=connect to {0}\ninstr.action.runtime.exec=run the following executable: {0}\ninstr.action.invoke_sys_arg=invoke the {0}.{1}() operation on {2}\ninstr.button.yes=Yes\ninstr.action.policy_security_exception=The Applet is not allowed to {0} by IWSS Javascan site policy.\ninstr.action.file.write=perform a write operation on file {0}\ninstr.dialog.title.applet_alert=--APPLET ALERT--\ninstr.action.receive_data=receive data from {0}\ninstr.action.bind_local_unspec=bind to a free local port\ninstr.msg.dialog.applet_stopped=The applet has been terminated because it was attempting to perform an action that violates corporate security policy.\ninstr.msg.thread.limit=have more than {0} active threads\ninstr.msg.dialog.ask_stop_applet=Do you want to stop the applet now?\ninstr.msg.window.limit=have more than {0} active windows\ninstr.action.file.nondestructive_alt=access \"{0}\" state attributes\ninstr.action.invoke=invoke {0}\ninstr.button.ok=OK\ninstr.msg.dialog.action_warning_start=The applet is attempting to {0}\ninstr.msg.thread.group_limit=create new thread groups\ninstr.button.stop_applet=Stop Applet\ninstr.action.file.destructive_alt=perform a \"{0}\" state change operation\ninstr.action.file.nondestructive=access the \"{1}\" state attributes of file {0}\ninstr.action.file.destructive=perform a \"{1}\" state change operation on file {0}\ninstr.button.disallow=Disallow\ninstr.action.file.read=perform a read operation on file {0}");
        this.ta = null;
        this.br = new BufferedReader(new InputStreamReader(System.in));
    }

    public void init() {
        this.initialise();
        this.setLayout(new BorderLayout(1, 1));
        this.ta = new TextArea("", 10, 80, 0);
        this.ta.setEditable(true);
        this.ta.addKeyListener(this);
        this.add("Center", this.ta);
        this.printIntroText();
        this.print(this.getPrompt());
    }

    public void initialise() {
        this.j = new JEP();
        this.j.addStandardConstants();
        this.j.addStandardFunctions();
        this.j.addComplex();
        this.j.setAllowUndeclared(true);
        this.j.setAllowAssignment(true);
        this.j.setImplicitMul(true);
    }

    public static void main(String[] args) {
        Console c = new Console();
        c.run(args);
    }

    public void run(String[] args) {
        this.initialise();
        if (args.length > 0) {
            int i = 1;
            while (i < args.length) {
                this.processCommand(args[i]);
                ++i;
            }
        } else {
            this.inputLoop();
        }
    }

    public void inputLoop() {
        String command = "";
        this.printIntroText();
        this.print(this.getPrompt());
        while ((command = this.getCommand()) != null) {
            if (!this.processCommand(command)) break;
            this.print(this.getPrompt());
        }
    }

    public boolean processCommand(String command) {
        if (command.equals("quit") || command.equals("exit")) {
            return false;
        }
        if (command.equals("help")) {
            this.printHelp();
            return true;
        }
        if (command.equals("functions")) {
            this.printFuns();
            return true;
        }
        if (command.equals("operators")) {
            this.printOps();
            return true;
        }
        if (command.equals("variables")) {
            this.printVars();
            return true;
        }
        if (!this.testSpecialCommands(command)) {
            return true;
        }
        try {
            Node n = this.j.parse(command);
            this.processEquation(n);
        }
        catch (Exception e) {
            return this.handleError(e);
        }
        return true;
    }

    public void processEquation(Node node) throws ParseException {
        Object res = this.j.evaluate(node);
        this.println(res);
    }

    protected String getCommand() {
        String s = null;
        if (this.br == null) {
            return null;
        }
        try {
            s = this.br.readLine();
            if (s == null) {
                return null;
            }
        }
        catch (IOException e) {
            this.println("IOError exiting");
            return null;
        }
        return s;
    }

    public String getPrompt() {
        return "JEP > ";
    }

    public final void printStdHelp() {
        if (this.ta == null) {
            this.println("Type 'quit' or 'exit' to quit, 'help' for help.");
        } else {
            this.println("Type 'help' for help.");
        }
    }

    public void printHelp() {
        this.printStdHelp();
        this.println("'functions' lists defined functions");
        this.println("'operators' lists defined operators");
        this.println("'variables' lists variables and constants");
    }

    public void printIntroText() {
        this.println("JEP Console.");
        this.printStdHelp();
    }

    public void printFuns() {
        FunctionTable ft = this.j.getFunctionTable();
        this.println("Known functions:");
        Enumeration loop = ft.keys();
        while (loop.hasMoreElements()) {
            String s = (String)loop.nextElement();
            this.println("\t" + s);
        }
    }

    public void printOps() {
        OperatorSet opset = this.j.getOperatorSet();
        Operator[] ops = opset.getOperators();
        this.println("Known operators:");
        int i = 0;
        while (i < ops.length) {
            this.println("\t" + ops[i].toString());
            ++i;
        }
    }

    public void printVars() {
        SymbolTable st = this.j.getSymbolTable();
        this.println("Variables:");
        Enumeration loop = st.keys();
        while (loop.hasMoreElements()) {
            String s = (String)loop.nextElement();
            Object val = st.getValue(s);
            this.println("\t" + s + "\t" + val);
        }
    }

    public boolean testSpecialCommands(String command) {
        return true;
    }

    public boolean handleError(Exception e) {
        if (e instanceof ParseException) {
            this.println("Parse Error: " + e.getMessage());
        } else {
            this.println("Error: " + e.getClass().getName() + " " + e.getMessage());
        }
        return true;
    }

    public String[] split(String s) {
        StringTokenizer st = new StringTokenizer(s);
        int tokCount = st.countTokens();
        String[] res = new String[tokCount];
        int pos = 0;
        while (st.hasMoreTokens()) {
            res[pos++] = st.nextToken();
        }
        return res;
    }

    public void print(Object o) {
        String s = null;
        s = o == null ? "null" : o.toString();
        if (this.ta != null) {
            this.ta.append(s);
        } else {
            System.out.print(s);
        }
    }

    public void println(Object o) {
        String s = null;
        s = o == null ? "null" : o.toString();
        if (this.ta != null) {
            this.ta.append(String.valueOf(s) + "\n");
        } else {
            System.out.println(s);
        }
    }

    public void keyReleased(KeyEvent event) {
        int code = event.getKeyCode();
        if (code == 10) {
            int cpos = this.ta.getCaretPosition();
            String alltext = this.ta.getText();
            String before = alltext.substring(0, cpos - 1);
            int startOfLine = before.lastIndexOf(10);
            if (startOfLine > 0) {
                before = before.substring(startOfLine + 1);
            }
            String prompt = this.getPrompt();
            String line = null;
            if (before.startsWith(prompt)) {
                line = before.substring(prompt.length());
                this.processCommand(line);
            }
            this.print(this.getPrompt());
        }
    }

    public void keyPressed(KeyEvent arg0) {
    }

    public void keyTyped(KeyEvent arg0) {
    }

    public String getAppletInfo() {
        return "Jep Console applet\nR Morris Mar 2005\nSee http://www.singsurf.org/djep/";
    }
}

