/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djepExamples;

import org.lsmp.djep.djep.DJep;
import org.lsmp.djepExamples.XJepConsole;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;

public class DJepConsole
extends XJepConsole {
    private static final long serialVersionUID = -5801701990800128777L;

    public void initialise() {
        this.j = new DJep();
        this.j.addStandardConstants();
        this.j.addStandardFunctions();
        this.j.addComplex();
        this.j.setAllowUndeclared(true);
        this.j.setAllowAssignment(true);
        this.j.setImplicitMul(true);
        ((DJep)this.j).addStandardDiffRules();
    }

    public void printHelp() {
        super.printHelp();
        this.println("'diff(x^2,x)' to differentiate x^2 with respect to x");
        this.println("'verbose on', 'verbose off' switch verbose mode on or off");
    }

    public void printIntroText() {
        this.println("DJep: differentiation in JEP. e.g. diff(x^2,x)");
        this.printStdHelp();
    }

    public String getPrompt() {
        return "DJep > ";
    }

    public void processEquation(Node node) throws ParseException {
        DJep dj = (DJep)this.j;
        if (this.verbose) {
            this.print("Parsed:\t\t");
            this.println(dj.toString(node));
        }
        Node processed = dj.preprocess(node);
        if (this.verbose) {
            this.print("Processed:\t");
            this.println(dj.toString(processed));
        }
        Node simp = dj.simplify(processed);
        if (this.verbose) {
            this.print("Simplified:\t");
        }
        this.println(dj.toString(simp));
        if (this.verbose) {
            this.print("Full Brackets, no variable expansion:\n\t\t");
            dj.getPrintVisitor().setMode(1, true);
            dj.getPrintVisitor().setMode(16, false);
            this.println(dj.toString(simp));
            dj.getPrintVisitor().setMode(16, true);
            dj.getPrintVisitor().setMode(1, false);
        }
        Object val = dj.evaluate(simp);
        String s = dj.getPrintVisitor().formatValue(val);
        this.println("Value:\t\t" + s);
    }

    public static void main(String[] args) {
        DJepConsole c = new DJepConsole();
        c.run(args);
    }
}

