/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djepExamples;

import org.lsmp.djep.sjep.Monomial;
import org.lsmp.djep.sjep.PConstant;
import org.lsmp.djep.sjep.PFunction;
import org.lsmp.djep.sjep.PNodeI;
import org.lsmp.djep.sjep.POperator;
import org.lsmp.djep.sjep.PVariable;
import org.lsmp.djep.sjep.Polynomial;
import org.lsmp.djep.sjep.PolynomialCreator;
import org.lsmp.djep.xjep.XJep;
import org.lsmp.djepExamples.DJepConsole;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;

public class SJepConsole
extends DJepConsole {
    private static final long serialVersionUID = -2796652887843007314L;
    PolynomialCreator pc = null;

    public static void main(String[] args) {
        SJepConsole c = new SJepConsole();
        c.run(args);
    }

    public String getPrompt() {
        return "SJep > ";
    }

    public void initialise() {
        super.initialise();
        this.pc = new PolynomialCreator((XJep)this.j);
    }

    public void printIntroText() {
        this.println("SJep: advanced simplification/expansion");
    }

    public void processEquation(Node node) throws ParseException {
        XJep xj = (XJep)this.j;
        Node pre = xj.preprocess(node);
        Node proc = xj.simplify(pre);
        this.print("Old simp:\t");
        this.println(xj.toString(proc));
        Node simp = this.pc.simplify(proc);
        this.print("New simp:\t");
        this.println(xj.toString(simp));
        PNodeI poly = this.pc.createPoly(proc);
        this.explain(poly, 0);
        Node expand = this.pc.expand(proc);
        this.print("Expanded:\t");
        this.println(xj.toString(expand));
        Object val = xj.evaluate(simp);
        String s = xj.getPrintVisitor().formatValue(val);
        this.println("Value:\t\t" + s);
    }

    private void explain(PNodeI pnode, int depth) {
        block7: {
            block11: {
                block10: {
                    block9: {
                        block8: {
                            block6: {
                                int i = 0;
                                while (i < depth) {
                                    this.print(" ");
                                    ++i;
                                }
                                if (!(pnode instanceof Polynomial)) break block6;
                                Polynomial poly = (Polynomial)pnode;
                                this.println("Polynomial with " + poly.getNTerms() + " terms:");
                                int i2 = 0;
                                while (i2 < poly.getNTerms()) {
                                    this.explain(poly.getTerm(i2), depth + 1);
                                    ++i2;
                                }
                                break block7;
                            }
                            if (!(pnode instanceof Monomial)) break block8;
                            Monomial mon = (Monomial)pnode;
                            this.print("Monomial with coefficient: ");
                            this.print(mon.getCoeff().getValue().toString());
                            this.println(" and " + mon.getNVars() + " variables:");
                            int i = 0;
                            while (i < mon.getNVars()) {
                                this.explain(mon.getVar(i), depth + 1);
                                int j = 0;
                                while (j < depth) {
                                    this.print(" ");
                                    ++j;
                                }
                                this.println(" power:");
                                this.explain(mon.getPower(i), depth + 1);
                                ++i;
                            }
                            break block7;
                        }
                        if (!(pnode instanceof PConstant)) break block9;
                        this.println("Constant: " + ((PConstant)pnode).getValue().toString());
                        break block7;
                    }
                    if (!(pnode instanceof PVariable)) break block10;
                    this.println("Variable: " + ((PVariable)pnode).getVariable().toString());
                    break block7;
                }
                if (!(pnode instanceof PFunction)) break block11;
                PFunction fun = (PFunction)pnode;
                this.println("Function: " + fun.getName() + " with " + fun.getNArgs() + "arguments:");
                int i = 0;
                while (i < fun.getNArgs()) {
                    this.explain(fun.getArg(i), depth + 1);
                    ++i;
                }
                break block7;
            }
            if (!(pnode instanceof POperator)) break block7;
            POperator fun = (POperator)pnode;
            this.println("Operator: " + fun.getName() + " with " + fun.getNArgs() + "arguments:");
            int i = 0;
            while (i < fun.getNArgs()) {
                this.explain(fun.getArg(i), depth + 1);
                ++i;
            }
        }
    }
}

