/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djepJUnit;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.lsmp.djep.vectorJep.VectorJep;
import org.nfunk.jep.JEP;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.type.Complex;

public class JepTest
extends TestCase {
    JEP j;
    public static final boolean SHOW_BAD = false;
    static /* synthetic */ Class class$0;

    public JepTest(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.lsmp.djepJUnit.JepTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.lsmp.djepJUnit.JepTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite suite = new TestSuite((Class)clazz);
        suite.run(new TestResult());
    }

    protected void setUp() {
        this.j = new JEP();
        this.j.addStandardConstants();
        this.j.addStandardFunctions();
        this.j.addComplex();
        this.j.setAllowAssignment(true);
        this.j.setAllowUndeclared(true);
        this.j.setImplicitMul(true);
    }

    public void myAssertEquals(String msg, Object expected, Object actual) {
        if (!actual.equals(expected)) {
            System.out.println("Error: '" + msg + "' is '" + actual + "' should be '" + expected + "'");
        }
        JepTest.assertEquals((String)("<" + msg + ">"), (Object)expected, (Object)actual);
        System.out.println("Success: Value of \"" + msg + "\" is " + actual);
    }

    public void myAssertNaN(String msg, Object actual) {
        if (actual instanceof Double) {
            if (Double.isNaN((Double)actual)) {
                System.out.println("Success: Value of \"" + msg + "\" is " + actual);
            } else {
                System.out.println("Error: \"" + msg + "\" is '" + actual + "' should be NaN");
                JepTest.assertTrue((String)("<" + msg + "> is " + actual + " should be NaN"), (boolean)false);
            }
        } else {
            System.out.println("Error: '" + msg + "' is '" + actual + "' should be 'NaN'");
            JepTest.assertTrue((String)("<" + msg + ">"), (boolean)false);
        }
    }

    public Object calcValue(String expr) throws ParseException {
        Node n = this.j.parse(expr);
        return this.calcValue(n);
    }

    public Object calcValue(Node expr) throws ParseException {
        Object val = this.j.evaluate(expr);
        return val;
    }

    public void valueTest(String expr, Object expected) throws Exception {
        Object res = this.calcValue(expr);
        this.myAssertEquals(expr, expected, res);
    }

    public void valueTest(String expr, String expected) throws Exception {
        Object res = this.calcValue(expr);
        this.myAssertEquals(expr, expected, res.toString());
    }

    public void valueTestNaN(String expr) throws Exception {
        Object res = this.calcValue(expr);
        this.myAssertNaN(expr, res);
    }

    public void valueTestInt(String expr, int a) throws Exception {
        this.valueTest(expr, new Integer(a));
    }

    public void valueTest(String expr, double a) throws Exception {
        this.valueTest(expr, new Double(a));
    }

    public void valueTest(String expr, double a, double tol) throws Exception {
        Object res = this.calcValue(expr);
        if (res instanceof Double) {
            double val = (Double)res;
            if (Math.abs(val - a) < tol) {
                System.out.println("Success value of \"" + expr + "\" is " + res);
            } else {
                System.out.println("Error value of \"" + expr + "\" is " + res + " should be " + a);
                JepTest.assertEquals((String)expr, (double)a, (double)val, (double)tol);
            }
        } else {
            System.out.println("Error value of \"" + expr + "\" is " + res + " should be " + a);
            JepTest.assertTrue((String)("<" + expr + "> expected: <" + a + "> but was <" + res + ">"), (boolean)false);
        }
    }

    public void complexValueTest(String expr, Complex expected, double tol) throws Exception {
        Object res = this.calcValue(expr);
        if (expected.equals((Complex)res, tol)) {
            System.out.println("Success value of \"" + expr + "\" is " + res);
        } else {
            System.out.println("Error value of \"" + expr + "\" is " + res + " should be " + expected);
            JepTest.assertTrue((String)("<" + expr + "> expected: <" + expected + "> but was <" + res + ">"), (boolean)false);
        }
    }

    public void testGood() {
        this.myAssertEquals("1", new Double(1.0), new Double(1.0));
        this.myAssertNaN("NaN", new Double(Double.NaN));
    }

    public void testSimpleSum() throws Exception {
        this.valueTest("1+2", 3.0);
        this.valueTest("2*6+3", 15.0);
        this.valueTest("2*(6+3)", 18.0);
    }

    public void testLogical() throws Exception {
        System.out.println("\nTesting logical operations");
        this.valueTest("T=1", 1.0);
        this.valueTest("F=0", 0.0);
        this.valueTest("!T", 0.0);
        this.valueTest("!F", 1.0);
        this.valueTest("!5", 0.0);
        this.valueTest("-0==0", 1.0);
        this.valueTest("!-5", 0.0);
        this.valueTest("-!5==0", 1.0);
        this.valueTest("-!0", -1.0);
        this.valueTest("-0", -0.0);
        this.valueTest("T&&T", 1.0);
        this.valueTest("T&&F", 0.0);
        this.valueTest("F&&T", 0.0);
        this.valueTest("F&&F", 0.0);
        this.valueTest("T||T", 1.0);
        this.valueTest("T||F", 1.0);
        this.valueTest("F||T", 1.0);
        this.valueTest("F||F", 0.0);
        this.calcValue("a=F");
        this.calcValue("b=F");
        this.calcValue("c=F");
        this.valueTest("(a&&(b||c)) == ((a&&b)||(a&&c))", 1.0);
        this.valueTest("(a||(b&&c)) == ((a||b)&&(a||c))", 1.0);
        this.calcValue("a=F");
        this.calcValue("b=F");
        this.calcValue("c=T");
        this.valueTest("(a&&(b||c)) == ((a&&b)||(a&&c))", 1.0);
        this.valueTest("(a||(b&&c)) == ((a||b)&&(a||c))", 1.0);
        this.calcValue("a=F");
        this.calcValue("b=T");
        this.calcValue("c=F");
        this.valueTest("(a&&(b||c)) == ((a&&b)||(a&&c))", 1.0);
        this.valueTest("(a||(b&&c)) == ((a||b)&&(a||c))", 1.0);
        this.calcValue("a=F");
        this.calcValue("b=T");
        this.calcValue("c=T");
        this.valueTest("(a&&(b||c)) == ((a&&b)||(a&&c))", 1.0);
        this.valueTest("(a||(b&&c)) == ((a||b)&&(a||c))", 1.0);
        this.calcValue("a=T");
        this.calcValue("b=F");
        this.calcValue("c=F");
        this.valueTest("(a&&(b||c)) == ((a&&b)||(a&&c))", 1.0);
        this.valueTest("(a||(b&&c)) == ((a||b)&&(a||c))", 1.0);
        this.calcValue("a=T");
        this.calcValue("b=F");
        this.calcValue("c=T");
        this.valueTest("(a&&(b||c)) == ((a&&b)||(a&&c))", 1.0);
        this.valueTest("(a||(b&&c)) == ((a||b)&&(a||c))", 1.0);
        this.calcValue("a=T");
        this.calcValue("b=T");
        this.calcValue("c=F");
        this.valueTest("(a&&(b||c)) == ((a&&b)||(a&&c))", 1.0);
        this.valueTest("(a||(b&&c)) == ((a||b)&&(a||c))", 1.0);
        this.calcValue("a=T");
        this.calcValue("b=T");
        this.calcValue("c=T");
        this.valueTest("(a&&(b||c)) == ((a&&b)||(a&&c))", 1.0);
        this.valueTest("(a||(b&&c)) == ((a||b)&&(a||c))", 1.0);
        this.j.addVariable("true", new Boolean(true));
        this.j.addVariable("false", new Boolean(false));
        this.valueTest("true==true", 1.0);
        this.valueTest("false==false", 1.0);
        this.valueTest("true==false", 0.0);
        this.valueTest("true==true&&false==false", 1.0);
        this.valueTest("if(true==true&&false==false,6,7)", 6.0);
        this.valueTest("if(false&&true,6,7)", 7.0);
        this.valueTest("if(true&&false==false,6,7)", 6.0);
        this.valueTest("if((true&&true)==true,6,7)", 6.0);
        this.valueTest("if((!false)==true,6,7)", 6.0);
    }

    public void testFunction() throws Exception {
        System.out.println("\nTesting real functions");
        this.valueTest("abs(2.5)", 2.5);
        this.valueTest("abs(-2.5)", 2.5);
        this.valueTest("acos(1/sqrt(2))", 0.7853981633974483, 1.0E-8);
        this.valueTest("cos(pi/3)", 0.5, 1.0E-8);
        this.valueTest("atan2(3,4)", Math.atan2(3.0, 4.0), 1.0E-8);
        this.valueTest("2^4", 16.0);
        this.valueTest("2^10", 1024.0);
        this.valueTest("2^0.5", Math.sqrt(2.0), 1.0E-8);
        this.valueTest("2^(-0.5)", 1.0 / Math.sqrt(2.0), 1.0E-8);
        this.valueTest("2^(-4)", 0.0625, 1.0E-8);
        this.valueTest("2^(-10)", 9.765625E-4, 1.0E-8);
    }

    public void testComplex() throws Exception {
        System.out.println("\nTesting complex values");
        double tol = 1.0E-8;
        this.complexValueTest("z=complex(3,2)", new Complex(3.0, 2.0), tol);
        this.complexValueTest("z*z-z", new Complex(2.0, 10.0), tol);
        this.complexValueTest("z^3", new Complex(-9.0, 46.0), tol);
        this.complexValueTest("(z*z-z)/z", new Complex(2.0, 2.0), tol);
        this.complexValueTest("w=polar(2,pi/2)", new Complex(0.0, 2.0), tol);
        this.complexValueTest("ln(-1)", new Complex(0.0, Math.PI), tol);
        this.complexValueTest("sqrt(-1)", new Complex(0.0, 1.0), tol);
        this.complexValueTest("pow(-1,0.5)", new Complex(0.0, 1.0), tol);
        this.valueTest("arg(w)", 1.5707963267948966);
        this.valueTest("cmod(w)", 2.0);
        this.valueTest("re(z)", 3.0);
        this.valueTest("im(z)", 2.0);
        this.complexValueTest("conj(z)", new Complex(3.0, -2.0), tol);
        this.complexValueTest("exp(pi i/2)", new Complex(0.0, 1.0), tol);
    }

    public void testIf() throws Exception {
        System.out.println("\nTesting if statement");
        this.valueTest("if(1,2,3)", 2.0);
        this.valueTest("if(-1,2,3)", 3.0);
        this.valueTest("if(0,2,3)", 3.0);
        this.valueTest("if(1,2,3,4)", 2.0);
        this.valueTest("if(-1,2,3,4)", 3.0);
        this.valueTest("if(0,2,3,4)", 4.0);
        this.valueTest("if(0>=0,2,3,4)", 2.0);
        this.valueTest("x=3", 3.0);
        this.valueTest("if(x==3,1,-1)", 1.0);
        this.valueTest("if(x!=3,1,-1)", -1.0);
        this.valueTest("if(x>=3,1,-1)", 1.0);
        this.valueTest("if(x>3,1,-1)", -1.0);
        this.valueTest("if(x<=3,1,-1)", 1.0);
        this.valueTest("if(x<3,1,-1)", -1.0);
    }

    public void testAssign() throws Exception {
        System.out.println("\nTesting assignment of variables");
        this.valueTest("x=3", 3.0);
        this.valueTest("y=3+4", 7.0);
        this.valueTest("z=x+y", 10.0);
        this.valueTest("a=b=c=z", 10.0);
        this.valueTest("b", 10.0);
        this.valueTest("d=f=a-b", 0.0);
        this.valueTest("x=2", 2.0);
        this.valueTest("(x*x)*x*(x*x)", 32.0);
        new VectorJep();
        this.valueTest("(x*x)*x*(x*x)", 32.0);
    }

    public void testDotInName() throws ParseException, Exception {
        System.out.println("\nTesting names with dot in them");
        this.valueTest("x.x=3", 3.0);
        this.valueTest("x.x+1", 4.0);
    }

    public void testBinom() throws ParseException, Exception {
        System.out.println("\nTesting binomial coeffs");
        this.valueTestInt("binom(0,0)", 1);
        this.valueTestInt("binom(1,0)", 1);
        this.valueTestInt("binom(1,1)", 1);
        this.valueTestInt("binom(2,0)", 1);
        this.valueTestInt("binom(2,1)", 2);
        this.valueTestInt("binom(2,2)", 1);
        this.valueTestInt("binom(3,0)", 1);
        this.valueTestInt("binom(3,1)", 3);
        this.valueTestInt("binom(3,2)", 3);
        this.valueTestInt("binom(3,3)", 1);
        this.valueTestInt("binom(4,0)", 1);
        this.valueTestInt("binom(4,1)", 4);
        this.valueTestInt("binom(4,2)", 6);
        this.valueTestInt("binom(4,3)", 4);
        this.valueTestInt("binom(4,4)", 1);
        this.valueTestInt("binom(5,0)", 1);
        this.valueTestInt("binom(5,1)", 5);
        this.valueTestInt("binom(5,2)", 10);
        this.valueTestInt("binom(5,3)", 10);
        this.valueTestInt("binom(5,4)", 5);
        this.valueTestInt("binom(5,5)", 1);
        this.valueTestInt("binom(6,0)", 1);
        this.valueTestInt("binom(6,1)", 6);
        this.valueTestInt("binom(6,2)", 15);
        this.valueTestInt("binom(6,3)", 20);
        this.valueTestInt("binom(6,4)", 15);
        this.valueTestInt("binom(6,5)", 6);
        this.valueTestInt("binom(6,6)", 1);
        this.valueTestInt("binom(10,1)", 10);
        this.valueTestInt("binom(10,5)", 252);
    }

    public void testNaN() throws Exception {
        System.out.println("\nTesting for NaN");
        this.j.addVariable("x", new Double(Double.NaN));
        System.out.println("x=NaN");
        this.valueTestNaN("ln(x)");
        this.valueTestNaN("log(x)");
        this.valueTestNaN("sin(x)");
        this.valueTestNaN("x+x");
        this.valueTest("x!=x", 1.0);
        this.valueTest("x==x", 0.0);
        this.j.addVariable("y", new Double(Double.NaN));
        Node n = this.j.parse("x+5");
        System.out.println(this.calcValue(n));
        Node n2 = this.j.parse("y");
        System.out.println(this.calcValue(n2));
        this.valueTest("x == x+5", 0.0);
        this.valueTest("x == 0/0", 0.0);
        this.valueTest("x == x", 0.0);
        this.valueTest("x == 0 * x", 0.0);
        this.valueTest("x == 5", 0.0);
        this.valueTest("x == y", 0.0);
        this.valueTest("y == y", 0.0);
        System.out.println("Set x to Double(5)");
        this.j.setVarValue("x", new Double(5.0));
        this.valueTest("x == x+5", 0.0);
        this.valueTest("x == x", 1.0);
    }

    public void testAssign2() {
        System.out.println("\nTesting for assignment using parseExpression and getValue");
        JEP parser = new JEP();
        parser.addVariable("AB", 12.0);
        parser.addVariable("graph", new Object());
        parser.addVariable("graph1", null);
        parser.setAllowAssignment(true);
        parser.parseExpression("AB=3");
        System.out.println("AB=3" + parser.getValue());
        parser.parseExpression("AB+2");
        double result = parser.getValue();
        JepTest.assertEquals((String)"<AB+2>", (double)5.0, (double)result, (double)0.0);
    }

    boolean isExpressionValid(String expression) {
        JEP jep = this.j;
        try {
            Node n = jep.parse(expression);
            System.out.println("expression " + expression + " \n Parsed value " + jep.hasError());
            if (jep.hasError()) {
                System.out.println("jep.getErrorInfo " + jep.getErrorInfo());
                return false;
            }
            System.out.println("jep.getSymbolTable " + jep.getSymbolTable());
            System.out.println("Eval: " + jep.evaluate(n).toString());
            return true;
        }
        catch (Error e) {
            System.out.println(e.getMessage());
            if (jep.hasError()) {
                System.out.println("Error is : " + jep.getErrorInfo());
            }
            return false;
        }
        catch (Exception e1) {
            System.out.println(e1.getMessage());
            if (jep.hasError()) {
                System.out.println("Error is : " + jep.getErrorInfo());
            }
            return false;
        }
    }

    public void testNumParam() throws Exception {
        this.j.parse("if(3,1,2)");
        this.j.parse("if(4,1,2,3)");
        try {
            this.j.parse("if(5,1,2,3,4)");
            JepTest.fail((String)"Did not trap illegal number of arguments");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.j.parse("a1=1234");
        this.j.parse("a2=5678");
        this.j.parse("ApportionmentAmt=4321");
        this.j.parse("a4 = 2000 + (3000 /2000) + (3.45787 * 33544 - (212.223 /2000)) + + 1200");
        this.j.parse("a3 = if(a1 > 0 && ApportionmentAmt < 1000, if(a2 < 2000, if(a2 < 1000, 200, 0), if(a1 > 1000, if((2000 + (3000 /2000) + (3.45787 * 33544 - (212.223 /2000)) + 1200 + ApportionmentAmt / 2000 + ApportionmentAmt * ApportionmentAmt + 2000) > 0, 100, 200),200)), if(a1/a2 < 1000, a1/a2, 1, a1 * a2 + a1))");
        try {
            this.j.parse("a3 = if(a1 > 0 && ApportionmentAmt < 1000, if(a2 < 2000, if(a2 < 1000, 200, 0), if(a1 > 1000, if((2000 + (3000 /2000) + (3.45787 * 33544 - (212.223 /2000)) + 1200 + ApportionmentAmt / 2000 + ApportionmentAmt * ApportionmentAmt + 2000) > 0, 100, 200)),200), if(a1/a2 < 1000, a1/a2, 1, a1 * a2 + a1))");
            JepTest.fail((String)"Did not trap illegal number of arguments");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void testUndeclared() throws Exception {
        this.j.setAllowUndeclared(false);
        try {
            this.j.parse("zap * wow");
            JepTest.fail((String)"Should have found undeclared error");
        }
        catch (ParseException e) {
            System.out.println("Error caught: " + e.getMessage());
        }
        try {
            this.j.setVarValue("foo", new Double(5.0));
            JepTest.fail((String)"Should have found a null pointer exception");
        }
        catch (NullPointerException e) {
            System.out.println("Expected error caught: " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    public void testBad() throws Exception {
    }
}

