/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djepJUnit;

import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.lsmp.djep.djep.DJep;
import org.lsmp.djep.rewrite.CollectPowers;
import org.lsmp.djep.rewrite.ExpandBrackets;
import org.lsmp.djep.rewrite.RewriteRuleI;
import org.lsmp.djep.rewrite.RewriteVisitor;
import org.lsmp.djepJUnit.DJepTest;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;

public class RewriteTest
extends DJepTest {
    DJep j;
    public static final boolean SHOW_BAD = false;
    static /* synthetic */ Class class$0;

    public RewriteTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.lsmp.djepJUnit.RewriteTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite suite = new TestSuite((Class)clazz);
        suite.run(new TestResult());
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.lsmp.djepJUnit.RewriteTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public void testRewrite() throws Exception {
        DJep j = new DJep();
        j.addStandardFunctions();
        j.addStandardConstants();
        j.setImplicitMul(true);
        j.addComplex();
        j.setAllowUndeclared(true);
        j.setAllowAssignment(true);
        j.addStandardDiffRules();
        j.getPrintVisitor().setMaxLen(80);
        j.addVariable("x", 0.0);
        RewriteVisitor ev = new RewriteVisitor();
        ExpandBrackets expand = new ExpandBrackets(j);
        CollectPowers colectPower = new CollectPowers(j);
        RewriteRuleI[] rules = new RewriteRuleI[]{expand, colectPower};
        String[] expresions = new String[]{"x*x", "x*x^2", "x^2*x"};
        int i = 0;
        while (i < expresions.length) {
            Node node = j.parse(expresions[i]);
            System.out.print("Eqn:\t");
            j.println(node);
            Node node2 = ev.rewrite(node, j, rules, true);
            System.out.print("Expand:\t");
            j.println(node2);
            ++i;
        }
    }

    public void testTaylor() throws Exception {
        Node node2;
        DJep taylorParser = new DJep();
        taylorParser.addStandardFunctions();
        taylorParser.addStandardConstants();
        taylorParser.setAllowUndeclared(true);
        taylorParser.setAllowAssignment(true);
        taylorParser.setImplicitMul(true);
        taylorParser.addComplex();
        taylorParser.addStandardDiffRules();
        taylorParser.getPrintVisitor().setMaxLen(80);
        taylorParser.addVariable("x", 0.0);
        RewriteVisitor ev = new RewriteVisitor();
        ExpandBrackets expand = new ExpandBrackets(taylorParser);
        CollectPowers colectPower = new CollectPowers(taylorParser);
        RewriteRuleI[] rules = new RewriteRuleI[]{expand, colectPower};
        Node node3 = node2 = taylorParser.parse("ln(1+x)");
        int i = 1;
        while (i < 5) {
            Node node4 = taylorParser.differentiate(node3, "x");
            System.out.println("Deriv " + i);
            taylorParser.println(node4);
            Node node5 = taylorParser.simplify(node4);
            System.out.println("Simp ");
            taylorParser.println(node5);
            Node node6 = ev.rewrite(node5, taylorParser, rules, true);
            System.out.println("Expand ");
            taylorParser.println(node6);
            node3 = node5;
            ++i;
        }
    }

    public void testMemory() throws Exception {
        DJep taylorParser = new DJep();
        taylorParser.addStandardFunctions();
        taylorParser.addStandardConstants();
        taylorParser.setAllowUndeclared(true);
        taylorParser.setAllowAssignment(true);
        taylorParser.setImplicitMul(true);
        taylorParser.addComplex();
        taylorParser.addStandardDiffRules();
        taylorParser.addVariable("x", 0.0);
    }

    public void testBad() throws ParseException {
    }
}

