/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jepexamples;

import com.trend.iwss.jscan.runtime.CallContext;
import com.trend.iwss.jscan.runtime.MiscPolicyRuntime;
import com.trend.iwss.jscan.runtime.Session;
import com.trend.iwss.jscan.runtime.WindowPolicyRuntime;
import java.applet.Applet;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import org.nfunk.jep.JEP;

public class Evaluator
extends Applet {
    private static final long serialVersionUID = 4592714713689369505L;
    private JEP myParser;
    private double xValue;
    private TextField exprField;
    private TextField xField;
    private TextArea errorTextArea;
    private Label resultLabel;
    private Checkbox implicitCheckbox;
    private Checkbox undeclaredCheckbox;

    public Evaluator() {
        Session.setAppletInstance(this, "mmc.sess_pe_act.action=validate\nthread.thread_num_max=8\nfile.destructive.state=disabled\njscan.session.user_name=172.26.113.23\njscan.sess_applet_act.unsigned=instrument\njscan.sess_applet_act.stub_out_blocked_applet=true\njscan.sess_applet_act.block_all=false\nmmc.sess_pe_act.block_invalid=true\nmmc.sess_cab_act.block_unsigned=false\nthread.thread_num_limited=true\nwindow.num_max=5\njscan.session.policyname=TU1DIERlZmF1bHQgUG9saWN5\njscan.sess_applet_act.sig_trusted=pass\njscan.sess_applet_act.sig_invalid=block\nmmc.sess_pe_act.block_blacklisted=false\nmmc.sess_cab_act.block_blacklisted=true\njscan.sess_applet_act.sig_blacklisted=block\njscan.session.origin_uri=http://www.singsurf.org/djep/jars/djep-full-latest.jar\nnet.connect_other=false\njscan.session.user_ipaddr=172.26.113.23\njscan.session.daemon_protocol=http\nthread.threadgroup_create=false\nfile.read.state=disabled\nfile.nondestructive.state=disabled\nnet.bind_enable=false\nnet.connect_src=true\nmmc.sess_cab_act.action=validate\nmmc.sess_pe_act.block_unsigned=false\nfile.write.state=disabled\nmmc.sess_cab_act.block_invalid=true\nwindow.num_limited=true", "instr.action.send_data=send data to {0}\ninstr.action.invoke_sys_noarg=invoke the {0}.{1}() operation\ninstr.msg.dialog.applet_terminated=APPLET TERMINATED\ninstr.button.no=No\ninstr.button.allow=Allow\ninstr.action.bind_local=bind local port {0}\ninstr.action.policy_stop_error=Applet disabled by IWSS Javascan site policy.\ninstr.action.connect=connect to {0}\ninstr.action.runtime.exec=run the following executable: {0}\ninstr.action.invoke_sys_arg=invoke the {0}.{1}() operation on {2}\ninstr.button.yes=Yes\ninstr.action.policy_security_exception=The Applet is not allowed to {0} by IWSS Javascan site policy.\ninstr.action.file.write=perform a write operation on file {0}\ninstr.dialog.title.applet_alert=--APPLET ALERT--\ninstr.action.receive_data=receive data from {0}\ninstr.action.bind_local_unspec=bind to a free local port\ninstr.msg.dialog.applet_stopped=The applet has been terminated because it was attempting to perform an action that violates corporate security policy.\ninstr.msg.thread.limit=have more than {0} active threads\ninstr.msg.dialog.ask_stop_applet=Do you want to stop the applet now?\ninstr.msg.window.limit=have more than {0} active windows\ninstr.action.file.nondestructive_alt=access \"{0}\" state attributes\ninstr.action.invoke=invoke {0}\ninstr.button.ok=OK\ninstr.msg.dialog.action_warning_start=The applet is attempting to {0}\ninstr.msg.thread.group_limit=create new thread groups\ninstr.button.stop_applet=Stop Applet\ninstr.action.file.destructive_alt=perform a \"{0}\" state change operation\ninstr.action.file.nondestructive=access the \"{1}\" state attributes of file {0}\ninstr.action.file.destructive=perform a \"{1}\" state change operation on file {0}\ninstr.button.disallow=Disallow\ninstr.action.file.read=perform a read operation on file {0}");
    }

    public static void main(String[] args) {
        Evaluator a = new Evaluator();
        a.init();
        a.start();
        Frame f = new Frame("Evaluator");
        f.add("Center", a);
        f.setSize(400, 200);
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                CallContext callContext = new CallContext(184, "java/lang/System", "exit", "(I)V", this).addArg(0);
                int n = callContext.getNextIntArg();
                MiscPolicyRuntime.preFilter(callContext);
                System.exit(n);
                MiscPolicyRuntime.postFilter(callContext);
            }
        });
        CallContext callContext = new CallContext(182, "java/awt/Frame", "setVisible", "(Z)V", null).addArg(true);
        Frame frame = f;
        callContext.setTarget(frame);
        boolean bl = callContext.getNextBoolArg();
        WindowPolicyRuntime.preFilter(callContext);
        frame.setVisible(bl);
        WindowPolicyRuntime.postFilter(callContext);
    }

    public void init() {
        this.xValue = 10.0;
        this.addGUIComponents();
        this.myParser = new JEP();
        this.myParser.initFunTab();
        this.myParser.addStandardFunctions();
        this.myParser.setTraverse(true);
        this.optionsChanged();
    }

    private void addGUIComponents() {
        this.setBackground(Color.white);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        c.fill = 2;
        c.weightx = 0.0;
        Label exprFieldp = new Label("Expression: ", 2);
        gridbag.setConstraints(exprFieldp, c);
        this.add(exprFieldp);
        c.weightx = 0.8;
        this.exprField = new TextField(27);
        gridbag.setConstraints(this.exprField, c);
        this.add(this.exprField);
        c.weightx = 0.0;
        Label xFieldp = new Label("x: ", 2);
        gridbag.setConstraints(xFieldp, c);
        this.add(xFieldp);
        c.weightx = 0.2;
        c.gridwidth = 0;
        this.xField = new TextField("" + this.xValue, 4);
        gridbag.setConstraints(this.xField, c);
        this.add(this.xField);
        c.weightx = 0.0;
        c.gridwidth = 1;
        Label resultLabelText = new Label("Result: ", 2);
        gridbag.setConstraints(resultLabelText, c);
        this.add(resultLabelText);
        c.weightx = 1.0;
        c.gridwidth = 0;
        this.resultLabel = new Label("", 0);
        gridbag.setConstraints(this.resultLabel, c);
        this.add(this.resultLabel);
        c.weightx = 0.0;
        c.gridwidth = 1;
        Label optionsLabelText = new Label("Options: ", 2);
        gridbag.setConstraints(optionsLabelText, c);
        this.add(optionsLabelText);
        c.weightx = 1.0;
        c.gridwidth = 0;
        this.implicitCheckbox = new Checkbox("Implicit multiplication", true);
        gridbag.setConstraints(this.implicitCheckbox, c);
        this.add(this.implicitCheckbox);
        c.weightx = 0.0;
        c.gridwidth = 1;
        Label spaceLabelText = new Label(" ", 2);
        gridbag.setConstraints(spaceLabelText, c);
        this.add(spaceLabelText);
        c.weightx = 1.0;
        c.gridwidth = 0;
        this.undeclaredCheckbox = new Checkbox("Allow undeclared identifiers");
        gridbag.setConstraints(this.undeclaredCheckbox, c);
        this.add(this.undeclaredCheckbox);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.anchor = 11;
        Label errorLabel = new Label("Errors: ", 2);
        gridbag.setConstraints(errorLabel, c);
        this.add(errorLabel);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        this.errorTextArea = new TextArea("");
        this.errorTextArea.setEditable(false);
        this.errorTextArea.setBackground(Color.white);
        gridbag.setConstraints(this.errorTextArea, c);
        this.add(this.errorTextArea);
        this.exprField.addTextListener(new TextListener(){

            public void textValueChanged(TextEvent evt) {
                Evaluator.this.exprFieldTextValueChanged();
            }
        });
        this.xField.addTextListener(new TextListener(){

            public void textValueChanged(TextEvent evt) {
                Evaluator.this.xFieldTextValueChanged();
            }
        });
        this.implicitCheckbox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                Evaluator.this.optionsChanged();
            }
        });
        this.undeclaredCheckbox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                Evaluator.this.optionsChanged();
            }
        });
    }

    private void parseExpression() {
        this.myParser.initSymTab();
        this.myParser.addStandardConstants();
        this.myParser.addComplex();
        this.myParser.addVariable("x", this.xValue);
        this.myParser.parseExpression(this.exprField.getText());
    }

    private void exprFieldTextValueChanged() {
        this.parseExpression();
        this.updateResult();
    }

    private void xFieldTextValueChanged() {
        try {
            this.xValue = Double.valueOf(this.xField.getText());
        }
        catch (NumberFormatException e) {
            System.out.println("Invalid format in xField");
            this.xValue = 0.0;
        }
        this.myParser.addVariable("x", this.xValue);
        this.updateResult();
    }

    private void optionsChanged() {
        this.myParser.setImplicitMul(this.implicitCheckbox.getState());
        this.myParser.setAllowUndeclared(this.undeclaredCheckbox.getState());
        this.parseExpression();
        this.updateResult();
    }

    private void updateResult() {
        Object result = this.myParser.getValueAsObject();
        if (result != null) {
            this.resultLabel.setText(result.toString());
        } else {
            this.resultLabel.setText("");
        }
        String errorInfo = this.myParser.getErrorInfo();
        if (errorInfo != null) {
            this.errorTextArea.setText(errorInfo);
        } else {
            this.errorTextArea.setText("");
        }
    }
}

