/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jepexamples;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.TextField;
import java.util.Date;
import org.nfunk.jep.JEP;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.SymbolTable;
import org.nfunk.jep.evaluation.CommandElement;
import org.nfunk.jep.evaluation.CommandEvaluator;
import org.nfunk.jep.evaluation.ExpressionCompiler;
import org.nfunk.jep.type.Complex;

public class FractalCanvas
extends Canvas {
    private static final long serialVersionUID = -593341831485283712L;
    private int scaleX = 100;
    private int scaleY = 100;
    private Dimension dimensions = this.getSize();
    private int iterations = 20;
    private int nEvals = 0;
    private boolean hasError = true;
    private JEP myParser;
    private ExpressionCompiler expressionCompiler;
    private CommandEvaluator evaluator;
    private CommandElement[] commands;
    private SymbolTable symTab;
    private TextField exprField;

    public FractalCanvas(String initialExpression, TextField exprField_in) {
        this.exprField = exprField_in;
        this.initParser(initialExpression);
        this.expressionCompiler = new ExpressionCompiler();
        this.evaluator = new CommandEvaluator();
        this.symTab = this.myParser.getSymbolTable();
    }

    private void initParser(String initialExpression) {
        this.myParser = new JEP();
        this.myParser.addStandardFunctions();
        this.myParser.addStandardConstants();
        this.myParser.addComplex();
        this.myParser.addVariable("z", 0.0, 0.0);
        this.myParser.addVariable("c", 0.0, 0.0);
        this.setExpressionString(initialExpression);
    }

    public void setExpressionString(String newString) {
        this.nEvals = 0;
        this.myParser.parseExpression(newString);
        this.hasError = this.myParser.hasError();
        if (this.hasError) {
            this.exprField.setForeground(Color.red);
        } else {
            this.exprField.setForeground(Color.black);
        }
    }

    public void setIterations(int iterations_in) {
        this.iterations = iterations_in;
    }

    private void paintWhite(Graphics g) {
        g.setColor(Color.white);
        g.fillRect(0, 0, this.dimensions.width, this.dimensions.height);
    }

    private void paintFractalSansJEP(Graphics g) {
        System.out.println("paintFractalSansJEP()");
        System.out.println("done.");
    }

    private void paintRegion(Graphics g, int x, int y, int width, int height, int depth, int depth_max) {
        if (depth == depth_max) {
            double p = (double)(x + width / 2 - 230) / (double)this.scaleX;
            double q = (double)(y + height / 2 - 150) / (double)this.scaleY;
            int count = 0;
            double re = 0.0;
            double im = 0.0;
            double resq = 0.0;
            double imsq = 0.0;
            while (count < this.iterations && resq + imsq < 4.0) {
                double imtemp = 2.0 * re * im;
                re = resq - imsq + p;
                im = imtemp + q;
                ++count;
                resq = re * re;
                imsq = im * im;
                ++this.nEvals;
            }
            if (count != this.iterations) {
                g.setColor(new Color(0, 0, (int)(255.0 * (Math.sqrt(count) / Math.sqrt(this.iterations)))));
                g.fillRect(x, y, width, height);
            }
        } else {
            this.paintRegion(g, x, y, width / 2, height - height / 2, depth + 1, depth_max);
            this.paintRegion(g, x + width / 2, y, width - width / 2, height / 2, depth + 1, depth_max);
            this.paintRegion(g, x, y + height / 2, width / 2, height - height / 2, depth + 1, depth_max);
            this.paintRegion(g, x + width / 2, y + height / 2, width - width / 2, height - height / 2, depth + 1, depth_max);
        }
    }

    private void paintFractal(Graphics g) {
        Complex c = this.myParser.addVariable("c", 0.0, 0.0);
        Complex z = this.myParser.addVariable("z", 0.0, 0.0);
        int x = 0;
        while (x <= this.dimensions.width - 1) {
            int y = 0;
            while (y <= this.dimensions.height - 1) {
                int count = 0;
                c.set((double)(x - 230) / (double)this.scaleX, (double)(y - 150) / (double)this.scaleY);
                z.set(0.0, 0.0);
                while (count < this.iterations && z.abs2() < 4.0) {
                    z.set(this.myParser.getComplexValue());
                    ++count;
                    ++this.nEvals;
                }
                if (count != this.iterations) {
                    g.setColor(new Color(0, 0, (int)(255.0 * (Math.sqrt(count) / Math.sqrt(this.iterations)))));
                    g.fillRect(x, y, 1, 1);
                }
                ++y;
            }
            ++x;
        }
    }

    private void paintFractalWithCompiler(Graphics g) {
        Complex c = this.myParser.addVariable("c", 0.0, 0.0);
        Complex z = this.myParser.addVariable("z", 0.0, 0.0);
        try {
            this.commands = this.expressionCompiler.compile(this.myParser.getTopNode());
        }
        catch (ParseException e) {
            System.out.println("Failed to compile expression");
            e.printStackTrace();
        }
        int x = 0;
        while (x <= this.dimensions.width - 1) {
            int y = 0;
            while (y <= this.dimensions.height - 1) {
                int count = 0;
                c.set((double)(x - 230) / (double)this.scaleX, (double)(y - 150) / (double)this.scaleY);
                z.set(0.0, 0.0);
                while (count < this.iterations && z.abs2() < 4.0) {
                    try {
                        Complex temp = (Complex)this.evaluator.evaluate(this.commands, this.symTab);
                        z.set(temp);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ++count;
                    ++this.nEvals;
                }
                if (count != this.iterations) {
                    g.setColor(new Color(0, 0, (int)(255.0 * (Math.sqrt(count) / Math.sqrt(this.iterations)))));
                    g.fillRect(x, y, 1, 1);
                }
                ++y;
            }
            ++x;
        }
    }

    private void paintNonJEPFractal(Graphics g) {
        int x = 0;
        while (x <= this.dimensions.width - 1) {
            int y = 0;
            while (y <= this.dimensions.height - 1) {
                double p = (double)(x - 230) / (double)this.scaleX;
                double q = (double)(y - 150) / (double)this.scaleY;
                int count = 0;
                double re = 0.0;
                double im = 0.0;
                double resq = 0.0;
                double imsq = 0.0;
                while (count < this.iterations && resq + imsq < 4.0) {
                    double imtemp = 2.0 * re * im;
                    re = resq - imsq + p;
                    im = imtemp + q;
                    resq = re * re;
                    imsq = im * im;
                    ++count;
                    ++this.nEvals;
                }
                if (count != this.iterations) {
                    g.setColor(new Color(0, 0, (int)(255.0 * (Math.sqrt(count) / Math.sqrt(this.iterations)))));
                    g.fillRect(x, y, 1, 1);
                }
                ++y;
            }
            ++x;
        }
    }

    public void paint(Graphics g) {
        this.dimensions = this.getSize();
        this.paintWhite(g);
        if (!this.hasError) {
            System.out.println("Painting... ");
            Date start = new Date();
            this.nEvals = 0;
            this.paintFractalWithCompiler(g);
            Date finish = new Date();
            System.out.print("done. sec/eval: ");
            double seconds = (double)(finish.getTime() - start.getTime()) / 1000.0;
            System.out.println(seconds / (double)this.nEvals);
        }
    }
}

