classdef class_REVS_drive_cycle
	% class_REVS_drive_cycle
	
	properties
		
		name = '';		
		sample_start_enable = false;
		
		phase_name;	
		phase@double vector
		phase_time@double vector
		
		cycle_time@double vector
		cycle_speed_mps@double vector
		
		in_gear@double vector
        in_gear_time@double vector
        
		ignition@double vector
        ignition_time@double vector
        
        grade_dist_m@double vector
        grade_pct@double vector
				
	end
	
	
	methods
		
	
		function val = get.phase_name(obj)
			
			if ~isempty( obj.phase_name)
				val =  obj.phase_name;
			else
				phase_str = strtrim(cellstr(int2str((1:max(obj.phase))')));				
				val  = phase_str';				
			end
			
		end
				
	end
	
end

