classdef class_REVS_sim_params
    %class_REVS_sim_params
    %	Stores parameter information for a REVS2 vehicle simulation. Parameter
    %	information is specified by a string or
    %	cell array of strings pointing to peremeter definition files that
    %	will be called via the run command.
    
    properties
        engine_fname        = '';     % filename or cell array of filenames of engine params script
        transmission_fname  = '';     % filename or cell array of filenames of transmission params script
        vehicle_fname       = '';     % filename or cell array of filenames of vehicle params script
        electric_fname      = '';     % filename or cell array of filenames of electric params script
        accessory_fname     = '';     % filename or cell array of filenames of accessory params script
        controls_fname      = '';     % filename or cell array of filenames of controls params script
        
        driver_fname   = 'default';   % filename of drive params script or 'default'
        ambient_fname  = 'default';   % filename of ambient params script or 'default'
        
        preprocess_fname    = '';     % filename or cell array of filenames of preprocessing scripts to run after loading params and before running the simulation
    end
    
    methods
        function load( obj, ws)
            if nargin < 2
                ws = 'caller';
            end
            
            % engine
            [~,NAME] = fileparts(strrep(obj.engine_fname,'"',''));
            if ~isempty(NAME)
                if ischar( obj.engine_fname )
                    evalin(ws,['run(''',strrep(obj.engine_fname,'"',''),''');']);
                elseif iscell( obj.engine_fname )
                    for p = 1:numel( obj.engine_fname )
                        evalin(ws,['run(''',strrep(obj.engine_fname{p},'"',''),''');']);
                    end
                end
            end
            
            % transmission
            [~,NAME] = fileparts(strrep(obj.transmission_fname,'"',''));
            if ~isempty(NAME)
                if ischar( obj.transmission_fname )
                    evalin(ws,['run(''',strrep(obj.transmission_fname,'"',''),''');']);
                elseif iscell( obj.transmission_fname )
                    for p = 1:numel( obj.transmission_fname )
                        evalin(ws,['run(''',strrep(obj.transmission_fname{p},'"',''),''');']);
                    end
                end
            end
            
            % vehicle
            [~,NAME] = fileparts(strrep(obj.vehicle_fname,'"',''));
            if ~isempty(NAME)
                if ischar( obj.vehicle_fname )
                    evalin(ws,['run(''',strrep(obj.vehicle_fname,'"',''),''');']);
                elseif iscell( obj.vehicle_fname )
                    for p = 1:numel( obj.vehicle_fname )
                        evalin(ws,['run(''',strrep(obj.vehicle_fname{p},'"',''),''');']);
                    end
                end
            end
            
            % electric            
            if ~isempty(obj.electric_fname)
                [~,NAME] = fileparts(strrep(obj.electric_fname,'"',''));
            else
                NAME = '';
            end            
            if ~isempty(NAME)
                if ischar( obj.electric_fname )
                    evalin(ws,['run(''',strrep(obj.electric_fname,'"',''),''');']);
                elseif iscell( obj.electric_fname )
                    for p = 1:numel( obj.electric_fname )
                        evalin(ws,['run(''',strrep(obj.electric_fname{p},'"',''),''');']);
                    end
                end
            end
            
            % accessory
            if ~isempty(obj.accessory_fname)
                [~,NAME] = fileparts(strrep(obj.accessory_fname,'"',''));
            else
                NAME = '';
            end
            if ~isempty(NAME)
                if ischar( obj.accessory_fname )
                    evalin(ws,['run(''',strrep(obj.accessory_fname,'"',''),''');']);
                elseif iscell( obj.accessory_fname )
                    for p = 1:numel( obj.accessory_fname )
                        evalin(ws,['run(''',strrep(obj.accessory_fname{p},'"',''),''');']);
                    end
                end
            end
            
            % controls
            [~,NAME] = fileparts(strrep(obj.controls_fname,'"',''));
            if ~isempty(NAME)
                if ischar( obj.controls_fname )
                    evalin(ws,['run(''',strrep(obj.controls_fname,'"',''),''');']);
                elseif iscell( obj.controls_fname )
                    for p = 1:numel( obj.controls_fname )
                        evalin(ws,['run(''',strrep(obj.controls_fname{p},'"',''),''');']);
                    end
                end
            end
            
            % driver
            if ~isempty(obj.driver_fname)
                [~,NAME] = fileparts(strrep(obj.driver_fname,'"',''));
            else
                NAME = '';
            end
            if strcmpi(obj.driver_fname,'default') || isempty(NAME)
                assignin(ws,'driver', class_REVS_driver);
            elseif ischar( obj.driver_fname )
                evalin(ws,['run(''',strrep(obj.driver_fname,'"',''),''');']);
            elseif iscell( obj.driver_fname )
                for p = 1:numel( obj.driver_fname )
                    evalin(ws,['run(''',strrep(obj.driver_fname{p},'"',''),''');']);
                end
            end
            
            % ambient
            if ~isempty(obj.ambient_fname)
                [~,NAME] = fileparts(strrep(obj.ambient_fname,'"',''));
            else
                NAME = '';
            end
            if strcmpi(obj.ambient_fname,'default') || isempty(NAME)
                assignin(ws,'ambient', class_REVS_ambient);
            elseif ischar( obj.ambient_fname )
                evalin(ws,['run(''',strrep(obj.ambient_fname,'"',''),''');']);
            elseif iscell( obj.ambient_fname )
                for p = 1:numel( obj.ambient_fname )
                    evalin(ws,['run(''',strrep(obj.ambient_fname{p},'"',''),''');']);
                end
            end
        end % load
        
        % ------------------------------------------------------------------------
        function run_preprocess( obj, ws)
            if nargin < 2
                ws = 'caller';
            end
            
            % preprocess
            [~,NAME] = fileparts(obj.preprocess_fname);
            if ~isempty(NAME)
                if ischar( obj.preprocess_fname )
                    evalin(ws,['run(''',obj.preprocess_fname,''');']);
                elseif iscell( obj.preprocess_fname )
                    for p = 1:numel( obj.preprocess_fname )
                        evalin(ws,['run(''',obj.preprocess_fname{p},''');']);
                    end
                end
            end
        end % run_preprocess
        
    end % methods
    
end % class
