classdef class_REVS_table_lockup
    %class_REVS_table_lockup 
    %   Torque converter lockup strategy based on tables of lock and unlock speed
      
    properties(Constant)
        type = enum_transmission_lockup_select.table_lockup;
    end
        
    
    properties
        
        lockup_speed_source = enum_speed_source.engine_speed_rpm;   % Speed source to compare to lock and unlock tables [enum_speed_source]
        lockup_load_source = enum_load_source.driver_acl_pct;       % Load source to index lock and unlock tables [enum_load_source]

        lock_map_load;      % Lockup table load axis - in units of load source
        lock_map_speed;     % Lockup speed table - in units of selected speed source

        unlock_map_load;    % Unlock table load axis - in units of load source
        unlock_map_speed;   % Unlock speed table - in units of selected speed source
    

        lockup_delay_secs = 0.5;    % Lockup Transition delay for hysteresis [seconds]
        lockup_allowed = true;      % Global lockup enable/disable [bool]
    end
    
    methods
        
    end
    
end

