classdef enum_transmission_type < Simulink.IntEnumType
    enumeration
        none(0)
        automatic(1)
        automatic_3state(2)
        manual(3)
        AMT(4)
        DCT(5)
        CVT(6)
    end
    
     methods
        % overloading mat2str allows us to store enums in database without
        % special treatment
        function [str] = mat2str(obj)
			class_str = class(obj);
 			[enums,strs] = enumeration(class_str);
			idx = (enums == obj);
			str = [class_str,'.',strs{idx}];
        end   
     end
end
