function [ ] = REVS_DOR_accessories( test_data, model_data, varargin )
% function [ ] = REVS_DOR_accessories( test_data, model_data )
%   creates an accessory DOR.
%   test_data can be a cell array of class_test_data objects or a single
%   class_test_data object.
%   model_data is intended to be a class_test_data object of model data
%   but could also be any singular class_test_data object.
%
% varargs:
% data_descriptor     = parse_varargs(varargin,'descriptor','','string');
% time_range          = parse_varargs(varargin,'time_range',[]);
% accessory_plots     = parse_varargs(varargin,'accessory_plots',false,'toggle');

data_descriptor     = parse_varargs(varargin,'descriptor','','string');
time_range          = parse_varargs(varargin,'time_range',[]);
accessory_plots     = parse_varargs(varargin,'accessory_plots',false,'toggle');

if isempty(time_range)
    model_pts = [];
    time_range = [model_data.time(1) model_data.time(end)];
else
    model_pts = (model_data.time >= time_range(1)) & (model_data.time <= time_range(end));
end

if ~iscell(test_data)
    test_data = {test_data};
end

if accessory_plots
    
    DOR_time_plot(test_data, model_data, data_descriptor, 'accessory.alternator_electrical_kW', 'Alternator Electrical Power', 'model_pts', model_pts);
    DOR_time_plot(test_data, model_data, data_descriptor, 'accessory.alternator_mechanical_kW', 'Alternator Mechanical Power', 'model_pts', model_pts);    
    DOR_time_plot(test_data, model_data, data_descriptor, 'accessory.alternator_A',             'Alternator Current', 'model_pts', model_pts);

    DOR_time_plot(test_data, model_data, data_descriptor, 'accessory.battery.terminal_voltage_V',   'Accessory Battery Voltage', 'model_pts', model_pts);
    DOR_time_plot(test_data, model_data, data_descriptor, 'accessory.battery.terminal_current_A',   'Accessory Battery Current', 'model_pts', model_pts);
    DOR_time_plot(test_data, model_data, data_descriptor, 'accessory.battery.terminal_power_kW',    'Accessory Battery Power', 'model_pts', model_pts);
    DOR_time_plot(test_data, model_data, data_descriptor, 'accessory.battery.state_of_charge_norm', 'Accessory Battery SoC', 'model_pts', model_pts, 'ylim', [0 1]);

    %%    
    DOR_time_plot(test_data, model_data, data_descriptor, 'accessory.DCDC_input_V',     'DCDC input V', 'model_pts', model_pts);
    DOR_time_plot(test_data, model_data, data_descriptor, 'accessory.DCDC_input_A',     'DCDC input A', 'model_pts', model_pts);
    DOR_time_plot(test_data, model_data, data_descriptor, 'accessory.DCDC_input_kW',    'DCDC input kW', 'model_pts', model_pts);
    
    DOR_time_plot(test_data, model_data, data_descriptor, 'accessory.DCDC_output_V',    'DCDC output V', 'model_pts', model_pts);
    DOR_time_plot(test_data, model_data, data_descriptor, 'accessory.DCDC_output_A',    'DCDC output A', 'model_pts', model_pts);
    DOR_time_plot(test_data, model_data, data_descriptor, 'accessory.DCDC_output_kW',   'DCDC output kW', 'model_pts', model_pts);
        
end

end
