function [ revs_data ] = REVS_HVM_renamalyzer( vehicle, engine, transmission, audit, datalog )
% function [ revs_data ] = REVS_CVM_renamalyzer( audit, datalog )
%   stores raw model outputs in REVS class_test_data for comparison with test
%   data in the same format, for example

revs_data = REVS_VM_vehicle_renamalyzer(vehicle, audit, datalog);

revs_data = REVS_VM_engine_renamalyzer(revs_data, vehicle, engine, audit, datalog);

revs_data = REVS_VM_transmission_renamalyzer(revs_data, transmission, audit, datalog);

% revs_data.accessory.alternator_A                    = audit.elec.alternator.input_Amps;
% revs_data.accessory.alternator_V                    = audit.elec.alternator.input_Volts;
% revs_data.accessory.alternator_electrical_kW        = audit.elec.alternator.input_kW;
% revs_data.accessory.alternator_speed_radps          = audit.mech.alternator.output_radps;
% revs_data.accessory.alternator_torque_Nm            = audit.mech.alternator.output_Nm;
% revs_data.accessory.alternator_mechanical_kW        = audit.mech.alternator.output_kW;
% 
% revs_data.accessory.battery.terminal_current_A      = audit.elec.battery_Amps;
% revs_data.accessory.battery.terminal_voltage_V      = audit.elec.battery_Volts;
% revs_data.accessory.battery.terminal_power_kW       = audit.elec.battery_kW;
% revs_data.accessory.battery.state_of_charge_norm    = datalog.battery.SoC_norm;
% 
% revs_data.accessory.torque_Nm                       = audit.mech.accessories.total_Nm;
% revs_data.accessory.speed_radps                     = audit.mech.accessories.total_radps;
% revs_data.accessory.mechanical_kW                   = audit.mech.accessories.total_kW;

revs_data.propulsion_battery.terminal_current_A     = audit.elec.propulsion_battery_Amps;
revs_data.propulsion_battery.terminal_voltage_V     = audit.elec.propulsion_battery_Volts;
revs_data.propulsion_battery.terminal_power_kW      = audit.elec.propulsion_battery_kW;
revs_data.propulsion_battery.state_of_charge_norm   = datalog.propulsion_battery.SoC_norm;

revs_data.emachine.speed_radps  = audit.mech.drive_motor.output_radps;
revs_data.emachine.torque_Nm    = audit.mech.drive_motor.output_Nm;
revs_data.emachine.current_A    = audit.elec.drive_motor.input_Amps;
revs_data.emachine.voltage_V    = audit.elec.drive_motor.input_Volts;

revs_data.accessory.DCDC_input_A    = audit.elec.low_voltage_DCDC.input_Amps;
revs_data.accessory.DCDC_input_V    = audit.elec.low_voltage_DCDC.input_Volts;
revs_data.accessory.DCDC_output_A   = audit.elec.low_voltage_DCDC.output_Amps;
revs_data.accessory.DCDC_output_V   = audit.elec.low_voltage_DCDC.output_Volts;

end
