function [ revs_data ] = REVS_VM_vehicle_renamalyzer( vehicle, audit, datalog )

% load vehicle data common to all vehicles
revs_data = class_test_data(datalog.time);

revs_data.vehicle.mass_static_kg            = vehicle.mass_static_kg;
revs_data.vehicle.mass_dynamic_kg           = vehicle.mass_dynamic_kg;

if isprop(revs_data.vehicle,'coastdown_target_A_N')
    revs_data.vehicle.coastdown_target_A_N             = vehicle.coastdown_target_A_N;
    revs_data.vehicle.coastdown_target_B_Npms          = vehicle.coastdown_target_B_Npms;
    revs_data.vehicle.coastdown_target_C_Npms2         = vehicle.coastdown_target_C_Npms2;
end

revs_data.vehicle.tire_rolling_radius_m     = vehicle.drive_axle1.tire.radius_m;
revs_data.vehicle.accel_pedal_norm          = datalog.driver.accel_norm;
revs_data.vehicle.brake_pedal_norm          = datalog.driver.brake_norm;
revs_data.vehicle.drive_cycle_speed_mps     = datalog.drive_cycle_speed_mps;
revs_data.vehicle.drive_cycle_phase         = datalog.drive_cycle_phase;
revs_data.vehicle.drive_cycle_time          = datalog.time;
revs_data.vehicle.dyno_speed_mps            = audit.mech.vehicle.output_mps;
revs_data.vehicle.dyno_distance_m           = audit.mech.vehicle.output_m;
revs_data.vehicle.dyno_tractive_force_N     = audit.mech.vehicle.input_N;

revs_data.vehicle.final_drive_ratio         = vehicle.drive_axle1.final_drive.gear_ratio;
revs_data.vehicle.speed_mps                 = audit.mech.vehicle.output_mps; % was audit.mech.drive_axle1.tire.input_radps * revs_data.vehicle.tire_rolling_radius_m;
revs_data.vehicle.wheel_torque_Nm           = audit.mech.drive_axle1.tire.input_Nm;
revs_data.vehicle.halfshaft_torque_Nm       = audit.mech.drive_axle1.tire.input_Nm;

end
