function [ spd_radps ] = REVS_calc_engine_torque_speed( e, torque_norm, mode )
% [ spd_radps ] = REVS_calc_engine_torque_speed( e, torque_norm, mode )
%       e = engine structure
%       torque_norm = fraction of max torque to determine the speed(s) of
%       mode = optional 'min' or 'max'

hires_speeds_radps = 0:0.1:e.full_throttle_speed_radps(end);
hires_torque_Nm = interp1(e.full_throttle_speed_radps, e.full_throttle_torque_Nm, hires_speeds_radps);

[max_torque_Nm, max_torque_idx] = max(hires_torque_Nm); 

idx = find( hires_torque_Nm >= max_torque_Nm .* torque_norm);

if nargin <= 2
    % Highest and Lowest speeds that meet target engine torque
	idx = [idx(1), idx(end)];	
elseif strcmp(mode , 'min' )
	% Lowest speed that meets target engine torque
	idx = idx(1);
elseif strcmp(mode , 'max' )
	% Highest speed that meets target engine torque
	idx = idx(end);
end

spd_radps = hires_speeds_radps(idx);
	
end
