function [ LEGH ] = add_legend( legend_string, varargin )
% function [ LEGH ] = add_legend( legend_string )
%   adds legend_string to the current legend, if a legend does not exist
%   it is created.  Returns legend handle LEGH.
%   Supports normal legend varargs

LEGH = legend;
if isempty(LEGH) || isempty(LEGH.String) || isequal(LEGH.String{1},'')
    LEGH = legend(legend_string, varargin{:} );  % first legend string
else
    LEGH = legend({LEGH.String{:},legend_string}, varargin{:} ); % subsequent strings
end

set(LEGH,'Interpreter','none');

end

