function [lineseries] = fplothg(varargin)

figure;

lineseries = superplot(varargin{:});

hold on

grid on

% Autolabeling
if length(lineseries) == 1 && isnumeric(varargin{1}) && isnumeric(varargin{2})
	% Single line x vs y
	
	xlabel(inputname(1),'Interpreter','none');
	ylabel(inputname(2),'Interpreter','none');
	
elseif length(lineseries) == 1 && isnumeric(varargin{1})
	% Single line y vs ticks
	
	ylabel(inputname(1),'Interpreter','none');
	xlabel('ticks')
	
else
	% Multiline
	
	if isnumeric(varargin{1}) && isnumeric(varargin{2})
		x_name = inputname(1);
	else
		x_name = 'ticks';
	end
	
	l = 1;	
	legend_str = {};
	while l < length(varargin)
	
		if isnumeric(varargin{l}) &&  isnumeric(varargin{l+1})
			legend_str{end+1} = inputname(l+1);
			if ~strcmp( x_name, inputname(l) )
				x_name = '';
			end
			l = l+2;
		elseif 	isnumeric(varargin{l})
			legend_str{end+1} = inputname(l);
			if ~strcmp( x_name, 'ticks' )
				x_name = '';
			end
			l = l+1;
		else
			l = l+1;
		end
		
	end
	
	legend(legend_str,'Interpreter','none');
	xlabel(x_name,'Interpreter','none');
	
end


end




% 
% x_size = size(x);
% 
% if (isempty(varargin))
%     if x_size(2) > 1
%         lineseries = plot(x(:,1),x(:,2), '.-');
%     else
%         lineseries = plot(x, '.-');
%     end
% 
% elseif ~ischar(varargin{1}) && (length(varargin) < 2)
%     lineseries = plot(x, varargin{1}, '.-');
% else
%     lineseries = plot(x, varargin{:});
% end
% %autoplotlabeler;
% 
%         if (isempty(varargin) || (length(varargin) == 1 && ischar(varargin{1}))) && ~isequal(inputname(1),'')
%             ylabel(inputname(1),'Interpreter','none');
%             xlabel('ticks')
%             title(strcat([inputname(1) ' v. ticks ' date]),'Interpreter','none');
%         elseif (length(varargin) >= 1) && ~isequal(inputname(1),'') && ~isequal(inputname(2),'')
%             xlabel(inputname(1),'Interpreter','none');
%             ylabel(inputname(2),'Interpreter','none');
%             title(strcat([inputname(2) ' v. ' inputname(1) ' ' date]),'Interpreter','none');
%         end
% 
% 
% [legend_h,object_h,plot_h,text_strings] = legend;
% if (isempty(varargin) || ischar(varargin{1}))
%     legend_h = legend([text_strings, inputname(1)]);
% else
%     legend_h = legend([text_strings, inputname(2)]);
% end
% set(legend_h,'Interpreter','none');
% 
% if (ishold==0) hold on; end
% grid on;
% 
% %set(gcf, 'Renderer', 'painters');
