
%% result post-processing


clear result;

% get audit vars
result_vars = who('result__*');


if REVS.powertrain_type.is_conventional
	result = class_REVS_CVM_result(drive_cycle, engine.fuel, vehicle.fuel) ;
elseif REVS.powertrain_type.is_hybrid
	result = class_REVS_HVM_result(drive_cycle, engine.fuel, vehicle.fuel) ;
elseif REVS.powertrain_type.is_bev
    result = class_REVS_EVM_result(drive_cycle);
else
	result = struct;
	warning('Unknown powertrain type "%s" storing results to a structure',REVS.model_architecture)
end

result_fields = properties(result);

% Move individual variables into audit structure
for i = 1:length(result_vars)
    	
	if isstruct(result) || ismember(result_vars{i}(9:end), result_fields)  

        % eval new var into struct
        eval([strrep(result_vars{i}, 'result__', 'result.') ' = ' result_vars{i} ';']);
    
	else
		warning('Result class %s does not have a field "%s" simulation data ignored', class(result), result_vars{i}(9:end));		
	end
end

% cleanup

clear result__*;
clear result_vars;
clear result_fields;
clear i;


