% Other processing

if  REVS.powertrain_type.is_conventional
    if exist('audit','var') && exist('datalog','var') && (REVS.verbose > 0)
        model_data = REVS_CVM_renamalyzer( vehicle, engine, transmission, audit, datalog );
    end
elseif REVS.powertrain_type.is_bev
    if exist('audit','var') && exist('datalog','var') && (REVS.verbose > 0)
        
        if transmission.type == enum_transmission_type.no_transmission
            model_data = REVS_EVM_renamalyzer( vehicle, [], audit, datalog );
        else
            model_data = REVS_EVM_renamalyzer( vehicle, transmission, audit, datalog );
        end
        
    end
elseif REVS.powertrain_type.is_hybrid
    model_data = REVS_HVM_renamalyzer( vehicle, engine, transmission, audit, datalog );
end

%% common postproc, all architectures

if ~REVS.verbose % create minimal model_data set, else model_data already created above
    % just pull in enough data for J2951 stats:
    model_data                                  = class_test_data(datalog.time);
    model_data.vehicle.mass_static_kg           = vehicle.mass_static_kg;
    model_data.vehicle.coastdown_target_A_N            = vehicle.coastdown_target_A_N;
    model_data.vehicle.coastdown_target_B_Npms         = vehicle.coastdown_target_B_Npms;
    model_data.vehicle.coastdown_target_C_Npms2        = vehicle.coastdown_target_C_Npms2;
    model_data.vehicle.drive_cycle_phase        = datalog.drive_cycle_phase;
    model_data.vehicle.drive_cycle_speed_mps    = datalog.drive_cycle_speed_mps;
    model_data.vehicle.speed_mps                = datalog.vehicle.speed_mps;
    
    % for idle data in matrix output...
    model_data.engine.speed_rpm                 = datalog.engine.crankshaft_speed_radps * convert.radps2rpm;
    model_data.engine.gross_torque_Nm           = datalog.engine.crankshaft_gross_torque_Nm;
    model_data.engine.gross_power_kW            = datalog.engine.crankshaft_speed_radps .* datalog.engine.crankshaft_gross_torque_Nm / 1000;
    model_data.engine.fuel.flow_rate_gps        = datalog.engine.fuel_rate_gps;
    model_data.engine.fuel.energy_density_MJpkg = engine.fuel.energy_density_MJpkg;
    model_data.vehicle.fuel.energy_density_MJpkg = vehicle.fuel.energy_density_MJpkg;
end

if exist('model_data')
    if isfield(REVS,'output_fid')
        result.drive_quality = REVS_SAEJ2951(model_data, 'verbose', REVS.verbose, 'output_fid', REVS.output_fid);
    else
        result.drive_quality = REVS_SAEJ2951(model_data, 'verbose', REVS.verbose);
    end
end

if REVS.verbose > 0
    if isfield(REVS,'output_fid')
        result.print(REVS.output_fid);
    else
        result.print;
    end
end
