      PROGRAM O3MAX3Q2
C...PROGRAM TO FIND MAX-3 O3/NO2 CONCENTRATIONS BY SEASON AND HOUR OF DAY
C...  RUN WITH O3FIL.ASC formatted file (FOR BACKGROUND NO2 W/ AERMOD)
C...FILES MUST BE ARRANGED DEC,JAN,FEB...SEP,OCT,NOV (WITH ONE YEAR OF DATA)
C...  BECAUSE OF USEPA/CAPCOA REQUIREMENTS OF WINTER NOT BROKEN APART
C...  I.E., ONE CONTINGUOUS 3-MONTH PERIOD SPANNING THE NEW YEAR
C
      DIMENSION XMAX(4,24,3),IDATE(4,24,3),ICNT(4,24)
      DIMENSION JM(12),JS(12)
      DATA JM/31,28,31,30,31,30,31,31,30,31,30,31/
      DATA JS/ 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 1/
C
      OPEN(1,STATUS='OLD',FILE='no2fil.asc')
C
      READ(1,1) IY
      IY=IY+1
      BACKSPACE(1)
      IF(4.0*FLOAT(INT(FLOAT(IY)/4.0)).EQ.FLOAT(IY)) JM(2)=29
C
      DO 10 II=1,12
      I=II-1
      IF(I.EQ.0) I=12
      IS=JS(I)
      DO 10 J=1,JM(I)
      DO 10 K=1,24
      READ(1,1,END=9) IY,IM,ID,IH,OZONE
    1 FORMAT(4i2.2,f8.3)
      IF(IH.NE.K) GOTO 91 
      IF(ID.NE.J) GOTO 92
      IF(IM.NE.I) GOTO 93
      IF(ABS(OZONE).GE.900.0)    GOTO 10
      IF(    OZONE .LT.  0.0)    GOTO 10
                           ICNT(IS,IH)=ICNT(IS,IH)+1
C...CONVERT PPB TO UG/M3
                           OZONE=OZONE*40.9*46/1000
C     IF(OZONE.LE.XMAX(IS,IH,3)) GOTO 10
                           JDATE=IY*1000000+IM*10000+ID*100+IH
      NN=0
      DO 5 N=1,3
      NN=NN+1
      IF(OZONE.GT.XMAX(IS,IH,N)) GOTO 6
    5 CONTINUE
      GOTO 10
    6 IF(NN.EQ.3) GOTO 8
      DO 7 N=3,NN+1,-1
         XMAX(IS,IH,N) = XMAX(IS,IH,N-1)
    7   IDATE(IS,IH,N) =IDATE(IS,IH,N-1)
    8    XMAX(IS,IH,NN)=OZONE
        IDATE(IS,IH,NN)=JDATE
   10 CONTINUE
C
    9 CLOSE(1)
      OPEN(2,STATUS='NEW',FILE='no2fil.out')
      DO 15 IH=1,24
      WRITE(2,12) IH,(XMAX(IS,IH,1),IDATE(IS,IH,1),IS=1,4),
     +               (XMAX(IS,IH,2),IDATE(IS,IH,2),IS=1,4),
     +               (XMAX(IS,IH,3),IDATE(IS,IH,3),IS=1,4),
     +               (ICNT(IS,IH),                 IS=1,4)
   12 FORMAT(/1X,I2.2,4(F8.3,I9.8)/,3X,4(F8.3,I9.8)/,
     +             3X,4(F8.3,I9.8)/,3X,4(I8.2,9X))
   15 CONTINUE
      CLOSE(2)
      STOP
   90 FORMAT(1X,4I2.2,5X,F8.3)
   91 WRITE(6,90) IY,IM,ID,IH,OZONE
      STOP 'PROBLEM WITH HOURS'
   92 WRITE(6,90) IY,IM,ID,IH,OZONE
      STOP 'PROBLEM WITH DAYS OF MONTH'
   93 WRITE(6,90) IY,IM,ID,IH,OZONE
      STOP 'PROBLEM WITH MONTH'
      END
