 $(function () {
        Highcharts.setOptions({
          lang: {
            thousandsSep: ','
          },
          colors: ["#7cb5ec", "#f7a35c", "#90ee7e", "#7798BF", "#aaeeee", "#ff0066", "#eeaaee",
    "#55BF3B", "#DF5353", "#7798BF", "#aaeeee"]
        });
      });

      /**
       * Visualize an HTML table using Highcharts. The top (horizontal) header 
       * is used for series names, and the left (vertical) header is used 
       * for category names. This function is based on jQuery.
       * @param {Object} table The reference to the HTML table to visualize
       * @param {Object} options Highcharts options
       */

      Highcharts.visualize = function(table, options) {
        
        //Convert scientific notation values to num (outside this round function toFixed converts back to string)
        Number.prototype.round = function(p) {
          p = p || 10;
          return parseFloat( this.toFixed(p) );
        };

        //the slices
        var sliceNames = [];
        $('tbody th', table).each(function (i) { 
          sliceNames.push(this.innerHTML);
        });

        // the data series from new datatable
        options.series = [];
        $('thead tr, tbody tr', table).each( function(i) {
          var tr = this;
          $('th, td', tr).each( function(j) {

          if (j > 0) { //skip first column
              if (i == 0) { // get the name and init the series
                options.series[j - 1] = { 
                  name: this.innerHTML,
                  data: [],
                  center: [],
                  showInLegend: true,
                  title: {
                    verticalAlign: 'top',
                    y: -40
                  }
                };
              } else { // add values
                var a = this.innerHTML;
                //handle empty values, set to zero
                  if(a.replace(/\s/g,"") == ""){
                    a = 0;
                    var b = 0;
                    var c = 0;
                  }
                  else {
                    var b = parseFloat(a);
                    var c = b.round(20);
                  }
                  //console.log(c);

                //build data object
                options.series[j - 1].data.push({name: sliceNames[i- 1], y: c});
            }
          }
    
          });
        });

        //filter series for each
        if ($('#energy').is(':visible')) {
          options.series = options.series.slice(0,1); 
          var chart = new Highcharts.Chart(options);
        }
        if ($('#cost').is(':visible')) {
          options.series = options.series.slice(8,9); 
          var chart = new Highcharts.Chart(options);
        }
        if ($('#mass-based').is(':visible')) {
          options.series = options.series.slice(1,8);
          //position multiple pies
          options.series[0].center.push('15%','25%');
          options.series[1].center.push('40%','25%');
          options.series[2].center.push('65%','25%');
          options.series[3].center.push('90%','25%');
          options.series[4].center.push('15%','85%');
          options.series[5].center.push('40%','85%');
          options.series[6].center.push('65%','85%');
          //set chart titles
          options.series[0].title.text = '<b>Primary material (kg)</b>';
          options.series[1].title.text = '<b>GHG emission (kg of CE)</b>';
          options.series[2].title.text = '<b>Air emission (kg)</b>';
          options.series[3].title.text = '<b>Water emission (kg)</b>';
          options.series[4].title.text = '<b>Toxic material (kg)</b>';
          options.series[5].title.text = '<b>Municipal solid waste (kg)</b>';
          options.series[6].title.text = '<b>Hazardous waste (kg)</b>';
          //remove repeating legends
          options.series[1].showInLegend = false;
          options.series[2].showInLegend = false;
          options.series[3].showInLegend = false;
          options.series[4].showInLegend = false;
          options.series[5].showInLegend = false;
          options.series[6].showInLegend = false;
          //functionality for multiple chart legend
          var chart = new Highcharts.Chart(options);
          $(chart.series[0].data).each(function(i, e) {
            e.legendItem.on('click', function(event) {
                var legendItem=e.name;
                event.stopPropagation();
                $(chart.series).each(function(j,f){
                  $(this.data).each(function(k,z){
                    if(z.name==legendItem) {
                      if(z.visible) {
                        z.setVisible(false);
                      }
                      else {
                        z.setVisible(true);
                      }
                    }
                });
            });    
          });
        });
      }

      //for pies with all 0 values add outline
      Highcharts.wrap(Highcharts.seriesTypes.pie.prototype, 'render', function (proceed) {
      proceed.call(this);
    
      if (!this.circle) {
        this.circle = this.chart.renderer.circle(0, 0, 0).add(this.group);
      }
      if (this.total === 0) {
        this.circle.attr({
          cx: this.center[0],
          cy: this.center[1],
          r: this.center[2] / 2,
          fill: 'none',
          stroke: 'silver',
          'stroke-width': 1
        });
      } else {
        this.circle.attr({
            'stroke-width': 0
        });
      }
      });

    } //end visualize function



      $(document).ready(function() { 

        var table = document.getElementById('summaryData');
        
        //chart options 1  
        options = {
             chart: {
                renderTo: 'mass-based',
                type: 'pie',
             },
             title: {
                text: 'Mass-based Savings Summary'
             },
            xAxis: {},
            yAxis: {
                title: {
                   text: 'kg'
                },
                labels: {
                    format: '{value:,.0f}'
                }
             },
             tooltip: {
                formatter: function() {
                   //return '<b>'+ this.series.name +'</b><br/>'+
                      //this.y.toExponential(2) +' '+ this.x;
                      //this.y +' '+ this.x; //.toLowerCase();
                      return '<b>'+ this.series.name +'</b><br/>'+
                      this.y.toExponential(2) +' '+ this.point.name;
                }
             },
            plotOptions: {
             pie: {
                allowPointSelect: true,
                cursor: 'pointer',
                size: 100,
                dataLabels: {
                    enabled: true,
                    style: {
                        fontWeight: 'normal'
                    },
                    connectorPadding: 2,
                    distance: 10,
                    formatter: function () {
                        //return '<b>' + this.point.name + '</b>: ' + this.percentage + ' %';
                        return this.y.toExponential(2);
                    }
                }//,
                //showInLegend: true
              }
            },
            exporting: {
            sourceWidth: 900,
            buttons: {
                contextButton: {
                    y:8,
                    text: 'Download'
                }
            }
          },
            credits: {
              enabled: false
            }
          };


         //chart options 2 
         options2 = {
             chart: {
                renderTo: 'energy',
                type: 'pie'
             },
             title: {
                text: 'Energy Savings Summary'
             },
             xAxis: {},
             yAxis: {
                title: {
                   text: 'KWh eq'
                },
                labels: {
                    format: '{value:,.0f}'
                }
             },
             tooltip: {
                formatter: function() {
                   //return '<b>'+ this.series.name +'</b><br/>'+
                      //this.y.toExponential(2) +' '+ this.x;
                      //this.y +' '+ this.x; //.toLowerCase();
                    return '<b>'+ this.series.name +'</b><br/>'+
                      this.y.toExponential(2) +' '+ this.point.name;
                }
             },
            plotOptions: {
             pie: {
                allowPointSelect: true,
                cursor: 'pointer',
                dataLabels: {
                    enabled: true,
                    style: {
                        fontWeight: 'normal'
                    },
                    connectorPadding: 2,
                    distance: 10,
                    formatter: function () {
                        //return '<b>' + this.point.name + '</b>: ' + this.percentage + ' %';
                        return this.y.toExponential(2); //.toExponential(2);
                    }
                },
                showInLegend: true
              }
            },
            exporting: {
            sourceWidth: 900,
            buttons: {
                contextButton: {
                    y:8,
                    text: 'Download'
                }
            }
            },
            credits: {
              enabled: false
            }
          };

          //chart options 3
          options3 = {
             chart: {
                renderTo: 'cost',
                type: 'pie'
             },
             title: {
                text: 'Cost Savings Summary'
             },
             xAxis: {},
             yAxis: {
                title: {
                   text: ' '
                },
                labels: {
                    format: '$ {value:,.0f}'
                }
             },
             tooltip: {
                formatter: function() {
                   //return '<b>'+ this.series.name +'</b><br/>'+
                      ////this.y.toExponential(2) +' '+ this.x;
                      //this.y +' '+ this.x;//.toLowerCase();
                      return '<b>'+ this.series.name +'</b><br/>'+
                      //this.y.toExponential(2) +' '+ this.point.name;
                      '$' + commaSeparateNumber(this.y) +' '+ this.point.name;
                }
             },
            plotOptions: {
             pie: {
                allowPointSelect: true,
                cursor: 'pointer',
                dataLabels: {
                    enabled: true,
                    style: {
                        fontWeight: 'normal'
                    },
                    connectorPadding: 2,
                    distance: 10,
                    formatter: function () {
                        //return '<b>' + this.point.name + '</b>: ' + this.percentage + ' %';
                        return '$' + commaSeparateNumber(this.y.toFixed(2));
                    }
                },
                showInLegend: true
              }
            },
            exporting: {
            sourceWidth: 900,
            buttons: {
                contextButton: {
                    y:8,
                    text: 'Download'
                }
            }
            },
            credits: {
              enabled: false
            }
          };


  //get data for summary datatable
    var items = [];

    //from use and end of life table (add unique ID useTable to original table)
      $('#useTable tr').each( function(i) {
        if (i == 5 || i == 16) { //the rows of data we want - change if these change
          var newTr = $(this).clone();
          items.push(newTr);
          newTr.appendTo($("#summaryData"));
        }
      });
      //from all product table (add unique ID allProductsTable to original table)
      $('#allProductTable tr').each( function(i) {
        if (i == 26) { //the rows of data we want - change if these change
          var newTr = $(this).clone();
          items.push(newTr);
          newTr.appendTo($("#summaryData"));
        }
      }); 
  
   
    //select charts and visualize
     $('select#charts').on('change', function() {
        var $toggled = "#" + $(this).val();
        if (this.value == 'mass-based') {
          $($toggled).toggle();
          $('#instruction').show();
          $($toggled).siblings(':visible').hide();
          Highcharts.visualize(table, options);
        }
        else if (this.value == 'energy') {
          $($toggled).toggle();
          $('#instruction').show();
          $($toggled).siblings(':visible').hide();
          Highcharts.visualize(table, options2);
        }
        else if (this.value == 'cost') {
          $($toggled).toggle();
          $('#instruction').show();
          $($toggled).siblings(':visible').hide();
          Highcharts.visualize(table, options3);
        }
        else {
          $('#mass-based,#energy,#cost,#instruction').hide();
        }   
      }); 

    $('#eqTableToggle').click(function(e){
       e.preventDefault();
        $('#eqTable').toggle();
      });

    $('#referencesPopup').dialog({
        autoOpen:false,
        width: '75%'
    });

    $('a.references').click(function(e) {
      e.preventDefault();
      $('#referencesPopup').dialog('open');
    });    

    $("#accordion").accordion({ 
        header: "h3", 
        collapsible: true, 
        active: false, 
        heightStyle: "content", 
        autoHeight: false,
        clearStyle: true  
    });

  //initialize summaryData dataTable 
  $('#summaryData').DataTable({
    "searching": false,
    "paging": false,
    "info": false,
    "ordering": false,
    "bAutoWidth": false,
    "footerCallback": function(row, data, start, end, display) {
    var api = this.api();
    api.columns('.sum', {
      page: 'current'
    }).every(function() {
    var sum = this
      .data()
      .reduce(function(a, b) {
        var x = parseFloat(a) || 0;
        var y = parseFloat(b) || 0;
        return x + y;
      }, 0);
      //convert num to exponential
      sum = sum.toExponential(2);
        $(this.footer()).html(sum);
      });
    },
    dom: 'Bfrtip',
        buttons: [
          { 
            extend: 'print',
            footer: true
          },
          {
            extend: 'excel',
            footer: true
          }
          ]
  }); 

    //dataTable equivalencyData 
    $('table#summaryData tfoot > tr th').not(':first').each(function(i) {
      //convert exponentials to numbers
      var num = Number($(this).text());
      var num2 = Number($(this).text());
      //console.log(num);

      if (i == 0) {
        num = (num / 12183).toFixed(2);
        if (num < 0.01 ) {
          num = '< 0.01';
        }
        $('td.energy').html('electricity to power '+commaSeparateNumber(num)+ ' US household(s) for a year');
      }
      if (i == 1) {
        num = (num / 331065759).toFixed(2);
        num2 = (num2 / 36281).toFixed(2);
        if (num < 0.01) {
          num = '< 0.01';
        }
        if (num2 < 0.01) {
          num2 = '< 0.01';
        }
        $('td.primary').html('the weight of '+commaSeparateNumber(num)+ ' Empire State Buildings <br>the weight of ' + commaSeparateNumber(num2)+ ' 18-wheelers (tractor-trailers)');
      }
      if (i == 2) {
        num = (num / 1290).toFixed(2);
        if (num < 0.01 ) {
          num = '< 0.01';
        }
        $('td.ghg').html('removing '+commaSeparateNumber(num)+ ' passenger car(s) from the road per year');
      }
      if (i == 3) {
        num = (num / 1000).toFixed(2);
        if (num < 0.01 ) {
          num = '< 0.01';
        }
        $('td.air').html(commaSeparateNumber(num)+ ' metric ton(s) of air emissions');
      }
      if (i == 4) {
        num = (num / 1000).toFixed(2);
        if (num < 0.01 ) {
          num = '< 0.01';
        }
        $('td.water').html(commaSeparateNumber(num)+ ' metric ton(s) of water emissions');
      }
      if (i == 5) {
        num = (num / 5200).toFixed(2);
        num2 = (num2 / 2.3).toFixed(2);
        if (num < 0.01) {
          num = '< 0.01';
        }
        if (num2 < 0.01) {
          num2 = '< 0.01';
        }
        $('td.toxic').html('the weight of '+commaSeparateNumber(num)+ ' elephants <br>the weight of ' + commaSeparateNumber(num2)+ ' bricks');
      }
      if (i == 6) {
        num = (num / 1860).toFixed(2);
        if (num < 0.01 ) {
          num = '< 0.01';
        }
        $('td.municipal').html('solid waste generated by '+commaSeparateNumber(num)+ ' US household(s) in a year');
      }
      if (i == 7) {
        num = (num / 10100000).toFixed(2);
        num2 = (num2 / 121).toFixed(2);
        if (num < 0.01) {
          num = '< 0.01';
        }
        if (num2 < 0.01) {
          num2 = '< 0.01';
        }
        $('td.hazardous').html('the weight of '+commaSeparateNumber(num)+ ' Eiffel Towers <br>the weight of ' + commaSeparateNumber(num2)+ ' refrigerators');
      }
      if (i == 8) {
        num = num.toFixed(2);
        if (num < 0.01 ) {
          num = '< 0.01';
        }
        $('td.cost').html('$'+commaSeparateNumber(num));
      } 

    });


    //initialize references dataTable 
      $('#references, #equivalencyData').DataTable( {
        "searching": false,
        "paging": false,
        "info": false,
        "ordering": false,
        "bAutoWidth": false,
         "columnDefs": [
          { "width": "20%", "targets": 0 }
        ],
        dom: 'Bfrtip',
        buttons: [
          { 
           extend: 'print'
          },
          {
            extend: 'excel'
          }
          ]
    });


});

    function commaSeparateNumber(val){
      while (/(\d+)(\d{3})/.test(val.toString())){
        val = val.toString().replace(/(\d+)(\d{3})/, '$1'+','+'$2');
      }
      return val;
    }
