package com.saic.eebc.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;

import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

import com.saic.eebc.dto.DataCompEndOfLifeMainResultDTO;
import com.saic.eebc.dto.DataCompProductCombinedResultDTO;
import com.saic.eebc.dto.DataCompProductInterimResultDTO;
import com.saic.eebc.dto.DataCompProductMainResultDTO;
import com.saic.eebc.dto.DataCompUseDataInterimResultDTO;
import com.saic.eebc.dto.DataCompUseDataMainResultDTO;
import com.saic.eebc.dto.DataComparisonResultDTO;
import com.saic.eebc.dto.EebcProductEntryObjectDTO;
import com.saic.eebc.dto.EndOfLifeDTO;
import com.saic.eebc.dto.EnergyReuseRecycleTotalDTO;
import com.saic.eebc.dto.EnergySavingProductMainDTO;
import com.saic.eebc.dto.InputUseAndEOLDTO;
import com.saic.eebc.dto.ProductInformationDTO;
import com.saic.eebc.dto.SavingByCriteriaProductMainDTO;
import com.saic.eebc.dto.SavingProductDisplayDTO;
import com.saic.eebc.dto.SavingReportDisplayDTO;
import com.saic.eebc.dto.SavingReportDisplayDTO;
import com.saic.eebc.dto.SavingsEOLInterimResultDTO;
import com.saic.eebc.dto.SavingsEOLMainResultDTO;
import com.saic.eebc.dto.SavingsProductInterimResultDTO;
import com.saic.eebc.dto.SavingsProductMainResultDTO;
import com.saic.eebc.dto.SavingsReport;
import com.saic.eebc.dto.SavingsUseDataMainResultDTO;
import com.saic.eebc.dto.SupportingCalculationResultDTO;

public class EebcCalculationServiceImpl implements EebcCalculationService {

	protected final Logger logger = Logger.getLogger(getClass());
	private Properties prop8b2 = null;
	private Properties prop8a = null;
	private Properties prop8b1 = null;
	private Properties propproductInterim = null;
	private Properties propassumptioncalc = null;
	private SupportingCalculationResultDTO supportingCalculationResultDTO = null;
	NumberFormat formatter = new DecimalFormat("0.00E0");
	

	
	List<SavingsProductMainResultDTO> SavingsProductMainResultDTOList = new ArrayList<SavingsProductMainResultDTO>();

	public SavingsReport GenerateReportFromEEBCObject(
			EebcProductEntryObjectDTO eebcProductEntryObject) {
		List<SavingProductDisplayDTO> savingReportDisplayProductDTOList = new ArrayList<SavingProductDisplayDTO>();
		new ArrayList<SavingReportDisplayDTO>();
		new ArrayList<SavingReportDisplayDTO>();
		SavingsReport savingsReport = new SavingsReport();
		try {
			prop8b2 = loadParams("assumptionsepeattiers");
			prop8a = loadParams("assumptionbase");
			prop8b1 = loadParams("assumptionepeatdefault");
			propproductInterim = loadParams("productinterimenergy");
			propassumptioncalc = loadParams("assumptionsCalculations");

		} catch (Exception ex) {
			ex.printStackTrace();
		}
		if (eebcProductEntryObject != null) {
			
			savingReportDisplayProductDTOList = generateSavingsProductReport(eebcProductEntryObject);
			savingsReport.setSavingsproduct(savingReportDisplayProductDTOList);
            savingsReport.setSavingsAllproduct(generateAllProductSavingReportDisplayDTO(SavingsProductMainResultDTOList));
			// UseData Input Report Object
            if(eebcProductEntryObject
					.getInputUseAndEolObject() !=null && eebcProductEntryObject
							.getInputUseAndEolObject().getUseTotal() !=null)
            {
            	supportingCalculationResultDTO = generateSupportingCalculations(eebcProductEntryObject
    					.getInputUseAndEolObject());
			DataCompUseDataInterimResultDTO dataCompUseDataInterimResultDTO = generateDataCompUseDataInterimResultDTO(eebcProductEntryObject
					.getInputUseAndEolObject());
			DataCompUseDataMainResultDTO dataCompUseDataMainResultDTO = generateDataCompUseDataMainResultDTO(
					eebcProductEntryObject.getInputUseAndEolObject(),
					dataCompUseDataInterimResultDTO);
			SavingsUseDataMainResultDTO savingsUseDataMainResultDTO = generateSavingsUseDataMainResultDTO(
					eebcProductEntryObject.getInputUseAndEolObject(),
					dataCompUseDataMainResultDTO,
					supportingCalculationResultDTO);
			savingsReport
					.setUseInput(generateUseDataDisplayDTO(savingsUseDataMainResultDTO));
            }

			// EOL Report Object
            if(eebcProductEntryObject.getInputUseAndEolObject().getEndOfLifeInputs() !=null && eebcProductEntryObject.getInputUseAndEolObject().getEndOfLifeInputs().getTotalUnitsReused()!=null && eebcProductEntryObject.getInputUseAndEolObject().getEndOfLifeInputs().getTotalUnitsRecycledExclMixedElect() !=null)
            {
			DataCompEndOfLifeMainResultDTO dataCompEndOfLifeMainResultDTO = generateDataCompEndOfLifeMainResultDTO(eebcProductEntryObject
					.getInputUseAndEolObject().getEndOfLifeInputs());
			SavingsEOLInterimResultDTO savingsEOLInterimResultDTO = generateSavingsEOLInterimResultDTO(
					eebcProductEntryObject.getInputUseAndEolObject()
							.getEndOfLifeInputs(),
					dataCompEndOfLifeMainResultDTO);
			SavingsEOLMainResultDTO savingsEOLMainResultDTO = generateSavingsEOLMainResultDTO(savingsEOLInterimResultDTO);
			savingsReport
					.setEndOfLise(generateEOLDisplayDTO(savingsEOLMainResultDTO));
            }
		}

		return savingsReport;
	}

	public List<SavingProductDisplayDTO> generateSavingsProductReport(
			EebcProductEntryObjectDTO eebcProductEntryObject) {
		List<SavingProductDisplayDTO> savingProductDisplayDTOList = new ArrayList<SavingProductDisplayDTO>();

		new ArrayList<SavingReportDisplayDTO>();
		SavingsProductMainResultDTOList = new ArrayList<SavingsProductMainResultDTO>();
		SavingsProductMainResultDTOList = generateSavingsProductList(eebcProductEntryObject);
		// Add the logic for all product
		for (SavingsProductMainResultDTO savingsProductMainResultDTO : SavingsProductMainResultDTOList) {
			if (generateSavingReportDisplayDTO(savingsProductMainResultDTO) != null
					&& generateSavingReportDisplayDTO(
							savingsProductMainResultDTO).size() > 0) {
				SavingProductDisplayDTO savingProductDisplayDTO = new SavingProductDisplayDTO();
				savingProductDisplayDTO.setProductInfoID("Test");
				savingProductDisplayDTO
						.setSavingsproductList(generateSavingReportDisplayDTO(savingsProductMainResultDTO));
				savingProductDisplayDTOList.add(savingProductDisplayDTO);
			}
		}
		return savingProductDisplayDTOList;
	}
	
	public List<SavingsProductMainResultDTO> generateSavingsProductList(EebcProductEntryObjectDTO eebcProductEntryObject){
	
		if (eebcProductEntryObject != null) {
			if (eebcProductEntryObject.getProductInformationList() != null
					&& eebcProductEntryObject.getProductInformationList()
							.size() > 0) {
				for (ProductInformationDTO productInformation : eebcProductEntryObject
						.getProductInformationList()) {

					if (productInformation != null
							&& productInformation.getProductDetails()
									.getProductType() != null) {
						DataCompProductInterimResultDTO dataCompProductInterimResultDTO = new DataCompProductInterimResultDTO();
						DataCompProductMainResultDTO dataCompProductMainResultDTO = new DataCompProductMainResultDTO();
						SavingsProductInterimResultDTO savingsProductInterimResultDTO = new SavingsProductInterimResultDTO();
						SavingsProductMainResultDTO savingsProductMainResultDTO = new SavingsProductMainResultDTO();
						if(productInformation.getManuDeclarationOfPostRecycledPlastic()!=null && productInformation.getManuDeclarationOfPostRecycledPlastic().trim().length()>0)
						{
							productInformation.setManuDeclarationOfPostRecycledPlastic(Double.toString(Double.valueOf(productInformation.getManuDeclarationOfPostRecycledPlastic())/100));
						}
						
						if(productInformation.getPercentPowermkanagEnabledComp()!=null && productInformation.getPercentPowermkanagEnabledComp().trim().length()>0)
						{
							productInformation.setPercentPowermkanagEnabledComp((Double.toString(Double.valueOf(productInformation.getPercentPowermkanagEnabledComp())/100)));
						}
						
						if(productInformation.getPercentPowermkanagEnabledDisp()!=null && productInformation.getPercentPowermkanagEnabledDisp().trim().length()>0)
						{
							productInformation.setPercentPowermkanagEnabledDisp((Double.toString(Double.valueOf(productInformation.getPercentPowermkanagEnabledDisp())/100)));
						}
						
						if(productInformation.getLowRecycledPlasticContent()!=null && productInformation.getLowRecycledPlasticContent().trim().length()>0)
						{
							productInformation.setLowRecycledPlasticContent((Double.toString(Double.valueOf(productInformation.getLowRecycledPlasticContent())/100)));
						}
						
						if(productInformation.getUpperRecycledPlasticContent()!=null && productInformation.getUpperRecycledPlasticContent().trim().length()>0)
						{
							productInformation.setUpperRecycledPlasticContent((Double.toString(Double.valueOf(productInformation.getUpperRecycledPlasticContent())/100)));
						}
						
						if(productInformation.getLowRecycledResinContent()!=null && productInformation.getLowRecycledResinContent().trim().length()>0)
						{
							productInformation.setLowRecycledResinContent((Double.toString(Double.valueOf(productInformation.getLowRecycledResinContent())/100)));
						}
						
						if(productInformation.getUpperRecycledResinContent()!=null && productInformation.getUpperRecycledResinContent().trim().length()>0)
						{
							productInformation.setUpperRecycledResinContent((Double.toString(Double.valueOf(productInformation.getUpperRecycledResinContent())/100)));
						}
						
						if(productInformation.getLowRecycledAddPackageContent()!=null && productInformation.getLowRecycledAddPackageContent().trim().length()>0)
						{
							productInformation.setLowRecycledAddPackageContent((Double.toString(Double.valueOf(productInformation.getLowRecycledAddPackageContent())/100)));
						}
						
						if(productInformation.getUpperRecycledAddPackageContent()!=null && productInformation.getUpperRecycledAddPackageContent().trim().length()>0)
						{
							productInformation.setUpperRecycledAddPackageContent((Double.toString(Double.valueOf(productInformation.getUpperRecycledAddPackageContent())/100)));
						}
						
						dataCompProductInterimResultDTO = generateDataCompProductInterimResultDTO(productInformation);
						dataCompProductMainResultDTO = generateDataCompProductmainResultDTO(
								productInformation,
								dataCompProductInterimResultDTO);
						savingsProductInterimResultDTO = generateSavingsProductInterimResultDTO(
								productInformation,
								dataCompProductMainResultDTO);
						savingsProductMainResultDTO = generateSavingsProductMainResultDTO(
								productInformation,
								savingsProductInterimResultDTO,
								dataCompProductMainResultDTO);
						SavingsProductMainResultDTOList
								.add(savingsProductMainResultDTO);

					}

				}
			}
		}
		return SavingsProductMainResultDTOList;
	}

	public List<SavingReportDisplayDTO> generateAllProductSavingReportDisplayDTO(
			List<SavingsProductMainResultDTO> savingsProductMainResultDTOList) {
		
		// Reduced Toxicity Toxic Material Savings
		Double totalToxicMaterialSavingsPb = 0.00;
		Double toxicTotalMaterialsavingsHg = 0.00;
		Double toxicTotalMaterialsavingsHgLightSrc = 0.00;
		Double toxicTotalMaterialsavingsHgFree = 0.00;
		Double toxicTotalMaterialsavingsRoHsCd = 0.00;
		Double toxicTotalMaterialsavingsRoHsCr6 = 0.00;
		Double toxicTotalMaterialsavingsRoHsPBB = 0.00;
		Double toxicTotalMaterialsavingsRoHsPBDE = 0.00;

		// Reduced Toxicity Haz waste Savings
		Double totalHazWasteSavingsPb = 0.00;
		Double totalHazWasteSavingsHgFree = 0.00;
		// Material Use
		Double totalRecycledContentEnergySaving = 0.00;
		Double totalRecycledContentPrimaryMaterialsaving = 0.00;
		Double totalRecycledContentghgEmissionSaving = 0.00;
		Double totalRecycledContentWaterEmissionSaving = 0.00;
		Double totalRecycledContentAirEmissionSaving = 0.00;
		Double totalRecycledContentMuncipalWasteSaving = 0.00;
		Double totalRecycledContentCostSaving = 0.00;

		// Corrugated Packaging
		Double totalCorrugatedPackagingEnergySaving = 0.00;
		Double totalCorrugatedPackagingPrimaryMaterialsaving = 0.00;
		Double totalCorrugatedPackagingghgEmissionSaving = 0.00;
		Double totalCorrugatedPackagingWaterEmissionSaving = 0.00;
		Double totalCorrugatedPackagingAirEmissionSaving = 0.00;
		Double totalCorrugatedPackagingMuncipalWasteSaving = 0.00;
		Double totalCorrugatedPackagingCostSaving = 0.00;

		// Plastic/foam
		Double totalPlasticEnergySaving = 0.00;
		Double totalPlasticPrimaryMaterialsaving = 0.00;
		Double totalPlasticghgEmissionSaving = 0.00;
		Double totalPlasticWaterEmissionSaving = 0.00;
		Double totalPlasticAirEmissionSaving = 0.00;
		Double totalPlasticMuncipalWasteSaving = 0.00;
		Double totalPlasticCostSaving = 0.00;

		// other packaging
		Double totalOtherEnergySaving = 0.00;
		Double totalOtherPrimaryMaterialsaving = 0.00;
		Double totalOtherghgEmissionSaving = 0.00;
		Double totalOtherWaterEmissionSaving = 0.00;
		Double totalOtherAirEmissionSaving = 0.00;
		Double totalOtherMuncipalWasteSaving = 0.00;
		Double totalOtherCostSaving = 0.00;

		// cpg
		Double totalCPGEnergySaving = 0.00;
		Double totalCPGPrimaryMaterialsaving = 0.00;
		Double totalCPGghgEmissionSaving = 0.00;
		Double totalCPGWaterEmissionSaving = 0.00;
		Double totalCPGAirEmissionSaving = 0.00;
		Double totalCPGMuncipalWasteSaving = 0.00;
		Double totalCPGCostSaving = 0.00;

		// package reuse
		Double totalPackageReuseEnergySaving = 0.00;
		Double totalPackageReusePrimaryMaterialsaving = 0.00;
		Double totalPackageReuseghgEmissionSaving = 0.00;
		Double totalPackageReuseWaterEmissionSaving = 0.00;
		Double totalPackageReuseAirEmissionSaving = 0.00;
		Double totalPackageReuseMuncipalWasteSaving = 0.00;
		Double totalPackageReuseCostSaving = 0.00;

		// Product Life energy5
		Double totalLifeEnergy5EnergySaving = 0.00;
		Double totalLifeEnergy5PrimaryMaterialsaving = 0.00;
		Double totalLifeEnergy5ghgEmissionSaving = 0.00;
		Double totalLifeEnergy5WaterEmissionSaving = 0.00;
		Double totalLifeEnergy5AirEmissionSaving = 0.00;
		Double totalLifeEnergy5CostSaving = 0.00;

		// Product First energy5
		Double totalFirstEnergy5EnergySaving = 0.00;
		Double totalFirstEnergy5PrimaryMaterialsaving = 0.00;
		Double totalFirstEnergy5ghgEmissionSaving = 0.00;
		Double totalFirstEnergy5WaterEmissionSaving = 0.00;
		Double totalFirstEnergy5AirEmissionSaving = 0.00;
		Double totalFirstEnergy5CostSaving = 0.00;
		
		//packaging subtotals 
		Double totalEnergySubTotal = 0.00;
		 Double totalPrimarySubTotal =0.00;
		 Double totalGhgSubTotal =0.00;
		 Double totalWaterSubTotal =0.00;
		 Double totalAirSubTotal=0.00;
		 Double totalMuncipalSubTotal =0.00;
		 Double totalCostSubTotal =0.00;

		
		for (SavingsProductMainResultDTO savingsProductMainResultDTO : savingsProductMainResultDTOList) {
			if (savingsProductMainResultDTO !=null) {
				 totalToxicMaterialSavingsPb+= savingsProductMainResultDTO.getToxicMaterialsavingsFromPb() == null?0.00:savingsProductMainResultDTO.getToxicMaterialsavingsFromPb();
				 toxicTotalMaterialsavingsHg += savingsProductMainResultDTO.getToxicMaterialsavingsFromHg() ==null?0.00:savingsProductMainResultDTO.getToxicMaterialsavingsFromHg(); 
				 toxicTotalMaterialsavingsHgLightSrc += savingsProductMainResultDTO.getToxicMaterialsavingsFromHgInLightSrc() == null?0.00:savingsProductMainResultDTO.getToxicMaterialsavingsFromHgInLightSrc();
				 toxicTotalMaterialsavingsHgFree += savingsProductMainResultDTO.getToxicMaterialsavingsFromHgFreeLamps()==null?0.00:savingsProductMainResultDTO.getToxicMaterialsavingsFromHgFreeLamps();
				 toxicTotalMaterialsavingsRoHsCd += savingsProductMainResultDTO.getToxicMaterialsavingsFromCd()==null?0.00:savingsProductMainResultDTO.getToxicMaterialsavingsFromCd();
				 toxicTotalMaterialsavingsRoHsCr6 += savingsProductMainResultDTO.getToxicMaterialsavingsFromCr6()==null?0.00:savingsProductMainResultDTO.getToxicMaterialsavingsFromCr6();
				 toxicTotalMaterialsavingsRoHsPBB += savingsProductMainResultDTO.getToxicMaterialsavingsFromPBB()==null?0.00:savingsProductMainResultDTO.getToxicMaterialsavingsFromPBB();
				 toxicTotalMaterialsavingsRoHsPBDE += savingsProductMainResultDTO.getToxicMaterialsavingsFromPBDE()==null?0.00:savingsProductMainResultDTO.getToxicMaterialsavingsFromPBDE();
				 
				 

				// Reduced Toxicity Haz waste Savings
				 totalHazWasteSavingsPb += savingsProductMainResultDTO == null?0.00:savingsProductMainResultDTO.getHwSavings();
				 totalHazWasteSavingsHgFree += savingsProductMainResultDTO.getToxicMaterialsavingsFromHgFreeLamps() == null?0.00:savingsProductMainResultDTO.getHwSavingsHgFreelamps();
		

				// Material Use
				 totalRecycledContentEnergySaving += savingsProductMainResultDTO.getMaterialuseSaving().getEnergySavings()== null?0.00:savingsProductMainResultDTO.getMaterialuseSaving().getEnergySavings();
				 totalRecycledContentPrimaryMaterialsaving += savingsProductMainResultDTO.getMaterialuseSaving().getPrimaryMaterialSavings()== null?0.00:savingsProductMainResultDTO.getMaterialuseSaving().getPrimaryMaterialSavings();
				 totalRecycledContentghgEmissionSaving += savingsProductMainResultDTO.getMaterialuseSaving().getGhgEmissionSaving()== null?0.00:savingsProductMainResultDTO.getMaterialuseSaving().getGhgEmissionSaving();
				 totalRecycledContentWaterEmissionSaving += savingsProductMainResultDTO.getMaterialuseSaving().getWaterEmissionSaving()== null?0.00:savingsProductMainResultDTO.getMaterialuseSaving().getWaterEmissionSaving();
				 totalRecycledContentAirEmissionSaving += savingsProductMainResultDTO.getMaterialuseSaving().getAirEmissionsaving()== null?0.00:savingsProductMainResultDTO.getMaterialuseSaving().getAirEmissionsaving();
				 totalRecycledContentMuncipalWasteSaving += savingsProductMainResultDTO.getMaterialuseSaving().getMuncipalWasteSavings()== null?0.00:savingsProductMainResultDTO.getMaterialuseSaving().getMuncipalWasteSavings();
				 totalRecycledContentCostSaving += savingsProductMainResultDTO.getMaterialuseSaving().getCostSavings()== null?0.00:savingsProductMainResultDTO.getMaterialuseSaving().getCostSavings();
				
				 // Packaging
				 totalCorrugatedPackagingEnergySaving += savingsProductMainResultDTO.getRecycleSaving().getEnergySavings()== null?0.00:savingsProductMainResultDTO.getRecycleSaving().getEnergySavings();
				 totalCorrugatedPackagingPrimaryMaterialsaving += savingsProductMainResultDTO.getRecycleSaving().getPrimaryMaterialSavings()== null?0.00:savingsProductMainResultDTO.getRecycleSaving().getPrimaryMaterialSavings();
				 totalCorrugatedPackagingghgEmissionSaving += savingsProductMainResultDTO.getRecycleSaving().getGhgEmissionSaving()== null?0.00:savingsProductMainResultDTO.getRecycleSaving().getGhgEmissionSaving();
				 totalCorrugatedPackagingWaterEmissionSaving += savingsProductMainResultDTO.getRecycleSaving().getWaterEmissionSaving()== null?0.00: savingsProductMainResultDTO.getRecycleSaving().getWaterEmissionSaving();
				 totalCorrugatedPackagingAirEmissionSaving += savingsProductMainResultDTO.getRecycleSaving().getAirEmissionsaving()== null?0.00:savingsProductMainResultDTO.getRecycleSaving().getAirEmissionsaving();
				 totalCorrugatedPackagingMuncipalWasteSaving += savingsProductMainResultDTO.getRecycleSaving().getMuncipalWasteSavings()== null?0.00:savingsProductMainResultDTO.getRecycleSaving().getMuncipalWasteSavings();
				 totalCorrugatedPackagingCostSaving += savingsProductMainResultDTO.getRecycleSaving().getCostSavings()== null?0.00:savingsProductMainResultDTO.getRecycleSaving().getCostSavings();

				// Plastic/foam
				 totalPlasticEnergySaving += savingsProductMainResultDTO.getPackagingSaving().getEnergySavings()== null?0.00:savingsProductMainResultDTO.getPackagingSaving().getEnergySavings();
				 totalPlasticPrimaryMaterialsaving += savingsProductMainResultDTO.getPackagingSaving().getPrimaryMaterialSavings()== null?0.00:savingsProductMainResultDTO.getPackagingSaving().getPrimaryMaterialSavings();
				 totalPlasticghgEmissionSaving += savingsProductMainResultDTO.getPackagingSaving().getGhgEmissionSaving()== null?0.00:savingsProductMainResultDTO.getPackagingSaving().getGhgEmissionSaving();
				 totalPlasticWaterEmissionSaving += savingsProductMainResultDTO.getPackagingSaving().getWaterEmissionSaving()== null?0.00:savingsProductMainResultDTO.getPackagingSaving().getWaterEmissionSaving();
				 totalPlasticAirEmissionSaving += savingsProductMainResultDTO.getPackagingSaving().getAirEmissionsaving()== null?0.00:savingsProductMainResultDTO.getPackagingSaving().getAirEmissionsaving();
				 totalPlasticMuncipalWasteSaving += savingsProductMainResultDTO.getPackagingSaving().getMuncipalWasteSavings()== null?0.00:savingsProductMainResultDTO.getPackagingSaving().getMuncipalWasteSavings();
				 totalPlasticCostSaving += savingsProductMainResultDTO.getPackagingSaving().getCostSavings()== null?0.00:savingsProductMainResultDTO.getPackagingSaving().getCostSavings();
                
				 // other packaging
				 totalOtherEnergySaving += savingsProductMainResultDTO.getOtherPackagingSaving().getEnergySavings()== null?0.00:savingsProductMainResultDTO.getOtherPackagingSaving().getEnergySavings();
				 totalOtherPrimaryMaterialsaving += savingsProductMainResultDTO.getOtherPackagingSaving().getPrimaryMaterialSavings()== null?0.00:savingsProductMainResultDTO.getOtherPackagingSaving().getPrimaryMaterialSavings();
				 totalOtherghgEmissionSaving += savingsProductMainResultDTO.getOtherPackagingSaving().getGhgEmissionSaving()== null?0.00:savingsProductMainResultDTO.getOtherPackagingSaving().getGhgEmissionSaving();
				 totalOtherWaterEmissionSaving += savingsProductMainResultDTO.getOtherPackagingSaving().getWaterEmissionSaving()== null?0.00:savingsProductMainResultDTO.getOtherPackagingSaving().getWaterEmissionSaving();
				 totalOtherAirEmissionSaving += savingsProductMainResultDTO.getOtherPackagingSaving().getAirEmissionsaving()== null?0.00:savingsProductMainResultDTO.getOtherPackagingSaving().getAirEmissionsaving();
				 totalOtherMuncipalWasteSaving += savingsProductMainResultDTO.getOtherPackagingSaving().getMuncipalWasteSavings()== null?0.00:savingsProductMainResultDTO.getOtherPackagingSaving().getMuncipalWasteSavings();
				 totalOtherCostSaving += savingsProductMainResultDTO.getOtherPackagingSaving().getCostSavings()== null?0.00:savingsProductMainResultDTO.getOtherPackagingSaving().getCostSavings();

				// cpg
				 totalCPGEnergySaving += savingsProductMainResultDTO.getRecycleContentInCPG().getEnergySavings()== null?0.00:savingsProductMainResultDTO.getRecycleContentInCPG().getEnergySavings();
				 totalCPGPrimaryMaterialsaving += savingsProductMainResultDTO.getRecycleContentInCPG().getPrimaryMaterialSavings()== null?0.00:savingsProductMainResultDTO.getRecycleContentInCPG().getPrimaryMaterialSavings();
				 totalCPGghgEmissionSaving += savingsProductMainResultDTO.getRecycleContentInCPG().getGhgEmissionSaving()== null?0.00:savingsProductMainResultDTO.getRecycleContentInCPG().getGhgEmissionSaving();
				 totalCPGWaterEmissionSaving += savingsProductMainResultDTO.getRecycleContentInCPG().getWaterEmissionSaving()== null?0.00:savingsProductMainResultDTO.getRecycleContentInCPG().getWaterEmissionSaving();
				 totalCPGAirEmissionSaving += savingsProductMainResultDTO.getRecycleContentInCPG().getAirEmissionsaving()== null?0.00:savingsProductMainResultDTO.getRecycleContentInCPG().getAirEmissionsaving();
				 totalCPGMuncipalWasteSaving += savingsProductMainResultDTO.getRecycleContentInCPG().getMuncipalWasteSavings()== null?0.00:savingsProductMainResultDTO.getRecycleContentInCPG().getMuncipalWasteSavings();
				 totalCPGCostSaving += savingsProductMainResultDTO.getRecycleContentInCPG().getCostSavings()== null?0.00:savingsProductMainResultDTO.getRecycleContentInCPG().getCostSavings();
				 

				// package reuse
				 totalPackageReuseEnergySaving += savingsProductMainResultDTO.getPackagingReuse().getEnergySavings()== null?0.00:savingsProductMainResultDTO.getPackagingReuse().getEnergySavings();
				 totalPackageReusePrimaryMaterialsaving += savingsProductMainResultDTO.getPackagingReuse().getPrimaryMaterialSavings()== null?0.00:savingsProductMainResultDTO.getPackagingReuse().getPrimaryMaterialSavings();
				 totalPackageReuseghgEmissionSaving += savingsProductMainResultDTO.getPackagingReuse().getGhgEmissionSaving()== null?0.00:savingsProductMainResultDTO.getPackagingReuse().getGhgEmissionSaving();
				 totalPackageReuseWaterEmissionSaving += savingsProductMainResultDTO.getPackagingReuse().getWaterEmissionSaving()== null?0.00:savingsProductMainResultDTO.getPackagingReuse().getWaterEmissionSaving();
				 totalPackageReuseAirEmissionSaving += savingsProductMainResultDTO.getPackagingReuse().getAirEmissionsaving()== null?0.00:savingsProductMainResultDTO.getPackagingReuse().getAirEmissionsaving();
				 totalPackageReuseMuncipalWasteSaving += savingsProductMainResultDTO.getPackagingReuse().getMuncipalWasteSavings()== null?0.00: savingsProductMainResultDTO.getPackagingReuse().getMuncipalWasteSavings();
				 totalPackageReuseCostSaving += savingsProductMainResultDTO.getPackagingReuse().getCostSavings()== null?0.00:savingsProductMainResultDTO.getPackagingReuse().getCostSavings();
				 
				// Product Life energy5
				 totalLifeEnergy5EnergySaving += savingsProductMainResultDTO.getEnergySaving5Life().getEnergySaving()== null?0.00:savingsProductMainResultDTO.getEnergySaving5Life().getEnergySaving() ;
				 totalLifeEnergy5PrimaryMaterialsaving += savingsProductMainResultDTO.getEnergySaving5Life().getPrimaryMaterialSaving()== null?0.00:savingsProductMainResultDTO.getEnergySaving5Life().getPrimaryMaterialSaving();
				 totalLifeEnergy5ghgEmissionSaving += savingsProductMainResultDTO.getEnergySaving5Life().getGhgEmissionSaving()== null?0.00:savingsProductMainResultDTO.getEnergySaving5Life().getGhgEmissionSaving();
				 totalLifeEnergy5WaterEmissionSaving += savingsProductMainResultDTO.getEnergySaving5Life().getWaterEmissionSaving()== null?0.00:savingsProductMainResultDTO.getEnergySaving5Life().getWaterEmissionSaving();
				 totalLifeEnergy5AirEmissionSaving += savingsProductMainResultDTO.getEnergySaving5Life().getAirEmissionsaving()== null?0.00:savingsProductMainResultDTO.getEnergySaving5Life().getAirEmissionsaving();
				 totalLifeEnergy5CostSaving += savingsProductMainResultDTO.getEnergySaving5Life().getCostSaving()== null?0.00:savingsProductMainResultDTO.getEnergySaving5Life().getCostSaving();
				

				// Product First energy5
				 totalFirstEnergy5EnergySaving += savingsProductMainResultDTO.getEnergySaving5First().getEnergySaving()== null?0.00:savingsProductMainResultDTO.getEnergySaving5First().getEnergySaving();
				 totalFirstEnergy5PrimaryMaterialsaving += savingsProductMainResultDTO.getEnergySaving5First().getPrimaryMaterialSaving()== null?0.00:savingsProductMainResultDTO.getEnergySaving5First().getPrimaryMaterialSaving();
				 totalFirstEnergy5ghgEmissionSaving += savingsProductMainResultDTO.getEnergySaving5First().getGhgEmissionSaving()== null?0.00:savingsProductMainResultDTO.getEnergySaving5First().getGhgEmissionSaving();
				 totalFirstEnergy5WaterEmissionSaving += savingsProductMainResultDTO.getEnergySaving5First().getWaterEmissionSaving()== null?0.00:savingsProductMainResultDTO.getEnergySaving5First().getWaterEmissionSaving();
				 totalFirstEnergy5AirEmissionSaving += savingsProductMainResultDTO.getEnergySaving5First().getAirEmissionsaving()== null?0.00:savingsProductMainResultDTO.getEnergySaving5First().getAirEmissionsaving();
				 totalFirstEnergy5CostSaving += savingsProductMainResultDTO.getEnergySaving5First().getCostSaving()== null?0.00:savingsProductMainResultDTO.getEnergySaving5First().getCostSaving();
				 
				 
				  totalEnergySubTotal += savingsProductMainResultDTO.getPackagingSubTotal().getEnergySavings();
				  totalPrimarySubTotal +=savingsProductMainResultDTO.getPackagingSubTotal().getPrimaryMaterialSavings();
				  totalGhgSubTotal +=savingsProductMainResultDTO.getPackagingSubTotal().getGhgEmissionSaving();
				  totalWaterSubTotal +=savingsProductMainResultDTO.getPackagingSubTotal().getWaterEmissionSaving();
				  totalAirSubTotal+=savingsProductMainResultDTO.getPackagingSubTotal().getAirEmissionsaving() ;
				  totalMuncipalSubTotal +=savingsProductMainResultDTO.getPackagingSubTotal().getMuncipalWasteSavings() ;
				  totalCostSubTotal +=savingsProductMainResultDTO.getPackagingSubTotal().getCostSavings();
			}
		}
		
		// Toxic Material Subtotal
	
		 
		 Double totalToxicmaterialSubTotal =  totalToxicMaterialSavingsPb+ toxicTotalMaterialsavingsHg+toxicTotalMaterialsavingsHgLightSrc+toxicTotalMaterialsavingsHgFree+toxicTotalMaterialsavingsRoHsCd+toxicTotalMaterialsavingsRoHsCr6+toxicTotalMaterialsavingsRoHsPBB+toxicTotalMaterialsavingsRoHsPBDE;
		 Double totalHazWasteSubTotal = totalHazWasteSavingsPb+ totalHazWasteSavingsHgFree;
		 
		
		    Double totalEnergySubTotalLife=totalRecycledContentEnergySaving +totalEnergySubTotal;
			Double totalPrimarySubTotalLife=totalRecycledContentPrimaryMaterialsaving + totalPrimarySubTotal;
			Double totalGhgSubTotalLife=totalRecycledContentghgEmissionSaving +totalGhgSubTotal;
			Double totalWaterSubTotalLife= totalRecycledContentWaterEmissionSaving + totalWaterSubTotal;
			Double totalAirSubTotalLife=totalRecycledContentAirEmissionSaving +totalAirSubTotal;
	    //	Double totalMuncipalSubTotalLife=totalCorrugatedPackagingMuncipalWasteSaving+totalPlasticMuncipalWasteSaving+totalOtherMuncipalWasteSaving+totalCPGMuncipalWasteSaving+totalPackageReuseMuncipalWasteSaving;
			Double totalCostSubTotalLife=totalRecycledContentCostSaving + totalCostSubTotal;
		//	Double totalHazSubTotal=totalCorrugatedPackagingEnergySaving+totalPlasticEnergySaving+totalOtherEnergySaving+totalCPGEnergySaving+totalPackageReuseEnergySaving;
		
			
			Double EnergyLifeTotalSubEnergy = totalLifeEnergy5EnergySaving+totalEnergySubTotalLife;
			Double EnergyLifeTotalSubPrimaryMaterialsaving = totalLifeEnergy5PrimaryMaterialsaving+totalPrimarySubTotalLife;
			Double EnergyLifeTotalghgEmissionSaving = totalLifeEnergy5ghgEmissionSaving+totalGhgSubTotalLife;
			Double EnergyLifeTotalWaterEmissionSaving = totalLifeEnergy5WaterEmissionSaving+totalWaterSubTotalLife;
		    Double EnergyLifeTotalAirEmissionSaving = totalLifeEnergy5AirEmissionSaving+totalAirSubTotalLife;
		    Double EnergyLifeTotalCostSaving = totalLifeEnergy5CostSaving+totalCostSubTotalLife;
		    Double EnergtLifeMuncipal =  totalMuncipalSubTotal +totalRecycledContentMuncipalWasteSaving;
		     
		    
		    Double EnergyFirstTotalSubEnergy = totalFirstEnergy5EnergySaving+totalEnergySubTotalLife;
			Double EnergyFirstTotalSubPrimaryMaterialsaving = totalFirstEnergy5PrimaryMaterialsaving+totalPrimarySubTotalLife;
			Double EnergyFirstTotalghgEmissionSaving = totalFirstEnergy5ghgEmissionSaving+totalGhgSubTotalLife;
			Double EnergyFirstTotalWaterEmissionSaving = totalFirstEnergy5WaterEmissionSaving+totalWaterSubTotalLife;
		    Double EnergyFirstTotalAirEmissionSaving = totalFirstEnergy5AirEmissionSaving+totalAirSubTotalLife;
		    Double EnergyFirstTotalCostSaving = totalFirstEnergy5CostSaving+totalCostSubTotalLife;
		    
		    
			
			
		List<SavingReportDisplayDTO> savingsReportProductList = new ArrayList<SavingReportDisplayDTO>();

		// energySavings;
		// primaryMaterialSavings;
		// ghgEmissionSaving;
		// airEmissionsaving;
		// waterEmissionSaving;
		// muncipalWasteSavings;
		// costSavings;

		// REDUCED TOXICITY
	
		savingsReportProductList.add(new SavingReportDisplayDTO(
				"REDUCED TOXICITY", "", "", "", "", "", "", "", "", ""));
		savingsReportProductList
				.add(new SavingReportDisplayDTO(
						"RoHs Compliance-Pb", "", "", "", "", "",
						totalToxicMaterialSavingsPb == null ? ""
								: formatter.format((totalToxicMaterialSavingsPb)), "",
								totalHazWasteSavingsPb == null ? ""
								: formatter.format((totalHazWasteSavingsPb)), ""));
		savingsReportProductList.add(new SavingReportDisplayDTO(
				"RoHs Compliance-Hg (excludes lamps)", "", "", "",
				"", "", toxicTotalMaterialsavingsHg == null ? "" : formatter.format(
						(toxicTotalMaterialsavingsHg)), "", "", ""));
		savingsReportProductList.add(new SavingReportDisplayDTO(
				"Hg in light source; max avg of 3 mgHg/lamp", "",
				"", "", "", "",  toxicTotalMaterialsavingsHgLightSrc == null ? ""
						: formatter.format(( toxicTotalMaterialsavingsHgLightSrc)),
				"", "", ""));
		savingsReportProductList
				.add(new SavingReportDisplayDTO(
						"Hg-free lamps",
						"",
						"",
						"",
						"",
						"",
						toxicTotalMaterialsavingsHgFree == null ? ""
								: formatter.format((toxicTotalMaterialsavingsHgFree)),
						"", totalHazWasteSavingsHgFree == null ? ""
								: formatter.format((totalHazWasteSavingsHgFree)), ""));
		savingsReportProductList
				.add(new SavingReportDisplayDTO(
						"RoHs Compliance-Cd", "", "", "", "", "",
						toxicTotalMaterialsavingsRoHsCd == null ? ""
								: formatter.format((toxicTotalMaterialsavingsRoHsCd)), "",
						"", ""));
		savingsReportProductList
				.add(new SavingReportDisplayDTO(
						"RoHs Compliance-Cr6+", "", "", "", "", "",
						 toxicTotalMaterialsavingsRoHsCr6 == null ? ""
								: formatter.format(( toxicTotalMaterialsavingsRoHsCr6)), "",
						"", ""));
		savingsReportProductList
				.add(new SavingReportDisplayDTO(
						"RoHs Compliance-PBB", "", "", "", "", "",
						toxicTotalMaterialsavingsRoHsPBB == null ? ""
								: formatter.format((toxicTotalMaterialsavingsRoHsPBB)), "",
						"", ""));
		savingsReportProductList
				.add(new SavingReportDisplayDTO(
						"RoHs Compliance-PBDE", "", "", "", "", "",
						toxicTotalMaterialsavingsRoHsPBDE == null ? ""
								: formatter.format((toxicTotalMaterialsavingsRoHsPBDE)),
						"", "", ""));
		savingsReportProductList.add(new SavingReportDisplayDTO("Reduced Toxicity SUBTOTAL",
				"", "", "", "", "", totalToxicmaterialSubTotal == null ? "" : formatter.format(
						totalToxicmaterialSubTotal), "",
						totalHazWasteSubTotal == null ? "500"
						: formatter.format(totalHazWasteSubTotal), ""));

		// MATERIAL USE
		savingsReportProductList.add(new SavingReportDisplayDTO("MATERIAL USE",
				"", "", "", "", "", "", "", "", ""));
		savingsReportProductList
				.add(new SavingReportDisplayDTO(
						"Recycled content in product",
						totalRecycledContentEnergySaving == null ? "" : formatter.format(
								(totalRecycledContentEnergySaving)),
								totalRecycledContentPrimaryMaterialsaving == null ? ""
								: formatter.format((totalRecycledContentPrimaryMaterialsaving)),
								totalRecycledContentghgEmissionSaving == null ? "" : formatter.format(
								(totalRecycledContentghgEmissionSaving)),
								totalRecycledContentAirEmissionSaving == null ? "" : formatter.format(
								(totalRecycledContentAirEmissionSaving)),
										totalRecycledContentWaterEmissionSaving == null ? "" : formatter.format(
								(totalRecycledContentWaterEmissionSaving)), "",
								totalRecycledContentMuncipalWasteSaving == null ? ""
								: formatter.format((totalRecycledContentMuncipalWasteSaving)), "",
								totalRecycledContentCostSaving == null ? "" : formatter.format(
								(totalRecycledContentCostSaving))));
	
		savingsReportProductList
		.add(new SavingReportDisplayDTO(
				"Material Use SUBTOTAL",
				totalRecycledContentEnergySaving == null ? "" : formatter.format(
						(totalRecycledContentEnergySaving)),
						totalRecycledContentPrimaryMaterialsaving == null ? ""
						: formatter.format((totalRecycledContentPrimaryMaterialsaving)),
						totalRecycledContentghgEmissionSaving == null ? "" : formatter.format(
						(totalRecycledContentghgEmissionSaving)),
						totalRecycledContentAirEmissionSaving == null ? "" : formatter.format(
						(totalRecycledContentAirEmissionSaving)),
								totalRecycledContentWaterEmissionSaving == null ? "" : formatter.format(
						(totalRecycledContentWaterEmissionSaving)), "",
						totalRecycledContentMuncipalWasteSaving == null ? ""
						: formatter.format((totalRecycledContentMuncipalWasteSaving)), "",
						totalRecycledContentCostSaving == null ? "" : formatter.format(
						(totalRecycledContentCostSaving))));

		// PACKAGING
		savingsReportProductList.add(new SavingReportDisplayDTO("PACKAGING",
				"", "", "", "", "", "", "", "", ""));
		savingsReportProductList
				.add(new SavingReportDisplayDTO(
						"Average recycled content in corrugated packaging",
						totalCorrugatedPackagingEnergySaving == null ? "" : formatter.format(
								(totalCorrugatedPackagingEnergySaving)),
								totalCorrugatedPackagingPrimaryMaterialsaving == null ? ""
								: formatter.format((totalCorrugatedPackagingPrimaryMaterialsaving)),
								totalCorrugatedPackagingghgEmissionSaving == null ? "" : formatter.format(
								(totalCorrugatedPackagingghgEmissionSaving)),
								totalCorrugatedPackagingAirEmissionSaving == null ? "" : formatter.format(
								(totalCorrugatedPackagingAirEmissionSaving)),
										 totalCorrugatedPackagingWaterEmissionSaving == null ? "" : formatter.format(
								( totalCorrugatedPackagingWaterEmissionSaving)), "",
								totalCorrugatedPackagingMuncipalWasteSaving == null ? ""
								: formatter.format((totalCorrugatedPackagingMuncipalWasteSaving)), "",
								totalCorrugatedPackagingCostSaving == null ? "" : formatter.format(
								(totalCorrugatedPackagingCostSaving))));
		
		
		savingsReportProductList
				.add(new SavingReportDisplayDTO(
						"Average recycled content in plastic/foam packaging",
						 totalPlasticEnergySaving== null ? "" : formatter.format(
								( totalPlasticEnergySaving)),
								totalPlasticPrimaryMaterialsaving == null ? ""
								: formatter.format((totalPlasticPrimaryMaterialsaving)),
								totalPlasticghgEmissionSaving == null ? "" : formatter.format(
								(totalPlasticghgEmissionSaving)),
						totalPlasticAirEmissionSaving == null ? "" : formatter.format(
								(totalPlasticAirEmissionSaving)),
										totalPlasticWaterEmissionSaving == null ? "" : formatter.format(
								(totalPlasticWaterEmissionSaving)), "",
								totalPlasticMuncipalWasteSaving == null ? ""
								: formatter.format((totalPlasticMuncipalWasteSaving)), "",
								totalPlasticCostSaving == null ? "" : formatter.format(
								(totalPlasticCostSaving))));
		
		
		savingsReportProductList.add(new SavingReportDisplayDTO(
				"Average recycled content in other packaging",
				totalOtherEnergySaving == null ? "" : formatter.format(
						(totalOtherEnergySaving)),
						totalOtherPrimaryMaterialsaving == null ? "" : formatter.format(
						(totalOtherPrimaryMaterialsaving)),
						totalOtherghgEmissionSaving == null ? "" : formatter.format(
						(totalOtherghgEmissionSaving)),
						totalOtherAirEmissionSaving == null ? "" : formatter.format(
						(totalOtherAirEmissionSaving)),
								totalOtherWaterEmissionSaving == null ? "" : formatter.format(
						(totalOtherWaterEmissionSaving)), "",
						totalOtherMuncipalWasteSaving == null ? "" : formatter.format(
						(totalOtherMuncipalWasteSaving)), "",
						totalOtherCostSaving == null ? "" : formatter.format(
						(totalOtherCostSaving))));

		
		savingsReportProductList
				.add(new SavingReportDisplayDTO(
						"Minimum 25% for recycled content in corrugated packaging (CPG)",
						 totalCPGEnergySaving == null ? "" : formatter.format(
								( totalCPGEnergySaving)),
								totalCPGPrimaryMaterialsaving == null ? ""
								: formatter.format((totalCPGPrimaryMaterialsaving)),
								totalCPGghgEmissionSaving == null ? "" : formatter.format(
								(totalCPGghgEmissionSaving)),
								totalCPGAirEmissionSaving == null ? "" : formatter.format(
								(totalCPGAirEmissionSaving)),
										totalCPGWaterEmissionSaving == null ? "" : formatter.format(
								(totalCPGWaterEmissionSaving)), "",
								totalCPGMuncipalWasteSaving == null ? ""
								: formatter.format((totalCPGMuncipalWasteSaving)), "",
								totalCPGCostSaving == null ? "" : formatter.format(
								(totalCPGCostSaving))));
		
		// package reuse
		savingsReportProductList.add(new SavingReportDisplayDTO(
				"Packaging avoided per unit by packaging reuse",
				totalPackageReuseEnergySaving == null ? "" : formatter.format(
						(totalPackageReuseEnergySaving)),
						totalPackageReusePrimaryMaterialsaving == null ? "" : formatter.format(
						(totalPackageReusePrimaryMaterialsaving)),
						 totalPackageReuseghgEmissionSaving == null ? "" : formatter.format(
						(totalPackageReuseghgEmissionSaving)),
						totalPackageReuseAirEmissionSaving == null ? "" : formatter.format(
						(totalPackageReuseAirEmissionSaving)),
						totalPackageReuseWaterEmissionSaving == null ? "" : formatter.format(
						(totalPackageReuseWaterEmissionSaving)),
				"", totalPackageReuseMuncipalWasteSaving == null ? "" : formatter.format(
						(totalPackageReuseMuncipalWasteSaving)), "",
						totalPackageReuseCostSaving == null ? "" : formatter.format(
						(totalPackageReuseCostSaving))));
	

		savingsReportProductList
				.add(new SavingReportDisplayDTO("Packaging SUBTOTAL",
						totalEnergySubTotal == null ? "" : formatter.format(
								(totalEnergySubTotal)),
								totalPrimarySubTotal == null ? ""
								: formatter.format((totalPrimarySubTotal)),
								totalGhgSubTotal == null ? "" : formatter.format(
								(totalGhgSubTotal)),
								totalAirSubTotal == null ? "" : formatter.format(
								(totalAirSubTotal)),
								totalWaterSubTotal == null ? "" : formatter.format(
								(totalWaterSubTotal)), "",
								totalMuncipalSubTotal == null?"":formatter.format(totalMuncipalSubTotal),"",totalCostSubTotal == null?"":formatter.format(totalCostSubTotal)));

		// ENERGY PRODUCT LIFE YEAR		
		savingsReportProductList
				.add(new SavingReportDisplayDTO("Energy (Product Lifetime)",
						"", "", "", "", "", "", "", "", ""));
		savingsReportProductList
				.add(new SavingReportDisplayDTO(
						"ENERGY STAR 6.*",
						totalLifeEnergy5EnergySaving == null ? "" : formatter.format(
								(totalLifeEnergy5EnergySaving)),
								totalLifeEnergy5PrimaryMaterialsaving == null ? ""
								: formatter.format((totalLifeEnergy5PrimaryMaterialsaving)),
								totalLifeEnergy5ghgEmissionSaving == null ? "" : formatter.format(
								(totalLifeEnergy5ghgEmissionSaving)),
								totalLifeEnergy5AirEmissionSaving == null ? "" : formatter.format(
								(totalLifeEnergy5AirEmissionSaving)),
								totalLifeEnergy5WaterEmissionSaving == null ? "" : formatter.format(
								(totalLifeEnergy5WaterEmissionSaving)),
						"",
						"",
						"",
						totalLifeEnergy5CostSaving == null ? ""
								: formatter.format((totalLifeEnergy5CostSaving))));
		
	
		//2017
		//remove subtotal
		/*
		savingsReportProductList
		.add(new SavingReportDisplayDTO(
				"SUBTOTALS",
				totalLifeEnergy5EnergySaving == null ? "" : formatter.format(
						(totalLifeEnergy5EnergySaving)),
						totalLifeEnergy5PrimaryMaterialsaving == null ? ""
						: formatter.format((totalLifeEnergy5PrimaryMaterialsaving)),
						totalLifeEnergy5ghgEmissionSaving == null ? "" : formatter.format(
						(totalLifeEnergy5ghgEmissionSaving)),
						totalLifeEnergy5AirEmissionSaving == null ? "" : formatter.format(
						(totalLifeEnergy5AirEmissionSaving)),
						totalLifeEnergy5WaterEmissionSaving == null ? "" : formatter.format(
						(totalLifeEnergy5WaterEmissionSaving)),
				"",
				"",
				"",
				totalLifeEnergy5CostSaving == null ? ""
						: formatter.format((totalLifeEnergy5CostSaving))));
		
		  */
		


		// ENERGY PRODUCT FIRST YEAR
		savingsReportProductList.add(new SavingReportDisplayDTO(
				"Energy (Product First Year)", "", "", "", "", "", "", "", "",
				""));
		
		savingsReportProductList
				.add(new SavingReportDisplayDTO("ENERGY STAR 6.*",
						totalFirstEnergy5EnergySaving == null ? "" : formatter.format(
								(totalFirstEnergy5EnergySaving)),
								totalFirstEnergy5PrimaryMaterialsaving  == null ? ""
								: formatter.format((totalFirstEnergy5PrimaryMaterialsaving )),
						totalFirstEnergy5ghgEmissionSaving == null ? "" : formatter.format(
								(totalFirstEnergy5ghgEmissionSaving)),
								totalFirstEnergy5AirEmissionSaving == null ? "" : formatter.format(
								(totalFirstEnergy5AirEmissionSaving)),
										totalFirstEnergy5WaterEmissionSaving == null ? "" : formatter.format(
								(totalFirstEnergy5WaterEmissionSaving)), "",
						"", "",
										 totalFirstEnergy5CostSaving == null ? "" : formatter.format(
								( totalFirstEnergy5CostSaving))));
		
		//2017
		//remove subtotal
		/*
		savingsReportProductList
		.add(new SavingReportDisplayDTO("SUBTOTAL",
				totalFirstEnergy5EnergySaving == null ? "" : formatter.format(
						(totalFirstEnergy5EnergySaving)),
						totalFirstEnergy5PrimaryMaterialsaving  == null ? ""
						: formatter.format((totalFirstEnergy5PrimaryMaterialsaving )),
				totalFirstEnergy5ghgEmissionSaving == null ? "" : formatter.format(
						(totalFirstEnergy5ghgEmissionSaving)),
						totalFirstEnergy5AirEmissionSaving == null ? "" : formatter.format(
						(totalFirstEnergy5AirEmissionSaving)),
								totalFirstEnergy5WaterEmissionSaving == null ? "" : formatter.format(
						(totalFirstEnergy5WaterEmissionSaving)), "",
				"", "",
								 totalFirstEnergy5CostSaving == null ? "" : formatter.format(
						( totalFirstEnergy5CostSaving))));
	
		  */
		
		savingsReportProductList
		.add(new SavingReportDisplayDTO(
				"Purchasing Lifetime SUBTOTAL (All products)",
				EnergyLifeTotalSubEnergy == null ? "" : formatter.format(
						(EnergyLifeTotalSubEnergy)),
						EnergyLifeTotalSubPrimaryMaterialsaving == null ? ""
						: formatter.format((EnergyLifeTotalSubPrimaryMaterialsaving)),
						EnergyLifeTotalghgEmissionSaving == null ? "" : formatter.format(
						(EnergyLifeTotalghgEmissionSaving)),
						 EnergyLifeTotalAirEmissionSaving == null ? "" : formatter.format(
						(EnergyLifeTotalAirEmissionSaving)),
						EnergyLifeTotalWaterEmissionSaving == null ? "" : formatter.format(
						(EnergyLifeTotalWaterEmissionSaving)),
						totalToxicmaterialSubTotal == null ? "" : formatter.format(
								(totalToxicmaterialSubTotal)),
								EnergtLifeMuncipal == null ? "" : formatter.format(
										(EnergtLifeMuncipal)),
										totalHazWasteSubTotal == null ? "" : formatter.format(
												(totalHazWasteSubTotal)),
				EnergyLifeTotalCostSaving == null ? ""
						: formatter.format((EnergyLifeTotalCostSaving))));
		
		
		
		savingsReportProductList
		.add(new SavingReportDisplayDTO(
				"Purchasing First Year SUBTOTAL (All products)",
				EnergyFirstTotalSubEnergy == null ? "" : formatter.format(
						(EnergyFirstTotalSubEnergy)),
						EnergyFirstTotalSubPrimaryMaterialsaving == null ? ""
						: formatter.format((EnergyFirstTotalSubPrimaryMaterialsaving)),
						EnergyFirstTotalghgEmissionSaving == null ? "" : formatter.format(
						(EnergyFirstTotalghgEmissionSaving)),
						 EnergyFirstTotalAirEmissionSaving == null ? "" : formatter.format(
						(EnergyFirstTotalAirEmissionSaving)),
						EnergyFirstTotalWaterEmissionSaving == null ? "" : formatter.format(
						(EnergyFirstTotalWaterEmissionSaving)),
						totalToxicmaterialSubTotal == null ? "" : formatter.format(
								(totalToxicmaterialSubTotal)),
								EnergtLifeMuncipal == null ? "" : formatter.format(
										(EnergtLifeMuncipal)),
										"",
				EnergyLifeTotalCostSaving == null ? ""
						: formatter.format((EnergyFirstTotalCostSaving))));
		
		
		

		return savingsReportProductList;
		
		
	}

	// Display of one product

	public List<SavingReportDisplayDTO> generateSavingReportDisplayDTO(
			SavingsProductMainResultDTO savingsProductMainResultDTO) {

		List<SavingReportDisplayDTO> savingsReportProductList = new ArrayList<SavingReportDisplayDTO>();

		// energySavings;
		// primaryMaterialSavings;
		// ghgEmissionSaving;
		// airEmissionsaving;
		// waterEmissionSaving;
		// muncipalWasteSavings;
		// costSavings;
		// REDUCED TOXICITY
		savingsReportProductList.add(new SavingReportDisplayDTO(
				"REDUCED TOXICITY", "", "", "", "", "", "", "", "", ""));
		savingsReportProductList
				.add(new SavingReportDisplayDTO(
						"RoHs Compliance-Pb", "", "", "", "", "",
						savingsProductMainResultDTO
								.getToxicMaterialsavingsFromPb() == null ? ""
								: formatter.format(savingsProductMainResultDTO
										.getToxicMaterialsavingsFromPb()), "",
						savingsProductMainResultDTO.getHwSavings() == null ? ""
								: formatter.format((savingsProductMainResultDTO
										.getHwSavings())), ""));
		savingsReportProductList.add(new SavingReportDisplayDTO(
				"RoHs Compliance-Hg (excludes lamps)", "", "", "",
				"", "", savingsProductMainResultDTO
						.getToxicMaterialsavingsFromHg() == null ? "" : formatter.format(
						(savingsProductMainResultDTO
								.getToxicMaterialsavingsFromHg())), "", "", ""));
		savingsReportProductList.add(new SavingReportDisplayDTO(
				"Hg in light source; max avg of 3 mgHg/lamp", "",
				"", "", "", "", savingsProductMainResultDTO
						.getToxicMaterialsavingsFromHgInLightSrc() == null ? ""
						: formatter.format((savingsProductMainResultDTO
								.getToxicMaterialsavingsFromHgInLightSrc())),
				"", "", ""));
		savingsReportProductList
				.add(new SavingReportDisplayDTO(
						"Hg-free lamps",
						"",
						"",
						"",
						"",
						"",
						savingsProductMainResultDTO
								.getToxicMaterialsavingsFromHgFreeLamps() == null ? ""
								: formatter.format((savingsProductMainResultDTO
										.getToxicMaterialsavingsFromHgFreeLamps())),
						"", savingsProductMainResultDTO
								.getHwSavingsHgFreelamps() == null ? ""
								: formatter.format((savingsProductMainResultDTO
										.getHwSavingsHgFreelamps())), ""));
		savingsReportProductList
				.add(new SavingReportDisplayDTO(
						"RoHs Compliance-Cd", "", "", "", "", "",
						savingsProductMainResultDTO
								.getToxicMaterialsavingsFromCd() == null ? ""
								: formatter.format((savingsProductMainResultDTO
										.getToxicMaterialsavingsFromCd())), "",
						"", ""));
		savingsReportProductList
				.add(new SavingReportDisplayDTO(
						"RoHs Compliance-Cr6+", "", "", "", "", "",
						savingsProductMainResultDTO
								.getToxicMaterialsavingsFromCr6() == null ? ""
								: formatter.format((savingsProductMainResultDTO
										.getToxicMaterialsavingsFromCr6())), "",
						"", ""));
		savingsReportProductList
				.add(new SavingReportDisplayDTO(
						"RoHs Compliance-PBB", "", "", "", "", "",
						savingsProductMainResultDTO
								.getToxicMaterialsavingsFromPBB() == null ? ""
								: formatter.format((savingsProductMainResultDTO
										.getToxicMaterialsavingsFromPBB())), "",
						"", ""));
		savingsReportProductList
				.add(new SavingReportDisplayDTO(
						"RoHs Compliance-PBDE", "", "", "", "", "",
						savingsProductMainResultDTO
								.getToxicMaterialsavingsFromPBDE() == null ? ""
								: formatter.format((savingsProductMainResultDTO
										.getToxicMaterialsavingsFromPBDE())),
						"", "", ""));
		savingsReportProductList.add(new SavingReportDisplayDTO("Reduced Toxicity SUBTOTAL",
				"", "", "", "", "", savingsProductMainResultDTO
						.getTotaltoxicMaterialsavings() == null ? "" : formatter.format(
						(savingsProductMainResultDTO
								.getTotaltoxicMaterialsavings())), "",
				savingsProductMainResultDTO.getTotalHwSavings() == null ? ""
						: formatter.format((savingsProductMainResultDTO
								.getTotalHwSavings())), ""));

		// MATERIAL USE
		savingsReportProductList.add(new SavingReportDisplayDTO("MATERIAL USE",
				"", "", "", "", "", "", "", "", ""));
		savingsReportProductList
				.add(new SavingReportDisplayDTO(
						"Recycled content in product",
						savingsProductMainResultDTO.getMaterialuseSaving()
								.getEnergySavings() == null ? "" : formatter.format(
								(savingsProductMainResultDTO
										.getMaterialuseSaving()
										.getEnergySavings())),
						savingsProductMainResultDTO.getMaterialuseSaving()
								.getPrimaryMaterialSavings() == null ? ""
								: formatter.format((savingsProductMainResultDTO
										.getMaterialuseSaving()
										.getPrimaryMaterialSavings())),
						savingsProductMainResultDTO.getMaterialuseSaving()
								.getGhgEmissionSaving() == null ? "" : formatter.format(
								(savingsProductMainResultDTO
										.getMaterialuseSaving()
										.getGhgEmissionSaving())),
						savingsProductMainResultDTO.getMaterialuseSaving()
								.getAirEmissionsaving() == null ? "" : formatter.format(
								(savingsProductMainResultDTO
										.getMaterialuseSaving()
										.getAirEmissionsaving())),
						savingsProductMainResultDTO.getMaterialuseSaving()
								.getWaterEmissionSaving() == null ? "" : formatter.format(
								(savingsProductMainResultDTO
										.getMaterialuseSaving()
										.getWaterEmissionSaving())), "",
						savingsProductMainResultDTO.getMaterialuseSaving()
								.getMuncipalWasteSavings() == null ? ""
								: formatter.format((savingsProductMainResultDTO
										.getMaterialuseSaving()
										.getMuncipalWasteSavings())), "",
						savingsProductMainResultDTO.getMaterialuseSaving()
								.getCostSavings() == null ? "" : formatter.format(
								(savingsProductMainResultDTO
										.getMaterialuseSaving()
										.getCostSavings()))));
		
		savingsReportProductList
				.add(new SavingReportDisplayDTO("Material Use SUBTOTAL",
						savingsProductMainResultDTO.getMaterialuseSaving()
								.getEnergySavings() == null ? "" : formatter.format(
								(savingsProductMainResultDTO
										.getMaterialuseSaving()
										.getEnergySavings())),
						savingsProductMainResultDTO.getMaterialuseSaving()
								.getPrimaryMaterialSavings() == null ? ""
								: formatter.format((savingsProductMainResultDTO
										.getMaterialuseSaving()
										.getPrimaryMaterialSavings())),
						savingsProductMainResultDTO.getMaterialuseSaving()
								.getGhgEmissionSaving() == null ? "" : formatter.format(
								(savingsProductMainResultDTO
										.getMaterialuseSaving()
										.getGhgEmissionSaving())),
						savingsProductMainResultDTO.getMaterialuseSaving()
								.getAirEmissionsaving() == null ? "" : formatter.format(
								(savingsProductMainResultDTO
										.getMaterialuseSaving()
										.getAirEmissionsaving())),
						savingsProductMainResultDTO.getMaterialuseSaving()
								.getWaterEmissionSaving() == null ? "" : formatter.format(
								(savingsProductMainResultDTO
										.getMaterialuseSaving()
										.getWaterEmissionSaving())), "",
						savingsProductMainResultDTO.getMaterialuseSaving()
								.getMuncipalWasteSavings() == null ? ""
								: formatter.format((savingsProductMainResultDTO
										.getMaterialuseSaving()
										.getMuncipalWasteSavings())), "",
						savingsProductMainResultDTO.getMaterialuseSaving()
								.getCostSavings() == null ? "" : formatter.format(
								(savingsProductMainResultDTO
										.getMaterialuseSaving()
										.getCostSavings()))));

		// PACKAGING
		savingsReportProductList.add(new SavingReportDisplayDTO("PACKAGING",
				"", "", "", "", "", "", "", "", ""));
		savingsReportProductList
				.add(new SavingReportDisplayDTO(
						"Average recycled content in corrugated packaging",
						savingsProductMainResultDTO.getRecycleSaving()
								.getEnergySavings() == null ? "" : formatter.format(
								(savingsProductMainResultDTO
										.getRecycleSaving().getEnergySavings())),
						savingsProductMainResultDTO.getRecycleSaving()
								.getPrimaryMaterialSavings() == null ? ""
								: formatter.format((savingsProductMainResultDTO
										.getRecycleSaving()
										.getPrimaryMaterialSavings())),
						savingsProductMainResultDTO.getRecycleSaving()
								.getGhgEmissionSaving() == null ? "" : formatter.format(
								(savingsProductMainResultDTO
										.getRecycleSaving()
										.getGhgEmissionSaving())),
						savingsProductMainResultDTO.getRecycleSaving()
								.getAirEmissionsaving() == null ? "" : formatter.format(
								(savingsProductMainResultDTO
										.getRecycleSaving()
										.getAirEmissionsaving())),
						savingsProductMainResultDTO.getRecycleSaving()
								.getWaterEmissionSaving() == null ? "" : formatter.format(
								(savingsProductMainResultDTO
										.getRecycleSaving()
										.getWaterEmissionSaving())), "",
						savingsProductMainResultDTO.getRecycleSaving()
								.getMuncipalWasteSavings() == null ? ""
								: formatter.format((savingsProductMainResultDTO
										.getRecycleSaving()
										.getMuncipalWasteSavings())), "",
						savingsProductMainResultDTO.getRecycleSaving()
								.getCostSavings() == null ? "" : formatter.format(
								(savingsProductMainResultDTO
										.getRecycleSaving().getCostSavings()))));
		savingsReportProductList
				.add(new SavingReportDisplayDTO(
						"Average recycled content in plastic/foam packaging",
						savingsProductMainResultDTO.getPackagingSaving()
								.getEnergySavings() == null ? "" : formatter.format(
								(savingsProductMainResultDTO
										.getPackagingSaving()
										.getEnergySavings())),
						savingsProductMainResultDTO.getPackagingSaving()
								.getPrimaryMaterialSavings() == null ? ""
								: formatter.format((savingsProductMainResultDTO
										.getPackagingSaving()
										.getPrimaryMaterialSavings())),
						savingsProductMainResultDTO.getPackagingSaving()
								.getGhgEmissionSaving() == null ? "" : formatter.format(
								(savingsProductMainResultDTO
										.getPackagingSaving()
										.getGhgEmissionSaving())),
						savingsProductMainResultDTO.getPackagingSaving()
								.getAirEmissionsaving() == null ? "" : formatter.format(
								(savingsProductMainResultDTO
										.getPackagingSaving()
										.getAirEmissionsaving())),
						savingsProductMainResultDTO.getPackagingSaving()
								.getWaterEmissionSaving() == null ? "" : formatter.format(
								(savingsProductMainResultDTO
										.getPackagingSaving()
										.getWaterEmissionSaving())), "",
						savingsProductMainResultDTO.getPackagingSaving()
								.getMuncipalWasteSavings() == null ? ""
								: formatter.format((savingsProductMainResultDTO
										.getPackagingSaving()
										.getMuncipalWasteSavings())), "",
						savingsProductMainResultDTO.getPackagingSaving()
								.getCostSavings() == null ? "" : formatter.format(
								(savingsProductMainResultDTO
										.getPackagingSaving().getCostSavings()))));
		savingsReportProductList.add(new SavingReportDisplayDTO(
				"Average recycled content in other packaging",
				savingsProductMainResultDTO.getOtherPackagingSaving()
						.getEnergySavings() == null ? "" : formatter.format(
						(savingsProductMainResultDTO
								.getOtherPackagingSaving().getEnergySavings())),
				savingsProductMainResultDTO.getOtherPackagingSaving()
						.getPrimaryMaterialSavings() == null ? "" : formatter.format(
						(savingsProductMainResultDTO
								.getOtherPackagingSaving()
								.getPrimaryMaterialSavings())),
				savingsProductMainResultDTO.getOtherPackagingSaving()
						.getGhgEmissionSaving() == null ? "" : formatter.format(
						(savingsProductMainResultDTO
								.getOtherPackagingSaving()
								.getGhgEmissionSaving())),
				savingsProductMainResultDTO.getOtherPackagingSaving()
						.getAirEmissionsaving() == null ? "" : formatter.format(
						(savingsProductMainResultDTO
								.getOtherPackagingSaving()
								.getAirEmissionsaving())),
				savingsProductMainResultDTO.getOtherPackagingSaving()
						.getWaterEmissionSaving() == null ? "" : formatter.format(
						(savingsProductMainResultDTO
								.getOtherPackagingSaving()
								.getWaterEmissionSaving())), "",
				savingsProductMainResultDTO.getOtherPackagingSaving()
						.getMuncipalWasteSavings() == null ? "" : formatter.format(
						(savingsProductMainResultDTO
								.getOtherPackagingSaving()
								.getMuncipalWasteSavings())), "",
				savingsProductMainResultDTO.getOtherPackagingSaving()
						.getCostSavings() == null ? "" : formatter.format(
						(savingsProductMainResultDTO
								.getOtherPackagingSaving().getCostSavings()))));
		savingsReportProductList
				.add(new SavingReportDisplayDTO(
						"Minimum 25% for recycled content in corrugated packaging (CPG)",
						savingsProductMainResultDTO.getRecycleContentInCPG()
								.getEnergySavings() == null ? "" : formatter.format(
								(savingsProductMainResultDTO
										.getRecycleContentInCPG()
										.getEnergySavings())),
						savingsProductMainResultDTO.getRecycleContentInCPG()
								.getPrimaryMaterialSavings() == null ? ""
								: formatter.format((savingsProductMainResultDTO
										.getRecycleContentInCPG()
										.getPrimaryMaterialSavings())),
						savingsProductMainResultDTO.getRecycleContentInCPG()
								.getGhgEmissionSaving() == null ? "" : formatter.format(
								(savingsProductMainResultDTO
										.getRecycleContentInCPG()
										.getGhgEmissionSaving())),
						savingsProductMainResultDTO.getRecycleContentInCPG()
								.getAirEmissionsaving() == null ? "" : formatter.format(
								(savingsProductMainResultDTO
										.getRecycleContentInCPG()
										.getAirEmissionsaving())),
						savingsProductMainResultDTO.getRecycleContentInCPG()
								.getWaterEmissionSaving() == null ? "" : formatter.format(
								(savingsProductMainResultDTO
										.getRecycleContentInCPG()
										.getWaterEmissionSaving())), "",
						savingsProductMainResultDTO.getRecycleContentInCPG()
								.getMuncipalWasteSavings() == null ? ""
								: formatter.format((savingsProductMainResultDTO
										.getRecycleContentInCPG()
										.getMuncipalWasteSavings())), "",
						savingsProductMainResultDTO.getRecycleContentInCPG()
								.getCostSavings() == null ? "" : formatter.format(
								(savingsProductMainResultDTO
										.getRecycleContentInCPG()
										.getCostSavings()))));
		savingsReportProductList.add(new SavingReportDisplayDTO(
				"Packaging avoided per unit by packaging reuse",
				savingsProductMainResultDTO.getPackagingReuse()
						.getEnergySavings() == null ? "" : formatter.format(
						(savingsProductMainResultDTO
								.getPackagingReuse().getEnergySavings())),
				savingsProductMainResultDTO.getPackagingReuse()
						.getPrimaryMaterialSavings() == null ? "" : formatter.format(
						(savingsProductMainResultDTO
								.getPackagingReuse()
								.getPrimaryMaterialSavings())),
				savingsProductMainResultDTO.getPackagingReuse()
						.getGhgEmissionSaving() == null ? "" : formatter.format(
						(savingsProductMainResultDTO
								.getPackagingReuse().getGhgEmissionSaving())),
				savingsProductMainResultDTO.getPackagingReuse()
						.getAirEmissionsaving() == null ? "" : formatter.format(
						(savingsProductMainResultDTO
								.getPackagingReuse().getAirEmissionsaving())),
				savingsProductMainResultDTO.getPackagingReuse()
						.getWaterEmissionSaving() == null ? "" : formatter.format(
						(savingsProductMainResultDTO
								.getPackagingReuse().getWaterEmissionSaving())),
				"", savingsProductMainResultDTO.getPackagingReuse()
						.getMuncipalWasteSavings() == null ? "" : formatter.format(
						(savingsProductMainResultDTO
								.getPackagingReuse()
								.getMuncipalWasteSavings())), "",
				savingsProductMainResultDTO.getMaterialuseSaving()
						.getCostSavings() == null ? "" : formatter.format(
						(savingsProductMainResultDTO.getPackagingReuse().getCostSavings()))));
		savingsReportProductList
				.add(new SavingReportDisplayDTO("Packaging SUBTOTAL",
						savingsProductMainResultDTO.getPackagingSubTotal()
								.getEnergySavings() == null ? "" : formatter.format(
								(savingsProductMainResultDTO
										.getPackagingSubTotal()
										.getEnergySavings())),
						savingsProductMainResultDTO.getPackagingSubTotal()
								.getPrimaryMaterialSavings() == null ? ""
								: formatter.format((savingsProductMainResultDTO
										.getPackagingSubTotal()
										.getPrimaryMaterialSavings())),
						savingsProductMainResultDTO.getPackagingSubTotal()
								.getGhgEmissionSaving() == null ? "" : formatter.format(
								(savingsProductMainResultDTO
										.getPackagingSubTotal()
										.getGhgEmissionSaving())),
						savingsProductMainResultDTO.getPackagingSubTotal()
								.getAirEmissionsaving() == null ? "" : formatter.format(
								(savingsProductMainResultDTO
										.getPackagingSubTotal()
										.getAirEmissionsaving())),
						savingsProductMainResultDTO.getPackagingSubTotal()
								.getWaterEmissionSaving() == null ? "" : formatter.format(
								(savingsProductMainResultDTO
										.getPackagingSubTotal()
										.getWaterEmissionSaving())), "",
						savingsProductMainResultDTO.getPackagingSubTotal()
								.getMuncipalWasteSavings() == null ? ""
								: formatter.format((savingsProductMainResultDTO
										.getPackagingSubTotal()
										.getMuncipalWasteSavings())), "",
						savingsProductMainResultDTO.getPackagingSubTotal()
								.getCostSavings() == null ? "" : formatter.format(
								(savingsProductMainResultDTO
										.getPackagingSubTotal()
										.getCostSavings()))));

		// ENERGY PRODUCT FIRST YEAR
		savingsReportProductList
				.add(new SavingReportDisplayDTO("Energy (Product Lifetime)",
						"", "", "", "", "", "", "", "", ""));
		savingsReportProductList
				.add(new SavingReportDisplayDTO(
						"ENERGY STAR 6.*",
						savingsProductMainResultDTO.getEnergySaving5Life()
								.getEnergySaving() == null ? "" : formatter.format(
								(savingsProductMainResultDTO
										.getEnergySaving5Life()
										.getEnergySaving())),
						savingsProductMainResultDTO.getEnergySaving5Life()
								.getPrimaryMaterialSaving() == null ? ""
								: formatter.format((savingsProductMainResultDTO
										.getEnergySaving5Life()
										.getPrimaryMaterialSaving())),
						savingsProductMainResultDTO.getEnergySaving5Life()
								.getGhgEmissionSaving() == null ? "" : formatter.format(
								(savingsProductMainResultDTO
										.getEnergySaving5Life()
										.getGhgEmissionSaving())),
						savingsProductMainResultDTO.getEnergySaving5Life()
								.getAirEmissionsaving() == null ? "" : formatter.format(
								(savingsProductMainResultDTO
										.getEnergySaving5Life()
										.getAirEmissionsaving())),
						savingsProductMainResultDTO.getEnergySaving5Life()
								.getWaterEmissionSaving() == null ? "" : formatter.format(
								(savingsProductMainResultDTO
										.getEnergySaving5Life()
										.getWaterEmissionSaving())),
						"",
						savingsProductMainResultDTO.getEnergySaving5Life()
								.getMuncipalWasteSaving() == null ? "" : formatter.format(
								(savingsProductMainResultDTO
										.getEnergySaving5Life()
										.getMuncipalWasteSaving())),
						"",
						savingsProductMainResultDTO.getEnergySaving5Life()
								.getCostSaving() == null ? ""
								: formatter.format((savingsProductMainResultDTO
										.getEnergySaving5Life().getCostSaving()))));
	

		// ENERGY PRODUCT FIRST YEAR
		savingsReportProductList.add(new SavingReportDisplayDTO(
				"Energy (Product First Year)", "", "", "", "", "", "", "", "",
				""));
		savingsReportProductList
				.add(new SavingReportDisplayDTO("ENERGY STAR 6.*",
						savingsProductMainResultDTO.getEnergySaving5First()
								.getEnergySaving() == null ? "" : formatter.format(
								(savingsProductMainResultDTO
										.getEnergySaving5First()
										.getEnergySaving())),
						savingsProductMainResultDTO.getEnergySaving5First()
								.getPrimaryMaterialSaving() == null ? ""
								: formatter.format((savingsProductMainResultDTO
										.getEnergySaving5First()
										.getPrimaryMaterialSaving())),
						savingsProductMainResultDTO.getEnergySaving5First()
								.getGhgEmissionSaving() == null ? "" : formatter.format(
								(savingsProductMainResultDTO
										.getEnergySaving5First()
										.getGhgEmissionSaving())),
						savingsProductMainResultDTO.getEnergySaving5First()
								.getAirEmissionsaving() == null ? "" : formatter.format(
								(savingsProductMainResultDTO
										.getEnergySaving5First()
										.getAirEmissionsaving())),
						savingsProductMainResultDTO.getEnergySaving5First()
								.getWaterEmissionSaving() == null ? "" : formatter.format(
								(savingsProductMainResultDTO
										.getEnergySaving5First()
										.getWaterEmissionSaving())), "",
						savingsProductMainResultDTO.getEnergySaving5First()
								.getMuncipalWasteSaving() == null ? "" : formatter.format(
								(savingsProductMainResultDTO
										.getEnergySaving5First()
										.getMuncipalWasteSaving())), "",
						savingsProductMainResultDTO.getEnergySaving5First()
								.getCostSaving() == null ? "" : formatter.format(
								(savingsProductMainResultDTO
										.getEnergySaving5First()
										.getCostSaving()))));
	
		
		savingsReportProductList
		.add(new SavingReportDisplayDTO(
				"Purchasing Lifetime SUBTOTAL For Product",
				savingsProductMainResultDTO.getLifetimeSubTotal()
						.getEnergySaving() == null ? "" : formatter.format(
						(savingsProductMainResultDTO
								.getLifetimeSubTotal()
								.getEnergySaving())),
				savingsProductMainResultDTO.getLifetimeSubTotal()
						.getPrimaryMaterialSaving() == null ? ""
						: formatter.format((savingsProductMainResultDTO
								.getLifetimeSubTotal()
								.getPrimaryMaterialSaving())),
				savingsProductMainResultDTO.getLifetimeSubTotal()
						.getGhgEmissionSaving() == null ? "" : formatter.format(
						(savingsProductMainResultDTO
								.getLifetimeSubTotal()
								.getGhgEmissionSaving())),
				savingsProductMainResultDTO.getLifetimeSubTotal()
						.getAirEmissionsaving() == null ? "" : formatter.format(
						(savingsProductMainResultDTO
								.getLifetimeSubTotal()
								.getAirEmissionsaving())),
				savingsProductMainResultDTO.getLifetimeSubTotal()
						.getWaterEmissionSaving() == null ? "" : formatter.format(
						(savingsProductMainResultDTO
								.getLifetimeSubTotal()
								.getWaterEmissionSaving())), 
				savingsProductMainResultDTO
								.getTotaltoxicMaterialsavings() == null ? "" : formatter.format(
										(savingsProductMainResultDTO
												.getTotaltoxicMaterialsavings())),
				savingsProductMainResultDTO.getLifetimeSubTotal().getMuncipalWasteSaving() == null ? ""
												: formatter.format((savingsProductMainResultDTO.getLifetimeSubTotal().getMuncipalWasteSaving())), 
				savingsProductMainResultDTO.getTotalHwSavings() == null ? ""
																: formatter.format((savingsProductMainResultDTO
																		.getTotalHwSavings())),
				savingsProductMainResultDTO.getLifetimeSubTotal()
						.getCostSaving() == null ? "" : formatter.format(
						(savingsProductMainResultDTO
								.getLifetimeSubTotal().getCostSaving()))));

		savingsReportProductList
				.add(new SavingReportDisplayDTO(
						"Purchasing First Year SUBTOTAL For Product",
						savingsProductMainResultDTO.getFirstYearSubTotal()
								.getEnergySaving() == null ? "" : formatter.format(
								(savingsProductMainResultDTO
										.getFirstYearSubTotal()
										.getEnergySaving())),
						savingsProductMainResultDTO.getFirstYearSubTotal()
								.getPrimaryMaterialSaving() == null ? ""
								: formatter.format((savingsProductMainResultDTO
										.getFirstYearSubTotal()
										.getPrimaryMaterialSaving())),
						savingsProductMainResultDTO.getFirstYearSubTotal()
								.getGhgEmissionSaving() == null ? "" : formatter.format(
								(savingsProductMainResultDTO
										.getFirstYearSubTotal()
										.getGhgEmissionSaving())),
						savingsProductMainResultDTO.getFirstYearSubTotal()
								.getAirEmissionsaving() == null ? "" : formatter.format(
								(savingsProductMainResultDTO
										.getFirstYearSubTotal()
										.getAirEmissionsaving())),
						savingsProductMainResultDTO.getFirstYearSubTotal()
								.getWaterEmissionSaving() == null ? "" : formatter.format(
								(savingsProductMainResultDTO
										.getFirstYearSubTotal()
										.getWaterEmissionSaving())),
										savingsProductMainResultDTO
										.getTotaltoxicMaterialsavings() == null ? "" : formatter.format(
										(savingsProductMainResultDTO
												.getTotaltoxicMaterialsavings())),
												savingsProductMainResultDTO.getFirstYearSubTotal()
												.getMuncipalWasteSaving() == null ? ""
												: formatter.format((savingsProductMainResultDTO.getFirstYearSubTotal()
														.getMuncipalWasteSaving())),
														"",
						savingsProductMainResultDTO.getFirstYearSubTotal()
								.getCostSaving() == null ? ""
								: formatter.format((savingsProductMainResultDTO
										.getFirstYearSubTotal().getCostSaving()))));


		return savingsReportProductList;

	}

	// Display of EOL
	public List<SavingReportDisplayDTO> generateEOLDisplayDTO(
			SavingsEOLMainResultDTO savingsEOLMainResultDTO) {

		List<SavingReportDisplayDTO> savingsReportProductList = new ArrayList<SavingReportDisplayDTO>();

		// energySavings;
		// primaryMaterialSavings;
		// ghgEmissionSaving;
		// airEmissionsaving;
		// waterEmissionSaving;
		// muncipalWasteSavings;
		// costSavings;

		// EOL Reuse
		savingsReportProductList.add(new SavingReportDisplayDTO(
				"End-of-Life Management", "", "", "", "", "", "", "", "", ""));
		savingsReportProductList
				.add(new SavingReportDisplayDTO(
						"Computer and monitor reuse ",
						savingsEOLMainResultDTO.getComputerAndMonitorReuse()
								.getEnergySavings() == null ? "" : formatter.format(
								(savingsEOLMainResultDTO
										.getComputerAndMonitorReuse()
										.getEnergySavings())),
						savingsEOLMainResultDTO.getComputerAndMonitorReuse()
								.getPrimaryMaterialSavings() == null ? ""
								: formatter.format((savingsEOLMainResultDTO
										.getComputerAndMonitorReuse()
										.getPrimaryMaterialSavings())),
						savingsEOLMainResultDTO.getComputerAndMonitorReuse()
								.getGhgEmissionSaving() == null ? "" : formatter.format(
								(savingsEOLMainResultDTO
										.getComputerAndMonitorReuse()
										.getGhgEmissionSaving())),
						savingsEOLMainResultDTO.getComputerAndMonitorReuse()
								.getAirEmissionsaving() == null ? "" : formatter.format(
								(savingsEOLMainResultDTO
										.getComputerAndMonitorReuse()
										.getAirEmissionsaving())),
						savingsEOLMainResultDTO.getComputerAndMonitorReuse()
								.getWaterEmissionSaving() == null ? "" : formatter.format(
								(savingsEOLMainResultDTO
										.getComputerAndMonitorReuse()
										.getWaterEmissionSaving())),
						savingsEOLMainResultDTO.getComputerAndMonitorReuse()
								.getToxicMaterialSavings() == null ? ""
								: formatter.format((savingsEOLMainResultDTO
										.getComputerAndMonitorReuse()
										.getToxicMaterialSavings())),
						savingsEOLMainResultDTO.getComputerAndMonitorReuse()
								.getMuncipalWasteSavings() == null ? ""
								: formatter.format((savingsEOLMainResultDTO
										.getComputerAndMonitorReuse()
										.getMuncipalWasteSavings())),
						savingsEOLMainResultDTO.getComputerAndMonitorReuse()
								.getHazardWasteSavings() == null ? "" : formatter.format(
								(savingsEOLMainResultDTO
										.getComputerAndMonitorReuse()
										.getHazardWasteSavings())),
						savingsEOLMainResultDTO.getComputerAndMonitorReuse()
								.getCostSavings() == null ? "" : formatter.format(
								(savingsEOLMainResultDTO
										.getComputerAndMonitorReuse()
										.getCostSavings()))));
		savingsReportProductList
				.add(new SavingReportDisplayDTO(
						"Mobile phone reuse",
						savingsEOLMainResultDTO.getMobilePhoneReuse()
								.getEnergySavings() == null ? "" : formatter.format(
								(savingsEOLMainResultDTO
										.getMobilePhoneReuse()
										.getEnergySavings())),
						savingsEOLMainResultDTO.getMobilePhoneReuse()
								.getPrimaryMaterialSavings() == null ? ""
								: formatter.format((savingsEOLMainResultDTO
										.getMobilePhoneReuse()
										.getPrimaryMaterialSavings())),
						savingsEOLMainResultDTO.getMobilePhoneReuse()
								.getGhgEmissionSaving() == null ? "" : formatter.format(
								(savingsEOLMainResultDTO
										.getMobilePhoneReuse()
										.getGhgEmissionSaving())),
						savingsEOLMainResultDTO.getMobilePhoneReuse()
								.getAirEmissionsaving() == null ? "" : formatter.format(
								(savingsEOLMainResultDTO
										.getMobilePhoneReuse()
										.getAirEmissionsaving())),
						savingsEOLMainResultDTO.getMobilePhoneReuse()
								.getWaterEmissionSaving() == null ? "" : formatter.format(
								(savingsEOLMainResultDTO
										.getMobilePhoneReuse()
										.getWaterEmissionSaving())),
						savingsEOLMainResultDTO.getMobilePhoneReuse()
								.getToxicMaterialSavings() == null ? ""
								: formatter.format((savingsEOLMainResultDTO
										.getMobilePhoneReuse()
										.getToxicMaterialSavings())),
						savingsEOLMainResultDTO.getMobilePhoneReuse()
								.getMuncipalWasteSavings() == null ? ""
								: formatter.format((savingsEOLMainResultDTO
										.getMobilePhoneReuse()
										.getMuncipalWasteSavings())),
						savingsEOLMainResultDTO.getMobilePhoneReuse()
								.getHazardWasteSavings() == null ? "" : formatter.format(
								(savingsEOLMainResultDTO
										.getMobilePhoneReuse()
										.getHazardWasteSavings())),
						savingsEOLMainResultDTO.getMobilePhoneReuse()
								.getCostSavings() == null ? ""
								: formatter.format((savingsEOLMainResultDTO
										.getMobilePhoneReuse().getCostSavings()))));
		savingsReportProductList.add(new SavingReportDisplayDTO(
				"Reuse SUBTOTAL (All Products)",
				savingsEOLMainResultDTO.getTotalSavingsEOLReuse()
						.getEnergySavings() == null ? "" : formatter.format(
						(savingsEOLMainResultDTO
								.getTotalSavingsEOLReuse().getEnergySavings())),
				savingsEOLMainResultDTO.getTotalSavingsEOLReuse()
						.getPrimaryMaterialSavings() == null ? "" : formatter.format(
						(savingsEOLMainResultDTO
								.getTotalSavingsEOLReuse()
								.getPrimaryMaterialSavings())),
				savingsEOLMainResultDTO.getTotalSavingsEOLReuse()
						.getGhgEmissionSaving() == null ? "" : formatter.format(
						(savingsEOLMainResultDTO
								.getTotalSavingsEOLReuse()
								.getGhgEmissionSaving())),
				savingsEOLMainResultDTO.getTotalSavingsEOLReuse()
						.getAirEmissionsaving() == null ? "" : formatter.format(
						(savingsEOLMainResultDTO
								.getTotalSavingsEOLReuse()
								.getAirEmissionsaving())),
				savingsEOLMainResultDTO.getTotalSavingsEOLReuse()
						.getWaterEmissionSaving() == null ? "" : formatter.format(
						(savingsEOLMainResultDTO
								.getTotalSavingsEOLReuse()
								.getWaterEmissionSaving())),
				savingsEOLMainResultDTO.getTotalSavingsEOLReuse()
						.getToxicMaterialSavings() == null ? "" : formatter.format(
						(savingsEOLMainResultDTO
								.getTotalSavingsEOLReuse()
								.getToxicMaterialSavings())),
				savingsEOLMainResultDTO.getTotalSavingsEOLReuse()
						.getMuncipalWasteSavings() == null ? "" : formatter.format(
						(savingsEOLMainResultDTO
								.getTotalSavingsEOLReuse()
								.getMuncipalWasteSavings())),
				savingsEOLMainResultDTO.getTotalSavingsEOLReuse()
						.getHazardWasteSavings() == null ? "" : formatter.format(
						(savingsEOLMainResultDTO
								.getTotalSavingsEOLReuse()
								.getHazardWasteSavings())),
				savingsEOLMainResultDTO.getTotalSavingsEOLReuse()
						.getCostSavings() == null ? "" : formatter.format(
						(savingsEOLMainResultDTO
								.getTotalSavingsEOLReuse().getCostSavings()))));

		// EOL Recycle
		//Dev notes: remove End-Of-Life Management 
		//03/08/2017
		//savingsReportProductList.add(new SavingReportDisplayDTO(
						//"End-Of-Life Management", "", "", "", "", "", "", "", "", ""));
		
		savingsReportProductList.add(new SavingReportDisplayDTO(
				"Computer and monitor recycling",
				savingsEOLMainResultDTO.getComputerAndMonitorRecycle()
						.getEnergySavings() == null ? "" : formatter.format(
						(savingsEOLMainResultDTO
								.getComputerAndMonitorRecycle()
								.getEnergySavings())), savingsEOLMainResultDTO
						.getComputerAndMonitorRecycle()
						.getPrimaryMaterialSavings() == null ? "" : formatter.format(
						(savingsEOLMainResultDTO
								.getComputerAndMonitorRecycle()
								.getPrimaryMaterialSavings())),
				savingsEOLMainResultDTO.getComputerAndMonitorRecycle()
						.getGhgEmissionSaving() == null ? "" : formatter.format(
						(savingsEOLMainResultDTO
								.getComputerAndMonitorRecycle()
								.getGhgEmissionSaving())),
				savingsEOLMainResultDTO.getComputerAndMonitorRecycle()
						.getAirEmissionsaving() == null ? "" : formatter.format(
						(savingsEOLMainResultDTO
								.getComputerAndMonitorRecycle()
								.getAirEmissionsaving())),
				savingsEOLMainResultDTO.getComputerAndMonitorRecycle()
						.getWaterEmissionSaving() == null ? "" : formatter.format(
						(savingsEOLMainResultDTO
								.getComputerAndMonitorRecycle()
								.getWaterEmissionSaving())),
				savingsEOLMainResultDTO.getComputerAndMonitorRecycle()
						.getToxicMaterialSavings() == null ? "" : formatter.format(
						(savingsEOLMainResultDTO
								.getComputerAndMonitorRecycle()
								.getToxicMaterialSavings())),
				savingsEOLMainResultDTO.getComputerAndMonitorRecycle()
						.getMuncipalWasteSavings() == null ? "" : formatter.format(
						(savingsEOLMainResultDTO
								.getComputerAndMonitorRecycle()
								.getMuncipalWasteSavings())),
				savingsEOLMainResultDTO.getComputerAndMonitorRecycle()
						.getHazardWasteSavings() == null ? "" : formatter.format(
						(savingsEOLMainResultDTO
								.getComputerAndMonitorRecycle()
								.getHazardWasteSavings())),
				savingsEOLMainResultDTO.getComputerAndMonitorRecycle()
						.getCostSavings() == null ? "" : formatter.format(
						(savingsEOLMainResultDTO
								.getComputerAndMonitorRecycle()
								.getCostSavings()))));
		savingsReportProductList
				.add(new SavingReportDisplayDTO("Mobile phone recycling",
						savingsEOLMainResultDTO.getMobilePhoneRecycle()
								.getEnergySavings() == null ? "" : formatter.format(
								(savingsEOLMainResultDTO
										.getMobilePhoneRecycle()
										.getEnergySavings())),
						savingsEOLMainResultDTO.getMobilePhoneRecycle()
								.getPrimaryMaterialSavings() == null ? ""
								: formatter.format((savingsEOLMainResultDTO
										.getMobilePhoneRecycle()
										.getPrimaryMaterialSavings())),
						savingsEOLMainResultDTO.getMobilePhoneRecycle()
								.getGhgEmissionSaving() == null ? "" : formatter.format(
								(savingsEOLMainResultDTO
										.getMobilePhoneRecycle()
										.getGhgEmissionSaving())),
						savingsEOLMainResultDTO.getMobilePhoneRecycle()
								.getAirEmissionsaving() == null ? "" : formatter.format(
								(savingsEOLMainResultDTO
										.getMobilePhoneRecycle()
										.getAirEmissionsaving())),
						savingsEOLMainResultDTO.getMobilePhoneRecycle()
								.getWaterEmissionSaving() == null ? "" : formatter.format(
								(savingsEOLMainResultDTO
										.getMobilePhoneRecycle()
										.getWaterEmissionSaving())),
						savingsEOLMainResultDTO.getMobilePhoneRecycle()
								.getToxicMaterialSavings() == null ? ""
								: formatter.format((savingsEOLMainResultDTO
										.getMobilePhoneRecycle()
										.getToxicMaterialSavings())),
						savingsEOLMainResultDTO.getMobilePhoneRecycle()
								.getMuncipalWasteSavings() == null ? ""
								: formatter.format((savingsEOLMainResultDTO
										.getMobilePhoneRecycle()
										.getMuncipalWasteSavings())),
						savingsEOLMainResultDTO.getMobilePhoneRecycle()
								.getHazardWasteSavings() == null ? "" : formatter.format(
								(savingsEOLMainResultDTO
										.getMobilePhoneRecycle()
										.getHazardWasteSavings())),
						savingsEOLMainResultDTO.getMobilePhoneRecycle()
								.getCostSavings() == null ? "" : formatter.format(
								(savingsEOLMainResultDTO
										.getMobilePhoneRecycle()
										.getCostSavings()))));
		savingsReportProductList.add(new SavingReportDisplayDTO(
				"Mixed electronics recycling",
				savingsEOLMainResultDTO.getMixedofficeElectronicsRecycle()
						.getEnergySavings() == null ? "" : formatter.format(
						(savingsEOLMainResultDTO
								.getMixedofficeElectronicsRecycle()
								.getEnergySavings())), savingsEOLMainResultDTO
						.getMixedofficeElectronicsRecycle()
						.getPrimaryMaterialSavings() == null ? "" : formatter.format(
						(savingsEOLMainResultDTO
								.getMixedofficeElectronicsRecycle()
								.getPrimaryMaterialSavings())),
				savingsEOLMainResultDTO.getMixedofficeElectronicsRecycle()
						.getGhgEmissionSaving() == null ? "" : formatter.format(
						(savingsEOLMainResultDTO
								.getMixedofficeElectronicsRecycle()
								.getGhgEmissionSaving())),
				savingsEOLMainResultDTO.getMixedofficeElectronicsRecycle()
						.getAirEmissionsaving() == null ? "" : formatter.format(
						(savingsEOLMainResultDTO
								.getMixedofficeElectronicsRecycle()
								.getAirEmissionsaving())),
				savingsEOLMainResultDTO.getMixedofficeElectronicsRecycle()
						.getWaterEmissionSaving() == null ? "" : formatter.format(
						(savingsEOLMainResultDTO
								.getMixedofficeElectronicsRecycle()
								.getWaterEmissionSaving())),
				savingsEOLMainResultDTO.getMixedofficeElectronicsRecycle()
						.getToxicMaterialSavings() == null ? "" : formatter.format(
						(savingsEOLMainResultDTO
								.getMixedofficeElectronicsRecycle()
								.getToxicMaterialSavings())),
				savingsEOLMainResultDTO.getMixedofficeElectronicsRecycle()
						.getMuncipalWasteSavings() == null ? "" : formatter.format(
						(savingsEOLMainResultDTO
								.getMixedofficeElectronicsRecycle()
								.getMuncipalWasteSavings())),
				savingsEOLMainResultDTO.getMixedofficeElectronicsRecycle()
						.getHazardWasteSavings() == null ? "" : formatter.format(
						(savingsEOLMainResultDTO
								.getMixedofficeElectronicsRecycle()
								.getHazardWasteSavings())),
				savingsEOLMainResultDTO.getMixedofficeElectronicsRecycle()
						.getCostSavings() == null ? "" : formatter.format(
						(savingsEOLMainResultDTO
								.getMixedofficeElectronicsRecycle()
								.getCostSavings()))));
		savingsReportProductList
				.add(new SavingReportDisplayDTO(
						"Recycling SUBTOTAL (All Products)",
						savingsEOLMainResultDTO.getTotalSavingsEOLRecycle()
								.getEnergySavings() == null ? "" : formatter.format(
								(savingsEOLMainResultDTO
										.getTotalSavingsEOLRecycle()
										.getEnergySavings())),
						savingsEOLMainResultDTO.getTotalSavingsEOLRecycle()
								.getPrimaryMaterialSavings() == null ? ""
								: formatter.format((savingsEOLMainResultDTO
										.getTotalSavingsEOLRecycle()
										.getPrimaryMaterialSavings())),
						savingsEOLMainResultDTO.getTotalSavingsEOLRecycle()
								.getGhgEmissionSaving() == null ? "" : formatter.format(
								(savingsEOLMainResultDTO
										.getTotalSavingsEOLRecycle()
										.getGhgEmissionSaving())),
						savingsEOLMainResultDTO.getTotalSavingsEOLRecycle()
								.getAirEmissionsaving() == null ? "" : formatter.format(
								(savingsEOLMainResultDTO
										.getTotalSavingsEOLRecycle()
										.getAirEmissionsaving())),
						savingsEOLMainResultDTO.getTotalSavingsEOLRecycle()
								.getWaterEmissionSaving() == null ? "" : formatter.format(
								(savingsEOLMainResultDTO
										.getTotalSavingsEOLRecycle()
										.getWaterEmissionSaving())),
						savingsEOLMainResultDTO.getTotalSavingsEOLRecycle()
								.getToxicMaterialSavings() == null ? ""
								: formatter.format((savingsEOLMainResultDTO
										.getTotalSavingsEOLRecycle()
										.getToxicMaterialSavings())),
						savingsEOLMainResultDTO.getTotalSavingsEOLRecycle()
								.getMuncipalWasteSavings() == null ? ""
								: formatter.format((savingsEOLMainResultDTO
										.getTotalSavingsEOLRecycle()
										.getMuncipalWasteSavings())),
						savingsEOLMainResultDTO.getTotalSavingsEOLRecycle()
								.getHazardWasteSavings() == null ? "" : formatter.format(
								(savingsEOLMainResultDTO
										.getTotalSavingsEOLRecycle()
										.getHazardWasteSavings())),
						savingsEOLMainResultDTO.getTotalSavingsEOLRecycle()
								.getCostSavings() == null ? "" : formatter.format(
								(savingsEOLMainResultDTO
										.getTotalSavingsEOLRecycle()
										.getCostSavings()))));

		// EOL Total
		savingsReportProductList
				.add(new SavingReportDisplayDTO(
						"End-of-life Management SUBTOTAL (All Products)",
						savingsEOLMainResultDTO.getTotalSavingsElectronics()
								.getEnergySavings() == null ? "" : formatter.format(
								(savingsEOLMainResultDTO
										.getTotalSavingsElectronics()
										.getEnergySavings())),
						savingsEOLMainResultDTO.getTotalSavingsElectronics()
								.getPrimaryMaterialSavings() == null ? ""
								: formatter.format((savingsEOLMainResultDTO
										.getTotalSavingsElectronics()
										.getPrimaryMaterialSavings())),
						savingsEOLMainResultDTO.getTotalSavingsElectronics()
								.getGhgEmissionSaving() == null ? "" : formatter.format(
								(savingsEOLMainResultDTO
										.getTotalSavingsElectronics()
										.getGhgEmissionSaving())),
						savingsEOLMainResultDTO.getTotalSavingsElectronics()
								.getAirEmissionsaving() == null ? "" : formatter.format(
								(savingsEOLMainResultDTO
										.getTotalSavingsElectronics()
										.getAirEmissionsaving())),
						savingsEOLMainResultDTO.getTotalSavingsElectronics()
								.getWaterEmissionSaving() == null ? "" : formatter.format(
								(savingsEOLMainResultDTO
										.getTotalSavingsElectronics()
										.getWaterEmissionSaving())),
						savingsEOLMainResultDTO.getTotalSavingsElectronics()
								.getToxicMaterialSavings() == null ? ""
								: formatter.format((savingsEOLMainResultDTO
										.getTotalSavingsElectronics()
										.getToxicMaterialSavings())),
						savingsEOLMainResultDTO.getTotalSavingsElectronics()
								.getMuncipalWasteSavings() == null ? ""
								: formatter.format((savingsEOLMainResultDTO
										.getTotalSavingsElectronics()
										.getMuncipalWasteSavings())),
						savingsEOLMainResultDTO.getTotalSavingsElectronics()
								.getHazardWasteSavings() == null ? "" : formatter.format(
								(savingsEOLMainResultDTO
										.getTotalSavingsElectronics()
										.getHazardWasteSavings())),
						savingsEOLMainResultDTO.getTotalSavingsElectronics()
								.getCostSavings() == null ? "" : formatter.format(
								(savingsEOLMainResultDTO
										.getTotalSavingsElectronics()
										.getCostSavings()))));

		return savingsReportProductList;

	}

	// Display of EOL
	public List<SavingReportDisplayDTO> generateUseDataDisplayDTO(
			SavingsUseDataMainResultDTO savingsUseDataMainResultDTO) {

		List<SavingReportDisplayDTO> savingsReportProductList = new ArrayList<SavingReportDisplayDTO>();

		// energySavings;
		// primaryMaterialSavings;
		// ghgEmissionSaving;
		// airEmissionsaving;
		// waterEmissionSaving;
		// muncipalWasteSavings;
		// costSavings;

		// Use Life
		savingsReportProductList.add(new SavingReportDisplayDTO(
				"Use (Lifetime)", "", "", "", "", "", "", "", "", ""));
		savingsReportProductList.add(new SavingReportDisplayDTO(
				"Power management",
				savingsUseDataMainResultDTO.getPowerManagementEnabledLife()
						.getEnergySavings() == null ? "" : formatter.format(
						(savingsUseDataMainResultDTO
								.getPowerManagementEnabledLife()
								.getEnergySavings())),
				savingsUseDataMainResultDTO.getPowerManagementEnabledLife()
						.getPrimaryMaterialSavings() == null ? "" : formatter.format(
						(savingsUseDataMainResultDTO
								.getPowerManagementEnabledLife()
								.getPrimaryMaterialSavings())),
				savingsUseDataMainResultDTO.getPowerManagementEnabledLife()
						.getGhgEmissionSaving() == null ? "" : formatter.format(
						(savingsUseDataMainResultDTO
								.getPowerManagementEnabledLife()
								.getGhgEmissionSaving())),
				savingsUseDataMainResultDTO.getPowerManagementEnabledLife()
						.getAirEmissionsaving() == null ? "" : formatter.format(
						(savingsUseDataMainResultDTO
								.getPowerManagementEnabledLife()
								.getAirEmissionsaving())),
				savingsUseDataMainResultDTO.getPowerManagementEnabledLife()
						.getWaterEmissionSaving() == null ? "" : formatter.format(
						(savingsUseDataMainResultDTO
								.getPowerManagementEnabledLife()
								.getWaterEmissionSaving())),
				savingsUseDataMainResultDTO.getPowerManagementEnabledLife()
						.getToxicMaterialSavings() == null ? "": formatter.format(
						(savingsUseDataMainResultDTO
								.getPowerManagementEnabledLife()
								.getToxicMaterialSavings())),
				savingsUseDataMainResultDTO.getPowerManagementEnabledLife()
						.getMuncipalWasteSavings() == null ? "" : formatter.format(
						(savingsUseDataMainResultDTO
								.getPowerManagementEnabledLife()
								.getMuncipalWasteSavings())),
				savingsUseDataMainResultDTO.getPowerManagementEnabledLife()
						.getHazardWasteSavings() == null ? "" : formatter.format(
						(savingsUseDataMainResultDTO
								.getPowerManagementEnabledLife()
								.getHazardWasteSavings())),
				savingsUseDataMainResultDTO.getPowerManagementEnabledLife()
						.getCostSavings() == null ? "" : formatter.format(
						(savingsUseDataMainResultDTO
								.getPowerManagementEnabledLife()
								.getCostSavings()))));
		savingsReportProductList
				.add(new SavingReportDisplayDTO("Extend product life",
						savingsUseDataMainResultDTO.getExtendProductLife()
								.getEnergySavings() == null ? "" : formatter.format(
								(savingsUseDataMainResultDTO
										.getExtendProductLife()
										.getEnergySavings())),
						savingsUseDataMainResultDTO.getExtendProductLife()
								.getPrimaryMaterialSavings() == null ? ""
								: formatter.format((savingsUseDataMainResultDTO
										.getExtendProductLife()
										.getPrimaryMaterialSavings())),
						savingsUseDataMainResultDTO.getExtendProductLife()
								.getGhgEmissionSaving() == null ? "" : formatter.format(
								(savingsUseDataMainResultDTO
										.getExtendProductLife()
										.getGhgEmissionSaving())),
						savingsUseDataMainResultDTO.getExtendProductLife()
								.getAirEmissionsaving() == null ? "" : formatter.format(
								(savingsUseDataMainResultDTO
										.getExtendProductLife()
										.getAirEmissionsaving())),
						savingsUseDataMainResultDTO.getExtendProductLife()
								.getWaterEmissionSaving() == null ? "" : formatter.format(
								(savingsUseDataMainResultDTO
										.getExtendProductLife()
										.getWaterEmissionSaving())),
						savingsUseDataMainResultDTO.getExtendProductLife()
								.getToxicMaterialSavings() == null ? ""
								: formatter.format((savingsUseDataMainResultDTO
										.getExtendProductLife()
										.getToxicMaterialSavings())),
						savingsUseDataMainResultDTO.getExtendProductLife()
								.getMuncipalWasteSavings() == null ? ""
								: formatter.format((savingsUseDataMainResultDTO
										.getExtendProductLife()
										.getMuncipalWasteSavings())),
						savingsUseDataMainResultDTO.getExtendProductLife()
								.getHazardWasteSavings() == null ? "" : formatter.format(
								(savingsUseDataMainResultDTO
										.getExtendProductLife()
										.getHazardWasteSavings())),
						savingsUseDataMainResultDTO.getExtendProductLife()
								.getCostSavings() == null ? "" : formatter.format(
								(savingsUseDataMainResultDTO
										.getExtendProductLife()
										.getCostSavings()))));
		savingsReportProductList
				.add(new SavingReportDisplayDTO(
						"Use Lifetime SUBTOTAL (All Products)",
						savingsUseDataMainResultDTO.getProductLifeTotal()
								.getEnergySavings() == null ? "" : formatter.format(
								(savingsUseDataMainResultDTO
										.getProductLifeTotal()
										.getEnergySavings())),
						savingsUseDataMainResultDTO.getProductLifeTotal()
								.getPrimaryMaterialSavings() == null ? ""
								: formatter.format((savingsUseDataMainResultDTO
										.getProductLifeTotal()
										.getPrimaryMaterialSavings())),
						savingsUseDataMainResultDTO.getProductLifeTotal()
								.getGhgEmissionSaving() == null ? "" : formatter.format(
								(savingsUseDataMainResultDTO
										.getProductLifeTotal()
										.getGhgEmissionSaving())),
						savingsUseDataMainResultDTO.getProductLifeTotal()
								.getAirEmissionsaving() == null ? "" : formatter.format(
								(savingsUseDataMainResultDTO
										.getProductLifeTotal()
										.getAirEmissionsaving())),
						savingsUseDataMainResultDTO.getProductLifeTotal()
								.getWaterEmissionSaving() == null ? "" : formatter.format(
								(savingsUseDataMainResultDTO
										.getProductLifeTotal()
										.getWaterEmissionSaving())),
						savingsUseDataMainResultDTO.getProductLifeTotal()
								.getToxicMaterialSavings() == null ? ""
								: formatter.format((savingsUseDataMainResultDTO
										.getProductLifeTotal()
										.getToxicMaterialSavings())),
						savingsUseDataMainResultDTO.getProductLifeTotal()
								.getMuncipalWasteSavings() == null ? ""
								: formatter.format((savingsUseDataMainResultDTO
										.getProductLifeTotal()
										.getMuncipalWasteSavings())),
						savingsUseDataMainResultDTO.getProductLifeTotal()
								.getHazardWasteSavings() == null ? "" : formatter.format(
								(savingsUseDataMainResultDTO
										.getProductLifeTotal()
										.getHazardWasteSavings())),
						savingsUseDataMainResultDTO.getProductLifeTotal()
								.getCostSavings() == null ? ""
								: formatter.format((savingsUseDataMainResultDTO
										.getProductLifeTotal().getCostSavings()))));

		// Use First Year
		savingsReportProductList.add(new SavingReportDisplayDTO(
				"Use (First Year)", "", "", "", "", "", "", "", "", ""));
		savingsReportProductList.add(new SavingReportDisplayDTO(
				"Power management",
				savingsUseDataMainResultDTO.getPowerManagementEnabledFirst()
						.getEnergySavings() == null ? "" : formatter.format(
						(savingsUseDataMainResultDTO
								.getPowerManagementEnabledFirst()
								.getEnergySavings())),
				savingsUseDataMainResultDTO.getPowerManagementEnabledFirst()
						.getPrimaryMaterialSavings() == null ? "" : formatter.format(
						(savingsUseDataMainResultDTO
								.getPowerManagementEnabledFirst()
								.getPrimaryMaterialSavings())),
				savingsUseDataMainResultDTO.getPowerManagementEnabledFirst()
						.getGhgEmissionSaving() == null ? "" : formatter.format(
						(savingsUseDataMainResultDTO
								.getPowerManagementEnabledFirst()
								.getGhgEmissionSaving())),
				savingsUseDataMainResultDTO.getPowerManagementEnabledFirst()
						.getAirEmissionsaving() == null ? "" : formatter.format(
						(savingsUseDataMainResultDTO
								.getPowerManagementEnabledFirst()
								.getAirEmissionsaving())),
				savingsUseDataMainResultDTO.getPowerManagementEnabledFirst()
						.getWaterEmissionSaving() == null ? "" : formatter.format(
						(savingsUseDataMainResultDTO
								.getPowerManagementEnabledFirst()
								.getWaterEmissionSaving())),
				savingsUseDataMainResultDTO.getPowerManagementEnabledFirst()
						.getToxicMaterialSavings() == null ? "" : formatter.format(
						(savingsUseDataMainResultDTO
								.getPowerManagementEnabledFirst()
								.getToxicMaterialSavings())),
				savingsUseDataMainResultDTO.getPowerManagementEnabledFirst()
						.getMuncipalWasteSavings() == null ? "" : formatter.format(
						(savingsUseDataMainResultDTO
								.getPowerManagementEnabledFirst()
								.getMuncipalWasteSavings())),
				savingsUseDataMainResultDTO.getPowerManagementEnabledFirst()
						.getHazardWasteSavings() == null ? "" : formatter.format(
						(savingsUseDataMainResultDTO
								.getPowerManagementEnabledFirst()
								.getHazardWasteSavings())),
				savingsUseDataMainResultDTO.getPowerManagementEnabledFirst()
						.getCostSavings() == null ? "" : formatter.format(
						(savingsUseDataMainResultDTO
								.getPowerManagementEnabledFirst()
								.getCostSavings()))));

		return savingsReportProductList;

	}

	public DataCompProductCombinedResultDTO generateDataCompProductCombinedResultDTO(
			ProductInformationDTO productInformation) {
		DataCompProductCombinedResultDTO dataCompProductCombinedResultDTO = null;
		generateDataCompProductInterimResultDTO(productInformation);

		return dataCompProductCombinedResultDTO;
	}

	public DataCompProductInterimResultDTO generateDataCompProductInterimResultDTO(
			ProductInformationDTO productInformation) {
		DataCompProductInterimResultDTO dataCompProductInterimResultDTO = new DataCompProductInterimResultDTO();

		if (productInformation != null
				&& productInformation.getProductDetails() != null) {
			if (productInformation.getProductDetails().getProductType() != null
					&& productInformation.getProductDetails().getProductType()
							.trim().length() > 0) {
				String propertyName = "";
				if (productInformation.getProductDetails().getProductType()
						.trim().length() > 0
						&& productInformation.getProductDetails()
								.getEpeatRegTier() != null
						&& productInformation.getProductDetails()
								.getEpeatRegTier().trim().length() > 0) {
					propertyName = productInformation.getProductDetails()
							.getProductType()
							+ productInformation.getProductDetails()
									.getEpeatRegTier();
				} else {
					propertyName = "cpuBronze";
				}
				if ("lcd".equalsIgnoreCase(productInformation
						.getProductDetails().getProductType())
						|| "notebook".equalsIgnoreCase(productInformation
								.getProductDetails().getProductType())) {
					if ("yes".equalsIgnoreCase(productInformation
							.getProductDetails().getIsProdEPEATRegd())) {
						dataCompProductInterimResultDTO
								.setNumOfLamps(Double.parseDouble(prop8b2
										.getProperty(propertyName
												+ "Reportingonamountofmercuryusedinlightsources,NumberoflampswithHg")));
						dataCompProductInterimResultDTO
								.setMassHgPerlamp(Double.parseDouble((String) prop8b2
										.getProperty(propertyName
												+ "Reportingonamountofmercuryusedinlightsources,maximumaverageHgcontentperlamp")));
					} else {
						dataCompProductInterimResultDTO.setNumOfLamps(Double
								.parseDouble((String) prop8a
										.getProperty(productInformation
												.getProductDetails()
												.getProductType()
												+ "avgnumberOflampsperunit")));
						dataCompProductInterimResultDTO.setMassHgPerlamp(Double
								.parseDouble((String) prop8a
										.getProperty(productInformation
												.getProductDetails()
												.getProductType()
												+ "avgHgcontentinlamps")));
					}
				} else {
					dataCompProductInterimResultDTO.setNumOfLamps(null);
					dataCompProductInterimResultDTO.setMassHgPerlamp(null);
				}
				if (productInformation.getProductDetails().getIsProdEPEATRegd() != null
						&& productInformation.getProductDetails()
								.getIsProdEPEATRegd().trim().length() > 0
						&& "yes".equalsIgnoreCase(productInformation
								.getProductDetails().getIsProdEPEATRegd())) {
					BigDecimal avgPlasticAmt = new BigDecimal(
							(String) prop8a.getProperty(productInformation
									.getProductDetails().getProductType()
									+ "avgAmtOfPlasticinproduct"));
					BigDecimal declaredPercent = null;
					BigDecimal declared10Percent = null;
					BigDecimal declared25Percent = null;
					if (((String) prop8b2
							.getProperty(propertyName
									+ "Manufacturersdeclaredpercentrecycledcontentforproduct") != null)
							&& Double
									.parseDouble((String) prop8b2
											.getProperty(propertyName
													+ "Manufacturersdeclaredpercentrecycledcontentforproduct")) > 0.00) {
						BigDecimal lookUpValue =BigDecimal.valueOf(Double.parseDouble(
								(String) prop8b2
										.getProperty(propertyName+"Manufacturersdeclaredpercentrecycledcontentforproduct")));
						declaredPercent = lookUpValue.multiply(avgPlasticAmt);
					} else {
						declaredPercent = new BigDecimal("0");
					}
					if ("Yes"
							.equalsIgnoreCase((String) prop8b2
									.getProperty(propertyName
											+ "Minimumcontentofpostconsumerrecycledplasticgt10percent"))) {
						declared10Percent = new BigDecimal("0.10")
								.multiply(avgPlasticAmt);
					} else {
						declared10Percent = new BigDecimal("0");
					}
					if ("Yes"
							.equalsIgnoreCase((String) prop8b2
									.getProperty(propertyName
											+ "Highercontentofpostconsumerrecycledplasticgt25percent"))) {
						declared25Percent = new BigDecimal("0.25")
								.multiply(avgPlasticAmt);
					} else {
						declared25Percent = new BigDecimal("0");
					}
					
//EDITED:1
					dataCompProductInterimResultDTO
							.setDeclaredPercent(declaredPercent.max(
									declared10Percent).max(declared25Percent));
					
					dataCompProductInterimResultDTO.setAvgMassOfRcPlasticResin(dataCompProductInterimResultDTO.getDeclaredPercent().doubleValue());
					
					double recycleFoamResin = Double
							.parseDouble((String) prop8b2
									.getProperty(propertyName
											+ "Declarationofrecycledcontentinpackaging,%recycledcontentforcorrugated/paperfiberpackaging"));
					double recyclePaperFiber = Double
							.parseDouble((String) prop8b2
									.getProperty(propertyName
											+ "Declarationofrecycledcontentinpackaging,%recycledcontentforplastic/foam/resinpackaging"));
					double recycleOtherPackage = Double
							.parseDouble((String) prop8b2
									.getProperty(propertyName
											+ "Declarationofrecycledcontentinpackaging,%recycledcontentforotherpackaging"));

					double avgRecycleCorrPerPackagForProd = Double
							.parseDouble((String) prop8a
									.getProperty(productInformation
											.getProductDetails()
											.getProductType()
											+ "avgAmtOfcorrugatedperunitpackage"));
					double avgRecyclePlasticPerPackagForProd = Double
							.parseDouble((String) prop8a
									.getProperty(productInformation
											.getProductDetails()
											.getProductType()
											+ "avgAmtOfplastic/foamperunitpackage"));
					double avgRecycleOtherPerPackagForProd = Double
							.parseDouble((String) prop8a
									.getProperty(productInformation
											.getProductDetails()
											.getProductType()
											+ "avgAmtOfotherPackagingperunitpackage"));

					dataCompProductInterimResultDTO
							.setCorrugatedPackaging(recycleFoamResin
									* avgRecycleCorrPerPackagForProd);
					dataCompProductInterimResultDTO
							.setPlasticPackaging(recyclePaperFiber
									* avgRecyclePlasticPerPackagForProd);
					dataCompProductInterimResultDTO
							.setOtherPackaging(recycleOtherPackage
									* avgRecycleOtherPerPackagForProd);
				} else {
			
					dataCompProductInterimResultDTO.setAvgMassOfRcPlasticResin(Double.parseDouble((String) prop8a
									.getProperty(productInformation
											.getProductDetails()
											.getProductType()
											+ "avgAmtOfRecycledplastic(resin)ContentInProduct")));

					dataCompProductInterimResultDTO
							.setCorrugatedPackaging(Double.parseDouble((String) prop8a
									.getProperty(productInformation
											.getProductDetails()
											.getProductType()
											+ "avgAmtOfRecycledcontentOfPackaging,1-corrugated")));
					dataCompProductInterimResultDTO
							.setPlasticPackaging(Double.parseDouble((String) prop8a
									.getProperty(productInformation
											.getProductDetails()
											.getProductType()
											+ "PercentRecycledcontentOfPackaging,2-plastic/foam")));
					dataCompProductInterimResultDTO
							.setOtherPackaging(Double.parseDouble((String) prop8a
									.getProperty(productInformation
											.getProductDetails()
											.getProductType()
											+ "PercentRecycledcontentOfPackaging,3-other")));
					dataCompProductInterimResultDTO
							.setDeclaredPercent(new BigDecimal(
									(String) prop8a
											.getProperty(productInformation
													.getProductDetails()
													.getProductType()
													+ "avgAmtOfRecycledplastic(resin)ContentInProduct")));
				}

				prop8b2
						.getProperty(propertyName + "Reusablepackaging");

				double avgRecycleCPG = Double.parseDouble((String) prop8a
						.getProperty(productInformation.getProductDetails()
								.getProductType()
								+ "avgAmtOfcorrugatedperunitpackage"));
				double avgRecyclePackagingReuse = Double
						.parseDouble((String) prop8a
								.getProperty(productInformation
										.getProductDetails().getProductType()
										+ "avgAmtOfPackagingperproduct"));
				double recyclePackagingCorrugated = Double
						.parseDouble((String) prop8b1
								.getProperty("CPGrecycledcontentofpackaging,corrugated"));
				double packagingReuse = Double.parseDouble((String) prop8b1
						.getProperty("Packagingreused"));

				if (productInformation.getProductDetails().getIsProdEPEATRegd() != null
						&& productInformation.getProductDetails()
								.getIsProdEPEATRegd().trim().length() > 0
						&& "yes".equalsIgnoreCase(productInformation
								.getProductDetails().getIsProdEPEATRegd())
						&& "yes".equalsIgnoreCase(((String) prop8b2
								.getProperty(propertyName+"Minimumpostconsumercontentguidelines(CPG)(Recycledcontentofcorrugatedpackaginggt25)")).trim())) {
					dataCompProductInterimResultDTO
							.setCpgPackaging(avgRecycleCPG
									* recyclePackagingCorrugated);
				} else {
					dataCompProductInterimResultDTO
							.setCpgPackaging(Double.parseDouble((String) prop8a
			                       .getProperty(productInformation
											.getProductDetails()
											.getProductType()
											+ "avgAmtOfRecycledcontentOfPackaging,1-corrugated")));
				}
				if (productInformation.getProductDetails().getIsProdEPEATRegd() != null
						&& productInformation.getProductDetails()
								.getIsProdEPEATRegd().trim().length() > 0
						&& "yes".equalsIgnoreCase(productInformation
								.getProductDetails().getIsProdEPEATRegd())
						&& "yes".equalsIgnoreCase(((String) prop8b2
								.getProperty(propertyName + "Reusablepackaging")))) {
					dataCompProductInterimResultDTO
							.setPackagingReuse(avgRecyclePackagingReuse
									* packagingReuse);
				} else {
					dataCompProductInterimResultDTO
							.setPackagingReuse(Double.parseDouble((String) prop8a
									.getProperty(productInformation
											.getProductDetails()
											.getProductType()
											+ "PackagingavoidedperunitbyPackagingreuse")));
				}
				if (productInformation.getPercentPowermkanagEnabledComp() != null
						|| productInformation
								.getPercentPowermkanagEnabledDisp() != null) {
					dataCompProductInterimResultDTO
							.setAvgUECForLCD(calculatePowerManagement("lcd",
									"energy5", productInformation
											.getPercentPowermkanagEnabledComp()));
					dataCompProductInterimResultDTO
							.setAvgUECForCPU(calculatePowerManagement("cpu",
									"energy5", productInformation
											.getPercentPowermkanagEnabledComp()));
					Double calculatedValueDisplay = (calculatePowerManagement(
							"notebookdisplay", "energy5",
							productInformation
									.getPercentPowermkanagEnabledDisp()));
					Double calculatedValueComp = calculatePowerManagement(
							"notebookcomputer", "energy5",
							productInformation
									.getPercentPowermkanagEnabledComp());
					dataCompProductInterimResultDTO
							.setAvgUECForNtbk(calculatedValueDisplay
									+ calculatedValueComp);
				}
			}
		}
		return dataCompProductInterimResultDTO;
	}

	private Double calculatePowerManagement(String productType,
			String energyValue, String input11or12) {

		Double zValue = 0.00;
		Double yValue = 0.00;
		Double calculatedValue = 0.00;
		Double x1Value = ((Double.parseDouble((String) propproductInterim
				.getProperty("a1" + productType + energyValue)) * Double
				.parseDouble((String) propproductInterim.getProperty("b1"
						+ productType + energyValue)))
				+ (Double.parseDouble((String) propproductInterim
						.getProperty("a2" + productType + energyValue)) * Double
						.parseDouble((String) propproductInterim
								.getProperty("b2" + productType + energyValue))) + (Double
				.parseDouble((String) propproductInterim.getProperty("a3"
						+ productType + energyValue)) * Double
				.parseDouble((String) propproductInterim.getProperty("b3"
						+ productType + energyValue)))) / 1000;
		Double x2Value = ((Double.parseDouble((String) propproductInterim
				.getProperty("a1" + productType + energyValue)) * Double
				.parseDouble((String) propproductInterim.getProperty("b1"
						+ productType + energyValue))) + (((Double
				.parseDouble((String) propproductInterim.getProperty("a2"
						+ productType + energyValue)) + Double
				.parseDouble((String) propproductInterim.getProperty("a3"
						+ productType + energyValue)))) * (Double
				.parseDouble((String) propproductInterim.getProperty("b2"
						+ productType + energyValue))))) / 1000;
		Double x3Value = ((Double.parseDouble((String) propproductInterim
				.getProperty("a3" + productType + energyValue)) * Double
				.parseDouble((String) propproductInterim.getProperty("b3"
						+ productType + energyValue))) + ((Double
				.parseDouble((String) propproductInterim.getProperty("a1"
						+ productType + energyValue)) + Double
				.parseDouble((String) propproductInterim.getProperty("a2"
						+ productType + energyValue))) * (Double
				.parseDouble((String) propproductInterim.getProperty("b1"
						+ productType + energyValue))))) / 1000;
		Double x4Value = ((Double.parseDouble((String) propproductInterim
				.getProperty("a1" + productType + energyValue))
				+ Double.parseDouble((String) propproductInterim
						.getProperty("a2" + productType + energyValue)) + Double
				.parseDouble((String) propproductInterim.getProperty("a3"
						+ productType + energyValue))) * (Double
				.parseDouble((String) propproductInterim.getProperty("b1"
						+ productType + energyValue)))) / 1000;

		if (input11or12 != null && input11or12.length() > 0) {
			zValue = Double.parseDouble(input11or12) / 100;
		} else {
			zValue = Double.parseDouble((String) propproductInterim
					.getProperty("percentpowermanage" + productType));
		}

		yValue = Double.parseDouble((String) propproductInterim
				.getProperty("percentUnitsTurnedOfAtNight" + productType));
		calculatedValue = (x1Value * zValue * yValue)
				+ (x2Value * zValue * (1 - yValue))
				+ (x3Value * (1 - zValue) * yValue)
				+ (x4Value * (1 - zValue) * (1 - yValue));
		return calculatedValue;
	}

	public DataCompProductMainResultDTO generateDataCompProductmainResultDTO(
			ProductInformationDTO productInformation,
			DataCompProductInterimResultDTO dataCompProductInterimResultDTO) {
		DataCompProductMainResultDTO dataCompProductmainResultDTO = new DataCompProductMainResultDTO();

		if (productInformation != null) {
			if ((productInformation.getProductDetails().getIsProdEPEATRegd() != null
					&& productInformation.getProductDetails()
							.getIsProdEPEATRegd().trim().length() > 0
					&& "yes".equalsIgnoreCase(productInformation
							.getProductDetails().getIsProdEPEATRegd())
					&& productInformation.getIsROHSCompliant() != null && productInformation
					.getIsROHSCompliant().trim().length() == 0)
					|| ("yes".equalsIgnoreCase(productInformation
							.getIsROHSCompliant()))) {
				dataCompProductmainResultDTO.setMassPb(Double
						.parseDouble((String) prop8b1
								.getProperty("Leadcontent")));
				dataCompProductmainResultDTO
						.setMassHg(Double.parseDouble((String) prop8b1
								.getProperty("Mercurycontent(notincludinglamps)")));
				dataCompProductmainResultDTO.setMassOdCD(Double
						.parseDouble((String) prop8b1
								.getProperty("Cadmiumcontent")) / 1000);
				dataCompProductmainResultDTO
						.setMassOfCr6(Double.parseDouble((String) prop8b1
								.getProperty("Hexavalentchromiumcontent")) / 1000);
				dataCompProductmainResultDTO
						.setMassOfPBB(Double.parseDouble((String) prop8b1
								.getProperty("PBBcontent")) / 1000);
				dataCompProductmainResultDTO.setMassOfPBDE(Double
						.parseDouble((String) prop8b1
								.getProperty("PBDEcontentperunit")) / 1000);

			} else {
				dataCompProductmainResultDTO.setMassPb(Double
						.parseDouble((String) prop8a
								.getProperty(productInformation
										.getProductDetails().getProductType()
										+ "avgPbContentPerUnit")));
				dataCompProductmainResultDTO.setMassHg(Double
						.parseDouble((String) prop8a
								.getProperty(productInformation
										.getProductDetails().getProductType()
										+ "avgPbContentPerUnit")));
				dataCompProductmainResultDTO.setMassOdCD(Double
						.parseDouble((String) prop8a
								.getProperty(productInformation
										.getProductDetails().getProductType()
										+ "avgcadmiumContentPerUnit")));
				dataCompProductmainResultDTO.setMassOfCr6(Double
						.parseDouble((String) prop8a
								.getProperty(productInformation
										.getProductDetails().getProductType()
										+ "avghexavalentChromiumPerUnit")));
				dataCompProductmainResultDTO.setMassOfPBB(Double
						.parseDouble((String) prop8a
								.getProperty(productInformation
										.getProductDetails().getProductType()
										+ "avgPBBContentPerUnit")));
				dataCompProductmainResultDTO.setMassOfPBDE(Double
						.parseDouble((String) prop8a
								.getProperty(productInformation
										.getProductDetails().getProductType()
										+ "avgPBDEContentPerUnit")));

			}
			if (dataCompProductmainResultDTO.getMassPb() != null
					|| dataCompProductmainResultDTO.getMassPb() == 0.00) {
				dataCompProductmainResultDTO.setAvgMassOfPWB(0.00);
				dataCompProductmainResultDTO
						.setAvgMassOfResinWireAndCableWithHg(0.00);
				
			} else {
				dataCompProductmainResultDTO.setAvgMassOfPWB(Double
						.parseDouble((String) prop8a
								.getProperty(productInformation
										.getProductDetails().getProductType()
										+ "avgWgtOfprintedwireboards")));
				dataCompProductmainResultDTO
						.setAvgMassOfResinWireAndCableWithHg(Double.parseDouble((String) prop8a
								.getProperty(productInformation
										.getProductDetails().getProductType()
										+ "avgWgtOfresin(plastic)inwireandcable")));
	
			}
			if (productInformation.getNumOfHgLampsUsed() != null
					&& productInformation.getNumOfHgLampsUsed().length() > 0) {
				dataCompProductmainResultDTO.setNoOfLamps(Double
						.parseDouble(productInformation.getNumOfHgLampsUsed()));
			} else {
				dataCompProductmainResultDTO
						.setNoOfLamps(dataCompProductInterimResultDTO
								.getNumOfLamps());
			}
			if (productInformation.getIsHgAddedLightSourceEliminated() != null
					&& "yes".equalsIgnoreCase(productInformation
							.getIsHgAddedLightSourceEliminated())) {
				dataCompProductmainResultDTO.setMassOfHgPerLamp(0.00);
			} else {
				if (productInformation.getIsAvgHgContentPerLamp() != null
						&& "yes".equalsIgnoreCase(productInformation
								.getIsAvgHgContentPerLamp())) {
					dataCompProductmainResultDTO.setMassOfHgPerLamp(0.003);
				} else {
					if (productInformation.getAmtHgUsedinLightSrc() != null
							&& productInformation.getAmtHgUsedinLightSrc()
									.length() > 0) {
						dataCompProductmainResultDTO.setMassOfHgPerLamp(Double
								.parseDouble(productInformation
										.getAmtHgUsedinLightSrc()));
					} else {
						dataCompProductmainResultDTO
								.setMassOfHgPerLamp(dataCompProductInterimResultDTO
										.getMassHgPerlamp());
					}
				}
			}
			if (dataCompProductmainResultDTO.getNoOfLamps() != null
					&& dataCompProductmainResultDTO.getMassOfHgPerLamp() != null) {
				dataCompProductmainResultDTO
						.setTotalMassOfHgInLamps(dataCompProductmainResultDTO
								.getNoOfLamps()
								* dataCompProductmainResultDTO
										.getMassOfHgPerLamp());
			} else {
				dataCompProductmainResultDTO.setTotalMassOfHgInLamps(null);
			}
			
			if(dataCompProductmainResultDTO.getTotalMassOfHgInLamps()!=null && dataCompProductmainResultDTO.getTotalMassOfHgInLamps()==0.00)
			{
					dataCompProductmainResultDTO
							.setColdCathodeFluroscentLampWithHg(0.00);
	
			}else	if(dataCompProductmainResultDTO.getTotalMassOfHgInLamps()!=null && dataCompProductmainResultDTO.getTotalMassOfHgInLamps()>0.00)
			{
				if (!"cpu".equalsIgnoreCase(productInformation
						.getProductDetails().getProductType())) {
					dataCompProductmainResultDTO
							.setColdCathodeFluroscentLampWithHg(Double.parseDouble((String) prop8a
									.getProperty(productInformation
											.getProductDetails()
											.getProductType()
											+ "avgWgtOfcoldcathodefluorescentlamps(CCFL)")));
				}else{
					dataCompProductmainResultDTO
					.setColdCathodeFluroscentLampWithHg(0.00);
				}
		}

			dataCompProductmainResultDTO.setAvgMassOfPlastic(Double
					.parseDouble((String) prop8a.getProperty(productInformation
							.getProductDetails().getProductType()
							+ "avgAmtOfPlasticinproduct")));

			if ((productInformation.getManuDeclarationOfPostRecycledPlastic() != null && productInformation
					.getManuDeclarationOfPostRecycledPlastic().trim().length() > 0)
					|| (productInformation.getMinPostRecyPlasticContent() != null
							&& productInformation
									.getMinPostRecyPlasticContent().length() > 0 && "yes"
								.equalsIgnoreCase(productInformation
										.getMinPostRecyPlasticContent()))
					|| (productInformation.getMaxPostRecyPlasticContent() != null
							&& productInformation
									.getMaxPostRecyPlasticContent().trim()
									.length() > 0 && "yes"
								.equalsIgnoreCase(productInformation
										.getMaxPostRecyPlasticContent()))) {
				if (productInformation
						.getManuDeclarationOfPostRecycledPlastic() != null
						&& (productInformation.getMaxPostRecyPlasticContent() != null
								&& productInformation
										.getMaxPostRecyPlasticContent().trim()
										.length() > 0 && "yes"
									.equalsIgnoreCase(productInformation
											.getMaxPostRecyPlasticContent()))) {
					if (Double.parseDouble(productInformation
							.getManuDeclarationOfPostRecycledPlastic()) > 0.25) {
						dataCompProductmainResultDTO
								.setAvgMassOfRecyConentInProdResin(Double.parseDouble(productInformation
										.getManuDeclarationOfPostRecycledPlastic()));
					} else {
						dataCompProductmainResultDTO
								.setAvgMassOfRecyConentInProdResin(0.25);
					}
				}
				if (productInformation
						.getManuDeclarationOfPostRecycledPlastic() != null
						&& (productInformation.getMinPostRecyPlasticContent() != null
								&& productInformation
										.getMinPostRecyPlasticContent().trim()
										.length() > 0 && "yes"
									.equalsIgnoreCase(productInformation
											.getMinPostRecyPlasticContent()))) {
					if (Double.parseDouble(productInformation
							.getManuDeclarationOfPostRecycledPlastic()) > 0.10) {
						dataCompProductmainResultDTO
								.setAvgMassOfRecyConentInProdResin(Double.parseDouble(productInformation
										.getManuDeclarationOfPostRecycledPlastic()));
					} else {
						dataCompProductmainResultDTO
								.setAvgMassOfRecyConentInProdResin(0.10);
					}
				}

				if ((productInformation.getMaxPostRecyPlasticContent() != null
						&& productInformation.getMaxPostRecyPlasticContent()
								.trim().length() > 0 && "yes"
							.equalsIgnoreCase(productInformation
									.getMaxPostRecyPlasticContent()))
						&& (productInformation.getMinPostRecyPlasticContent() != null
								&& productInformation
										.getMinPostRecyPlasticContent().trim()
										.length() > 0 && "yes"
									.equalsIgnoreCase(productInformation
											.getMinPostRecyPlasticContent()))) {
					dataCompProductmainResultDTO
							.setAvgMassOfRecyConentInProdResin(0.25);
				}
			
			}
			if (dataCompProductmainResultDTO
					.getAvgMassOfRecyConentInProdResin() != null) {
				
					dataCompProductmainResultDTO
							.setAvgMassOfRecyConentInProdResin(dataCompProductmainResultDTO
									.getAvgMassOfRecyConentInProdResin()* dataCompProductmainResultDTO.getAvgMassOfPlastic());
			
			}else {
 //EDITED
				dataCompProductmainResultDTO
						.setAvgMassOfRecyConentInProdResin(dataCompProductInterimResultDTO.getAvgMassOfRcPlasticResin().doubleValue());
			}

			dataCompProductmainResultDTO.setAvgMassOfCorrugatedPackaging(Double
					.parseDouble((String) prop8a.getProperty(productInformation
							.getProductDetails().getProductType()
							+ "avgAmtOfcorrugatedperunitpackage")));
			Double averageinput13 = null;
			if (productInformation.getLowRecycledPlasticContent() != null
					&& productInformation.getLowRecycledPlasticContent().trim()
							.length() > 0
					&& productInformation.getUpperRecycledPlasticContent() != null
					&& productInformation.getUpperRecycledPlasticContent()
							.trim().length() > 0) {
				averageinput13 = (Double.parseDouble(productInformation
						.getLowRecycledPlasticContent()) + Double
						.parseDouble(productInformation
								.getUpperRecycledPlasticContent())) / 2;
			}
			if (averageinput13 != null) {
				dataCompProductmainResultDTO
						.setAvgMassOfRecyContentInCorrugatePackaging(averageinput13
								* dataCompProductmainResultDTO
										.getAvgMassOfCorrugatedPackaging());
			} else {
				dataCompProductmainResultDTO
						.setAvgMassOfRecyContentInCorrugatePackaging(dataCompProductInterimResultDTO
								.getCorrugatedPackaging());
			}

			dataCompProductmainResultDTO
					.setAvgMassOfPlasticFormPackaging(Double.parseDouble((String) prop8a
							.getProperty(productInformation.getProductDetails()
									.getProductType()
									+ "avgAmtOfplastic/foamperunitpackage")));
			// 14
			Double averageinput14 = null;
			if (productInformation.getLowRecycledResinContent() != null
					&& productInformation.getLowRecycledResinContent().trim()
							.length() > 0
					&& productInformation.getUpperRecycledResinContent() != null
					&& productInformation.getUpperRecycledResinContent().trim()
							.length() > 0) {
				averageinput14 = (Double.parseDouble(productInformation
						.getLowRecycledResinContent()) + Double
						.parseDouble(productInformation
								.getUpperRecycledResinContent())) / 2;
			}
			if (averageinput14 != null) {
				dataCompProductmainResultDTO
						.setAvgMassOfRecyContentInPlasticFormPackaging(averageinput14
								* dataCompProductmainResultDTO
										.getAvgMassOfPlasticFormPackaging());
			} else {
				dataCompProductmainResultDTO
						.setAvgMassOfRecyContentInPlasticFormPackaging(dataCompProductInterimResultDTO
								.getPlasticPackaging());
			}

			dataCompProductmainResultDTO.setAvgMassofOtherPackaging(Double
					.parseDouble((String) prop8a.getProperty(productInformation
							.getProductDetails().getProductType()
							+ "avgAmtOfotherPackagingperunitpackage")));
			dataCompProductmainResultDTO
					.setAvgTotalMassPackagingPerProduct(Double
							.parseDouble((String) prop8a
									.getProperty(productInformation
											.getProductDetails()
											.getProductType()
											+ "avgAmtOfPackagingperproduct")));

			// 15
			Double averageinput15 = null;
			if (productInformation.getLowRecycledAddPackageContent() != null
					&& productInformation.getLowRecycledAddPackageContent()
							.trim().length() > 0
					&& productInformation.getUpperRecycledAddPackageContent() != null
					&& productInformation.getUpperRecycledAddPackageContent()
							.trim().length() > 0) {
				averageinput15 = (Double.parseDouble(productInformation
						.getLowRecycledAddPackageContent()) + Double
						.parseDouble(productInformation
								.getUpperRecycledAddPackageContent())) / 2;
			}
			if (averageinput15 != null) {
				dataCompProductmainResultDTO
						.setAvgMassOfRecyContentInOtherPackaging(averageinput15
								* dataCompProductmainResultDTO
										.getAvgMassofOtherPackaging());
			} else {
				dataCompProductmainResultDTO
						.setAvgMassOfRecyContentInOtherPackaging(dataCompProductInterimResultDTO
								.getOtherPackaging());
			}

			if (productInformation.getIspostConsContentGuidelineMinimum() != null
					&& productInformation
							.getIspostConsContentGuidelineMinimum().length() > 0
					&& "yes".equalsIgnoreCase(productInformation
							.getIspostConsContentGuidelineMinimum())) {
				Double cpgValue = 0.25 * dataCompProductmainResultDTO
						.getAvgMassOfCorrugatedPackaging();
				dataCompProductmainResultDTO
						.setMassEqCpg25CorrugatedPackaging(cpgValue);
			} else {
				
				dataCompProductmainResultDTO
						.setMassEqCpg25CorrugatedPackaging(dataCompProductInterimResultDTO
								.getCpgPackaging());
			}
			if (productInformation.getIsReusablePackaging() != null
					&& "yes".equalsIgnoreCase(productInformation
							.getIsReusablePackaging())) {
				dataCompProductmainResultDTO.setPackagingAvoideByReuse(Double
						.parseDouble((String) prop8b1
								.getProperty("Packagingreused"))
						* dataCompProductmainResultDTO
								.getAvgTotalMassPackagingPerProduct());
			} else {
				dataCompProductmainResultDTO
						.setPackagingAvoideByReuse(dataCompProductInterimResultDTO
								.getPackagingReuse());
			}

			if (productInformation.getProductDetails().getIsProdEPEATRegd() != null
					&& productInformation.getProductDetails()
							.getIsProdEPEATRegd().trim().length() > 0
					&& "yes".equalsIgnoreCase(productInformation
							.getProductDetails().getIsProdEPEATRegd())) {
				dataCompProductmainResultDTO
						.setAvgUECForLCD(dataCompProductInterimResultDTO
								.getAvgUECForLCD());
				dataCompProductmainResultDTO
						.setAvgUECForCPU(dataCompProductInterimResultDTO
								.getAvgUECForCPU());
				dataCompProductmainResultDTO
						.setAvgUECForNtbk(dataCompProductInterimResultDTO
								.getAvgUECForNtbk());
			} else {
				if (productInformation.getPercentPowermkanagEnabledComp() != null
						|| productInformation
								.getPercentPowermkanagEnabledDisp() != null) {
					dataCompProductmainResultDTO
							.setAvgUECForLCD(calculatePowerManagement("lcd",
									"energy0", productInformation
											.getPercentPowermkanagEnabledComp()));
					dataCompProductmainResultDTO
							.setAvgUECForCPU(calculatePowerManagement("cpu",
									"energy0", productInformation
											.getPercentPowermkanagEnabledComp()));
					Double calculatedValueDisplay = (calculatePowerManagement(
							"notebookdisplay", "energy0",
							productInformation
									.getPercentPowermkanagEnabledDisp()));
					Double calculatedValueComp = calculatePowerManagement(
							"notebookcomputer", "energy0",
							productInformation
									.getPercentPowermkanagEnabledComp());
					dataCompProductmainResultDTO
							.setAvgUECForNtbk(calculatedValueDisplay
									+ calculatedValueComp);
				}
			}

		}
		return dataCompProductmainResultDTO;
	}
	

	private SupportingCalculationResultDTO generateSupportingCalculations(
			InputUseAndEOLDTO inputUseAndEOLDTO) {
		Double productAsPercentTotalUnitsForLCD = 0.00;
		Double productAsPercentTotalUnitsForCRT = 0.00;
		Double productAsPercentTotalUnitsForCPU = 0.00;
		Double productAsPercentTotalUnitsForNoteBook = 0.00;

		Double avgLifeSpanForLCD = 0.00;
		Double avgLifeSpanForCRT = 0.00;
		Double avgLifeSpanForCPU = 0.00;
		Double avgLifeSpanForNoteBook = 0.00;

		Double avgLifeSpanForProducts = 0.00;
		Double weightedAvgLifeSpan = 0.00;
		Double weightedAvgProductionEnergy = 0.00;

		if ((inputUseAndEOLDTO.getLcdUse().getTotalEnergy4Units() != null
				&& inputUseAndEOLDTO.getLcdUse().getTotalEnergy4Units().trim()
						.length() > 0 && Double.parseDouble(inputUseAndEOLDTO
				.getLcdUse().getTotalEnergy4Units()) > 0)
				|| (inputUseAndEOLDTO.getLcdUse().getTotalEnergy5Units() != null
						&& inputUseAndEOLDTO.getLcdUse().getTotalEnergy5Units()
								.trim().length() > 0 && Double
						.parseDouble(inputUseAndEOLDTO.getLcdUse()
								.getTotalEnergy5Units()) > 0)) {
			
			if ((inputUseAndEOLDTO.getLcdUse().getTotalEnergy4Units() != null
					&& inputUseAndEOLDTO.getLcdUse().getTotalEnergy4Units().trim()
							.length() > 0 && Double.parseDouble(inputUseAndEOLDTO
					.getLcdUse().getTotalEnergy4Units()) > 0))
			{
				productAsPercentTotalUnitsForLCD = productAsPercentTotalUnitsForLCD +  (Double
						.parseDouble(inputUseAndEOLDTO.getLcdUse()
								.getTotalEnergy4Units()));
			}
			
			if ((inputUseAndEOLDTO.getLcdUse().getTotalEnergy5Units() != null
					&& inputUseAndEOLDTO.getLcdUse().getTotalEnergy5Units().trim()
							.length() > 0 && Double.parseDouble(inputUseAndEOLDTO
					.getLcdUse().getTotalEnergy5Units()) > 0))
			{
				productAsPercentTotalUnitsForLCD = productAsPercentTotalUnitsForLCD + (Double
						.parseDouble(inputUseAndEOLDTO.getLcdUse()
								.getTotalEnergy5Units()));
			}
			productAsPercentTotalUnitsForLCD = productAsPercentTotalUnitsForLCD
					/ Double.parseDouble(inputUseAndEOLDTO.getUseTotal());
		} else {
			if (inputUseAndEOLDTO.getUseTotal() != null
					&& inputUseAndEOLDTO.getUseTotal().trim().length() > 0
					&& Double.parseDouble(inputUseAndEOLDTO.getUseTotal()) == 0) {
				productAsPercentTotalUnitsForLCD = 0.00;
			}
		}

		if ((inputUseAndEOLDTO.getCrtUse().getTotalEnergy4Units() != null
				&& inputUseAndEOLDTO.getCrtUse().getTotalEnergy4Units().trim()
						.length() > 0 && Double.parseDouble(inputUseAndEOLDTO
				.getCrtUse().getTotalEnergy4Units()) > 0)
				|| (inputUseAndEOLDTO.getCrtUse().getTotalEnergy5Units() != null
						&& inputUseAndEOLDTO.getCrtUse().getTotalEnergy5Units()
								.trim().length() > 0 && Double
						.parseDouble(inputUseAndEOLDTO.getCrtUse()
								.getTotalEnergy5Units()) > 0)) {
			productAsPercentTotalUnitsForCRT = Double
					.parseDouble(inputUseAndEOLDTO.getCrtUse()
							.getTotalEnergy4Units())
					/ Double.parseDouble(inputUseAndEOLDTO.getUseTotal());
		} else {
			if (inputUseAndEOLDTO.getUseTotal() != null
					&& inputUseAndEOLDTO.getUseTotal().trim().length() > 0
					&& Double.parseDouble(inputUseAndEOLDTO.getUseTotal()) == 0) {
				productAsPercentTotalUnitsForCRT = 0.00;
			}
		}

		if ((inputUseAndEOLDTO.getDesktopComputerUse().getTotalEnergy4Units() != null
				&& inputUseAndEOLDTO.getDesktopComputerUse()
						.getTotalEnergy4Units().trim().length() > 0 && Double
				.parseDouble(inputUseAndEOLDTO.getDesktopComputerUse()
						.getTotalEnergy4Units()) > 0)
				|| (inputUseAndEOLDTO.getDesktopComputerUse()
						.getTotalEnergy5Units() != null
						&& inputUseAndEOLDTO.getDesktopComputerUse()
								.getTotalEnergy5Units().trim().length() > 0 && Double
						.parseDouble(inputUseAndEOLDTO.getDesktopComputerUse()
								.getTotalEnergy5Units()) > 0)) {
			
			if (inputUseAndEOLDTO.getDesktopComputerUse().getTotalEnergy4Units() != null
					&& inputUseAndEOLDTO.getDesktopComputerUse()
							.getTotalEnergy4Units().trim().length() > 0 && Double
					.parseDouble(inputUseAndEOLDTO.getDesktopComputerUse()
							.getTotalEnergy4Units()) > 0){
				productAsPercentTotalUnitsForCPU =  (Double
						.parseDouble(inputUseAndEOLDTO.getDesktopComputerUse()
								.getTotalEnergy4Units()));
				
			}
			
			if(inputUseAndEOLDTO.getDesktopComputerUse()
					.getTotalEnergy5Units() != null
					&& inputUseAndEOLDTO.getDesktopComputerUse()
							.getTotalEnergy5Units().trim().length() > 0 && Double
					.parseDouble(inputUseAndEOLDTO.getDesktopComputerUse()
							.getTotalEnergy5Units()) > 0)
			{
				productAsPercentTotalUnitsForCPU = productAsPercentTotalUnitsForCPU+ (Double
						.parseDouble(inputUseAndEOLDTO.getDesktopComputerUse()
								.getTotalEnergy5Units()));
			}
			
			productAsPercentTotalUnitsForCPU = productAsPercentTotalUnitsForCPU
					/ Double.parseDouble(inputUseAndEOLDTO.getUseTotal());
		} else {
			if (inputUseAndEOLDTO.getUseTotal() != null
					&& inputUseAndEOLDTO.getUseTotal().trim().length() > 0
					&& Double.parseDouble(inputUseAndEOLDTO.getUseTotal()) == 0) {
				productAsPercentTotalUnitsForCPU = 0.00;
			}
		}

		if ((inputUseAndEOLDTO.getNotebookUse().getTotalEnergy4Units() != null
				&& inputUseAndEOLDTO.getNotebookUse().getTotalEnergy4Units()
						.trim().length() > 0 && Double
				.parseDouble(inputUseAndEOLDTO.getNotebookUse()
						.getTotalEnergy4Units()) > 0)
				|| (inputUseAndEOLDTO.getNotebookUse().getTotalEnergy5Units() != null
						&& inputUseAndEOLDTO.getNotebookUse()
								.getTotalEnergy5Units().trim().length() > 0 && Double
						.parseDouble(inputUseAndEOLDTO.getNotebookUse()
								.getTotalEnergy5Units()) > 0)) {
			
			if(inputUseAndEOLDTO.getNotebookUse().getTotalEnergy4Units() != null
					&& inputUseAndEOLDTO.getNotebookUse().getTotalEnergy4Units()
					.trim().length() > 0 && Double
			.parseDouble(inputUseAndEOLDTO.getNotebookUse()
					.getTotalEnergy4Units()) > 0)
			{
				productAsPercentTotalUnitsForNoteBook = ((Double
						.parseDouble(inputUseAndEOLDTO.getNotebookUse()
								.getTotalEnergy4Units())));
			}
			
			if(inputUseAndEOLDTO.getNotebookUse().getTotalEnergy5Units() != null
					&& inputUseAndEOLDTO.getNotebookUse().getTotalEnergy5Units()
					.trim().length() > 0 && Double
			.parseDouble(inputUseAndEOLDTO.getNotebookUse()
					.getTotalEnergy5Units()) > 0)
			{
				productAsPercentTotalUnitsForNoteBook = productAsPercentTotalUnitsForNoteBook + ((Double
						.parseDouble(inputUseAndEOLDTO.getNotebookUse()
								.getTotalEnergy5Units())));
			}
			
			productAsPercentTotalUnitsForNoteBook = (productAsPercentTotalUnitsForNoteBook)/ (Double
					.parseDouble(inputUseAndEOLDTO.getUseTotal()));
		} else {
			if (inputUseAndEOLDTO.getUseTotal() != null
					&& inputUseAndEOLDTO.getUseTotal().trim().length() > 0
					&& Double.parseDouble(inputUseAndEOLDTO.getUseTotal()) == 0) {
				productAsPercentTotalUnitsForNoteBook = 0.00;
			}
		}
		if (inputUseAndEOLDTO.getLcdUse().getAverageLifeSpanOfUnits() != null
				&& inputUseAndEOLDTO.getLcdUse().getAverageLifeSpanOfUnits()
						.trim().length() > 0
				&& Double.parseDouble(inputUseAndEOLDTO.getLcdUse()
						.getAverageLifeSpanOfUnits()) > 0) {
			avgLifeSpanForLCD = Double.parseDouble(inputUseAndEOLDTO
					.getLcdUse().getAverageLifeSpanOfUnits());
		} else {
			avgLifeSpanForLCD = Double.parseDouble((String) prop8a
					.getProperty("lcdavglifetimeOfunit"));
		}
		if (inputUseAndEOLDTO.getNotebookUse().getAverageLifeSpanOfUnits() != null
				&& inputUseAndEOLDTO.getNotebookUse()
						.getAverageLifeSpanOfUnits().trim().length() > 0
				&& Double.parseDouble(inputUseAndEOLDTO.getNotebookUse()
						.getAverageLifeSpanOfUnits()) > 0) {
			avgLifeSpanForNoteBook = Double.parseDouble(inputUseAndEOLDTO
					.getNotebookUse().getAverageLifeSpanOfUnits());
		} else {
			avgLifeSpanForNoteBook = Double.parseDouble((String) prop8a
					.getProperty("notebookavglifetimeOfunit"));
		}
		if (inputUseAndEOLDTO.getCrtUse().getAverageLifeSpanOfUnits() != null
				&& inputUseAndEOLDTO.getCrtUse().getAverageLifeSpanOfUnits()
						.trim().length() > 0
				&& Double.parseDouble(inputUseAndEOLDTO.getCrtUse()
						.getAverageLifeSpanOfUnits()) > 0) {
			avgLifeSpanForCRT = Double.parseDouble(inputUseAndEOLDTO
					.getCrtUse().getAverageLifeSpanOfUnits());
		} else {
			avgLifeSpanForCRT = Double.parseDouble((String) prop8a
					.getProperty("crtavglifetimeOfunit"));
		}
		if (inputUseAndEOLDTO.getDesktopComputerUse()
				.getAverageLifeSpanOfUnits() != null
				&& inputUseAndEOLDTO.getDesktopComputerUse()
						.getAverageLifeSpanOfUnits().trim().length() > 0
				&& Double.parseDouble(inputUseAndEOLDTO.getDesktopComputerUse()
						.getAverageLifeSpanOfUnits()) > 0) {
			avgLifeSpanForCPU = Double.parseDouble(inputUseAndEOLDTO
					.getDesktopComputerUse().getAverageLifeSpanOfUnits());
		} else {
			avgLifeSpanForCPU = Double.parseDouble((String) prop8a
					.getProperty("cpuavglifetimeOfunit"));
		}
		if (inputUseAndEOLDTO.getUseTotal() != null
				&& inputUseAndEOLDTO.getUseTotal().trim().length() > 0
				&& Double.parseDouble(inputUseAndEOLDTO.getUseTotal()) > 0) {

			avgLifeSpanForProducts = ((productAsPercentTotalUnitsForLCD * Double
					.parseDouble((String) prop8a
							.getProperty("lcdavglifetimeOfunit")))
					+ (productAsPercentTotalUnitsForCPU * Double
							.parseDouble((String) prop8a
									.getProperty("cpuavglifetimeOfunit")))
					+ (productAsPercentTotalUnitsForCRT * Double
							.parseDouble((String) prop8a
									.getProperty("crtavglifetimeOfunit"))) + (productAsPercentTotalUnitsForNoteBook * Double
					.parseDouble((String) prop8a
							.getProperty("notebookavglifetimeOfunit")))) * 1.00;
			weightedAvgLifeSpan = ((productAsPercentTotalUnitsForLCD) * (avgLifeSpanForLCD))
					+ ((productAsPercentTotalUnitsForCPU) * (avgLifeSpanForCPU))
					+ ((productAsPercentTotalUnitsForCRT) * (avgLifeSpanForCRT))
					+ ((productAsPercentTotalUnitsForNoteBook) * (avgLifeSpanForNoteBook))
					* 1.00;
			weightedAvgProductionEnergy = (productAsPercentTotalUnitsForLCD * (Double
					.parseDouble((String) propproductInterim
							.getProperty("energyProductionlcd"))))
					+ (productAsPercentTotalUnitsForCRT * (Double
							.parseDouble((String) propproductInterim
									.getProperty("energyProductioncrt"))))
					+ (productAsPercentTotalUnitsForCPU * (Double
							.parseDouble((String) propproductInterim
									.getProperty("energyProductioncpu"))))
					+ (productAsPercentTotalUnitsForNoteBook * (Double
							.parseDouble((String) propproductInterim
									.getProperty("energyProductionnotebook"))));
		} else {
			avgLifeSpanForProducts = ((Double
					.parseDouble((String) propproductInterim
							.getProperty("distributionlcd"))) * Double
					.parseDouble((String) prop8a
							.getProperty("lcdavglifetimeOfunit")))
					+ ((Double.parseDouble((String) propproductInterim
							.getProperty("distributioncpu"))) * Double
							.parseDouble((String) prop8a
									.getProperty("cpuavglifetimeOfunit")))
					+ ((Double.parseDouble((String) propproductInterim
							.getProperty("distributioncrt")) * Double
							.parseDouble((String) prop8a
									.getProperty("crtavglifetimeOfunit"))) + ((Double
							.parseDouble((String) propproductInterim
									.getProperty("distributionnotebook"))) * Double
							.parseDouble((String) prop8a
									.getProperty("notebookavglifetimeOfunit"))))
					* 1.00;
			weightedAvgLifeSpan = ((Double
					.parseDouble((String) propproductInterim
							.getProperty("distributionlcd"))) * (avgLifeSpanForLCD))
					+ ((Double.parseDouble((String) propproductInterim
							.getProperty("distributioncpu"))) * (avgLifeSpanForCPU))
					+ ((Double.parseDouble((String) propproductInterim
							.getProperty("distributioncrt"))) * (avgLifeSpanForCRT))
					+ ((Double.parseDouble((String) propproductInterim
							.getProperty("distributionnotebook"))) * (avgLifeSpanForNoteBook));
			weightedAvgProductionEnergy = ((Double
					.parseDouble((String) propproductInterim
							.getProperty("energyProductionlcd"))) * (Double
					.parseDouble((String) propproductInterim
							.getProperty("distributionlcd"))))
					+ ((Double.parseDouble((String) propproductInterim
							.getProperty("energyProductioncrt"))) * ((Double
							.parseDouble((String) propproductInterim
									.getProperty("distributioncrt")))))
					+ ((Double.parseDouble((String) propproductInterim
							.getProperty("energyProductioncpu"))) * (Double
							.parseDouble((String) propproductInterim
									.getProperty("distributioncpu"))))
					+ ((Double.parseDouble((String) propproductInterim
							.getProperty("energyProductionnotebook"))) * (Double
							.parseDouble((String) propproductInterim
									.getProperty("distributionnotebook"))));
		}

		SupportingCalculationResultDTO supportingCalculationResultDTO = new SupportingCalculationResultDTO();
		supportingCalculationResultDTO.setAvgLifeSpanForCPU(avgLifeSpanForCPU);
		supportingCalculationResultDTO.setAvgLifeSpanForCRT(avgLifeSpanForCRT);
		supportingCalculationResultDTO.setAvgLifeSpanForLCD(avgLifeSpanForLCD);
		supportingCalculationResultDTO
				.setAvgLifeSpanForNoteBook(avgLifeSpanForNoteBook);
		supportingCalculationResultDTO
				.setWeightedAvgLifeSpan(weightedAvgLifeSpan);
		supportingCalculationResultDTO
				.setWeightedAvgProductionEnergy(weightedAvgProductionEnergy);
		supportingCalculationResultDTO
				.setAvgLifeSpanForProducts(avgLifeSpanForProducts);
		supportingCalculationResultDTO
				.setProductAsPercentTotalUnitsForCPU(productAsPercentTotalUnitsForCPU);
		supportingCalculationResultDTO
				.setProductAsPercentTotalUnitsForCRT(productAsPercentTotalUnitsForCRT);
		supportingCalculationResultDTO
				.setProductAsPercentTotalUnitsForLCD(productAsPercentTotalUnitsForLCD);
		supportingCalculationResultDTO
				.setProductAsPercentTotalUnitsForNoteBook(productAsPercentTotalUnitsForNoteBook);
		return supportingCalculationResultDTO;

	}

	private Double calculateTableB(String productType, String energyValue,
			Double tableAValue, InputUseAndEOLDTO inputUseAndEOLDTO,
			SupportingCalculationResultDTO supportingCalculationResultDTO) {

		Double value = 0.00;
		if ("notebook".equalsIgnoreCase(productType)) {
			// taking into consideration the average life span for the notebook-
			// not differentiating between display and the regular
			Double lookupDisplay = Double
					.parseDouble((String) propproductInterim
							.getProperty("weightedAvgnotebookdisplay"
									+ energyValue));
			Double lookupComputer = Double
					.parseDouble((String) propproductInterim
							.getProperty("weightedAvgnotebookcomputer"
									+ energyValue));
			Double valueDisp = 0.00;
			Double valueComp = 0.00;
			if ("energy4".equalsIgnoreCase(energyValue)) {
				if ((inputUseAndEOLDTO.getNotebookUse() != null
						&& inputUseAndEOLDTO.getNotebookUse()
								.getPercentPowerManagedDisplay().trim()
								.length() > 0 && Double
						.parseDouble(inputUseAndEOLDTO.getNotebookUse()
								.getPercentPowerManagedDisplay()) > 0)
						&& (inputUseAndEOLDTO.getNotebookUse()
								.getTotalEnergy4Units() != null
								&& inputUseAndEOLDTO.getNotebookUse()
										.getTotalEnergy4Units().trim().length() > 0 && Double
								.parseDouble(inputUseAndEOLDTO.getNotebookUse()
										.getTotalEnergy4Units()) > 0)) {
				valueDisp = (lookupDisplay - tableAValue)
					//valueDisp = ( tableAValue - lookupDisplay)
							* Double.parseDouble(inputUseAndEOLDTO
									.getNotebookUse().getTotalEnergy4Units())
							* supportingCalculationResultDTO
									.getAvgLifeSpanForNoteBook();
				}
				if ((inputUseAndEOLDTO.getNotebookUse() != null
						&& inputUseAndEOLDTO.getNotebookUse()
								.getPercentPowerManagedComputer().trim()
								.length() > 0 && Double
						.parseDouble(inputUseAndEOLDTO.getNotebookUse()
								.getPercentPowerManagedComputer()) > 0)
						&& (inputUseAndEOLDTO.getNotebookUse()
								.getTotalEnergy4Units() != null
								&& inputUseAndEOLDTO.getNotebookUse()
										.getTotalEnergy4Units().trim().length() > 0 && Double
								.parseDouble(inputUseAndEOLDTO.getNotebookUse()
										.getTotalEnergy4Units()) > 0)) {
					valueComp = (lookupComputer - tableAValue)
				//	valueDisp = ( tableAValue - lookupDisplay)
							* Double.parseDouble(inputUseAndEOLDTO
									.getNotebookUse().getTotalEnergy4Units())
							* supportingCalculationResultDTO
									.getAvgLifeSpanForNoteBook();
				}

			} else {
				if ((inputUseAndEOLDTO.getNotebookUse() != null
						&& inputUseAndEOLDTO.getNotebookUse()
								.getPercentPowerManagedDisplay().trim()
								.length() > 0 && Double
						.parseDouble(inputUseAndEOLDTO.getNotebookUse()
								.getPercentPowerManagedDisplay()) > 0)
						&& (inputUseAndEOLDTO.getNotebookUse()
								.getTotalEnergy5Units() != null
								&& inputUseAndEOLDTO.getNotebookUse()
										.getTotalEnergy5Units().trim().length() > 0 && Double
								.parseDouble(inputUseAndEOLDTO.getNotebookUse()
										.getTotalEnergy5Units()) > 0)) {
				valueDisp = (lookupDisplay - tableAValue)
				//	valueDisp = ( tableAValue - lookupDisplay )
							* Double.parseDouble(inputUseAndEOLDTO
									.getNotebookUse()
									.getTotalEnergy5Units())
							* supportingCalculationResultDTO
									.getAvgLifeSpanForNoteBook();
				}
				if ((inputUseAndEOLDTO.getNotebookUse() != null
						&& inputUseAndEOLDTO.getNotebookUse()
								.getPercentPowerManagedComputer().trim()
								.length() > 0 && Double
						.parseDouble(inputUseAndEOLDTO.getNotebookUse()
								.getPercentPowerManagedComputer()) > 0)
						&& (inputUseAndEOLDTO.getNotebookUse()
								.getTotalEnergy5Units() != null
								&& inputUseAndEOLDTO.getNotebookUse()
										.getTotalEnergy5Units().trim().length() > 0 && Double
								.parseDouble(inputUseAndEOLDTO.getNotebookUse()
										.getTotalEnergy5Units()) > 0)) {
					valueComp = (lookupComputer - tableAValue)
				//	valueComp = (tableAValue - lookupComputer)
							* Double.parseDouble(inputUseAndEOLDTO
									.getNotebookUse()
									.getTotalEnergy5Units())
							* supportingCalculationResultDTO
									.getAvgLifeSpanForNoteBook();
				}
			}
			value = valueDisp + valueComp;
		} else {
			Double lookupValue = Double.parseDouble((String) propproductInterim
					.getProperty("weightedAvg" + productType + energyValue));

			if ("cpu".equalsIgnoreCase(productType)) {
				if ("energy4".equalsIgnoreCase(energyValue)) {
					if (inputUseAndEOLDTO.getDesktopComputerUse()
							.getTotalEnergy4Units() != null
							&& inputUseAndEOLDTO.getDesktopComputerUse()
									.getTotalEnergy4Units().trim().length() > 0) {
					 value = (lookupValue - tableAValue)
					//	value = ( tableAValue - lookupValue)
								* Double.parseDouble(inputUseAndEOLDTO
										.getDesktopComputerUse()
										.getTotalEnergy4Units())
								* supportingCalculationResultDTO
										.getAvgLifeSpanForCPU();
					}
				} else {
					if (inputUseAndEOLDTO.getDesktopComputerUse()
							.getTotalEnergy5Units() != null
							&& inputUseAndEOLDTO.getDesktopComputerUse()
									.getTotalEnergy5Units().trim().length() > 0) {
						 value = (lookupValue - tableAValue)
					//	value = (tableAValue - lookupValue )
								* Double.parseDouble(inputUseAndEOLDTO
										.getDesktopComputerUse()
										.getTotalEnergy5Units())
								* supportingCalculationResultDTO
										.getAvgLifeSpanForCPU();
					}
				}
			} else if ("crt".equalsIgnoreCase(productType)) {
				if ("energy4".equalsIgnoreCase(energyValue)) {
					if (inputUseAndEOLDTO.getCrtUse().getTotalEnergy4Units() != null
							&& inputUseAndEOLDTO.getCrtUse()
									.getTotalEnergy4Units().trim().length() > 0) {
					 value = (lookupValue - tableAValue)
					//	value = ( tableAValue - lookupValue)
								* Double.parseDouble(inputUseAndEOLDTO
										.getCrtUse().getTotalEnergy4Units())
								* supportingCalculationResultDTO
										.getAvgLifeSpanForCRT();
					}
				} else {
					if (inputUseAndEOLDTO.getCrtUse().getTotalEnergy5Units() != null
							&& inputUseAndEOLDTO.getCrtUse()
									.getTotalEnergy5Units().trim().length() > 0) {
					 value = (lookupValue - tableAValue)
					//	value = ( tableAValue - lookupValue)
								* Double.parseDouble(inputUseAndEOLDTO
										.getCrtUse().getTotalEnergy5Units())
								* supportingCalculationResultDTO
										.getAvgLifeSpanForCRT();
					}
				}
			} else if ("lcd".equalsIgnoreCase(productType)) {
				if ("energy4".equalsIgnoreCase(energyValue)) {
					if (inputUseAndEOLDTO.getLcdUse().getTotalEnergy4Units() != null
							&& inputUseAndEOLDTO.getLcdUse()
									.getTotalEnergy4Units().trim().length() > 0) {
						value = (lookupValue - tableAValue)
						//value = (tableAValue - lookupValue)
								* Double.parseDouble(inputUseAndEOLDTO
										.getLcdUse().getTotalEnergy4Units())
								* supportingCalculationResultDTO
										.getAvgLifeSpanForLCD();
					}
				} else {
					if (inputUseAndEOLDTO.getLcdUse().getTotalEnergy5Units() != null
							&& inputUseAndEOLDTO.getLcdUse()
									.getTotalEnergy5Units().trim().length() > 0) {
				value = (lookupValue - tableAValue)
					//	value = ( tableAValue -lookupValue)
								* Double.parseDouble(inputUseAndEOLDTO
										.getLcdUse().getTotalEnergy5Units())
								* supportingCalculationResultDTO
										.getAvgLifeSpanForLCD();
					}
				}
			}
		}

		return value;
	}

	public DataCompUseDataInterimResultDTO generateDataCompUseDataInterimResultDTO(
			InputUseAndEOLDTO inputUseAndEOLDTO) {
		DataCompUseDataInterimResultDTO dataCompUseDataInterimResultDTO = new DataCompUseDataInterimResultDTO();

		if (inputUseAndEOLDTO != null) {

			if (inputUseAndEOLDTO.getDesktopComputerUse() != null) {
				Double lifeSpanValue = supportingCalculationResultDTO
						.getAvgLifeSpanForCPU();
				if ((inputUseAndEOLDTO.getDesktopComputerUse()
						.getTotalEnergy4Units() != null
						&& inputUseAndEOLDTO.getDesktopComputerUse()
								.getTotalEnergy4Units().trim().length() > 0 && Double
						.parseDouble(inputUseAndEOLDTO.getDesktopComputerUse()
								.getTotalEnergy4Units()) > 0)
						&& (inputUseAndEOLDTO.getDesktopComputerUse()
								.getPercentPowerManagedComputer() != null
								&& inputUseAndEOLDTO.getDesktopComputerUse()
										.getPercentPowerManagedComputer()
										.trim().length() > 0 && Double
								.parseDouble(inputUseAndEOLDTO
										.getDesktopComputerUse()
										.getPercentPowerManagedComputer()) > 0)) {
					dataCompUseDataInterimResultDTO
							.setUecforProductEnergy4cpu(calculatePowerManagement(
									"cpu", "energy4", inputUseAndEOLDTO
											.getDesktopComputerUse()
											.getPercentPowerManagedComputer()));
					Double tableValue = calculateTableB("cpu", "energy4",
							dataCompUseDataInterimResultDTO
									.getUecforProductEnergy4cpu(),
							inputUseAndEOLDTO, supportingCalculationResultDTO);
					dataCompUseDataInterimResultDTO
							.setLifetimeuecforProductEnergy4cpu(tableValue / 12);
					if (dataCompUseDataInterimResultDTO
							.getLifetimeuecforProductEnergy4cpu() != null
							&& (dataCompUseDataInterimResultDTO
									.getLifetimeuecforProductEnergy4cpu()) > 0) {
						dataCompUseDataInterimResultDTO
								.setLifetimeuecgt0forProductEnergy4cpu(dataCompUseDataInterimResultDTO
										.getLifetimeuecforProductEnergy4cpu());
					} else {
						dataCompUseDataInterimResultDTO
								.setLifetimeuecgt0forProductEnergy4cpu(0.00);
					}
					// table d
					if (lifeSpanValue > 12) {
						dataCompUseDataInterimResultDTO
								.setFirstYearuecforProductEnergy4cpu(tableValue
										/ supportingCalculationResultDTO
												.getAvgLifeSpanForCPU());
					} else {
						dataCompUseDataInterimResultDTO
								.setFirstYearuecforProductEnergy4cpu(tableValue
										/ (12 * supportingCalculationResultDTO
												.getAvgLifeSpanForCPU()));
					}
					if (dataCompUseDataInterimResultDTO
							.getFirstYearuecforProductEnergy4cpu() > 0) {
						dataCompUseDataInterimResultDTO
								.setFirstYearuecgt0forProductEnergy4cpu(dataCompUseDataInterimResultDTO
										.getFirstYearuecforProductEnergy4cpu());
					} else {
						dataCompUseDataInterimResultDTO
								.setFirstYearuecgt0forProductEnergy4cpu(0.00);
					}
				} else {
					dataCompUseDataInterimResultDTO
							.setLifetimeuecforProductEnergy4cpu(0.00);
					dataCompUseDataInterimResultDTO
							.setLifetimeuecgt0forProductEnergy4cpu(0.00);
					dataCompUseDataInterimResultDTO
							.setFirstYearuecgt0forProductEnergy4cpu(0.00);
					dataCompUseDataInterimResultDTO
							.setFirstYearuecforProductEnergy4cpu(0.00);
				}
				if ((inputUseAndEOLDTO.getDesktopComputerUse()
						.getTotalEnergy5Units() != null
						&& inputUseAndEOLDTO.getDesktopComputerUse()
								.getTotalEnergy5Units().trim().length() > 0 && Double
						.parseDouble(inputUseAndEOLDTO.getDesktopComputerUse()
								.getTotalEnergy5Units()) > 0)
						&& (inputUseAndEOLDTO.getDesktopComputerUse()
								.getPercentPowerManagedComputer() != null
								&& inputUseAndEOLDTO.getDesktopComputerUse()
										.getPercentPowerManagedComputer()
										.trim().length() > 0 && Double
								.parseDouble(inputUseAndEOLDTO
										.getDesktopComputerUse()
										.getPercentPowerManagedComputer()) > 0)) {
					dataCompUseDataInterimResultDTO
							.setUecforProductEnergy5cpu(calculatePowerManagement(
									"cpu", "energy5", inputUseAndEOLDTO
											.getDesktopComputerUse()
											.getPercentPowerManagedComputer()));
					Double tableValue = calculateTableB("cpu", "energy5",
							dataCompUseDataInterimResultDTO
									.getUecforProductEnergy5cpu(),
							inputUseAndEOLDTO, supportingCalculationResultDTO);
					dataCompUseDataInterimResultDTO
							.setLifetimeuecforProductEnergy5cpu(tableValue / 12);
					if (dataCompUseDataInterimResultDTO
							.getLifetimeuecforProductEnergy5cpu() != null
							&& (dataCompUseDataInterimResultDTO
									.getLifetimeuecforProductEnergy5cpu()) > 0) {
						dataCompUseDataInterimResultDTO
								.setLifetimeuecgt0forProductEnergy5cpu(dataCompUseDataInterimResultDTO
										.getLifetimeuecforProductEnergy5cpu());
					} else {
						dataCompUseDataInterimResultDTO
								.setLifetimeuecgt0forProductEnergy5cpu(0.00);
					}
					if (lifeSpanValue > 12) {
						dataCompUseDataInterimResultDTO
								.setFirstYearuecforProductEnergy5cpu(tableValue
										/ supportingCalculationResultDTO
												.getAvgLifeSpanForCPU());
					} else {
						dataCompUseDataInterimResultDTO
								.setFirstYearuecforProductEnergy5cpu(tableValue
										/ (12 * supportingCalculationResultDTO
												.getAvgLifeSpanForCPU()));
					}
					if (dataCompUseDataInterimResultDTO
							.getFirstYearuecforProductEnergy5cpu() > 0) {
						dataCompUseDataInterimResultDTO
								.setFirstYearuecgt0forProductEnergy5cpu(dataCompUseDataInterimResultDTO
										.getFirstYearuecforProductEnergy5cpu());
					} else {
						dataCompUseDataInterimResultDTO
								.setFirstYearuecgt0forProductEnergy5cpu(0.00);
					}

				} else {
					dataCompUseDataInterimResultDTO
							.setLifetimeuecforProductEnergy5cpu(0.00);
					dataCompUseDataInterimResultDTO
							.setLifetimeuecgt0forProductEnergy5cpu(0.00);
					dataCompUseDataInterimResultDTO
							.setFirstYearuecgt0forProductEnergy5cpu(0.00);
					dataCompUseDataInterimResultDTO
							.setFirstYearuecforProductEnergy5cpu(0.00);
				}
			}
			if (inputUseAndEOLDTO.getCrtUse() != null) {
				Double lifeSpanValue = supportingCalculationResultDTO
						.getAvgLifeSpanForCRT();
				if ((inputUseAndEOLDTO.getCrtUse() != null
						&& inputUseAndEOLDTO.getCrtUse()
								.getPercentPowerManagedDisplay().trim()
								.length() > 0 && Double
						.parseDouble(inputUseAndEOLDTO.getCrtUse()
								.getPercentPowerManagedDisplay()) > 0)
						&& (inputUseAndEOLDTO.getCrtUse()
								.getTotalEnergy4Units() != null
								&& inputUseAndEOLDTO.getCrtUse()
										.getTotalEnergy4Units().trim().length() > 0 && Double
								.parseDouble(inputUseAndEOLDTO.getCrtUse()
										.getTotalEnergy4Units()) > 0)) {
					dataCompUseDataInterimResultDTO
							.setUecforProductEnergy4crt(calculatePowerManagement(
									"crt", "energy4", inputUseAndEOLDTO
											.getCrtUse()
											.getPercentPowerManagedDisplay()));
					Double tableValue = calculateTableB("crt", "energy4",
							dataCompUseDataInterimResultDTO
									.getUecforProductEnergy4crt(),
							inputUseAndEOLDTO, supportingCalculationResultDTO);
					dataCompUseDataInterimResultDTO
							.setLifetimeuecforProductEnergy4crt(tableValue / 12);
					if (dataCompUseDataInterimResultDTO
							.getLifetimeuecforProductEnergy4crt() != null
							&& (dataCompUseDataInterimResultDTO
									.getLifetimeuecforProductEnergy4crt()) > 0) {
						dataCompUseDataInterimResultDTO
								.setLifetimeuecgt0forProductEnergy4crt(dataCompUseDataInterimResultDTO
										.getLifetimeuecforProductEnergy4crt());
					} else {
						dataCompUseDataInterimResultDTO
								.setLifetimeuecgt0forProductEnergy4crt(0.00);
					}
					Double value4FirstYearCRT = tableValue
							/ supportingCalculationResultDTO
									.getAvgLifeSpanForCRT();
					if (lifeSpanValue > 12) {
						dataCompUseDataInterimResultDTO
								.setFirstYearuecforProductEnergy4crt(value4FirstYearCRT);
					} else {
						dataCompUseDataInterimResultDTO
								.setFirstYearuecforProductEnergy4crt(value4FirstYearCRT / 12);
					}
					if (dataCompUseDataInterimResultDTO
							.getFirstYearuecforProductEnergy4crt() > 0) {
						dataCompUseDataInterimResultDTO
								.setFirstYearuecgt0forProductEnergy4crt(dataCompUseDataInterimResultDTO
										.getFirstYearuecforProductEnergy4crt());
					} else {
						dataCompUseDataInterimResultDTO
								.setFirstYearuecgt0forProductEnergy4crt(0.00);
					}
				} else {
					dataCompUseDataInterimResultDTO
							.setLifetimeuecforProductEnergy4crt(0.00);
					dataCompUseDataInterimResultDTO
							.setLifetimeuecgt0forProductEnergy4crt(0.00);
					dataCompUseDataInterimResultDTO
							.setFirstYearuecgt0forProductEnergy4crt(0.00);
					dataCompUseDataInterimResultDTO
							.setFirstYearuecforProductEnergy4crt(0.00);
				}
			}
			if (inputUseAndEOLDTO.getLcdUse() != null) {
				Double lifeSpanValue = supportingCalculationResultDTO
						.getAvgLifeSpanForLCD();
				if ((inputUseAndEOLDTO.getLcdUse() != null
						&& inputUseAndEOLDTO.getLcdUse()
								.getPercentPowerManagedDisplay().trim()
								.length() > 0 && Double
						.parseDouble(inputUseAndEOLDTO.getLcdUse()
								.getPercentPowerManagedDisplay()) > 0)
						&& (inputUseAndEOLDTO.getLcdUse()
								.getTotalEnergy4Units() != null
								&& inputUseAndEOLDTO.getLcdUse()
										.getTotalEnergy4Units().trim().length() > 0 && Double
								.parseDouble(inputUseAndEOLDTO.getLcdUse()
										.getTotalEnergy4Units()) > 0)) {
					dataCompUseDataInterimResultDTO
							.setUecforProductEnergy4lcd(calculatePowerManagement(
									"lcd", "energy4", inputUseAndEOLDTO
											.getLcdUse()
											.getPercentPowerManagedDisplay()));
					Double tableValue = calculateTableB("lcd", "energy4",
							dataCompUseDataInterimResultDTO
									.getUecforProductEnergy4lcd(),
							inputUseAndEOLDTO, supportingCalculationResultDTO);
					dataCompUseDataInterimResultDTO
							.setLifetimeuecforProductEnergy4lcd(tableValue / 12);
					if (dataCompUseDataInterimResultDTO
							.getLifetimeuecforProductEnergy4lcd() != null
							&& (dataCompUseDataInterimResultDTO
									.getLifetimeuecforProductEnergy4lcd()) > 0) {
						dataCompUseDataInterimResultDTO
								.setLifetimeuecgt0forProductEnergy4lcd(dataCompUseDataInterimResultDTO
										.getLifetimeuecforProductEnergy4lcd());
					} else {
						dataCompUseDataInterimResultDTO
								.setLifetimeuecgt0forProductEnergy4lcd(0.00);
					}
					Double value4FirstYearLCD = tableValue
							/ supportingCalculationResultDTO
									.getAvgLifeSpanForLCD();
					if (lifeSpanValue > 12) {
						dataCompUseDataInterimResultDTO
								.setFirstYearuecforProductEnergy4lcd(value4FirstYearLCD);
					} else {
						dataCompUseDataInterimResultDTO
								.setFirstYearuecforProductEnergy4lcd(value4FirstYearLCD / 12);
					}
					if (dataCompUseDataInterimResultDTO
							.getFirstYearuecforProductEnergy4lcd() > 0) {
						dataCompUseDataInterimResultDTO
								.setFirstYearuecgt0forProductEnergy4lcd(dataCompUseDataInterimResultDTO
										.getFirstYearuecforProductEnergy4lcd());
					} else {
						dataCompUseDataInterimResultDTO
								.setFirstYearuecgt0forProductEnergy4lcd(0.00);
					}
				} else {
					dataCompUseDataInterimResultDTO
							.setLifetimeuecforProductEnergy4lcd(0.00);
					dataCompUseDataInterimResultDTO
							.setLifetimeuecgt0forProductEnergy4lcd(0.00);
					dataCompUseDataInterimResultDTO
							.setFirstYearuecgt0forProductEnergy4lcd(0.00);
					dataCompUseDataInterimResultDTO
							.setFirstYearuecforProductEnergy4lcd(0.00);
				}
				if ((inputUseAndEOLDTO.getLcdUse() != null
						&& inputUseAndEOLDTO.getLcdUse()
								.getPercentPowerManagedDisplay().trim()
								.length() > 0 && Double
						.parseDouble(inputUseAndEOLDTO.getLcdUse()
								.getPercentPowerManagedDisplay()) > 0)
						&& (inputUseAndEOLDTO.getLcdUse()
								.getTotalEnergy5Units() != null
								&& inputUseAndEOLDTO.getLcdUse()
										.getTotalEnergy5Units().trim().length() > 0 && Double
								.parseDouble(inputUseAndEOLDTO.getLcdUse()
										.getTotalEnergy5Units()) > 0)) {
					dataCompUseDataInterimResultDTO
							.setUecforProductEnergy5lcd(calculatePowerManagement(
									"lcd", "energy5", inputUseAndEOLDTO
											.getLcdUse()
											.getPercentPowerManagedDisplay()));
					Double tableValue = calculateTableB("lcd", "energy5",
							dataCompUseDataInterimResultDTO
									.getUecforProductEnergy5lcd(),
							inputUseAndEOLDTO, supportingCalculationResultDTO);
					dataCompUseDataInterimResultDTO
							.setLifetimeuecforProductEnergy5lcd(tableValue / 12);
					if (dataCompUseDataInterimResultDTO
							.getLifetimeuecforProductEnergy5lcd() != null
							&& (dataCompUseDataInterimResultDTO
									.getLifetimeuecforProductEnergy5lcd()) > 0) {
						dataCompUseDataInterimResultDTO
								.setLifetimeuecgt0forProductEnergy5lcd(dataCompUseDataInterimResultDTO
										.getLifetimeuecforProductEnergy5lcd());
					} else {
						dataCompUseDataInterimResultDTO
								.setLifetimeuecgt0forProductEnergy5lcd(0.00);
					}
					Double value5FirstYearLCD = tableValue
							/ supportingCalculationResultDTO
									.getAvgLifeSpanForLCD();
					if (lifeSpanValue > 12) {
						dataCompUseDataInterimResultDTO
								.setFirstYearuecforProductEnergy5lcd(value5FirstYearLCD);
					} else {
						dataCompUseDataInterimResultDTO
								.setFirstYearuecforProductEnergy5lcd(value5FirstYearLCD / 12);
					}
					if (dataCompUseDataInterimResultDTO
							.getFirstYearuecforProductEnergy5lcd() > 0) {
						dataCompUseDataInterimResultDTO
								.setFirstYearuecgt0forProductEnergy5lcd(dataCompUseDataInterimResultDTO
										.getFirstYearuecforProductEnergy5lcd());
					} else {
						dataCompUseDataInterimResultDTO
								.setFirstYearuecgt0forProductEnergy5lcd(0.00);
					}
				} else {
					dataCompUseDataInterimResultDTO
							.setLifetimeuecforProductEnergy5lcd(0.00);
					dataCompUseDataInterimResultDTO
							.setLifetimeuecgt0forProductEnergy5lcd(0.00);
					dataCompUseDataInterimResultDTO
							.setFirstYearuecgt0forProductEnergy5lcd(0.00);
					dataCompUseDataInterimResultDTO
							.setFirstYearuecforProductEnergy5lcd(0.00);
				}
			}

			Double displayEnergy5Value = 0.00;
			Double displayEnergy4Value = 0.00;
			Double energy5Value = 0.00;
			Double energy4Value = 0.00;

			if ((inputUseAndEOLDTO.getNotebookUse() != null
					&& inputUseAndEOLDTO.getNotebookUse()
							.getPercentPowerManagedDisplay().trim().length() > 0 && Double
					.parseDouble(inputUseAndEOLDTO.getNotebookUse()
							.getPercentPowerManagedDisplay()) > 0)
					&& (inputUseAndEOLDTO.getNotebookUse()
							.getTotalEnergy5Units() != null && Double
							.parseDouble(inputUseAndEOLDTO.getNotebookUse()
									.getTotalEnergy5Units()) > 0)) {
				displayEnergy5Value = calculatePowerManagement(
						"notebookdisplay", "energy5", inputUseAndEOLDTO
								.getNotebookUse()
								.getPercentPowerManagedDisplay());
			}

			if ((inputUseAndEOLDTO.getNotebookUse() != null
					&& inputUseAndEOLDTO.getNotebookUse()
							.getPercentPowerManagedDisplay().trim().length() > 0 && Double
					.parseDouble(inputUseAndEOLDTO.getNotebookUse()
							.getPercentPowerManagedDisplay()) > 0)
					&& (inputUseAndEOLDTO.getNotebookUse()
							.getTotalEnergy4Units() != null && Double
							.parseDouble(inputUseAndEOLDTO.getNotebookUse()
									.getTotalEnergy4Units()) > 0)) {
				displayEnergy4Value = calculatePowerManagement(
						"notebookdisplay", "energy4", inputUseAndEOLDTO
								.getNotebookUse()
								.getPercentPowerManagedDisplay());
			}

			if ((inputUseAndEOLDTO.getNotebookUse() != null
					&& inputUseAndEOLDTO.getNotebookUse()
							.getPercentPowerManagedComputer().trim().length() > 0 && Double
					.parseDouble(inputUseAndEOLDTO.getNotebookUse()
							.getPercentPowerManagedComputer()) > 0)
					&& (inputUseAndEOLDTO.getNotebookUse()
							.getTotalEnergy5Units() != null
							&& inputUseAndEOLDTO.getNotebookUse()
									.getTotalEnergy5Units().trim().length() > 0 && Double
							.parseDouble(inputUseAndEOLDTO.getNotebookUse()
									.getTotalEnergy5Units()) > 0)) {
				energy5Value = calculatePowerManagement("notebookcomputer",
						"energy5", inputUseAndEOLDTO.getNotebookUse()
								.getPercentPowerManagedComputer());
			}

			if ((inputUseAndEOLDTO.getNotebookUse() != null
					&& inputUseAndEOLDTO.getNotebookUse()
							.getPercentPowerManagedComputer().trim().length() > 0 && Double
					.parseDouble(inputUseAndEOLDTO.getNotebookUse()
							.getPercentPowerManagedComputer()) > 0)
					&& (inputUseAndEOLDTO.getNotebookUse()
							.getTotalEnergy4Units() != null
							&& inputUseAndEOLDTO.getNotebookUse()
									.getTotalEnergy4Units().trim().length() > 0 && Double
							.parseDouble(inputUseAndEOLDTO.getNotebookUse()
									.getTotalEnergy4Units()) > 0)) {
				energy4Value = calculatePowerManagement("notebookcomputer",
						"energy4", inputUseAndEOLDTO.getNotebookUse()
								.getPercentPowerManagedComputer());
			}

			dataCompUseDataInterimResultDTO
					.setUecforProductEnergy5notebook(displayEnergy5Value
							+ energy5Value);
			dataCompUseDataInterimResultDTO
					.setUecforProductEnergy4notebook(displayEnergy4Value
							+ energy4Value);

			Double lifespan = supportingCalculationResultDTO
					.getAvgLifeSpanForNoteBook();
			double table5Value = calculateTableB("notebook", "energy5",
					dataCompUseDataInterimResultDTO
							.getUecforProductEnergy5notebook(),
					inputUseAndEOLDTO, supportingCalculationResultDTO);
			double table4Value = calculateTableB("notebook", "energy4",
					dataCompUseDataInterimResultDTO
							.getUecforProductEnergy4notebook(),
					inputUseAndEOLDTO, supportingCalculationResultDTO);
			dataCompUseDataInterimResultDTO
					.setLifetimeuecforProductEnergy5notebook(table5Value / 12);
			dataCompUseDataInterimResultDTO
					.setLifetimeuecforProductEnergy4notebook(table4Value / 12);
			double table5First = table5Value
					/ supportingCalculationResultDTO
							.getAvgLifeSpanForNoteBook();
			double table4First = table4Value
					/ supportingCalculationResultDTO
							.getAvgLifeSpanForNoteBook();
			if (lifespan > 12) {
				dataCompUseDataInterimResultDTO
						.setFirstYearuecforProductEnergy5notebook(table5First);
				dataCompUseDataInterimResultDTO
						.setFirstYearuecforProductEnergy4notebook(table4First);
			} else {
				dataCompUseDataInterimResultDTO
						.setFirstYearuecforProductEnergy5notebook(table5First / 12);
				dataCompUseDataInterimResultDTO
						.setFirstYearuecforProductEnergy4notebook(table4First / 12);
			}
			if (dataCompUseDataInterimResultDTO
					.getFirstYearuecforProductEnergy5notebook() > 0) {
				dataCompUseDataInterimResultDTO
						.setFirstYearuecgt0forProductEnergy5notebook(dataCompUseDataInterimResultDTO
								.getFirstYearuecforProductEnergy5notebook());
			} else {
				dataCompUseDataInterimResultDTO
						.setFirstYearuecgt0forProductEnergy5notebook(0.00);
			}
			if (dataCompUseDataInterimResultDTO
					.getFirstYearuecforProductEnergy4notebook() > 0) {
				dataCompUseDataInterimResultDTO
						.setFirstYearuecgt0forProductEnergy4notebook(dataCompUseDataInterimResultDTO
								.getFirstYearuecforProductEnergy4notebook());
			} else {
				dataCompUseDataInterimResultDTO
						.setFirstYearuecgt0forProductEnergy4notebook(0.00);
			}

			if (dataCompUseDataInterimResultDTO
					.getLifetimeuecforProductEnergy5notebook() != null
					&& dataCompUseDataInterimResultDTO
							.getLifetimeuecforProductEnergy5notebook() > 0) {
				dataCompUseDataInterimResultDTO
						.setLifetimeuecgt0forProductEnergy5notebook(dataCompUseDataInterimResultDTO
								.getLifetimeuecforProductEnergy5notebook());
			} else {
				dataCompUseDataInterimResultDTO
						.setLifetimeuecgt0forProductEnergy5notebook(0.00);
			}
			if (dataCompUseDataInterimResultDTO
					.getLifetimeuecforProductEnergy4notebook() != null
					&& dataCompUseDataInterimResultDTO
							.getLifetimeuecforProductEnergy4notebook() > 0) {
				dataCompUseDataInterimResultDTO
						.setLifetimeuecgt0forProductEnergy4notebook(dataCompUseDataInterimResultDTO
								.getLifetimeuecforProductEnergy4notebook());
			} else {
				dataCompUseDataInterimResultDTO
						.setLifetimeuecgt0forProductEnergy4notebook(0.00);
			}

		}
		return dataCompUseDataInterimResultDTO;
	}

	public DataCompUseDataMainResultDTO generateDataCompUseDataMainResultDTO(
			InputUseAndEOLDTO inputUseAndEOLDTO,
			DataCompUseDataInterimResultDTO dataCompUseDataInterimResultDTO) {
		DataCompUseDataMainResultDTO generateDataCompUseDataMainResultDTO = new DataCompUseDataMainResultDTO();
		if (inputUseAndEOLDTO != null) {
			if (supportingCalculationResultDTO != null) {
				//2015 fixing the error in the logic for PercentUnitsInService
				if (supportingCalculationResultDTO
						.getProductAsPercentTotalUnitsForCPU() <= 0.00
						&& supportingCalculationResultDTO.getProductAsPercentTotalUnitsForCRT() <= 0.00
						&& supportingCalculationResultDTO.getProductAsPercentTotalUnitsForLCD() <= 0.00
						&& supportingCalculationResultDTO.getProductAsPercentTotalUnitsForNoteBook() <= 0.00) {
					generateDataCompUseDataMainResultDTO
					.setPercentCPUUnitsInService((Double
							.parseDouble((String) propproductInterim
									.getProperty("distributioncpu"))));
					generateDataCompUseDataMainResultDTO
					.setPercentCRTUnitsInService((Double
							.parseDouble((String) propproductInterim
									.getProperty("distributioncrt"))));
					generateDataCompUseDataMainResultDTO
					.setPercentLCDUnitsInService((Double
							.parseDouble((String) propproductInterim
									.getProperty("distributionlcd"))));
					generateDataCompUseDataMainResultDTO
					.setPercentNtBkUnitsInService((Double.parseDouble((String) propproductInterim
							.getProperty("distributionnotebook"))));	
					
				}
				else{				
				
				if (supportingCalculationResultDTO
						.getProductAsPercentTotalUnitsForCPU() > 0.00) {
					generateDataCompUseDataMainResultDTO
							.setPercentCPUUnitsInService(supportingCalculationResultDTO
									.getProductAsPercentTotalUnitsForCPU());
				} else {
					generateDataCompUseDataMainResultDTO.setPercentCPUUnitsInService(0.0);
					
				}
				if (supportingCalculationResultDTO
						.getProductAsPercentTotalUnitsForCRT() > 0.00) {
					generateDataCompUseDataMainResultDTO
							.setPercentCRTUnitsInService(supportingCalculationResultDTO
									.getProductAsPercentTotalUnitsForCRT());
				} else {
					generateDataCompUseDataMainResultDTO.setPercentCRTUnitsInService(0.0);
					
				}
				if (supportingCalculationResultDTO
						.getProductAsPercentTotalUnitsForLCD() > 0.00) {
					generateDataCompUseDataMainResultDTO
							.setPercentLCDUnitsInService(supportingCalculationResultDTO
									.getProductAsPercentTotalUnitsForLCD());
				} else {
					generateDataCompUseDataMainResultDTO.setPercentLCDUnitsInService(0.0);
					
				}
				if (supportingCalculationResultDTO
						.getProductAsPercentTotalUnitsForNoteBook() > 0.00) {
					generateDataCompUseDataMainResultDTO
							.setPercentNtBkUnitsInService(supportingCalculationResultDTO
									.getProductAsPercentTotalUnitsForNoteBook());
				} else {
					generateDataCompUseDataMainResultDTO.setPercentNtBkUnitsInService(0.0);
					
				}
				}
				/* original code
				if (supportingCalculationResultDTO
						.getProductAsPercentTotalUnitsForCPU() > 0.00) {
					generateDataCompUseDataMainResultDTO
							.setPercentCPUUnitsInService(supportingCalculationResultDTO
									.getProductAsPercentTotalUnitsForCPU());
				} else {
					generateDataCompUseDataMainResultDTO
							.setPercentCPUUnitsInService((Double
									.parseDouble((String) propproductInterim
											.getProperty("distributioncpu"))));
				}
				if (supportingCalculationResultDTO
						.getProductAsPercentTotalUnitsForCRT() > 0.00) {
					generateDataCompUseDataMainResultDTO
							.setPercentCRTUnitsInService(supportingCalculationResultDTO
									.getProductAsPercentTotalUnitsForCRT());
				} else {
					generateDataCompUseDataMainResultDTO
							.setPercentCRTUnitsInService((Double
									.parseDouble((String) propproductInterim
											.getProperty("distributioncrt"))));
				}
				if (supportingCalculationResultDTO
						.getProductAsPercentTotalUnitsForLCD() > 0.00) {
					generateDataCompUseDataMainResultDTO
							.setPercentLCDUnitsInService(supportingCalculationResultDTO
									.getProductAsPercentTotalUnitsForLCD());
				} else {
					generateDataCompUseDataMainResultDTO
							.setPercentLCDUnitsInService((Double
									.parseDouble((String) propproductInterim
											.getProperty("distributionlcd"))));
				}
				if (supportingCalculationResultDTO
						.getProductAsPercentTotalUnitsForNoteBook() > 0.00) {
					generateDataCompUseDataMainResultDTO
							.setPercentNtBkUnitsInService(supportingCalculationResultDTO
									.getProductAsPercentTotalUnitsForNoteBook());
				} else {
					generateDataCompUseDataMainResultDTO
							.setPercentNtBkUnitsInService((Double.parseDouble((String) propproductInterim
									.getProperty("distributionnotebook"))));
				}
				*/
			}
			generateDataCompUseDataMainResultDTO
					.setEnergy4StarLifeTimeSavings(dataCompUseDataInterimResultDTO
							.getLifetimeuecgt0forProductEnergy4cpu()
							+ dataCompUseDataInterimResultDTO
									.getLifetimeuecgt0forProductEnergy4crt()
							+ dataCompUseDataInterimResultDTO
									.getLifetimeuecgt0forProductEnergy4lcd()
							+ dataCompUseDataInterimResultDTO
									.getLifetimeuecgt0forProductEnergy4notebook());
			generateDataCompUseDataMainResultDTO
					.setEnergy5StarLifeTimeSavings(dataCompUseDataInterimResultDTO
							.getLifetimeuecgt0forProductEnergy5cpu()
							+ dataCompUseDataInterimResultDTO
									.getLifetimeuecgt0forProductEnergy5lcd()
							+ dataCompUseDataInterimResultDTO
									.getLifetimeuecgt0forProductEnergy5notebook());
			generateDataCompUseDataMainResultDTO
					.setEnergy4StarFirstYearSavings(dataCompUseDataInterimResultDTO
							.getFirstYearuecgt0forProductEnergy4cpu()
							+ dataCompUseDataInterimResultDTO
									.getFirstYearuecgt0forProductEnergy4crt()
							+ dataCompUseDataInterimResultDTO
									.getFirstYearuecgt0forProductEnergy4lcd()
							+ dataCompUseDataInterimResultDTO
									.getFirstYearuecgt0forProductEnergy4notebook());
			generateDataCompUseDataMainResultDTO
					.setEnergy5StarFirstYearSavings(dataCompUseDataInterimResultDTO
							.getFirstYearuecgt0forProductEnergy5cpu()
							+ dataCompUseDataInterimResultDTO
									.getFirstYearuecgt0forProductEnergy5lcd()
							+ dataCompUseDataInterimResultDTO
									.getFirstYearuecgt0forProductEnergy5notebook());
			generateDataCompUseDataMainResultDTO
					.setAvgLifeSpanComputerSystem(supportingCalculationResultDTO
							.getWeightedAvgLifeSpan());
			generateDataCompUseDataMainResultDTO
					.setAvgMassOfCompSystem((generateDataCompUseDataMainResultDTO
							.getPercentCPUUnitsInService() * Double
							.parseDouble((String) prop8a
									.getProperty("cpuavgWgtOfproduct")))
							+ (generateDataCompUseDataMainResultDTO
									.getPercentLCDUnitsInService() * Double
									.parseDouble((String) prop8a
											.getProperty("lcdavgWgtOfproduct")))
							+ (generateDataCompUseDataMainResultDTO
									.getPercentCRTUnitsInService() * Double
									.parseDouble((String) prop8a
											.getProperty("crtavgWgtOfproduct")))
							+ (generateDataCompUseDataMainResultDTO
									.getPercentNtBkUnitsInService() * Double.parseDouble((String) prop8a
									.getProperty("notebookavgWgtOfproduct"))));

			Double avgHazMatInCPU = Double.parseDouble((String) prop8a
					.getProperty("cpuavgPbContentPerUnit"))
					+ Double.parseDouble((String) prop8a
							.getProperty("cpuavgHgcontentnotincludinglampsperunit"))
					+ Double.parseDouble((String) prop8a
							.getProperty("cpuavghexavalentChromiumPerUnit"))
					+ Double.parseDouble((String) prop8a
							.getProperty("cpuavgPBBContentPerUnit"))
					+ Double.parseDouble((String) prop8a
							.getProperty("cpuavgPBDEContentPerUnit"))
					+ Double.parseDouble((String) prop8a
							.getProperty("cpuavgcadmiumContentPerUnit"));
					//+ Double.parseDouble((String) prop8a
							//.getProperty("cpuavgtotalHgcontentinlamps"));
			//Notes: for 2015, add property cpuavgtotalHgcontentinlamps in the property file
			//since we plug in MFD for CPU in the first testing
			//
			
			
			Double avgHazMatInCRT = Double.parseDouble((String) prop8a
					.getProperty("crtavgPbContentPerUnit"))
					+ Double.parseDouble((String) prop8a
							.getProperty("crtavgHgcontentnotincludinglampsperunit"))
					+ Double.parseDouble((String) prop8a
							.getProperty("crtavghexavalentChromiumPerUnit"))
					+ Double.parseDouble((String) prop8a
							.getProperty("crtavgPBBContentPerUnit"))
					+ Double.parseDouble((String) prop8a
							.getProperty("crtavgPBDEContentPerUnit"))
					+ Double.parseDouble((String) prop8a
							.getProperty("crtavgcadmiumContentPerUnit"));
			Double avgHazMatInLCD = Double.parseDouble((String) prop8a
					.getProperty("lcdavgPbContentPerUnit"))
					+ Double.parseDouble((String) prop8a
							.getProperty("lcdavgHgcontentnotincludinglampsperunit"))
					+ Double.parseDouble((String) prop8a
							.getProperty("lcdavghexavalentChromiumPerUnit"))
					+ Double.parseDouble((String) prop8a
							.getProperty("lcdavgPBBContentPerUnit"))
					+ Double.parseDouble((String) prop8a
							.getProperty("lcdavgPBDEContentPerUnit"))
					+ Double.parseDouble((String) prop8a
							.getProperty("lcdavgcadmiumContentPerUnit"))
					+ Double.parseDouble((String) prop8a
							.getProperty("lcdavgtotalHgcontentinlamps"));
			Double avgHazMatInNtbk = Double.parseDouble((String) prop8a
					.getProperty("notebookavgPbContentPerUnit"))
					+ Double.parseDouble((String) prop8a
							.getProperty("notebookavgHgcontentnotincludinglampsperunit"))
					+ Double.parseDouble((String) prop8a
							.getProperty("notebookavghexavalentChromiumPerUnit"))
					+ Double.parseDouble((String) prop8a
							.getProperty("notebookavgPBBContentPerUnit"))
					+ Double.parseDouble((String) prop8a
							.getProperty("notebookavgPBDEContentPerUnit"))
					+ Double.parseDouble((String) prop8a
							.getProperty("notebookavgcadmiumContentPerUnit"))
					+ Double.parseDouble((String) prop8a
							.getProperty("notebookavgtotalHgcontentinlamps"));
			generateDataCompUseDataMainResultDTO
					.setAvgMassOfHazMaterialInCompSystem((avgHazMatInCPU * generateDataCompUseDataMainResultDTO
							.getPercentCPUUnitsInService())
							+ (avgHazMatInNtbk * generateDataCompUseDataMainResultDTO
									.getPercentNtBkUnitsInService())
							+ (avgHazMatInCRT * generateDataCompUseDataMainResultDTO
									.getPercentCRTUnitsInService())
							+ (avgHazMatInLCD * generateDataCompUseDataMainResultDTO
									.getPercentLCDUnitsInService()));
			generateDataCompUseDataMainResultDTO
					.setAvgMassOfHazWasteAvoidedForCompSystem((generateDataCompUseDataMainResultDTO
							.getPercentCPUUnitsInService() * Double.parseDouble((String) prop8a
							.getProperty("cpuavghazardousmaterialcontentinunit")))
							+ (generateDataCompUseDataMainResultDTO
									.getPercentLCDUnitsInService() * Double.parseDouble((String) prop8a
									.getProperty("lcdavghazardousmaterialcontentinunit")))
							+ (generateDataCompUseDataMainResultDTO
									.getPercentCRTUnitsInService() * Double.parseDouble((String) prop8a
									.getProperty("crtavghazardousmaterialcontentinunit")))
							+ (generateDataCompUseDataMainResultDTO
									.getPercentNtBkUnitsInService() * Double.parseDouble((String) prop8a
									.getProperty("notebookavghazardousmaterialcontentinunit"))));
		}
		return generateDataCompUseDataMainResultDTO;
	}

	public DataCompEndOfLifeMainResultDTO generateDataCompEndOfLifeMainResultDTO(
			EndOfLifeDTO endOfLifeDTO) {
		DataCompEndOfLifeMainResultDTO generateDataCompEndOfLifeMainResultDTO = new DataCompEndOfLifeMainResultDTO();
		if (endOfLifeDTO != null) {
			if ((endOfLifeDTO.getNumOfCPURecycled() != null && !endOfLifeDTO.getNumOfCPURecycled().isEmpty() && Double
					.parseDouble(endOfLifeDTO.getNumOfCPURecycled()) > 0)
					|| (endOfLifeDTO.getNumOfCPUReused() != null && !endOfLifeDTO.getNumOfCPUReused().isEmpty() && Double
							.parseDouble(endOfLifeDTO.getNumOfCPUReused()) > 0)) {
				generateDataCompEndOfLifeMainResultDTO
						.setMassOfProductCPU(Double.parseDouble((String) prop8a
								.getProperty("cpuavgWgtOfproduct")));
				generateDataCompEndOfLifeMainResultDTO.setMassOfPWBCPU(Double
						.parseDouble((String) prop8a
								.getProperty("cpuavgWgtOfprintedwireboards")));
				generateDataCompEndOfLifeMainResultDTO
						.setMasssOfResinInWireAndCableCPU(Double.parseDouble((String) prop8a
								.getProperty("cpuavgWgtOfresin(plastic)inwireandcable")));
				generateDataCompEndOfLifeMainResultDTO
						.setTotalMassOfHazwasteCPU(Double.parseDouble((String) prop8a
								.getProperty("cpuavgWgtOfprintedwireboards"))
								+ Double.parseDouble((String) prop8a
										.getProperty("cpuavgWgtOfresin(plastic)inwireandcable")));
			}
			if ((endOfLifeDTO.getNumOfLCDRecycled() != null &&  !endOfLifeDTO.getNumOfLCDRecycled().isEmpty() && Double
					.parseDouble(endOfLifeDTO.getNumOfLCDRecycled()) > 0)
					|| (endOfLifeDTO.getNumOfLCDReused() != null && !endOfLifeDTO.getNumOfLCDReused().isEmpty() && Double
							.parseDouble(endOfLifeDTO.getNumOfLCDReused()) > 0)) {
				generateDataCompEndOfLifeMainResultDTO
						.setMassOfProductLCD(Double.parseDouble((String) prop8a
								.getProperty("lcdavgWgtOfproduct")));
				generateDataCompEndOfLifeMainResultDTO.setMassOfPWBLCD(Double
						.parseDouble((String) prop8a
								.getProperty("lcdavgWgtOfprintedwireboards")));
				generateDataCompEndOfLifeMainResultDTO
						.setMassOfCCFLLCD(Double.parseDouble((String) prop8a
								.getProperty("lcdavgWgtOfcoldcathodefluorescentlamps(CCFL)")));
				generateDataCompEndOfLifeMainResultDTO
						.setMasssOfResinInWireAndCableLCD(Double.parseDouble((String) prop8a
								.getProperty("lcdavgWgtOfresin(plastic)inwireandcable")));
				generateDataCompEndOfLifeMainResultDTO
						.setTotalMassOfHazwasteLCD(Double.parseDouble((String) prop8a
								.getProperty("lcdavgWgtOfprintedwireboards"))
								+ Double.parseDouble((String) prop8a
										.getProperty("lcdavgWgtOfcoldcathodefluorescentlamps(CCFL)"))
								+ Double.parseDouble((String) prop8a
										.getProperty("lcdavgWgtOfresin(plastic)inwireandcable")));
			}
			if ((endOfLifeDTO.getNumOfCRTRecycled() != null && !endOfLifeDTO.getNumOfCRTRecycled().isEmpty() && Double
					.parseDouble(endOfLifeDTO.getNumOfCRTRecycled()) > 0)
					|| (endOfLifeDTO.getNumOfCRTReused() != null && !endOfLifeDTO.getNumOfCRTReused().isEmpty() && Double
							.parseDouble(endOfLifeDTO.getNumOfCRTReused()) > 0)) {
				generateDataCompEndOfLifeMainResultDTO
						.setMassOfProductCRT(Double.parseDouble((String) prop8a
								.getProperty("crtavgWgtOfproduct")));
				generateDataCompEndOfLifeMainResultDTO.setMassOfPWBNtCRT(Double
						.parseDouble((String) prop8a
								.getProperty("crtavgWgtOfprintedwireboards")));
				generateDataCompEndOfLifeMainResultDTO
						.setMassOfLeadGlassCRT(Double.parseDouble((String) prop8a
								.getProperty("crtuavgWgtOfleadedglass")));
				generateDataCompEndOfLifeMainResultDTO
						.setMasssOfResinInWireAndCableCRT(Double.parseDouble((String) prop8a
								.getProperty("crtavgWgtOfresin(plastic)inwireandcable")));
				generateDataCompEndOfLifeMainResultDTO
						.setTotalMassOfHazwasteCRT(Double.parseDouble((String) prop8a
								.getProperty("crtavgWgtOfprintedwireboards"))
								+ Double.parseDouble((String) prop8a
										.getProperty("crtuavgWgtOfleadedglass"))
								+ Double.parseDouble((String) prop8a
										.getProperty("crtavgWgtOfresin(plastic)inwireandcable")));
			}
			if ((endOfLifeDTO.getNumOfNoteBookRecycled() != null && !endOfLifeDTO.getNumOfNoteBookRecycled().isEmpty() && Double
					.parseDouble(endOfLifeDTO.getNumOfNoteBookRecycled()) > 0)
					|| (endOfLifeDTO.getNumOfNoteBookReused() != null && !endOfLifeDTO.getNumOfNoteBookReused().isEmpty() && Double
							.parseDouble(endOfLifeDTO.getNumOfNoteBookReused()) > 0)) {
				generateDataCompEndOfLifeMainResultDTO
						.setMassOfProductNtbk(Double.parseDouble((String) prop8a
								.getProperty("notebookavgWgtOfproduct")));
				generateDataCompEndOfLifeMainResultDTO
						.setMassOfPWBNtbk(Double.parseDouble((String) prop8a
								.getProperty("notebookavgWgtOfprintedwireboards")));
				generateDataCompEndOfLifeMainResultDTO
						.setMassOfCCFLNtbk(Double.parseDouble((String) prop8a
								.getProperty("notebookavgWgtOfcoldcathodefluorescentlamps(CCFL)")));
				generateDataCompEndOfLifeMainResultDTO
						.setMasssOfResinInWireAndCableNtbk(Double.parseDouble((String) prop8a
								.getProperty("notebookavgWgtOfresin(plastic)inwireandcable")));
				generateDataCompEndOfLifeMainResultDTO
						.setTotalMassOfHazwasteNtbk(Double.parseDouble((String) prop8a
								.getProperty("notebookavgWgtOfprintedwireboards"))
								+ Double.parseDouble((String) prop8a
										.getProperty("notebookavgWgtOfcoldcathodefluorescentlamps(CCFL)"))
								+ Double.parseDouble((String) prop8a
										.getProperty("notebookavgWgtOfresin(plastic)inwireandcable")));
			}
			if ((endOfLifeDTO.getNumOfMobileRecycled() != null && !endOfLifeDTO.getNumOfMobileRecycled().isEmpty() &&  Double
					.parseDouble(endOfLifeDTO.getNumOfMobileRecycled()) > 0)
					|| (endOfLifeDTO.getNumOfMobileReused() != null && !endOfLifeDTO.getNumOfMobileReused().isEmpty() && Double
							.parseDouble(endOfLifeDTO.getNumOfMobileReused()) > 0)) {
				generateDataCompEndOfLifeMainResultDTO
						.setMassOfProductMobileWithbattery(Double
								.parseDouble((String) prop8a
										.getProperty("mobileavgWgtOfproduct")));
				generateDataCompEndOfLifeMainResultDTO
						.setMassOfProductMobileWOutbattery(Double.parseDouble((String) prop8a
								.getProperty("mobileavgWgtOfproductWOBattery")));
				generateDataCompEndOfLifeMainResultDTO
						.setMassOfPWBProductMobile(Double
								.parseDouble((String) prop8a
										.getProperty("mobileavgPWB")));
				generateDataCompEndOfLifeMainResultDTO
						.setTotalMassOfHazwasteMoblie(Double
								.parseDouble((String) prop8a
										.getProperty("mobileavgPWB")));
			}
		}

		return generateDataCompEndOfLifeMainResultDTO;
	}

	// Check the calculations!!!!!!!!

	public SavingsProductInterimResultDTO generateSavingsProductInterimResultDTO(
			ProductInformationDTO productInformation,
			DataCompProductMainResultDTO dataCompProductMainResultDTO) {
		SavingsProductInterimResultDTO savingsProductInterimResultDTO = new SavingsProductInterimResultDTO();
		if (productInformation != null) {
			if (productInformation.getProductDetails().getProductType() != null
					&& productInformation.getProductDetails()
							.getNooFProductPurchased() != null
					&& Double.parseDouble(productInformation
							.getProductDetails().getNooFProductPurchased()) > 0) {

				savingsProductInterimResultDTO
						.setToxicSavingFromPb((Double
								.parseDouble((String) prop8a
										.getProperty(productInformation
												.getProductDetails()
												.getProductType()
												+ "avgPbContentPerUnit")) - dataCompProductMainResultDTO
								.getMassPb())
								* (Double.parseDouble(productInformation
										.getProductDetails()
										.getNooFProductPurchased())) / 1000);
				savingsProductInterimResultDTO
						.setToxicSavingFromHg((Double.parseDouble((String) prop8a
								.getProperty(productInformation
										.getProductDetails().getProductType()
										+ "avgHgcontentnotincludinglampsperunit")) - dataCompProductMainResultDTO
								.getMassHg())
								* (Double.parseDouble(productInformation
										.getProductDetails()
										.getNooFProductPurchased())) / 1000);
				savingsProductInterimResultDTO
						.setToxicSavingFromCD((Double
								.parseDouble((String) prop8a
										.getProperty(productInformation
												.getProductDetails()
												.getProductType()
												+ "avgcadmiumContentPerUnit")) - dataCompProductMainResultDTO
								.getMassOdCD())
								* (Double.parseDouble(productInformation
										.getProductDetails()
										.getNooFProductPurchased())) / 1000);
				savingsProductInterimResultDTO
						.setToxicSavingFromCR((Double.parseDouble((String) prop8a
								.getProperty(productInformation
										.getProductDetails().getProductType()
										+ "avghexavalentChromiumPerUnit")) - dataCompProductMainResultDTO
								.getMassOfCr6())
								* (Double.parseDouble(productInformation
										.getProductDetails()
										.getNooFProductPurchased())) / 1000);
				savingsProductInterimResultDTO
						.setToxicSavingFromPBB((Double
								.parseDouble((String) prop8a
										.getProperty(productInformation
												.getProductDetails()
												.getProductType()
												+ "avgPBBContentPerUnit")) - dataCompProductMainResultDTO
								.getMassOfPBB())
								* (Double.parseDouble(productInformation
										.getProductDetails()
										.getNooFProductPurchased())) / 1000);
				savingsProductInterimResultDTO
						.setToxicSavingFromPBDE((Double
								.parseDouble((String) prop8a
										.getProperty(productInformation
												.getProductDetails()
												.getProductType()
												+ "avgPBDEContentPerUnit")) - dataCompProductMainResultDTO
								.getMassOfPBDE())
								* (Double.parseDouble(productInformation
										.getProductDetails()
										.getNooFProductPurchased())) / 1000);
				savingsProductInterimResultDTO
						.setHwSavingFromPbPWB((Double
								.parseDouble((String) prop8a
										.getProperty(productInformation
												.getProductDetails()
												.getProductType()
												+ "avgWgtOfprintedwireboards")) - dataCompProductMainResultDTO
								.getAvgMassOfPWB())
								* (Double.parseDouble(productInformation
										.getProductDetails()
										.getNooFProductPurchased())));
				// average weight of leaded glass not calculated in current
				// version....
				// savingsProductInterimResultDTO.setHwSavingFromPbGlass((Double.parseDouble((String)prop8a.getProperty(productInformation.getProductDetails().getProductType()+"avgWgtOfleadedglass"))
				// - dataCompProductMainResultDTO.getA)/1000);

				savingsProductInterimResultDTO
						.setHwSavingFromPbWC((Double.parseDouble((String) prop8a
								.getProperty(productInformation
										.getProductDetails().getProductType()
										+ "avgWgtOfresin(plastic)inwireandcable")) - dataCompProductMainResultDTO
								.getAvgMassOfResinWireAndCableWithHg())
								* (Double.parseDouble(productInformation
										.getProductDetails()
										.getNooFProductPurchased())));
				// HW Savings from Pb-w&c always 'n/a' in this version of the
				// calculator..
				savingsProductInterimResultDTO
						.setHwSavingFromPbTotal(savingsProductInterimResultDTO
								.getHwSavingFromPbPWB()
								+ savingsProductInterimResultDTO
										.getHwSavingFromPbWC());
				Double uecvalue = 0.00;
				Double convUecvalue = 0.00;
				if ("cpu".equalsIgnoreCase(productInformation
						.getProductDetails().getProductType())) {
					uecvalue = dataCompProductMainResultDTO.getAvgUECForCPU();
					convUecvalue = calculatePowerManagement("cpu", "energy0",
							productInformation
									.getPercentPowermkanagEnabledComp());
				} else if ("notebook".equalsIgnoreCase(productInformation
						.getProductDetails().getProductType())) {
					uecvalue = dataCompProductMainResultDTO.getAvgUECForNtbk();
					convUecvalue = calculatePowerManagement("notebookdisplay",
							"energy0",
							productInformation
									.getPercentPowermkanagEnabledComp())
							+ calculatePowerManagement("notebookcomputer",
									"energy0",
									productInformation
											.getPercentPowermkanagEnabledComp());
				} else if ("lcd".equalsIgnoreCase(productInformation
						.getProductDetails().getProductType())) {
					uecvalue = dataCompProductMainResultDTO.getAvgUECForLCD();
					convUecvalue = calculatePowerManagement("lcd", "energy0",
							productInformation
									.getPercentPowermkanagEnabledComp());
				}

				savingsProductInterimResultDTO
						.setLifetimeEnergySaving(((Double
								.parseDouble((String) prop8a
										.getProperty(productInformation
												.getProductDetails()
												.getProductType()
												+ "avglifetimeOfunit")) / 12) * (convUecvalue - uecvalue))
								* (Double.parseDouble(productInformation
										.getProductDetails()
										.getNooFProductPurchased())));
				if (Double.parseDouble((String) prop8a
						.getProperty(productInformation.getProductDetails()
								.getProductType() + "avglifetimeOfunit")) < 12.0) {
					savingsProductInterimResultDTO
							.setFirstYearEnergySaving((Double
									.parseDouble((String) prop8a
											.getProperty(productInformation
													.getProductDetails()
													.getProductType()
													+ "avglifetimeOfunit")) / 12)
									* (convUecvalue - uecvalue)
									* (Double.parseDouble(productInformation
											.getProductDetails()
											.getNooFProductPurchased())));
				} else {
					savingsProductInterimResultDTO
							.setFirstYearEnergySaving(((convUecvalue - uecvalue) * (Double
									.parseDouble(productInformation
											.getProductDetails()
											.getNooFProductPurchased()))));
				}
			}
			Double ecf = (Double.parseDouble((String) propassumptioncalc
					.getProperty("energyConversionFactor")));
			savingsProductInterimResultDTO
					.setEnergySavingFromPackageReuse((dataCompProductMainResultDTO
							.getAvgMassOfCorrugatedPackaging()
							* (Double.parseDouble((String) propassumptioncalc
									.getProperty("totalenergydemandForPackagingCardboard"))) / ecf)
							+ ((dataCompProductMainResultDTO
									.getAvgMassofOtherPackaging() + dataCompProductMainResultDTO
									.getAvgMassOfPlasticFormPackaging())
									* (Double
											.parseDouble((String) propassumptioncalc
													.getProperty("totalenergydemandForPackagingPlastic"))) / ecf));
			savingsProductInterimResultDTO
					.setPmSavingFromPackageReuse((dataCompProductMainResultDTO
							.getAvgMassOfCorrugatedPackaging() * (Double.parseDouble((String) propassumptioncalc
							.getProperty("materialInputForPackagingCardboard"))))
							+ ((dataCompProductMainResultDTO
									.getAvgMassofOtherPackaging() + dataCompProductMainResultDTO
									.getAvgMassOfPlasticFormPackaging()) * (Double.parseDouble((String) propassumptioncalc
									.getProperty("materialInputForPackagingPlastic")))));
		
			savingsProductInterimResultDTO
					.setGhgSavingFromPbWC((dataCompProductMainResultDTO
							.getAvgMassOfCorrugatedPackaging() * (Double.parseDouble((String) propassumptioncalc
							.getProperty("ghgEmissionForPackagingCorrugated"))))
							+ ((dataCompProductMainResultDTO
									.getAvgMassofOtherPackaging() + dataCompProductMainResultDTO
									.getAvgMassOfPlasticFormPackaging()) * (Double.parseDouble((String) propassumptioncalc
									.getProperty("avgGhgEmissionForPackagingPackageResin")))));
			savingsProductInterimResultDTO
					.setAirSavingFromPbTotal((dataCompProductMainResultDTO
							.getAvgMassOfCorrugatedPackaging() * (Double.parseDouble((String) propassumptioncalc
							.getProperty("avgemissionToAirForPackagingCardboard"))))
							+ ((dataCompProductMainResultDTO
									.getAvgMassofOtherPackaging() + dataCompProductMainResultDTO
									.getAvgMassOfPlasticFormPackaging()) * (Double.parseDouble((String) propassumptioncalc
									.getProperty("avgemissionToAirForPackagingPlastic")))));
			savingsProductInterimResultDTO
					.setWaterSavingFromPbTotal((dataCompProductMainResultDTO
							.getAvgMassOfCorrugatedPackaging() * (Double.parseDouble((String) propassumptioncalc
							.getProperty("avgemissionToWaterForPackagingCardboard"))))
							+ ((dataCompProductMainResultDTO
									.getAvgMassofOtherPackaging() + dataCompProductMainResultDTO
									.getAvgMassOfPlasticFormPackaging()) * (Double.parseDouble((String) propassumptioncalc
									.getProperty("avgemissionToWaterForPackagingPlastic")))));
			// Per Product

		}
		return savingsProductInterimResultDTO;
	}

	public SavingsProductMainResultDTO generateSavingsProductMainResultDTO(
			ProductInformationDTO productInformation,
			SavingsProductInterimResultDTO savingsProductInterimResultDTO,
			DataCompProductMainResultDTO dataCompProductMainResultDTO) {
		SavingsProductMainResultDTO savingsProductMainResultDTO = new SavingsProductMainResultDTO();
		savingsProductMainResultDTO
				.setToxicMaterialsavingsFromPb(savingsProductInterimResultDTO
						.getToxicSavingFromPb());
		savingsProductMainResultDTO
				.setToxicMaterialsavingsFromHg(savingsProductInterimResultDTO
						.getToxicSavingFromHg());
		if (dataCompProductMainResultDTO.getTotalMassOfHgInLamps() != null
				&& dataCompProductMainResultDTO.getTotalMassOfHgInLamps() == 0.00) {
			savingsProductMainResultDTO
					.setToxicMaterialsavingsFromHgInLightSrc(0.00);
		} else {
			if ("lcd".equalsIgnoreCase(productInformation.getProductDetails()
					.getProductType())
					|| "notebook".equalsIgnoreCase(productInformation
							.getProductDetails().getProductType())) {
				savingsProductMainResultDTO
						.setToxicMaterialsavingsFromHgInLightSrc((((Double
								.parseDouble((String) prop8a
										.getProperty(productInformation
												.getProductDetails()
												.getProductType()
												+ "avgtotalHgcontentinlamps")))-dataCompProductMainResultDTO
								.getTotalMassOfHgInLamps())
								* Double.parseDouble(productInformation
										.getProductDetails()
										.getNooFProductPurchased())) / 1000);
			} else {
				savingsProductMainResultDTO
						.setToxicMaterialsavingsFromHgInLightSrc(0.00);
			}
		}
		
		if (dataCompProductMainResultDTO.getTotalMassOfHgInLamps() != null
				&& dataCompProductMainResultDTO.getTotalMassOfHgInLamps() == 0.00) {
			if ("lcd".equalsIgnoreCase(productInformation.getProductDetails()
					.getProductType())
					|| "notebook".equalsIgnoreCase(productInformation
							.getProductDetails().getProductType())) {
				savingsProductMainResultDTO
						.setToxicMaterialsavingsFromHgFreeLamps((((Double
								.parseDouble((String) prop8a
										.getProperty(productInformation
												.getProductDetails()
												.getProductType()
												+ "avgtotalHgcontentinlamps")))-dataCompProductMainResultDTO
								.getTotalMassOfHgInLamps())
								* Double.parseDouble(productInformation
										.getProductDetails()
										.getNooFProductPurchased())) / 1000);
			} else {
				savingsProductMainResultDTO
						.setToxicMaterialsavingsFromHgFreeLamps(0.00);
			}
		}else{
			
		}

		savingsProductMainResultDTO
				.setToxicMaterialsavingsFromPBB(savingsProductInterimResultDTO
						.getToxicSavingFromPBB());
		savingsProductMainResultDTO
				.setToxicMaterialsavingsFromPBDE(savingsProductInterimResultDTO
						.getToxicSavingFromPBDE());
		savingsProductMainResultDTO
				.setToxicMaterialsavingsFromCd(savingsProductInterimResultDTO
						.getToxicSavingFromCD());
		savingsProductMainResultDTO
				.setToxicMaterialsavingsFromCr6(savingsProductInterimResultDTO
						.getToxicSavingFromCR());
		savingsProductMainResultDTO
				.setTotaltoxicMaterialsavings(savingsProductMainResultDTO
						.getToxicMaterialsavingsFromPb()
						+ savingsProductMainResultDTO
								.getToxicMaterialsavingsFromHg()
						+ savingsProductMainResultDTO
								.getToxicMaterialsavingsFromCd()
						+ savingsProductMainResultDTO
								.getToxicMaterialsavingsFromCr6()
						+ savingsProductMainResultDTO
								.getToxicMaterialsavingsFromPBB()
						+ savingsProductMainResultDTO
								.getToxicMaterialsavingsFromPBDE());
		savingsProductMainResultDTO.setHwSavings(savingsProductInterimResultDTO
				.getHwSavingFromPbTotal());
	
		if ("lcd".equalsIgnoreCase(productInformation.getProductDetails()
				.getProductType())
				|| "notebook".equalsIgnoreCase(productInformation
						.getProductDetails().getProductType())) {
			savingsProductMainResultDTO
					.setHwSavingsHgFreelamps((Double.parseDouble((String) prop8a
							.getProperty(productInformation.getProductDetails()
									.getProductType()
									+ "avgWgtOfcoldcathodefluorescentlamps(CCFL)")) - dataCompProductMainResultDTO
							.getColdCathodeFluroscentLampWithHg())
							* Double.parseDouble(productInformation
									.getProductDetails()
									.getNooFProductPurchased()));
		} else {
			savingsProductMainResultDTO.setHwSavingsHgFreelamps(0.00);
		}
		savingsProductMainResultDTO
				.setTotalHwSavings(savingsProductMainResultDTO
						.getHwSavingsHgFreelamps()
						+ savingsProductMainResultDTO.getHwSavings());
		Double ecf = (Double.parseDouble((String) propassumptioncalc
				.getProperty("energyConversionFactor")));

		// Material Use
		// No Total Calculated Specifically for Material use since it has only
		// one calculated column
		Double diffvalue = 0.00;
		if (dataCompProductMainResultDTO.getAvgMassOfRecyConentInProdResin() != null
				&& dataCompProductMainResultDTO
						.getAvgMassOfRecyConentInProdResin() > 0.00) {
			diffvalue = dataCompProductMainResultDTO
					.getAvgMassOfRecyConentInProdResin()
					- Double.parseDouble((String) prop8a
							.getProperty(productInformation.getProductDetails()
									.getProductType()
									+ "avgAmtOfRecycledplastic(resin)ContentInProduct"));
		}
		
		SavingByCriteriaProductMainDTO materialUse = new SavingByCriteriaProductMainDTO();
		materialUse
				.setEnergySavings(diffvalue
						* Double.parseDouble((String) propassumptioncalc
								.getProperty("totalenergydemandForProductMaterialPlastic"))
						* (Double.parseDouble(productInformation
								.getProductDetails().getNooFProductPurchased()))
						/ ecf);
		materialUse.setPrimaryMaterialSavings(diffvalue
				* Double.parseDouble((String) propassumptioncalc
						.getProperty("materialInputForProductMaterialPlastic"))
				* (Double.parseDouble(productInformation.getProductDetails()
						.getNooFProductPurchased())));
		materialUse.setGhgEmissionSaving(diffvalue
				* Double.parseDouble((String) propassumptioncalc
						.getProperty("ghgEmissionForProductResin"))
				* (Double.parseDouble(productInformation.getProductDetails()
						.getNooFProductPurchased())));
		materialUse
				.setAirEmissionsaving(diffvalue
						* Double.parseDouble((String) propassumptioncalc
								.getProperty("avgemissionToAirForProductMaterialPlastic"))
						* (Double.parseDouble(productInformation
								.getProductDetails().getNooFProductPurchased())));
		materialUse
				.setWaterEmissionSaving(diffvalue
						* Double.parseDouble((String) propassumptioncalc
								.getProperty("avgemissionToWaterForProductMaterialPlastic"))
						* (Double.parseDouble(productInformation
								.getProductDetails().getNooFProductPurchased())));
		materialUse.setMuncipalWasteSavings(diffvalue
				
				
				
				* (Double.parseDouble(productInformation.getProductDetails()
						.getNooFProductPurchased())));
		materialUse.setCostSavings(materialUse.getEnergySavings()
				* Double.parseDouble((String) propassumptioncalc
						.getProperty("electricitycost")));
		savingsProductMainResultDTO.setMaterialuseSaving(materialUse);

		// Packaging
		// Avg recy content in corrugated packaging
		Double diffvaluerecycle = 0.00;
		if (dataCompProductMainResultDTO
				.getAvgMassOfRecyContentInCorrugatePackaging() != null
				&& dataCompProductMainResultDTO
						.getAvgMassOfRecyContentInCorrugatePackaging() > Double
						.parseDouble((String) prop8a
								.getProperty(productInformation
										.getProductDetails().getProductType()
										+ "avgAmtOfRecycledcontentOfPackaging,1-corrugated"))) {
			diffvaluerecycle = dataCompProductMainResultDTO
					.getAvgMassOfRecyContentInCorrugatePackaging()
					- Double.parseDouble((String) prop8a
							.getProperty(productInformation.getProductDetails()
									.getProductType()
									+ "avgAmtOfRecycledcontentOfPackaging,1-corrugated"));
		}	
		SavingByCriteriaProductMainDTO recycleSaving = new SavingByCriteriaProductMainDTO();
		recycleSaving.setEnergySavings(diffvaluerecycle
				* Double.parseDouble((String) propassumptioncalc
						.getProperty("totalenergydemandForPackagingCardboard"))
				* (Double.parseDouble(productInformation.getProductDetails()
						.getNooFProductPurchased())) / ecf);
		recycleSaving.setPrimaryMaterialSavings(diffvaluerecycle
				* Double.parseDouble((String) propassumptioncalc
						.getProperty("materialInputForPackagingCardboard"))
				* (Double.parseDouble(productInformation.getProductDetails()
						.getNooFProductPurchased())));
		recycleSaving.setGhgEmissionSaving(diffvaluerecycle
				* Double.parseDouble((String) propassumptioncalc
						.getProperty("ghgEmissionForPackagingCorrugatedNoBox"))
				* (Double.parseDouble(productInformation.getProductDetails()
						.getNooFProductPurchased())));
		recycleSaving.setAirEmissionsaving(diffvaluerecycle
				* Double.parseDouble((String) propassumptioncalc
						.getProperty("avgemissionToAirForPackagingCardboard"))
				* (Double.parseDouble(productInformation.getProductDetails()
						.getNooFProductPurchased())));
		recycleSaving
				.setWaterEmissionSaving(diffvaluerecycle
						* Double.parseDouble((String) propassumptioncalc
								.getProperty("avgemissionToWaterForPackagingCardboard"))
						* (Double.parseDouble(productInformation
								.getProductDetails().getNooFProductPurchased())));
		recycleSaving.setMuncipalWasteSavings(diffvaluerecycle
				* (Double.parseDouble(productInformation.getProductDetails()
						.getNooFProductPurchased())));
		recycleSaving.setCostSavings(recycleSaving.getEnergySavings()
				* Double.parseDouble((String) propassumptioncalc
						.getProperty("electricitycost")));
		savingsProductMainResultDTO.setRecycleSaving(recycleSaving);

		// Avg recy content in plastc/foam packaging
		Double diffvaluePlastic = 0.00;
		if (dataCompProductMainResultDTO
				.getAvgMassOfRecyContentInPlasticFormPackaging() != null
				&& dataCompProductMainResultDTO
						.getAvgMassOfRecyContentInPlasticFormPackaging() > Double
						.parseDouble((String) prop8a
								.getProperty(productInformation
										.getProductDetails().getProductType()
										+ "avgAmtRecycledcontentOfPackaging,2-plastic/foam"))) {
			diffvaluePlastic = dataCompProductMainResultDTO
					.getAvgMassOfRecyContentInPlasticFormPackaging()
					- Double.parseDouble((String) prop8a
							.getProperty(productInformation.getProductDetails()
									.getProductType()
									+ "avgAmtRecycledcontentOfPackaging,2-plastic/foam"));

		}
		// we are using packaging plastic value instead of packaging resin value
		// for AirEmissionSaving and WaterEmissionSaving
		SavingByCriteriaProductMainDTO packagingSaving = new SavingByCriteriaProductMainDTO();
		packagingSaving.setEnergySavings(diffvaluePlastic
				* Double.parseDouble((String) propassumptioncalc
						.getProperty("totalenergydemandForPackagingPlastic"))
				* (Double.parseDouble(productInformation.getProductDetails()
						.getNooFProductPurchased())) / ecf);
		packagingSaving.setPrimaryMaterialSavings(diffvaluePlastic
				* Double.parseDouble((String) propassumptioncalc
						.getProperty("materialInputForPackagingPlastic"))
				* (Double.parseDouble(productInformation.getProductDetails()
						.getNooFProductPurchased())));
		packagingSaving.setGhgEmissionSaving(diffvaluePlastic
				* Double.parseDouble((String) propassumptioncalc
						.getProperty("avgGHGEmissionForPackagingResin"))
				* (Double.parseDouble(productInformation.getProductDetails()
						.getNooFProductPurchased())));
		packagingSaving.setAirEmissionsaving(diffvaluePlastic
				* Double.parseDouble((String) propassumptioncalc
						.getProperty("avgemissionToAirForPackagingPlastic"))
				* (Double.parseDouble(productInformation.getProductDetails()
						.getNooFProductPurchased())));
		packagingSaving.setWaterEmissionSaving(diffvaluePlastic
				* Double.parseDouble((String) propassumptioncalc
						.getProperty("avgemissionToWaterForPackagingPlastic"))
				* (Double.parseDouble(productInformation.getProductDetails()
						.getNooFProductPurchased())));
		packagingSaving.setMuncipalWasteSavings(diffvaluePlastic
				* (Double.parseDouble(productInformation.getProductDetails()
						.getNooFProductPurchased())));
		packagingSaving.setCostSavings(packagingSaving.getEnergySavings()
				* Double.parseDouble((String) propassumptioncalc
						.getProperty("electricitycost")));
		savingsProductMainResultDTO.setPackagingSaving(packagingSaving);

		// we are using packaging plastic value instead of packaging resin value
		// for AirEmissionSaving and WaterEmissionSaving
		// Other Packaging
		Double diffvalueOther = 0.00;
		if (dataCompProductMainResultDTO.getAvgMassofOtherPackaging() > Double
				.parseDouble((String) prop8a.getProperty(productInformation
						.getProductDetails().getProductType()
						+ "avgAmtOfRecycledcontentOfPackaging,3-other"))) {
			diffvalueOther = dataCompProductMainResultDTO.getAvgMassOfRecyContentInOtherPackaging()
					- Double.parseDouble((String) prop8a
							.getProperty(productInformation.getProductDetails()
									.getProductType()
									+ "avgAmtOfRecycledcontentOfPackaging,3-other"));
		}
		SavingByCriteriaProductMainDTO otherPackageSaving = new SavingByCriteriaProductMainDTO();
		otherPackageSaving.setEnergySavings(diffvalueOther
				* Double.parseDouble((String) propassumptioncalc
						.getProperty("totalenergydemandForPackagingPlastic"))
				* (Double.parseDouble(productInformation.getProductDetails()
						.getNooFProductPurchased())) / ecf);
		otherPackageSaving.setPrimaryMaterialSavings(diffvalueOther
				* Double.parseDouble((String) propassumptioncalc
						.getProperty("materialInputForPackagingPlastic"))
				* (Double.parseDouble(productInformation.getProductDetails()
						.getNooFProductPurchased())));
		otherPackageSaving.setGhgEmissionSaving(diffvalueOther
				* Double.parseDouble((String) propassumptioncalc
						.getProperty("avgGhgEmissionForPackagingPackageResin"))
				* (Double.parseDouble(productInformation.getProductDetails()
						.getNooFProductPurchased())));
		otherPackageSaving.setAirEmissionsaving(diffvalueOther
				* Double.parseDouble((String) propassumptioncalc
						.getProperty("avgemissionToAirForPackagingPlastic"))
				* (Double.parseDouble(productInformation.getProductDetails()
						.getNooFProductPurchased())));
		otherPackageSaving.setWaterEmissionSaving(diffvalueOther
				* Double.parseDouble((String) propassumptioncalc
						.getProperty("avgemissionToWaterForPackagingPlastic"))
				* (Double.parseDouble(productInformation.getProductDetails()
						.getNooFProductPurchased())));
		otherPackageSaving.setMuncipalWasteSavings(diffvalueOther
				* (Double.parseDouble(productInformation.getProductDetails()
						.getNooFProductPurchased())));
		otherPackageSaving.setCostSavings(otherPackageSaving.getEnergySavings()
				* Double.parseDouble((String) propassumptioncalc
						.getProperty("electricitycost")));
		savingsProductMainResultDTO.setOtherPackagingSaving(otherPackageSaving);

		// Minimum 25% for recycled content in CPG
		Double diffvalueCPG = 0.00;
		if (dataCompProductMainResultDTO.getMassEqCpg25CorrugatedPackaging() != null
				&& Double
						.parseDouble((String) prop8a
								.getProperty(productInformation
										.getProductDetails().getProductType()
										+ "avgAmtOfRecycledcontentOfPackaging,1-corrugated")) >= 0.00) {
			diffvalueCPG = dataCompProductMainResultDTO
					.getMassEqCpg25CorrugatedPackaging()
					- Double.parseDouble((String) prop8a
							.getProperty(productInformation.getProductDetails()
									.getProductType()
									+ "avgAmtOfRecycledcontentOfPackaging,1-corrugated"));
		}
		
		
		SavingByCriteriaProductMainDTO recycleContentInCPG = new SavingByCriteriaProductMainDTO();
		recycleContentInCPG.setEnergySavings(diffvalueCPG
				* Double.parseDouble((String) propassumptioncalc
						.getProperty("totalenergydemandForPackagingCardboard"))
				* (Double.parseDouble(productInformation.getProductDetails()
						.getNooFProductPurchased())) / ecf);
		recycleContentInCPG.setPrimaryMaterialSavings(diffvalueCPG
				* Double.parseDouble((String) propassumptioncalc
						.getProperty("materialInputForPackagingCardboard"))
				* (Double.parseDouble(productInformation.getProductDetails()
						.getNooFProductPurchased())));
		
		recycleContentInCPG.setGhgEmissionSaving(diffvalueCPG
				* Double.parseDouble((String) propassumptioncalc
						.getProperty("ghgEmissionForPackagingCorrugatedNoBox"))
				* (Double.parseDouble(productInformation.getProductDetails()
						.getNooFProductPurchased())));
		recycleContentInCPG.setAirEmissionsaving(diffvalueCPG
				* Double.parseDouble((String) propassumptioncalc
						.getProperty("avgemissionToAirForPackagingCardboard"))
				* (Double.parseDouble(productInformation.getProductDetails()
						
						
						
						
						
						
						.getNooFProductPurchased())));
		recycleContentInCPG.setWaterEmissionSaving(diffvalueCPG
				* Double.parseDouble((String) propassumptioncalc
						.getProperty("avgemissionToWaterForPackagingCardboard"))
				* (Double.parseDouble(productInformation.getProductDetails()
						.getNooFProductPurchased())));
		recycleContentInCPG.setMuncipalWasteSavings(diffvalueCPG
				* (Double.parseDouble(productInformation.getProductDetails()
						.getNooFProductPurchased())));
		recycleContentInCPG.setCostSavings(recycleContentInCPG
				.getEnergySavings()
				* Double.parseDouble((String) propassumptioncalc
						.getProperty("electricitycost")));
		savingsProductMainResultDTO.setRecycleContentInCPG(recycleContentInCPG);

		// Packaging avaoided by packaging Reuse
		SavingByCriteriaProductMainDTO packagingReuse = null;
		if (dataCompProductMainResultDTO.getPackagingAvoideByReuse() == 0) {
			packagingReuse = new SavingByCriteriaProductMainDTO(0.00, 0.00,
					0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00);

		} else {
			packagingReuse = new SavingByCriteriaProductMainDTO();
			packagingReuse.setEnergySavings(savingsProductInterimResultDTO
					.getEnergySavingFromPackageReuse()
					* Double.parseDouble((String) prop8b1
							.getProperty("Packagingreused"))
					* (Double.parseDouble(productInformation
							.getProductDetails().getNooFProductPurchased())));
			packagingReuse
					.setPrimaryMaterialSavings(savingsProductInterimResultDTO
							.getPmSavingFromPackageReuse()
							* Double.parseDouble((String) prop8b1
									.getProperty("Packagingreused"))
							* (Double.parseDouble(productInformation
									.getProductDetails()
									.getNooFProductPurchased())));
			packagingReuse.setGhgEmissionSaving(savingsProductInterimResultDTO
					.getGhgSavingFromPbWC()
					* Double.parseDouble((String) prop8b1
							.getProperty("Packagingreused"))
					* (Double.parseDouble(productInformation
							.getProductDetails().getNooFProductPurchased())));
			packagingReuse.setAirEmissionsaving(savingsProductInterimResultDTO
					.getAirSavingFromPbTotal()
					* Double.parseDouble((String) prop8b1
							.getProperty("Packagingreused"))
					* (Double.parseDouble(productInformation
							.getProductDetails().getNooFProductPurchased())));
			packagingReuse
					.setWaterEmissionSaving(savingsProductInterimResultDTO
							.getWaterSavingFromPbTotal()
							* Double.parseDouble((String) prop8b1
									.getProperty("Packagingreused"))
							* (Double.parseDouble(productInformation
									.getProductDetails()
									.getNooFProductPurchased())));

			packagingReuse.setMuncipalWasteSavings((dataCompProductMainResultDTO
					.getPackagingAvoideByReuse()
					- Double.parseDouble((String) prop8a
							.getProperty((productInformation.getProductDetails()
									.getProductType() +"PackagingavoidedperunitbyPackagingreuse"))))
					* (Double.parseDouble(productInformation
							.getProductDetails().getNooFProductPurchased())));
			packagingReuse.setCostSavings(packagingReuse.getEnergySavings()
					* Double.parseDouble((String) propassumptioncalc
							.getProperty("electricitycost")));
		}
		savingsProductMainResultDTO.setPackagingReuse(packagingReuse);

		// Packaging SubTotal Row

		SavingByCriteriaProductMainDTO packagingSubTotal = new SavingByCriteriaProductMainDTO();
		if (recycleSaving.getEnergySavings() > recycleContentInCPG
				.getEnergySavings()) {
			packagingSubTotal.setEnergySavings(recycleSaving.getEnergySavings()
					+ packagingSaving.getEnergySavings()
					+ otherPackageSaving.getEnergySavings()
					+ packagingReuse.getEnergySavings());
		} else if (recycleSaving.getEnergySavings() < recycleContentInCPG
				.getEnergySavings()) {
			packagingSubTotal.setEnergySavings(recycleContentInCPG
					.getEnergySavings()
					+ packagingSaving.getEnergySavings()
					+ otherPackageSaving.getEnergySavings()
					+ packagingReuse.getEnergySavings());
		} else {
			packagingSubTotal.setEnergySavings(recycleSaving.getEnergySavings()
					+ recycleContentInCPG.getEnergySavings()
					+ packagingSaving.getEnergySavings()
					+ otherPackageSaving.getEnergySavings()
					+ packagingReuse.getEnergySavings());

		}
		if (recycleSaving.getPrimaryMaterialSavings() > recycleContentInCPG
				.getPrimaryMaterialSavings()) {
			packagingSubTotal.setPrimaryMaterialSavings(recycleSaving
					.getPrimaryMaterialSavings()
					+ packagingSaving.getPrimaryMaterialSavings()
					+ otherPackageSaving.getPrimaryMaterialSavings()
					+ packagingReuse.getPrimaryMaterialSavings());
		} else if (recycleSaving.getPrimaryMaterialSavings() < recycleContentInCPG
				.getPrimaryMaterialSavings()) {
			packagingSubTotal.setPrimaryMaterialSavings(packagingSaving
					.getPrimaryMaterialSavings()
					+ otherPackageSaving.getPrimaryMaterialSavings()
					+ recycleContentInCPG.getPrimaryMaterialSavings()
					+ packagingReuse.getPrimaryMaterialSavings());
		} else {
			packagingSubTotal.setPrimaryMaterialSavings(recycleSaving
					.getPrimaryMaterialSavings()
					+ packagingSaving.getPrimaryMaterialSavings()
					+ otherPackageSaving.getPrimaryMaterialSavings()
					+ recycleContentInCPG.getPrimaryMaterialSavings()
					+ packagingReuse.getPrimaryMaterialSavings());
		}
		if (recycleSaving.getGhgEmissionSaving() > recycleContentInCPG
				.getGhgEmissionSaving()) {
			packagingSubTotal.setGhgEmissionSaving(recycleSaving
					.getGhgEmissionSaving()
					+ packagingSaving.getGhgEmissionSaving()
					+ otherPackageSaving.getGhgEmissionSaving()
					+ packagingReuse.getGhgEmissionSaving());
		} else if (recycleSaving.getGhgEmissionSaving() < recycleContentInCPG
				.getGhgEmissionSaving()) {
			packagingSubTotal.setGhgEmissionSaving(packagingSaving
					.getGhgEmissionSaving()
					+ otherPackageSaving.getGhgEmissionSaving()
					+ recycleContentInCPG.getGhgEmissionSaving()
					+ packagingReuse.getGhgEmissionSaving());
		} else {
			packagingSubTotal.setGhgEmissionSaving(recycleSaving
					.getGhgEmissionSaving()
					+ packagingSaving.getGhgEmissionSaving()
					+ otherPackageSaving.getGhgEmissionSaving()
					+ recycleContentInCPG.getGhgEmissionSaving()
					+ packagingReuse.getGhgEmissionSaving());
		}
		if (recycleSaving.getAirEmissionsaving() > recycleContentInCPG
				.getAirEmissionsaving()) {
			packagingSubTotal.setAirEmissionsaving(recycleSaving
					.getAirEmissionsaving()
					+ packagingSaving.getAirEmissionsaving()
					+ otherPackageSaving.getAirEmissionsaving()
					+ packagingReuse.getAirEmissionsaving());
		} else if (recycleSaving.getAirEmissionsaving() < recycleContentInCPG
				.getAirEmissionsaving()) {
			packagingSubTotal.setAirEmissionsaving(packagingSaving
					.getAirEmissionsaving()
					+ otherPackageSaving.getAirEmissionsaving()
					+ recycleContentInCPG.getAirEmissionsaving()
					+ packagingReuse.getAirEmissionsaving());
		} else {
			packagingSubTotal.setAirEmissionsaving(recycleSaving
					.getAirEmissionsaving()
					+ packagingSaving.getAirEmissionsaving()
					+ otherPackageSaving.getAirEmissionsaving()
					+ recycleContentInCPG.getAirEmissionsaving()
					+ packagingReuse.getAirEmissionsaving());
		}
		if (recycleSaving.getWaterEmissionSaving() > recycleContentInCPG
				.getWaterEmissionSaving()) {
			packagingSubTotal.setWaterEmissionSaving(recycleSaving
					.getWaterEmissionSaving()
					+ packagingSaving.getWaterEmissionSaving()
					+ otherPackageSaving.getWaterEmissionSaving()
					+ packagingReuse.getWaterEmissionSaving());
		} else if (recycleSaving.getWaterEmissionSaving() < recycleContentInCPG
				.getWaterEmissionSaving()) {
			packagingSubTotal.setWaterEmissionSaving(packagingSaving
					.getWaterEmissionSaving()
					+ otherPackageSaving.getWaterEmissionSaving()
					+ recycleContentInCPG.getWaterEmissionSaving()
					+ packagingReuse.getWaterEmissionSaving());
		} else {
			packagingSubTotal.setWaterEmissionSaving(recycleSaving
					.getWaterEmissionSaving()
					+ packagingSaving.getWaterEmissionSaving()
					+ otherPackageSaving.getWaterEmissionSaving()
					+ recycleContentInCPG.getWaterEmissionSaving()
					+ packagingReuse.getWaterEmissionSaving());
		}
		if (recycleSaving.getMuncipalWasteSavings() > recycleContentInCPG
				.getMuncipalWasteSavings()) {
			packagingSubTotal.setMuncipalWasteSavings(recycleSaving
					.getMuncipalWasteSavings()
					+ packagingSaving.getMuncipalWasteSavings()
					+ otherPackageSaving.getMuncipalWasteSavings()
					+ packagingReuse.getMuncipalWasteSavings());
		} else if (recycleSaving.getMuncipalWasteSavings() < recycleContentInCPG
				.getMuncipalWasteSavings()) {
			packagingSubTotal.setMuncipalWasteSavings(packagingSaving
					.getMuncipalWasteSavings()
					+ otherPackageSaving.getMuncipalWasteSavings()
					+ recycleContentInCPG.getMuncipalWasteSavings()
					+ packagingReuse.getMuncipalWasteSavings());
		} else {
			packagingSubTotal.setMuncipalWasteSavings(recycleSaving
					.getMuncipalWasteSavings()
					+ packagingSaving.getMuncipalWasteSavings()
					+ otherPackageSaving.getMuncipalWasteSavings()
					+ recycleContentInCPG.getMuncipalWasteSavings()
					+ packagingReuse.getMuncipalWasteSavings());

		}
		if (recycleSaving.getCostSavings() > recycleContentInCPG
				.getCostSavings()) {
			packagingSubTotal.setCostSavings(recycleSaving.getCostSavings()
					+ packagingSaving.getCostSavings()
					+ otherPackageSaving.getCostSavings()
					+ packagingReuse.getCostSavings());
		} else if (recycleSaving.getCostSavings() < recycleContentInCPG
				.getCostSavings()) {
			packagingSubTotal.setCostSavings(packagingSaving.getCostSavings()
					+ otherPackageSaving.getCostSavings()
					+ recycleContentInCPG.getCostSavings()
					+ packagingReuse.getCostSavings());
		} else {
			packagingSubTotal.setCostSavings(recycleSaving.getCostSavings()
					+ packagingSaving.getCostSavings()
					+ otherPackageSaving.getCostSavings()
					+ recycleContentInCPG.getCostSavings()
					+ packagingReuse.getCostSavings());
		}
		savingsProductMainResultDTO.setPackagingSubTotal(packagingSubTotal);

		// Product life
	
		EnergySavingProductMainDTO productLifeEnergy = new EnergySavingProductMainDTO();
		productLifeEnergy.setEnergySaving(savingsProductInterimResultDTO
				.getLifetimeEnergySaving());
		productLifeEnergy
				.setPrimaryMaterialSaving(savingsProductInterimResultDTO
						.getLifetimeEnergySaving()
						* (Double.parseDouble((String) propassumptioncalc
								.getProperty("matInputPowerGridMix"))));
		productLifeEnergy.setGhgEmissionSaving(savingsProductInterimResultDTO
				.getLifetimeEnergySaving()
				* (Double.parseDouble((String) propassumptioncalc
						.getProperty("ghgEmissionFromElectricity"))));
		productLifeEnergy.setAirEmissionsaving(savingsProductInterimResultDTO
				.getLifetimeEnergySaving()
				* (Double.parseDouble((String) propassumptioncalc
						.getProperty("emissiontoAirPowerGridMix"))));
		productLifeEnergy.setWaterEmissionSaving(savingsProductInterimResultDTO
				.getLifetimeEnergySaving()
				* (Double.parseDouble((String) propassumptioncalc
						.getProperty("emissiontoWaterPowerGridMix"))));
		productLifeEnergy.setCostSaving(savingsProductInterimResultDTO
				.getLifetimeEnergySaving()
				* Double.parseDouble((String) propassumptioncalc
						.getProperty("electricitycost")));
		savingsProductMainResultDTO.setEnergySaving5Life(productLifeEnergy);

		// Product Life SubTotal ----> reduced Toxicity only have toxic material
		// savings
		EnergySavingProductMainDTO productLifeSubTotal = new EnergySavingProductMainDTO();
		productLifeSubTotal.setEnergySaving(productLifeEnergy.getEnergySaving()
				+ packagingSubTotal.getEnergySavings()
				+ materialUse.getEnergySavings());
		productLifeSubTotal.setPrimaryMaterialSaving(productLifeEnergy
				.getPrimaryMaterialSaving()
				+ packagingSubTotal.getPrimaryMaterialSavings()
				+ materialUse.getPrimaryMaterialSavings()
				);
		productLifeSubTotal.setGhgEmissionSaving(productLifeEnergy
				.getGhgEmissionSaving()
				+ packagingSubTotal.getGhgEmissionSaving()
				+ materialUse.getGhgEmissionSaving()
				);
		productLifeSubTotal.setAirEmissionsaving(productLifeEnergy
				.getAirEmissionsaving()
				+ packagingSubTotal.getAirEmissionsaving()
				+ materialUse.getAirEmissionsaving()
			);
	
		productLifeSubTotal.setWaterEmissionSaving(productLifeEnergy
				.getWaterEmissionSaving()
				+ packagingSubTotal.getWaterEmissionSaving()
				+ materialUse.getWaterEmissionSaving()
				);
		productLifeSubTotal.setCostSaving(packagingSubTotal.getCostSavings()
				+ materialUse.getCostSavings()
				+ productLifeEnergy.getCostSaving());
		
		productLifeSubTotal.setMuncipalWasteSaving(packagingSubTotal.getMuncipalWasteSavings()
				+ materialUse.getMuncipalWasteSavings());
	
	   productLifeSubTotal.setToxicWasteSaving(savingsProductMainResultDTO.getTotaltoxicMaterialsavings());
		
		savingsProductMainResultDTO.setLifetimeSubTotal(productLifeSubTotal);

		// First Year
		EnergySavingProductMainDTO productFirstEnergy = new EnergySavingProductMainDTO();
		productFirstEnergy.setEnergySaving(savingsProductInterimResultDTO
				.getFirstYearEnergySaving());
		productFirstEnergy
				.setPrimaryMaterialSaving(savingsProductInterimResultDTO
						.getFirstYearEnergySaving()
						* (Double.parseDouble((String) propassumptioncalc
								.getProperty("matInputPowerGridMix"))));
		productFirstEnergy.setGhgEmissionSaving(savingsProductInterimResultDTO
				.getFirstYearEnergySaving()
				* (Double.parseDouble((String) propassumptioncalc
						.getProperty("ghgEmissionFromElectricity"))));
		productFirstEnergy.setAirEmissionsaving(savingsProductInterimResultDTO
				.getFirstYearEnergySaving()
				* (Double.parseDouble((String) propassumptioncalc
						.getProperty("emissiontoAirPowerGridMix"))));
		productFirstEnergy
				.setWaterEmissionSaving(savingsProductInterimResultDTO
						.getFirstYearEnergySaving()
						* (Double.parseDouble((String) propassumptioncalc
								.getProperty("emissiontoWaterPowerGridMix"))));
		productFirstEnergy.setCostSaving(savingsProductInterimResultDTO
				.getFirstYearEnergySaving()
				* Double.parseDouble((String) propassumptioncalc
						.getProperty("electricitycost")));
		
		
		savingsProductMainResultDTO.setEnergySaving5First(productFirstEnergy);

		// Product Firsy Year SubTotal ----> reduced Toxicity only have toxic
		// material savings
		EnergySavingProductMainDTO productFirstSubTotal = new EnergySavingProductMainDTO();
		productFirstSubTotal.setEnergySaving(productFirstEnergy
				.getEnergySaving()
				+ packagingSubTotal.getEnergySavings()
				+ materialUse.getEnergySavings()
				);
		productFirstSubTotal.setPrimaryMaterialSaving(productFirstEnergy
				.getPrimaryMaterialSaving()
				+ packagingSubTotal.getPrimaryMaterialSavings()
				+ materialUse.getPrimaryMaterialSavings()
				);
		productFirstSubTotal.setGhgEmissionSaving(productFirstEnergy
				.getGhgEmissionSaving()
				+ packagingSubTotal.getGhgEmissionSaving()
				+ materialUse.getGhgEmissionSaving()
				);
		productFirstSubTotal.setAirEmissionsaving(productFirstEnergy
				.getAirEmissionsaving()
				+ packagingSubTotal.getAirEmissionsaving()
				+ materialUse.getAirEmissionsaving()
			);
		productFirstSubTotal.setWaterEmissionSaving(productFirstEnergy
				.getWaterEmissionSaving()
				+ packagingSubTotal.getWaterEmissionSaving()
				+ materialUse.getWaterEmissionSaving()
				);
		productFirstSubTotal.setCostSaving(packagingSubTotal.getCostSavings()
				+ materialUse.getCostSavings()
				+ productFirstEnergy.getCostSaving());
		
		productFirstSubTotal.setMuncipalWasteSaving(packagingSubTotal.getMuncipalWasteSavings()
				+ materialUse.getMuncipalWasteSavings());
		
		productFirstSubTotal.setToxicWasteSaving(savingsProductMainResultDTO.getTotaltoxicMaterialsavings());
		savingsProductMainResultDTO.setFirstYearSubTotal(productFirstSubTotal);

		return savingsProductMainResultDTO;
	}

	public SavingsUseDataMainResultDTO generateSavingsUseDataMainResultDTO(
			InputUseAndEOLDTO inputUseAndEOLDTO,
			DataCompUseDataMainResultDTO dataCompUseDataMainResultDTO,
			SupportingCalculationResultDTO supportingCalculationResultDTO) {
		SavingsUseDataMainResultDTO savingsUseDataMainResultDTO = new SavingsUseDataMainResultDTO();
		SavingByCriteriaProductMainDTO powerManagementEnabledLife = new SavingByCriteriaProductMainDTO();
		if (inputUseAndEOLDTO.getUseTotal() != null
				&& inputUseAndEOLDTO.getUseTotal().trim().length() > 0
				&& Double.parseDouble(inputUseAndEOLDTO.getUseTotal()) > 0) {

			powerManagementEnabledLife
					.setEnergySavings(dataCompUseDataMainResultDTO
							.getEnergy4StarLifeTimeSavings()
							+ dataCompUseDataMainResultDTO
									.getEnergy5StarLifeTimeSavings());
			powerManagementEnabledLife
					.setPrimaryMaterialSavings(powerManagementEnabledLife
							.getEnergySavings()
							* (Double.parseDouble((String) propassumptioncalc
									.getProperty("matInputPowerGridMix"))));
			powerManagementEnabledLife
					.setGhgEmissionSaving(powerManagementEnabledLife
							.getEnergySavings()
							* (Double.parseDouble((String) propassumptioncalc
									.getProperty("ghgEmissionFromElectricity"))));
			powerManagementEnabledLife
					.setAirEmissionsaving(powerManagementEnabledLife
							.getEnergySavings()
							* (Double.parseDouble((String) propassumptioncalc
									.getProperty("emissiontoAirPowerGridMix"))));
			powerManagementEnabledLife
					.setWaterEmissionSaving(powerManagementEnabledLife
							.getEnergySavings()
							* (Double.parseDouble((String) propassumptioncalc
									.getProperty("emissiontoWaterPowerGridMix"))));
			powerManagementEnabledLife
					.setCostSavings(powerManagementEnabledLife
							.getEnergySavings()
							* (Double.parseDouble((String) propassumptioncalc
									.getProperty("electricitycost"))));
			savingsUseDataMainResultDTO
					.setPowerManagementEnabledLife(powerManagementEnabledLife);

		} else {
			powerManagementEnabledLife
			.setEnergySavings(new Double(0));
			powerManagementEnabledLife
			.setPrimaryMaterialSavings(new Double(0));
	powerManagementEnabledLife
			.setGhgEmissionSaving(new Double(0));
	powerManagementEnabledLife
			.setAirEmissionsaving(new Double(0));
	powerManagementEnabledLife
			.setWaterEmissionSaving(new Double(0));
	/*Hui added 8/4/2017
	powerManagementEnabledLife
	.setToxicMaterialSavings(new Double(0));
	*/
	powerManagementEnabledLife
			.setCostSavings(new Double(0));
	savingsUseDataMainResultDTO
			.setPowerManagementEnabledLife(powerManagementEnabledLife);

		}

		Double interimPMvalue = (((dataCompUseDataMainResultDTO
				.getAvgLifeSpanComputerSystem() - supportingCalculationResultDTO
				.getAvgLifeSpanForProducts()) / (supportingCalculationResultDTO
				.getAvgLifeSpanForProducts()))
				* dataCompUseDataMainResultDTO.getAvgMassOfCompSystem() * Double
				.parseDouble(inputUseAndEOLDTO.getUseTotal()));

		Double interimEnergyvalue = interimPMvalue
				* supportingCalculationResultDTO
						.getWeightedAvgProductionEnergy();

		SavingByCriteriaProductMainDTO energySaving = new SavingByCriteriaProductMainDTO();
		if (interimEnergyvalue > 0.00
				&& (inputUseAndEOLDTO.getUseTotal() != null && Double
						.parseDouble(inputUseAndEOLDTO.getUseTotal()) > 0)) {
			energySaving.setEnergySavings(interimEnergyvalue);
		} else {
			energySaving.setEnergySavings(0.00);
		}
		if (interimPMvalue > 0.00
				&& (inputUseAndEOLDTO.getUseTotal() != null && Double
						.parseDouble(inputUseAndEOLDTO.getUseTotal()) > 0)) {
			energySaving.setPrimaryMaterialSavings(interimPMvalue);
		} else {
			energySaving.setPrimaryMaterialSavings(0.00);
		}
		energySaving.setGhgEmissionSaving(energySaving.getEnergySavings()
				* (Double.parseDouble((String) propassumptioncalc
						.getProperty("ghgEmissionFromElectricity"))));
		energySaving.setAirEmissionsaving(energySaving.getEnergySavings()
				* (Double.parseDouble((String) propassumptioncalc
						.getProperty("emissiontoAirPowerGridMix"))));
		energySaving.setWaterEmissionSaving(energySaving.getEnergySavings()
				* (Double.parseDouble((String) propassumptioncalc
						.getProperty("emissiontoWaterPowerGridMix"))));
		Double interToxicValue = (((dataCompUseDataMainResultDTO
				.getAvgLifeSpanComputerSystem() - supportingCalculationResultDTO
				.getAvgLifeSpanForProducts()) / (supportingCalculationResultDTO
				.getAvgLifeSpanForProducts()))
				* dataCompUseDataMainResultDTO
						.getAvgMassOfHazMaterialInCompSystem() * Double
				.parseDouble(inputUseAndEOLDTO.getUseTotal()));
		
		//2015 fixing
				interToxicValue = interToxicValue/1000;
		//end of 2015 fixing
		if (interToxicValue > 0.00
				&& (inputUseAndEOLDTO.getUseTotal() != null && Double
						.parseDouble(inputUseAndEOLDTO.getUseTotal()) > 0)) {
			energySaving.setToxicMaterialSavings(interToxicValue);
		} else {
			energySaving.setToxicMaterialSavings(0.00);
		}
		energySaving.setMuncipalWasteSavings(energySaving
				.getPrimaryMaterialSavings());
		Double interimHazValue = (((dataCompUseDataMainResultDTO
				.getAvgLifeSpanComputerSystem() - supportingCalculationResultDTO
				.getAvgLifeSpanForProducts()) / (supportingCalculationResultDTO
				.getAvgLifeSpanForProducts()))
				* dataCompUseDataMainResultDTO
						.getAvgMassOfHazWasteAvoidedForCompSystem() * Double
				.parseDouble(inputUseAndEOLDTO.getUseTotal()));
		if (interimHazValue > 0.00
				&& (inputUseAndEOLDTO.getUseTotal() != null && Double
						.parseDouble(inputUseAndEOLDTO.getUseTotal()) > 0)) {
			energySaving.setHazardWasteSavings(interimHazValue);
		} else {
			energySaving.setHazardWasteSavings(0.00);
		}
		energySaving.setCostSavings(energySaving.getEnergySavings()
				* (Double.parseDouble((String) propassumptioncalc
						.getProperty("electricitycost"))));
		savingsUseDataMainResultDTO.setExtendProductLife(energySaving);

		// Total Lifetime
		SavingByCriteriaProductMainDTO productLifeTotal = new SavingByCriteriaProductMainDTO();
		productLifeTotal.setEnergySavings(powerManagementEnabledLife
				.getEnergySavings() + energySaving.getEnergySavings());
		productLifeTotal.setPrimaryMaterialSavings(powerManagementEnabledLife
				.getPrimaryMaterialSavings()
				+ energySaving.getPrimaryMaterialSavings());
		productLifeTotal.setGhgEmissionSaving(powerManagementEnabledLife
				.getGhgEmissionSaving() + energySaving.getGhgEmissionSaving());

		productLifeTotal.setAirEmissionsaving(powerManagementEnabledLife
				.getAirEmissionsaving() + energySaving.getAirEmissionsaving());
		productLifeTotal.setWaterEmissionSaving(powerManagementEnabledLife
				.getWaterEmissionSaving()
				+ energySaving.getWaterEmissionSaving());
		/*hui should we add the Toxic? 8/3/2017 */
			productLifeTotal.setToxicMaterialSavings(energySaving.getToxicMaterialSavings()); 
			productLifeTotal.setMuncipalWasteSavings(energySaving.getMuncipalWasteSavings()); 
			productLifeTotal.setHazardWasteSavings(energySaving.getHazardWasteSavings()); 
		//hui end
		productLifeTotal.setCostSavings(powerManagementEnabledLife
				.getCostSavings() + energySaving.getCostSavings());
		savingsUseDataMainResultDTO.setProductLifeTotal(productLifeTotal);

		SavingByCriteriaProductMainDTO firstYearPower = new SavingByCriteriaProductMainDTO();
		if (inputUseAndEOLDTO.getUseTotal() != null
				&& Double.parseDouble(inputUseAndEOLDTO.getUseTotal()) > 0) {
			firstYearPower.setEnergySavings(dataCompUseDataMainResultDTO
					.getEnergy4StarFirstYearSavings()
					+ dataCompUseDataMainResultDTO
							.getEnergy5StarFirstYearSavings());
			firstYearPower.setPrimaryMaterialSavings(firstYearPower
					.getEnergySavings()
					* (Double.parseDouble((String) propassumptioncalc
							.getProperty("matInputPowerGridMix"))));
			firstYearPower.setGhgEmissionSaving(firstYearPower
					.getEnergySavings()
					* (Double.parseDouble((String) propassumptioncalc
							.getProperty("ghgEmissionFromElectricity"))));
			firstYearPower.setAirEmissionsaving(firstYearPower
					.getEnergySavings()
					* (Double.parseDouble((String) propassumptioncalc
							.getProperty("emissiontoAirPowerGridMix"))));
			firstYearPower.setWaterEmissionSaving(firstYearPower
					.getEnergySavings()
					* (Double.parseDouble((String) propassumptioncalc
							.getProperty("emissiontoWaterPowerGridMix"))));
			firstYearPower.setCostSavings(firstYearPower.getEnergySavings()
					* (Double.parseDouble((String) propassumptioncalc
							.getProperty("electricitycost"))));
			savingsUseDataMainResultDTO
					.setPowerManagementEnabledFirst(firstYearPower);
		}

		return savingsUseDataMainResultDTO;

	}

	private EnergyReuseRecycleTotalDTO calculateRecycleReuseTotal(
			Double reuseNum, Double recycleNum, String productType,
			DataCompEndOfLifeMainResultDTO dataCompEndOfLifeMainResultDTO) {
		EnergyReuseRecycleTotalDTO energyReuseRecycleTotal = new EnergyReuseRecycleTotalDTO();

		if (reuseNum != null && reuseNum > 0) {
			energyReuseRecycleTotal.setEnergySavingsReuse(reuseNum
					* Double.parseDouble((String) prop8a
							.getProperty(productType + "avgWgtOfproduct"))
					* (Double.parseDouble((String) propassumptioncalc
							.getProperty("sourcereductionconvereted"))));
			energyReuseRecycleTotal.setPrimaryMaterialSavingsReuse(reuseNum
					* Double.parseDouble((String) prop8a
							.getProperty(productType + "avgWgtOfproduct")));
			energyReuseRecycleTotal
					.setMuncipalWasteSavingsReuse(energyReuseRecycleTotal
							.getPrimaryMaterialSavingsReuse());

			if ("cpu".equalsIgnoreCase(productType)) {
				energyReuseRecycleTotal.setHazardWasteSavingsReuse(reuseNum
						* dataCompEndOfLifeMainResultDTO
								.getTotalMassOfHazwasteCPU());
			} else if ("lcd".equalsIgnoreCase(productType)) {
				energyReuseRecycleTotal.setHazardWasteSavingsReuse(reuseNum
						* dataCompEndOfLifeMainResultDTO
								.getTotalMassOfHazwasteLCD());
			} else if ("crt".equalsIgnoreCase(productType)) {
				energyReuseRecycleTotal.setHazardWasteSavingsReuse(reuseNum
						* dataCompEndOfLifeMainResultDTO
								.getTotalMassOfHazwasteCRT());
			} else if ("notebook".equalsIgnoreCase(productType)) {
				energyReuseRecycleTotal.setHazardWasteSavingsReuse(reuseNum
						* dataCompEndOfLifeMainResultDTO
								.getTotalMassOfHazwasteNtbk());
			}

			energyReuseRecycleTotal.setGhgEmissionSavingReuse(reuseNum
					* Double.parseDouble((String) prop8a
							.getProperty(productType + "avgWgtOfproduct"))
					* (Double.parseDouble((String) propassumptioncalc
							.getProperty("sourcereductionconveretedtable8"))));
			Double toxicContent = Double.parseDouble((String) prop8a
					.getProperty(productType + "avgPbContentPerUnit"))
					+ Double.parseDouble((String) prop8a
							.getProperty(productType
									+ "avgHgcontentnotincludinglampsperunit"))
					+ Double.parseDouble((String) prop8a
							.getProperty(productType
									+ "avgcadmiumContentPerUnit"))
					+ Double.parseDouble((String) prop8a
							.getProperty(productType
									+ "avghexavalentChromiumPerUnit"))
					+ Double.parseDouble((String) prop8a
							.getProperty(productType + "avgPBBContentPerUnit"))
					+ Double.parseDouble((String) prop8a
							.getProperty(productType + "avgPBDEContentPerUnit"));
			if ("lcd".equalsIgnoreCase(productType)
					|| "notebook".equalsIgnoreCase(productType)) {
				toxicContent = toxicContent
						+ Double.parseDouble((String) prop8a
								.getProperty(productType
										+ "avgtotalHgcontentinlamps"));
			}
			energyReuseRecycleTotal
					.setToxicMaterialSavingsReuse((toxicContent / 1000)
							* reuseNum);
		} else {
			energyReuseRecycleTotal.setEnergySavingsReuse(0.00);
			energyReuseRecycleTotal.setPrimaryMaterialSavingsReuse(0.00);
			energyReuseRecycleTotal.setMuncipalWasteSavingsReuse(0.00);
			energyReuseRecycleTotal.setHazardWasteSavingsReuse(0.00);
			energyReuseRecycleTotal.setGhgEmissionSavingReuse(0.00);
			energyReuseRecycleTotal.setToxicMaterialSavingsReuse(0.00);
		}
		if (recycleNum != null && recycleNum > 0) {
			energyReuseRecycleTotal.setEnergySavingsRecycle(recycleNum
					* Double.parseDouble((String) prop8a
							.getProperty(productType + "avgWgtOfproduct"))
					* (Double.parseDouble((String) propassumptioncalc
							.getProperty("recyclingconvereted"))));
			energyReuseRecycleTotal.setPrimaryMaterialSavingsRecycle(recycleNum
					* Double.parseDouble((String) prop8a
							.getProperty(productType + "avgWgtOfproduct")));
			energyReuseRecycleTotal
					.setMuncipalWasteSavingsRecycle(energyReuseRecycleTotal
							.getPrimaryMaterialSavingsRecycle());

			if ("cpu".equalsIgnoreCase(productType)) {
				energyReuseRecycleTotal.setHazardWasteSavingsRecycle(recycleNum
						* dataCompEndOfLifeMainResultDTO
								.getTotalMassOfHazwasteCPU());
			} else if ("lcd".equalsIgnoreCase(productType)) {
				energyReuseRecycleTotal.setHazardWasteSavingsRecycle(recycleNum
						* dataCompEndOfLifeMainResultDTO
								.getTotalMassOfHazwasteLCD());
			} else if ("crt".equalsIgnoreCase(productType)) {
				energyReuseRecycleTotal.setHazardWasteSavingsRecycle(recycleNum
						* dataCompEndOfLifeMainResultDTO
								.getTotalMassOfHazwasteCRT());
			} else if ("notebook".equalsIgnoreCase(productType)) {
				energyReuseRecycleTotal.setHazardWasteSavingsRecycle(recycleNum
						* dataCompEndOfLifeMainResultDTO
								.getTotalMassOfHazwasteNtbk());
			}
			energyReuseRecycleTotal.setGhgEmissionSavingRecycle(recycleNum
					* Double.parseDouble((String) prop8a
							.getProperty(productType + "avgWgtOfproduct"))
					* (Double.parseDouble((String) propassumptioncalc
							.getProperty("recyclingconveretedtable8"))));

		} else {
			energyReuseRecycleTotal.setEnergySavingsRecycle(0.00);
			energyReuseRecycleTotal.setPrimaryMaterialSavingsRecycle(0.00);
			energyReuseRecycleTotal.setMuncipalWasteSavingsRecycle(0.00);
			energyReuseRecycleTotal.setHazardWasteSavingsRecycle(0.00);
			energyReuseRecycleTotal.setGhgEmissionSavingRecycle(0.00);
			energyReuseRecycleTotal.setToxicMaterialSavingsRecycle(0.00);
		}
		return energyReuseRecycleTotal;
	}

	public SavingsEOLInterimResultDTO generateSavingsEOLInterimResultDTO(
			EndOfLifeDTO endOfLifeDTO,
			DataCompEndOfLifeMainResultDTO dataCompEndOfLifeMainResultDTO) {
		SavingsEOLInterimResultDTO savingsEOLInterimResultDTO = new SavingsEOLInterimResultDTO();
		savingsEOLInterimResultDTO
				.setCpuReuseRecycle(calculateRecycleReuseTotal(
						endOfLifeDTO.getNumOfCPUReused().isEmpty()?null:Double.parseDouble(endOfLifeDTO.getNumOfCPUReused()),
								endOfLifeDTO.getNumOfCPURecycled().isEmpty()?null:Double.parseDouble(endOfLifeDTO.getNumOfCPURecycled()),
						"cpu", dataCompEndOfLifeMainResultDTO));
		savingsEOLInterimResultDTO
				.setCrtReuseRecycle(calculateRecycleReuseTotal(
						endOfLifeDTO.getNumOfCRTReused().isEmpty()?null:Double.parseDouble(endOfLifeDTO.getNumOfCRTReused()),
								endOfLifeDTO.getNumOfCRTRecycled().isEmpty()?null:Double.parseDouble(endOfLifeDTO.getNumOfCRTRecycled()),
						"crt", dataCompEndOfLifeMainResultDTO));
		savingsEOLInterimResultDTO
				.setLcdReuseRecycle(calculateRecycleReuseTotal(
						endOfLifeDTO.getNumOfLCDReused().isEmpty()?null:Double.parseDouble(endOfLifeDTO.getNumOfLCDReused()),
								endOfLifeDTO.getNumOfLCDRecycled().isEmpty()?null:Double.parseDouble(endOfLifeDTO.getNumOfLCDRecycled()),
						"lcd", dataCompEndOfLifeMainResultDTO));
		savingsEOLInterimResultDTO
				.setNotebookReuseRecycle(calculateRecycleReuseTotal(endOfLifeDTO.getNumOfNoteBookReused().isEmpty()?null:Double
						.parseDouble(endOfLifeDTO.getNumOfNoteBookReused()),
						endOfLifeDTO
						.getNumOfNoteBookRecycled().isEmpty()?null:Double.parseDouble(endOfLifeDTO
								.getNumOfNoteBookRecycled()), "notebook",
						dataCompEndOfLifeMainResultDTO));

		EnergyReuseRecycleTotalDTO energyReuseRecycleTotalForMobile = new EnergyReuseRecycleTotalDTO();
		Double avgWtOfMobWOBattery = (Double.parseDouble((String) prop8a
				.getProperty("mobileavgWgtOfproduct")) - Double
				.parseDouble((String) prop8a
						.getProperty("mobileavgWgtOfproductWOBattery")));
		Double luvTotEnergyDemand = (Double
				.parseDouble((String) propassumptioncalc
						.getProperty("totalEnergyDemandMetalRecPerMatProccessed")));
		Double addSubValue = (Double.parseDouble((String) propassumptioncalc
				.getProperty("primProdAoidedDueToRecyCuCompound")))
				+ (Double.parseDouble((String) propassumptioncalc
						.getProperty("primProdAoidedDueToRecyPreciousMetal")))
				- (Double.parseDouble((String) propassumptioncalc
						.getProperty("metalRecForCuCompound")))
				- (Double.parseDouble((String) propassumptioncalc
						.getProperty("metalRecForPreciousMetal")))
				+ (Double.parseDouble((String) propassumptioncalc
						.getProperty("primProdReuseCuCompound")))
				+ (Double.parseDouble((String) propassumptioncalc
						.getProperty("primProdReusePreciousMetal")));
		Double addSubValue12c = (Double.parseDouble((String) propassumptioncalc
				.getProperty("primProdAoidedDueToRecyCuCompound12c")))
				+ (Double
						.parseDouble((String) propassumptioncalc
								.getProperty("primProdAoidedDueToRecyPreciousMetal12c")))
				- (Double.parseDouble((String) propassumptioncalc
						.getProperty("metalRecForCuCompound12c")))
				- (Double.parseDouble((String) propassumptioncalc
						.getProperty("metalRecForPreciousMetal12c")))
				+ (Double.parseDouble((String) propassumptioncalc
						.getProperty("primProdReuseCuCompound12c")))
				+ (Double.parseDouble((String) propassumptioncalc
						.getProperty("primProdReusePreciousMetal12c")));
		Double addSubValue12d = (Double.parseDouble((String) propassumptioncalc
				.getProperty("primProdAoidedDueToRecyCuCompound12d")))
				+ (Double
						.parseDouble((String) propassumptioncalc
								.getProperty("primProdAoidedDueToRecyPreciousMetal12d")))
				- (Double.parseDouble((String) propassumptioncalc
						.getProperty("metalRecForCuCompound12d")))
				- (Double.parseDouble((String) propassumptioncalc
						.getProperty("metalRecForPreciousMetal12d")))
				+ (Double.parseDouble((String) propassumptioncalc
						.getProperty("primProdReuseCuCompound12d")))
				+ (Double.parseDouble((String) propassumptioncalc
						.getProperty("primProdReusePreciousMetal12d")));
		Double addSubValue12e = (Double.parseDouble((String) propassumptioncalc
				.getProperty("primProdAoidedDueToRecyCuCompound12e")))
				+ (Double
						.parseDouble((String) propassumptioncalc
								.getProperty("primProdAoidedDueToRecyPreciousMetal12e")))
				- (Double.parseDouble((String) propassumptioncalc
						.getProperty("metalRecForCuCompound12e")))
				- (Double.parseDouble((String) propassumptioncalc
						.getProperty("metalRecForPreciousMetal12e")))
				+ (Double.parseDouble((String) propassumptioncalc
						.getProperty("primProdReuseCuCompound12e")))
				+ (Double.parseDouble((String) propassumptioncalc
						.getProperty("primProdReusePreciousMetal12e")));

		// For Mobile
		if (endOfLifeDTO.getNumOfMobileReused() != null && !endOfLifeDTO.getNumOfMobileReused().trim().isEmpty()
				&& Double.parseDouble(endOfLifeDTO.getNumOfMobileReused()) > 0) {
			String productType = "mobile";
			Double toxicContent = Double.parseDouble((String) prop8a
					.getProperty(productType + "avgPbContentPerUnit"))
					+ Double.parseDouble((String) prop8a
							.getProperty(productType
									+ "avgHgcontentnotincludinglampsperunit"))
					+ Double.parseDouble((String) prop8a
							.getProperty(productType
									+ "avgcadmiumContentPerUnit"))
					+ Double.parseDouble((String) prop8a
							.getProperty(productType
									+ "avghexavalentChromiumPerUnit"))
					+ Double.parseDouble((String) prop8a
							.getProperty(productType + "avgPBBContentPerUnit"))
					+ Double.parseDouble((String) prop8a
							.getProperty(productType + "avgPBDEContentPerUnit"));

			energyReuseRecycleTotalForMobile
					.setPrimaryMaterialSavingsReuse(Double
							.parseDouble(endOfLifeDTO.getNumOfMobileReused())
							* avgWtOfMobWOBattery);
			energyReuseRecycleTotalForMobile.setEnergySavingsReuse(Double
					.parseDouble(endOfLifeDTO.getNumOfMobileReused())
					* avgWtOfMobWOBattery
					* (Double.parseDouble((String) propassumptioncalc
							.getProperty("energyformobileProd"))));
			energyReuseRecycleTotalForMobile
					.setMuncipalWasteSavingsReuse(Double
							.parseDouble(endOfLifeDTO.getNumOfMobileReused())
							* Double.parseDouble((String) prop8a
									.getProperty("mobileavgWgtOfproduct")));
			energyReuseRecycleTotalForMobile.setHazardWasteSavingsReuse(Double
					.parseDouble(endOfLifeDTO.getNumOfMobileReused())
					* dataCompEndOfLifeMainResultDTO
							.getTotalMassOfHazwasteMoblie());
			energyReuseRecycleTotalForMobile.setGhgEmissionSavingReuse(Double
					.parseDouble(endOfLifeDTO.getNumOfMobileReused())
					* Double.parseDouble((String) propassumptioncalc
							.getProperty("reusedprimaryForSum")));
			energyReuseRecycleTotalForMobile
					.setToxicMaterialSavingsReuse((toxicContent / 1000)
							* Double.parseDouble(endOfLifeDTO
									.getNumOfMobileReused()));
			energyReuseRecycleTotalForMobile.setAirEmissionsavingReuse(Double
					.parseDouble(endOfLifeDTO.getNumOfMobileReused())
					* Double.parseDouble((String) propassumptioncalc
							.getProperty("reusedprimaryForSum12d")));
			energyReuseRecycleTotalForMobile.setWaterEmissionSavingReuse(Double
					.parseDouble(endOfLifeDTO.getNumOfMobileReused())
					* Double.parseDouble((String) propassumptioncalc
							.getProperty("reusedprimaryForSum12e")));
		} else {
			energyReuseRecycleTotalForMobile.setEnergySavingsReuse(0.00);
			energyReuseRecycleTotalForMobile
					.setPrimaryMaterialSavingsReuse(0.00);
			energyReuseRecycleTotalForMobile.setMuncipalWasteSavingsReuse(0.00);
			energyReuseRecycleTotalForMobile.setHazardWasteSavingsReuse(0.00);
			energyReuseRecycleTotalForMobile.setGhgEmissionSavingReuse(0.00);
			energyReuseRecycleTotalForMobile.setToxicMaterialSavingsReuse(0.00);
			energyReuseRecycleTotalForMobile.setAirEmissionsavingReuse(0.00);
			energyReuseRecycleTotalForMobile.setWaterEmissionSavingReuse(0.00);

		}

		if (endOfLifeDTO.getNumOfMobileRecycled() != null && !endOfLifeDTO.getNumOfMobileRecycled().trim().isEmpty()
				&& Double.parseDouble(endOfLifeDTO.getNumOfMobileRecycled()) > 0) {
			energyReuseRecycleTotalForMobile
					.setEnergySavingsRecycle((Double.parseDouble(endOfLifeDTO
							.getNumOfMobileRecycled()) * (addSubValue - (avgWtOfMobWOBattery * luvTotEnergyDemand)))
							/ (Double.parseDouble((String) propassumptioncalc
									.getProperty("energyConversionFactor"))));
			energyReuseRecycleTotalForMobile
					.setPrimaryMaterialSavingsRecycle((Double
							.parseDouble(endOfLifeDTO.getNumOfMobileRecycled()))
							* (Double.parseDouble((String) propassumptioncalc
									.getProperty("massRecycledCuCompound")) + Double.parseDouble((String) propassumptioncalc
									.getProperty("massRecycledPreciousMetal"))));
			energyReuseRecycleTotalForMobile
					.setMuncipalWasteSavingsRecycle(Double
							.parseDouble(endOfLifeDTO.getNumOfMobileRecycled())
							* Double.parseDouble((String) prop8a
									.getProperty("mobileavgWgtOfproduct")));
			energyReuseRecycleTotalForMobile
					.setHazardWasteSavingsRecycle(Double
							.parseDouble(endOfLifeDTO.getNumOfMobileRecycled())
							* dataCompEndOfLifeMainResultDTO
									.getTotalMassOfHazwasteMoblie());
			energyReuseRecycleTotalForMobile.setGhgEmissionSavingRecycle(Double
					.parseDouble(endOfLifeDTO.getNumOfMobileRecycled())
					* addSubValue12c);
			energyReuseRecycleTotalForMobile.setAirEmissionsavingRecycle(Double
					.parseDouble(endOfLifeDTO.getNumOfMobileRecycled())
					* addSubValue12d);
			energyReuseRecycleTotalForMobile
					.setWaterEmissionSavingRecycle(Double
							.parseDouble(endOfLifeDTO.getNumOfMobileRecycled())
							* addSubValue12e);
		} else {
			energyReuseRecycleTotalForMobile.setEnergySavingsRecycle(0.00);
			energyReuseRecycleTotalForMobile
					.setPrimaryMaterialSavingsRecycle(0.00);
			energyReuseRecycleTotalForMobile
					.setMuncipalWasteSavingsRecycle(0.00);
			energyReuseRecycleTotalForMobile.setHazardWasteSavingsRecycle(0.00);
			energyReuseRecycleTotalForMobile.setGhgEmissionSavingRecycle(0.00);
			energyReuseRecycleTotalForMobile.setAirEmissionsavingRecycle(0.00);
			energyReuseRecycleTotalForMobile
					.setWaterEmissionSavingRecycle(0.00);
		}
		savingsEOLInterimResultDTO
				.setMobileReuseRecycle(energyReuseRecycleTotalForMobile);

		// For Mixed Electronics
		EnergyReuseRecycleTotalDTO energyReuseRecycleTotalForMixedElectronics = new EnergyReuseRecycleTotalDTO();
		if (endOfLifeDTO.getKgsOfMixedOfficeRecycled() != null && !endOfLifeDTO
				.getKgsOfMixedOfficeRecycled().isEmpty()
				&& Double.parseDouble(endOfLifeDTO
						.getKgsOfMixedOfficeRecycled()) > 0) {
			Double energyRecycleValue = (Double
					.parseDouble((String) propassumptioncalc
							.getProperty("primaryprdAvoidedRecyForSum13b")))
					- (Double.parseDouble((String) propassumptioncalc
							.getProperty("matRecForSum13b")))
					+ (Double.parseDouble((String) propassumptioncalc
							.getProperty("primaryProdReuseForSum13b")));
			energyReuseRecycleTotalForMixedElectronics
					.setEnergySavingsRecycle((Double.parseDouble((endOfLifeDTO
							.getKgsOfMixedOfficeRecycled())) * (energyRecycleValue))
							/ (Double.parseDouble((String) propassumptioncalc
									.getProperty("energyConversionFactor"))));
			energyReuseRecycleTotalForMixedElectronics
					.setPrimaryMaterialSavingsRecycle(Double.parseDouble((String) propassumptioncalc
							.getProperty("primaryProdAvoidedForSum13a"))
							* Double.parseDouble(endOfLifeDTO
									.getKgsOfMixedOfficeRecycled()));
			energyReuseRecycleTotalForMixedElectronics
					.setMuncipalWasteSavingsRecycle(Double
							.parseDouble((String) propassumptioncalc
									.getProperty("massOfSum13a"))
							* Double.parseDouble(endOfLifeDTO
									.getKgsOfMixedOfficeRecycled()));
			energyReuseRecycleTotalForMixedElectronics
					.setHazardWasteSavingsRecycle(Double
							.parseDouble(endOfLifeDTO
									.getKgsOfMixedOfficeRecycled())
							* (Double.parseDouble((String) propassumptioncalc
									.getProperty("massOfTotPWBSum13a"))
									+ Double.parseDouble((String) propassumptioncalc
											.getProperty("massOfCRT13a")) + ((Double.parseDouble((String) prop8a
									.getProperty("mixedElectronicsPlasticResinexCu"))))));
			energyReuseRecycleTotalForMixedElectronics
					.setGhgEmissionSavingRecycle(Double
							.parseDouble(endOfLifeDTO
									.getKgsOfMixedOfficeRecycled())
							* ((Double.parseDouble((String) propassumptioncalc
									.getProperty("primaryprdAvoidedRecyForSum13c")))
									- (Double
											.parseDouble((String) propassumptioncalc
													.getProperty("matRecForSum13c"))) + (Double
										.parseDouble((String) propassumptioncalc
												.getProperty("primaryProdReuseForSum13c")))));
			energyReuseRecycleTotalForMixedElectronics
					.setAirEmissionsavingRecycle(Double
							.parseDouble(endOfLifeDTO
									.getKgsOfMixedOfficeRecycled())
							* ((Double.parseDouble((String) propassumptioncalc
									.getProperty("primaryprdAvoidedRecyForSum13d")))
									- (Double
											.parseDouble((String) propassumptioncalc
													.getProperty("matRecForSum13d"))) + (Double
										.parseDouble((String) propassumptioncalc
												.getProperty("primaryProdReuseForSum13d")))));
			energyReuseRecycleTotalForMixedElectronics
					.setWaterEmissionSavingRecycle(Double
							.parseDouble(endOfLifeDTO
									.getKgsOfMixedOfficeRecycled())
							* ((Double.parseDouble((String) propassumptioncalc
									.getProperty("primaryprdAvoidedRecyForSum13e")))
									- (Double
											.parseDouble((String) propassumptioncalc
													.getProperty("matRecForSum13e"))) + (Double
										.parseDouble((String) propassumptioncalc
												.getProperty("primaryProdReuseForSum13e")))));
		} else {
			energyReuseRecycleTotalForMixedElectronics
					.setEnergySavingsRecycle(0.00);
			energyReuseRecycleTotalForMixedElectronics
					.setPrimaryMaterialSavingsRecycle(0.00);
			energyReuseRecycleTotalForMixedElectronics
					.setMuncipalWasteSavingsRecycle(0.00);
			energyReuseRecycleTotalForMixedElectronics
					.setHazardWasteSavingsRecycle(0.00);
			energyReuseRecycleTotalForMixedElectronics
					.setGhgEmissionSavingRecycle(0.00);
			energyReuseRecycleTotalForMixedElectronics
					.setAirEmissionsavingRecycle(0.00);
			energyReuseRecycleTotalForMixedElectronics
					.setWaterEmissionSavingRecycle(0.00);
		}
		savingsEOLInterimResultDTO
				.setMixedElectronicsReuseRecycle(energyReuseRecycleTotalForMixedElectronics);

		return savingsEOLInterimResultDTO;
	}

	public SavingsEOLMainResultDTO generateSavingsEOLMainResultDTO(
			SavingsEOLInterimResultDTO savingsEOLInterimResultDTO) {
		SavingsEOLMainResultDTO savingsEOLMainResultDTO = new SavingsEOLMainResultDTO();

		SavingByCriteriaProductMainDTO computerAndMonitorReuse = new SavingByCriteriaProductMainDTO();
		computerAndMonitorReuse.setEnergySavings(savingsEOLInterimResultDTO
				.getCpuReuseRecycle().getEnergySavingsReuse()
				+ savingsEOLInterimResultDTO.getCrtReuseRecycle()
						.getEnergySavingsReuse()
				+ savingsEOLInterimResultDTO.getLcdReuseRecycle()
						.getEnergySavingsReuse()
				+ savingsEOLInterimResultDTO.getNotebookReuseRecycle()
						.getEnergySavingsReuse());
		computerAndMonitorReuse
				.setPrimaryMaterialSavings(savingsEOLInterimResultDTO
						.getCpuReuseRecycle().getPrimaryMaterialSavingsReuse()
						+ savingsEOLInterimResultDTO.getCrtReuseRecycle()
								.getPrimaryMaterialSavingsReuse()
						+ savingsEOLInterimResultDTO.getLcdReuseRecycle()
								.getPrimaryMaterialSavingsReuse()
						+ savingsEOLInterimResultDTO.getNotebookReuseRecycle()
								.getPrimaryMaterialSavingsReuse());
		computerAndMonitorReuse.setGhgEmissionSaving(savingsEOLInterimResultDTO
				.getCpuReuseRecycle().getGhgEmissionSavingReuse()
				+ savingsEOLInterimResultDTO.getCrtReuseRecycle()
						.getGhgEmissionSavingReuse()
				+ savingsEOLInterimResultDTO.getLcdReuseRecycle()
						.getGhgEmissionSavingReuse()
				+ savingsEOLInterimResultDTO.getNotebookReuseRecycle()
						.getGhgEmissionSavingReuse());
		computerAndMonitorReuse.setAirEmissionsaving(computerAndMonitorReuse
				.getEnergySavings()
				* (Double.parseDouble((String) propassumptioncalc
						.getProperty("emissiontoAirPowerGridMix"))));
		computerAndMonitorReuse.setWaterEmissionSaving(computerAndMonitorReuse
				.getEnergySavings()
				* (Double.parseDouble((String) propassumptioncalc
						.getProperty("emissiontoWaterPowerGridMix"))));
		computerAndMonitorReuse
				.setToxicMaterialSavings(savingsEOLInterimResultDTO
						.getCpuReuseRecycle().getToxicMaterialSavingsReuse()
						+ savingsEOLInterimResultDTO.getCrtReuseRecycle()
								.getToxicMaterialSavingsReuse()
						+ savingsEOLInterimResultDTO.getLcdReuseRecycle()
								.getToxicMaterialSavingsReuse()
						+ savingsEOLInterimResultDTO.getNotebookReuseRecycle()
								.getToxicMaterialSavingsReuse());
		computerAndMonitorReuse
				.setMuncipalWasteSavings(savingsEOLInterimResultDTO
						.getCpuReuseRecycle().getMuncipalWasteSavingsReuse()
						+ savingsEOLInterimResultDTO.getCrtReuseRecycle()
								.getMuncipalWasteSavingsReuse()
						+ savingsEOLInterimResultDTO.getLcdReuseRecycle()
								.getMuncipalWasteSavingsReuse()
						+ savingsEOLInterimResultDTO.getNotebookReuseRecycle()
								.getMuncipalWasteSavingsReuse());
		computerAndMonitorReuse
				.setHazardWasteSavings(savingsEOLInterimResultDTO
						.getCpuReuseRecycle().getHazardWasteSavingsReuse()
						+ savingsEOLInterimResultDTO.getCrtReuseRecycle()
								.getHazardWasteSavingsReuse()
						+ savingsEOLInterimResultDTO.getLcdReuseRecycle()
								.getHazardWasteSavingsReuse()
						+ savingsEOLInterimResultDTO.getNotebookReuseRecycle()
								.getHazardWasteSavingsReuse());
		computerAndMonitorReuse.setCostSavings(computerAndMonitorReuse
				.getEnergySavings()
				* (Double.parseDouble((String) propassumptioncalc
						.getProperty("electricitycost"))));
		savingsEOLMainResultDTO
				.setComputerAndMonitorReuse(computerAndMonitorReuse);

		SavingByCriteriaProductMainDTO mobilePhoneReuse = new SavingByCriteriaProductMainDTO();
		mobilePhoneReuse.setEnergySavings(savingsEOLInterimResultDTO
				.getMobileReuseRecycle().getEnergySavingsReuse());
		mobilePhoneReuse.setPrimaryMaterialSavings(savingsEOLInterimResultDTO
				.getMobileReuseRecycle().getPrimaryMaterialSavingsReuse());
		mobilePhoneReuse.setGhgEmissionSaving(savingsEOLInterimResultDTO
				.getMobileReuseRecycle().getGhgEmissionSavingReuse());
		mobilePhoneReuse.setAirEmissionsaving(savingsEOLInterimResultDTO
				.getMobileReuseRecycle().getAirEmissionsavingReuse());
		mobilePhoneReuse.setWaterEmissionSaving(savingsEOLInterimResultDTO
				.getMobileReuseRecycle().getWaterEmissionSavingReuse());
		mobilePhoneReuse.setToxicMaterialSavings(savingsEOLInterimResultDTO
				.getMobileReuseRecycle().getToxicMaterialSavingsReuse());
		mobilePhoneReuse.setMuncipalWasteSavings(savingsEOLInterimResultDTO
				.getMobileReuseRecycle().getMuncipalWasteSavingsReuse());
		mobilePhoneReuse.setHazardWasteSavings(savingsEOLInterimResultDTO
				.getMobileReuseRecycle().getHazardWasteSavingsReuse());
		mobilePhoneReuse.setCostSavings(mobilePhoneReuse.getEnergySavings()
				* (Double.parseDouble((String) propassumptioncalc
						.getProperty("electricitycost"))));
		savingsEOLMainResultDTO.setMobilePhoneReuse(mobilePhoneReuse);

		SavingByCriteriaProductMainDTO totalEOLReuse = new SavingByCriteriaProductMainDTO();
		totalEOLReuse.setEnergySavings(mobilePhoneReuse.getEnergySavings()
				+ computerAndMonitorReuse.getEnergySavings());
		totalEOLReuse.setPrimaryMaterialSavings(mobilePhoneReuse
				.getPrimaryMaterialSavings()
				+ computerAndMonitorReuse.getPrimaryMaterialSavings());
		totalEOLReuse.setGhgEmissionSaving(mobilePhoneReuse
				.getGhgEmissionSaving()
				+ computerAndMonitorReuse.getGhgEmissionSaving());
		totalEOLReuse.setAirEmissionsaving(mobilePhoneReuse
				.getAirEmissionsaving()
				+ computerAndMonitorReuse.getAirEmissionsaving());
		totalEOLReuse.setWaterEmissionSaving(mobilePhoneReuse
				.getWaterEmissionSaving()
				+ computerAndMonitorReuse.getWaterEmissionSaving());
		totalEOLReuse.setToxicMaterialSavings(mobilePhoneReuse
				.getToxicMaterialSavings()
				+ computerAndMonitorReuse.getToxicMaterialSavings());
		totalEOLReuse.setMuncipalWasteSavings(mobilePhoneReuse
				.getMuncipalWasteSavings()
				+ computerAndMonitorReuse.getMuncipalWasteSavings());
		totalEOLReuse.setHazardWasteSavings(mobilePhoneReuse
				.getHazardWasteSavings()
				+ computerAndMonitorReuse.getHazardWasteSavings());
		totalEOLReuse.setCostSavings(computerAndMonitorReuse.getCostSavings()
				+ mobilePhoneReuse.getCostSavings());
		savingsEOLMainResultDTO.setTotalSavingsEOLReuse(totalEOLReuse);

		SavingByCriteriaProductMainDTO computerAndMonitorRecycle = new SavingByCriteriaProductMainDTO();
		computerAndMonitorRecycle.setEnergySavings(savingsEOLInterimResultDTO
				.getCpuReuseRecycle().getEnergySavingsRecycle()
				+ savingsEOLInterimResultDTO.getCrtReuseRecycle()
						.getEnergySavingsRecycle()
				+ savingsEOLInterimResultDTO.getLcdReuseRecycle()
						.getEnergySavingsRecycle()
				+ savingsEOLInterimResultDTO.getNotebookReuseRecycle()
						.getEnergySavingsRecycle());
		computerAndMonitorRecycle
				.setPrimaryMaterialSavings(savingsEOLInterimResultDTO
						.getCpuReuseRecycle()
						.getPrimaryMaterialSavingsRecycle()
						+ savingsEOLInterimResultDTO.getCrtReuseRecycle()
								.getPrimaryMaterialSavingsRecycle()
						+ savingsEOLInterimResultDTO.getLcdReuseRecycle()
								.getPrimaryMaterialSavingsRecycle()
						+ savingsEOLInterimResultDTO.getNotebookReuseRecycle()
								.getPrimaryMaterialSavingsRecycle());
		computerAndMonitorRecycle
				.setGhgEmissionSaving(savingsEOLInterimResultDTO
						.getCpuReuseRecycle().getGhgEmissionSavingRecycle()
						+ savingsEOLInterimResultDTO.getCrtReuseRecycle()
								.getGhgEmissionSavingRecycle()
						+ savingsEOLInterimResultDTO.getLcdReuseRecycle()
								.getGhgEmissionSavingRecycle()
						+ savingsEOLInterimResultDTO.getNotebookReuseRecycle()
								.getGhgEmissionSavingRecycle());
		computerAndMonitorRecycle
				.setAirEmissionsaving(computerAndMonitorRecycle
						.getEnergySavings()
						* (Double.parseDouble((String) propassumptioncalc
								.getProperty("emissiontoAirPowerGridMix"))));
		computerAndMonitorRecycle
				.setWaterEmissionSaving(computerAndMonitorRecycle
						.getEnergySavings()
						* (Double.parseDouble((String) propassumptioncalc
								.getProperty("emissiontoWaterPowerGridMix"))));
		// computerAndMonitorRecycle.setToxicMaterialSavings(savingsEOLInterimResultDTO.getCpuReuseRecycle().getToxicMaterialSavingsRecycle()+savingsEOLInterimResultDTO.getCrtReuseRecycle().getToxicMaterialSavingsRecycle()+savingsEOLInterimResultDTO.getLcdReuseRecycle().getToxicMaterialSavingsRecycle()+savingsEOLInterimResultDTO.getNotebookReuseRecycle().getToxicMaterialSavingsRecycle());
		computerAndMonitorRecycle
				.setMuncipalWasteSavings(savingsEOLInterimResultDTO
						.getCpuReuseRecycle().getMuncipalWasteSavingsRecycle()
						+ savingsEOLInterimResultDTO.getCrtReuseRecycle()
								.getMuncipalWasteSavingsRecycle()
						+ savingsEOLInterimResultDTO.getLcdReuseRecycle()
								.getMuncipalWasteSavingsRecycle()
						+ savingsEOLInterimResultDTO.getNotebookReuseRecycle()
								.getMuncipalWasteSavingsRecycle());
		computerAndMonitorRecycle
				.setHazardWasteSavings(savingsEOLInterimResultDTO
						.getCpuReuseRecycle().getHazardWasteSavingsRecycle()
						+ savingsEOLInterimResultDTO.getCrtReuseRecycle()
								.getHazardWasteSavingsRecycle()
						+ savingsEOLInterimResultDTO.getLcdReuseRecycle()
								.getHazardWasteSavingsRecycle()
						+ savingsEOLInterimResultDTO.getNotebookReuseRecycle()
								.getHazardWasteSavingsRecycle());
		computerAndMonitorRecycle.setCostSavings(computerAndMonitorRecycle
				.getEnergySavings()
				* (Double.parseDouble((String) propassumptioncalc
						.getProperty("electricitycost"))));
		savingsEOLMainResultDTO
				.setComputerAndMonitorRecycle(computerAndMonitorRecycle);

		SavingByCriteriaProductMainDTO mobilePhoneRecycle = new SavingByCriteriaProductMainDTO();
		mobilePhoneRecycle.setEnergySavings(savingsEOLInterimResultDTO
				.getMobileReuseRecycle().getEnergySavingsRecycle());
		mobilePhoneRecycle.setPrimaryMaterialSavings(savingsEOLInterimResultDTO
				.getMobileReuseRecycle().getPrimaryMaterialSavingsRecycle());
		mobilePhoneRecycle.setGhgEmissionSaving(savingsEOLInterimResultDTO
				.getMobileReuseRecycle().getGhgEmissionSavingRecycle());
		mobilePhoneRecycle.setAirEmissionsaving(savingsEOLInterimResultDTO
				.getMobileReuseRecycle().getAirEmissionsavingRecycle());
		mobilePhoneRecycle.setWaterEmissionSaving(savingsEOLInterimResultDTO
				.getMobileReuseRecycle().getWaterEmissionSavingRecycle());
		// mobilePhoneRecycle.setToxicMaterialSavings(savingsEOLInterimResultDTO.getMobileReuseRecycle().getToxicMaterialSavingsRecycle());
		mobilePhoneRecycle.setMuncipalWasteSavings(savingsEOLInterimResultDTO
				.getMobileReuseRecycle().getMuncipalWasteSavingsRecycle());
		mobilePhoneRecycle.setHazardWasteSavings(savingsEOLInterimResultDTO
				.getMobileReuseRecycle().getHazardWasteSavingsRecycle());
		mobilePhoneRecycle.setCostSavings(mobilePhoneRecycle.getEnergySavings()
				* (Double.parseDouble((String) propassumptioncalc
						.getProperty("electricitycost"))));
		savingsEOLMainResultDTO.setMobilePhoneRecycle(mobilePhoneRecycle);

		SavingByCriteriaProductMainDTO mixedOfficeRecycle = new SavingByCriteriaProductMainDTO();
		mixedOfficeRecycle.setEnergySavings(savingsEOLInterimResultDTO
				.getMixedElectronicsReuseRecycle().getEnergySavingsRecycle());
		mixedOfficeRecycle.setPrimaryMaterialSavings(savingsEOLInterimResultDTO
				.getMixedElectronicsReuseRecycle()
				.getPrimaryMaterialSavingsRecycle());
		mixedOfficeRecycle.setGhgEmissionSaving(savingsEOLInterimResultDTO
				.getMixedElectronicsReuseRecycle()
				.getGhgEmissionSavingRecycle());
		mixedOfficeRecycle.setAirEmissionsaving(savingsEOLInterimResultDTO
				.getMixedElectronicsReuseRecycle()
				.getAirEmissionsavingRecycle());
		mixedOfficeRecycle.setWaterEmissionSaving(savingsEOLInterimResultDTO
				.getMixedElectronicsReuseRecycle()
				.getWaterEmissionSavingRecycle());
		// mobilePhoneRecycle.setToxicMaterialSavings(savingsEOLInterimResultDTO.getMobileReuseRecycle().getToxicMaterialSavingsRecycle());
		mixedOfficeRecycle.setMuncipalWasteSavings(savingsEOLInterimResultDTO
				.getMixedElectronicsReuseRecycle()
				.getMuncipalWasteSavingsRecycle());
		mixedOfficeRecycle.setHazardWasteSavings(savingsEOLInterimResultDTO
				.getMixedElectronicsReuseRecycle()
				.getHazardWasteSavingsRecycle());
		mixedOfficeRecycle.setCostSavings(mixedOfficeRecycle.getEnergySavings()
				* (Double.parseDouble((String) propassumptioncalc
						.getProperty("electricitycost"))));
		savingsEOLMainResultDTO
				.setMixedofficeElectronicsRecycle(mixedOfficeRecycle);

		SavingByCriteriaProductMainDTO totalEOLRecycle = new SavingByCriteriaProductMainDTO();
		totalEOLRecycle.setEnergySavings(mobilePhoneRecycle.getEnergySavings()
				+ computerAndMonitorRecycle.getEnergySavings()
				+ mixedOfficeRecycle.getEnergySavings());
		totalEOLRecycle.setPrimaryMaterialSavings(mobilePhoneRecycle
				.getPrimaryMaterialSavings()
				+ computerAndMonitorRecycle.getPrimaryMaterialSavings()
				+ mixedOfficeRecycle.getPrimaryMaterialSavings());
		totalEOLRecycle.setGhgEmissionSaving(mobilePhoneRecycle
				.getGhgEmissionSaving()
				+ computerAndMonitorRecycle.getGhgEmissionSaving()
				+ mixedOfficeRecycle.getGhgEmissionSaving());
		totalEOLRecycle.setAirEmissionsaving(mobilePhoneRecycle
				.getAirEmissionsaving()
				+ computerAndMonitorRecycle.getAirEmissionsaving()
				+ mixedOfficeRecycle.getAirEmissionsaving());
		totalEOLRecycle.setWaterEmissionSaving(mobilePhoneRecycle
				.getWaterEmissionSaving()
				+ computerAndMonitorRecycle.getWaterEmissionSaving()
				+ mixedOfficeRecycle.getWaterEmissionSaving());
		totalEOLRecycle.setMuncipalWasteSavings(mobilePhoneRecycle
				.getMuncipalWasteSavings()
				+ computerAndMonitorRecycle.getMuncipalWasteSavings()
				+ mixedOfficeRecycle.getMuncipalWasteSavings());
		totalEOLRecycle.setHazardWasteSavings(mobilePhoneRecycle
				.getHazardWasteSavings()
				+ computerAndMonitorRecycle.getHazardWasteSavings()
				+ mixedOfficeRecycle.getHazardWasteSavings());
		totalEOLRecycle.setCostSavings(computerAndMonitorRecycle
				.getCostSavings()
				+ mobilePhoneRecycle.getCostSavings()
				+ mixedOfficeRecycle.getCostSavings());
		savingsEOLMainResultDTO.setTotalSavingsEOLRecycle(totalEOLRecycle);

		SavingByCriteriaProductMainDTO totalSavingsElectronics = new SavingByCriteriaProductMainDTO();
		totalSavingsElectronics.setEnergySavings(totalEOLRecycle
				.getEnergySavings() + totalEOLReuse.getEnergySavings());
		totalSavingsElectronics.setPrimaryMaterialSavings(totalEOLRecycle
				.getPrimaryMaterialSavings()
				+ totalEOLReuse.getPrimaryMaterialSavings());
		totalSavingsElectronics.setGhgEmissionSaving(totalEOLRecycle
				.getGhgEmissionSaving() + totalEOLReuse.getGhgEmissionSaving());
		totalSavingsElectronics.setAirEmissionsaving(totalEOLRecycle
				.getAirEmissionsaving() + totalEOLReuse.getAirEmissionsaving());
		totalSavingsElectronics.setWaterEmissionSaving(totalEOLRecycle
				.getWaterEmissionSaving()
				+ totalEOLReuse.getWaterEmissionSaving());
		// no toxic saving for recycle
		totalSavingsElectronics.setToxicMaterialSavings(totalEOLReuse
				.getToxicMaterialSavings());
		totalSavingsElectronics.setMuncipalWasteSavings(totalEOLRecycle
				.getMuncipalWasteSavings()
				+ totalEOLReuse.getMuncipalWasteSavings());
		totalSavingsElectronics.setHazardWasteSavings(totalEOLRecycle
				.getHazardWasteSavings()
				+ totalEOLReuse.getHazardWasteSavings());
		totalSavingsElectronics.setCostSavings(totalEOLReuse.getCostSavings()
				+ totalEOLRecycle.getCostSavings());
		savingsEOLMainResultDTO
				.setTotalSavingsElectronics(totalSavingsElectronics);

		return savingsEOLMainResultDTO;
	}

	/**
	 * This method reads a properties file which is passed as the parameter to
	 * it and loads it into a java Properties object and returns it.
	 */
	private static Properties loadParams(String file) throws IOException {
		// Loads a ResourceBundle and creates Properties from it
		Properties prop = new Properties();
		Locale locale = new Locale("", "");
		ResourceBundle bundle = ResourceBundle.getBundle(file, locale);
		Enumeration enum1 = bundle.getKeys();
		String key = null;
		while (enum1.hasMoreElements()) {
			key = (String) enum1.nextElement();
			prop.put(key, bundle.getObject(key));
		}
		return prop;

	}

}
