package com.saic.eebc.util;
import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang.StringEscapeUtils;

import com.saic.eebc.util.FilteredHttpServletRequest;

public class TagSanitizingFilter implements Filter {
	
	public void init(FilterConfig filterConfig) throws ServletException {  
	   // this.filterConfig = filterConfig;  
	}  
	   
	public void destroy() {  
	   // this.filterConfig = null;  
	}  
	  
	public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain)   
	    throws IOException, ServletException {  
	     
	    chain.doFilter(new FilteredHttpServletRequest((HttpServletRequest) request), response);  

	}  

}

class FilteredHttpServletRequest extends HttpServletRequestWrapper {

public FilteredHttpServletRequest(HttpServletRequest servletRequest) {  
    super(servletRequest);  
}  
  
public String[] getParameterValues(String parameter) {  
 
  String[] values = super.getParameterValues(parameter);  
  if (values==null)  {  
              return null;  
      }  
  int count = values.length;  
  String[] encodedValues = new String[count];  
  for (int i = 0; i < count; i++) {  
             encodedValues[i] = cleanXSS(values[i]);  
   }    
  return encodedValues;   
}  
  
public String getParameter(String parameter) {  
      String value = super.getParameter(parameter);  
      if (value == null) {  
             return null;   
              }  
      return cleanXSS(value);  
}  
  
public String getHeader(String name) {  
    String value = super.getHeader(name);  
    if (value == null)  
        return null;  
    return cleanXSS(value);  
      
}  

private String cleanXSS(String value) {
	value = value.replaceAll("<script", "");
    value = value.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    value = value.replaceAll("\\(", "&#40;").replaceAll("\\)", "&#41;");  
    value = value.replaceAll("'", "&#39;");            
    value = value.replaceAll("eval\\((.*)\\)", "");  
    value = value.replaceAll("[\\\"\\\'][\\s]*javascript:(.*)[\\\"\\\']", "\"\"");  
    return value;
}  

}