package com.saic.eebc.web;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.log4j.Logger;
import org.hibernate.Hibernate;
import org.hibernate.validator.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import com.saic.eebc.*;
import com.saic.eebc.dto.EebcProductEntryObjectDTO;
import com.saic.eebc.dto.InputUseAndEOLDTO;
import com.saic.eebc.dto.ProductDetailsDTO;
import com.saic.eebc.dto.ProductInformationDTO;
import com.saic.eebc.service.EebcCalculationService;
import com.saic.eebc.service.EebcImportExportService;
import com.saic.eebc.validator.ProductValidator;


@Controller
public class ProductInfoController {
	
	DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
	 
	 @Autowired 
	private ProductValidator productValidator; 

	
	protected final Logger logger = Logger.getLogger(getClass());
	
	 

	/**
	 * Go to the home page
	 * 
	 * @param model
	 * @throws Exception
	 */
	@RequestMapping(value = "/addProduct.do", method = RequestMethod.GET)
	protected String addProduct (
			ModelMap model,
			HttpSession session) throws Exception {
		String forward = "productInfo";
        ProductInformationDTO productInformation = new  ProductInformationDTO();
        ProductDetailsDTO productDetails = new  ProductDetailsDTO();
        productDetails.setProductType("cpu");
        productDetails.setNooFProductPurchased("1");
        productDetails.setIsProdEPEATRegd("yes");
        productDetails.setEpeatRegTier("Bronze");
        productInformation.setIsROHSCompliant("yes");
        productInformation.setProductDetails(productDetails);
		model.addAttribute("newProduct", productInformation);
		return forward;
	}
	


	
	 

	/**
	 * Go to the home page
	 * 
	 * @param model
	 * @throws Exception
	 */
	@RequestMapping(value = "/saveProductInfo.do", method = RequestMethod.POST)
	protected String savePostProduct (
			ModelMap model,
			@ModelAttribute("newProduct") ProductInformationDTO productInformation,
			BindingResult errors,HttpSession session) throws Exception {
		String forward = "forward:eebcCalculator.do";
		productValidator.validate(productInformation, errors);
		if(errors.hasErrors())
		{
			forward ="productInfo";
			model.addAttribute("newProduct", productInformation);
		}else{
			if(productInformation.getProductInfoID()==null || productInformation.getProductInfoID().trim().length()==0 )
			{
		productInformation.setProductInfoID(UUID.randomUUID().toString());
			}
		if("DonotKnow".equalsIgnoreCase(productInformation.getProductDetails().getEpeatRegTier()))
		{
			productInformation.getProductDetails().setEpeatRegTier("Bronze");
		}
		
		session.setAttribute("productAdded", productInformation);
	//	model.addAttribute("eebcProductEntryObject", eebcProductEntryObjectSession);
	//	model.addAttribute("defaultTab", "productList");
		}
		return forward;
	}
	
	
	/**
	 * Go to the home page
	 * 
	 * @param model
	 * @throws Exception
	 */
	@RequestMapping(value = "/returnProjectList.do", method = RequestMethod.GET)
	protected String returnProductList (
			ModelMap model,
			@ModelAttribute("newProduct") ProductInformationDTO productInformation,
			BindingResult errors,HttpSession session) throws Exception {
		String forward = "forward:eebcCalculator.do";
     	model.addAttribute("defaultTab", "productList");		
		return forward;
	}
	
	

	/**
	 * Handle any exceptions
	 * @param ex	The exception
	 * @return		Error page
	 */
	@ExceptionHandler()
    public ModelAndView handleException(Exception ex) {
    	String guid = UUID.randomUUID().toString(); 
    	logger.error("Error: Search: GUID=" + guid, ex);
    	ModelAndView mav = new ModelAndView("error");
    	mav.addObject("guid", guid);
    	mav.addObject("error", ex);
    	return mav;
    }
}
