/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.extend;

import java.util.HashMap;
import java.util.Map;
import org.directwebremoting.extend.OutboundVariable;
import org.directwebremoting.util.LocalUtil;

public final class OutboundContext {
    private static final String OUTBOUND_VARIABLE_PREFIX = "s";
    private final Map map;
    private boolean referenceWrappers;
    private int nextVarIndex = 0;

    public OutboundContext() {
        HashMap assign;
        try {
            assign = (HashMap)LocalUtil.classForName("java.util.IdentityHashMap").newInstance();
            this.referenceWrappers = false;
        }
        catch (Exception ex) {
            assign = new HashMap();
            this.referenceWrappers = true;
        }
        this.map = assign;
    }

    public OutboundVariable get(Object object) {
        Object key = object;
        if (this.referenceWrappers) {
            key = new ReferenceWrapper(object);
        }
        return (OutboundVariable)this.map.get(key);
    }

    public void put(Object object, OutboundVariable ss) {
        Object key = object;
        if (this.referenceWrappers) {
            key = new ReferenceWrapper(object);
        }
        this.map.put(key, ss);
    }

    public String getNextVariableName() {
        String varName = OUTBOUND_VARIABLE_PREFIX + this.nextVarIndex;
        ++this.nextVarIndex;
        return varName;
    }

    public String toString() {
        return this.map.toString();
    }

    private static class ReferenceWrapper {
        private Object object;

        protected ReferenceWrapper(Object object) {
            this.object = object;
        }

        public int hashCode() {
            return System.identityHashCode(this.object);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ReferenceWrapper)) {
                return false;
            }
            ReferenceWrapper that = (ReferenceWrapper)obj;
            return this.object == that.object;
        }
    }
}

