/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.directwebremoting.ScriptBuffer;
import org.directwebremoting.extend.MarshallException;
import org.directwebremoting.extend.RealScriptSession;
import org.directwebremoting.extend.ScriptConduit;
import org.directwebremoting.impl.DefaultScriptSessionManager;
import org.directwebremoting.util.Logger;

public class DefaultScriptSession
implements RealScriptSession {
    protected final Map attributes = Collections.synchronizedMap(new HashMap());
    protected long lastAccessedTime = 0L;
    protected boolean invalidated = false;
    private final Object invalidLock = new Object();
    protected final SortedSet conduits = new TreeSet();
    protected final List scripts = new ArrayList();
    private final Object scriptLock = new Object();
    protected final String id;
    protected final long creationTime;
    protected final DefaultScriptSessionManager manager;
    private static final Logger log = Logger.getLogger(class$org$directwebremoting$impl$DefaultScriptSession == null ? (class$org$directwebremoting$impl$DefaultScriptSession = DefaultScriptSession.class$("org.directwebremoting.impl.DefaultScriptSession")) : class$org$directwebremoting$impl$DefaultScriptSession);
    static /* synthetic */ Class class$org$directwebremoting$impl$DefaultScriptSession;

    protected DefaultScriptSession(String id, DefaultScriptSessionManager manager) {
        this.id = id;
        if (id == null) {
            throw new IllegalArgumentException("id can not be null");
        }
        this.manager = manager;
        this.lastAccessedTime = this.creationTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String name) {
        this.checkNotInvalidated();
        Map map = this.attributes;
        synchronized (map) {
            return this.attributes.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value) {
        this.checkNotInvalidated();
        Map map = this.attributes;
        synchronized (map) {
            this.attributes.put(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) {
        this.checkNotInvalidated();
        Map map = this.attributes;
        synchronized (map) {
            this.attributes.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getAttributeNames() {
        this.checkNotInvalidated();
        Map map = this.attributes;
        synchronized (map) {
            Set keys = Collections.unmodifiableSet(this.attributes.keySet());
            return keys.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        Object object = this.invalidLock;
        synchronized (object) {
            this.invalidated = true;
            this.manager.invalidate(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInvalidated() {
        Object object = this.invalidLock;
        synchronized (object) {
            return this.invalidated;
        }
    }

    public String getId() {
        return this.id;
    }

    public long getCreationTime() {
        this.checkNotInvalidated();
        return this.creationTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastAccessedTime() {
        Object object = this.invalidLock;
        synchronized (object) {
            return this.lastAccessedTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addScript(ScriptBuffer script) {
        this.checkNotInvalidated();
        if (script == null) {
            throw new NullPointerException("null script");
        }
        Object object = this.scriptLock;
        synchronized (object) {
            if (this.conduits.size() == 0) {
                this.scripts.add(script);
            } else {
                boolean written = false;
                Iterator it = this.conduits.iterator();
                while (!written && it.hasNext()) {
                    ScriptConduit conduit = (ScriptConduit)it.next();
                    try {
                        written = conduit.addScript(script);
                    }
                    catch (Exception ex) {
                        it.remove();
                        log.debug("Failed to write to ScriptConduit, removing from list: " + conduit);
                    }
                }
                if (!written) {
                    this.scripts.add(script);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addScriptConduit(ScriptConduit conduit) throws IOException {
        this.checkNotInvalidated();
        Object object = this.scriptLock;
        synchronized (object) {
            this.writeScripts(conduit);
            this.conduits.add(conduit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeScripts(ScriptConduit conduit) throws IOException {
        this.checkNotInvalidated();
        Object object = this.scriptLock;
        synchronized (object) {
            Iterator it = this.scripts.iterator();
            while (it.hasNext()) {
                ScriptBuffer script = (ScriptBuffer)it.next();
                try {
                    if (!conduit.addScript(script)) break;
                    it.remove();
                }
                catch (MarshallException ex) {
                    log.warn("Failed to convert data. Dropping Javascript: " + script, ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeScriptConduit(ScriptConduit conduit) {
        this.checkNotInvalidated();
        Object object = this.scriptLock;
        synchronized (object) {
            boolean removed = this.conduits.remove(conduit);
            if (!removed) {
                log.debug("Removing unattached ScriptConduit: " + conduit);
                this.debug();
            }
        }
    }

    public Object getScriptLock() {
        return this.scriptLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasWaitingScripts() {
        Object object = this.scriptLock;
        synchronized (object) {
            return !this.scripts.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateLastAccessedTime() {
        Object object = this.invalidLock;
        synchronized (object) {
            this.lastAccessedTime = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkNotInvalidated() {
        Object object = this.invalidLock;
        synchronized (object) {
            long now = System.currentTimeMillis();
            long age = now - this.lastAccessedTime;
            if (age > this.manager.getScriptSessionTimeout()) {
                this.invalidate();
            }
            if (this.invalidated) {
                log.debug("ScriptSession has been invalidated.");
            }
        }
    }

    private void debug() {
        if (log.isDebugEnabled()) {
            log.debug("Known ScriptConduits:");
            Iterator it = this.conduits.iterator();
            while (it.hasNext()) {
                ScriptConduit c = (ScriptConduit)it.next();
                log.debug("- " + c);
            }
        }
    }

    public int hashCode() {
        return 572 + this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        DefaultScriptSession that = (DefaultScriptSession)obj;
        return this.id.equals(that.id);
    }

    public String toString() {
        return "DefaultScriptSession[id=" + this.id + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

